@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.EbsFunctions.getDefaultKmsKeyPlain
import com.pulumi.aws.ebs.EbsFunctions.getEbsVolumesPlain
import com.pulumi.aws.ebs.EbsFunctions.getEncryptionByDefaultPlain
import com.pulumi.aws.ebs.EbsFunctions.getSnapshotIdsPlain
import com.pulumi.aws.ebs.EbsFunctions.getSnapshotPlain
import com.pulumi.aws.ebs.EbsFunctions.getVolumePlain
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumeFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.outputs.GetDefaultKmsKeyResult
import com.pulumi.aws.ebs.kotlin.outputs.GetEbsVolumesResult
import com.pulumi.aws.ebs.kotlin.outputs.GetEncryptionByDefaultResult
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotIdsResult
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotResult
import com.pulumi.aws.ebs.kotlin.outputs.GetVolumeResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ebs.kotlin.outputs.GetDefaultKmsKeyResult.Companion.toKotlin as getDefaultKmsKeyResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetEbsVolumesResult.Companion.toKotlin as getEbsVolumesResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetEncryptionByDefaultResult.Companion.toKotlin as getEncryptionByDefaultResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotIdsResult.Companion.toKotlin as getSnapshotIdsResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin

public object EbsFunctions {
    /**
     * Use this data source to get the default EBS encryption KMS key in the current region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ebs.getDefaultKmsKey({});
     * const example = new aws.ebs.Volume("example", {
     *     availabilityZone: "us-west-2a",
     *     encrypted: true,
     *     kmsKeyId: current.then(current => current.keyArn),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ebs.get_default_kms_key()
     * example = aws.ebs.Volume("example",
     *     availability_zone="us-west-2a",
     *     encrypted=True,
     *     kms_key_id=current.key_arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ebs.GetDefaultKmsKey.Invoke();
     *     var example = new Aws.Ebs.Volume("example", new()
     *     {
     *         AvailabilityZone = "us-west-2a",
     *         Encrypted = true,
     *         KmsKeyId = current.Apply(getDefaultKmsKeyResult => getDefaultKmsKeyResult.KeyArn),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := ebs.LookupDefaultKmsKey(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ebs.NewVolume(ctx, "example", &ebs.VolumeArgs{
     * 			AvailabilityZone: pulumi.String("us-west-2a"),
     * 			Encrypted:        pulumi.Bool(true),
     * 			KmsKeyId:         pulumi.String(current.KeyArn),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:ebs:Volume
     *     properties:
     *       availabilityZone: us-west-2a
     *       encrypted: true
     *       kmsKeyId: ${current.keyArn}
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ebs:getDefaultKmsKey
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Use this data source to get the default EBS encryption KMS key in the current region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ebs.getDefaultKmsKey({});
     * const example = new aws.ebs.Volume("example", {
     *     availabilityZone: "us-west-2a",
     *     encrypted: true,
     *     kmsKeyId: current.then(current => current.keyArn),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ebs.get_default_kms_key()
     * example = aws.ebs.Volume("example",
     *     availability_zone="us-west-2a",
     *     encrypted=True,
     *     kms_key_id=current.key_arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ebs.GetDefaultKmsKey.Invoke();
     *     var example = new Aws.Ebs.Volume("example", new()
     *     {
     *         AvailabilityZone = "us-west-2a",
     *         Encrypted = true,
     *         KmsKeyId = current.Apply(getDefaultKmsKeyResult => getDefaultKmsKeyResult.KeyArn),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := ebs.LookupDefaultKmsKey(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ebs.NewVolume(ctx, "example", &ebs.VolumeArgs{
     * 			AvailabilityZone: pulumi.String("us-west-2a"),
     * 			Encrypted:        pulumi.Bool(true),
     * 			KmsKeyId:         pulumi.String(current.KeyArn),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:ebs:Volume
     *     properties:
     *       availabilityZone: us-west-2a
     *       encrypted: true
     *       kmsKeyId: ${current.keyArn}
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ebs:getDefaultKmsKey
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getDefaultKmsKey.
     */
    public suspend fun getDefaultKmsKey(): GetDefaultKmsKeyResult =
        getDefaultKmsKeyResultToKotlin(getDefaultKmsKeyPlain().await())

    /**
     * `aws.ebs.getEbsVolumes` provides identifying information for EBS volumes matching given criteria.
     * This data source can be useful for getting a list of volume IDs with (for example) matching tags.
     * ## Example Usage
     * The following demonstrates obtaining a map of availability zone to EBS volume ID for volumes with a given tag value.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ebs.getEbsVolumes({
     *     tags: {
     *         VolumeSet: "TestVolumeSet",
     *     },
     * });
     * const exampleGetVolume = example.then(example => .reduce((__obj, [, ]) => ({ &#46;&#46;&#46;__obj, [__key]: aws.ebs.getVolume({
     *     filters: [{
     *         name: "volume-id",
     *         values: [__value],
     *     }],
     * }) })));
     * export const availabilityZoneToVolumeId = exampleGetVolume.apply(exampleGetVolume => Object.values(exampleGetVolume).reduce((__obj, s) => ({ ...__obj, [s&#46;id]: s.availabilityZone })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ebs.get_ebs_volumes(tags={
     *     "VolumeSet": "TestVolumeSet",
     * })
     * example_get_volume = {__key: aws.ebs.get_volume(filters=[{
     *     "name": "volume-id",
     *     "values": [__value],
     * }]) for __key, __value in example.ids}
     * pulumi.export("availabilityZoneToVolumeId", {s.id: s.availability_zone for s in example_get_volume})
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ebs.GetEbsVolumes.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "VolumeSet", "TestVolumeSet" },
     *         },
     *     });
     *     var exampleGetVolume = ;
     *     return new Dictionary<string, object?>
     *     {
     *         ["availabilityZoneToVolumeId"] = exampleGetVolume.Apply(exampleGetVolume => (exampleGetVolume).Values.ToDictionary(item => {
     *             var s = item.Value;
     *             return s.Id;
     *         }, item => {
     *             var s = item.Value;
     *             return s.AvailabilityZone;
     *         })),
     *     };
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEbsVolumes.
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(argument: GetEbsVolumesPlainArgs): GetEbsVolumesResult =
        getEbsVolumesResultToKotlin(getEbsVolumesPlain(argument.toJava()).await())

    /**
     * @see [getEbsVolumes].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired volumes.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(
        filters: List<GetEbsVolumesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetEbsVolumesResult {
        val argument = GetEbsVolumesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getEbsVolumesResultToKotlin(getEbsVolumesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEbsVolumes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetEbsVolumesPlainArgs].
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(argument: suspend GetEbsVolumesPlainArgsBuilder.() -> Unit): GetEbsVolumesResult {
        val builder = GetEbsVolumesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEbsVolumesResultToKotlin(getEbsVolumesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a way to check whether default EBS encryption is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ebs.getEncryptionByDefault({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ebs.get_encryption_by_default()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ebs.GetEncryptionByDefault.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.LookupEncryptionByDefault(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ebs:getEncryptionByDefault
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Provides a way to check whether default EBS encryption is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ebs.getEncryptionByDefault({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ebs.get_encryption_by_default()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ebs.GetEncryptionByDefault.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.LookupEncryptionByDefault(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ebs:getEncryptionByDefault
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getEncryptionByDefault.
     */
    public suspend fun getEncryptionByDefault(): GetEncryptionByDefaultResult =
        getEncryptionByDefaultResultToKotlin(getEncryptionByDefaultPlain().await())

    /**
     * Use this data source to get information about an EBS Snapshot for use when provisioning EBS Volumes
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ebsVolume = aws.ebs.getSnapshot({
     *     mostRecent: true,
     *     owners: ["self"],
     *     filters: [
     *         {
     *             name: "volume-size",
     *             values: ["40"],
     *         },
     *         {
     *             name: "tag:Name",
     *             values: ["Example"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ebs_volume = aws.ebs.get_snapshot(most_recent=True,
     *     owners=["self"],
     *     filters=[
     *         {
     *             "name": "volume-size",
     *             "values": ["40"],
     *         },
     *         {
     *             "name": "tag:Name",
     *             "values": ["Example"],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ebsVolume = Aws.Ebs.GetSnapshot.Invoke(new()
     *     {
     *         MostRecent = true,
     *         Owners = new[]
     *         {
     *             "self",
     *         },
     *         Filters = new[]
     *         {
     *             new Aws.Ebs.Inputs.GetSnapshotFilterInputArgs
     *             {
     *                 Name = "volume-size",
     *                 Values = new[]
     *                 {
     *                     "40",
     *                 },
     *             },
     *             new Aws.Ebs.Inputs.GetSnapshotFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "Example",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.LookupSnapshot(ctx, &ebs.LookupSnapshotArgs{
     * 			MostRecent: pulumi.BoolRef(true),
     * 			Owners: []string{
     * 				"self",
     * 			},
     * 			Filters: []ebs.GetSnapshotFilter{
     * 				{
     * 					Name: "volume-size",
     * 					Values: []string{
     * 						"40",
     * 					},
     * 				},
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"Example",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolume = EbsFunctions.getSnapshot(GetSnapshotArgs.builder()
     *             .mostRecent(true)
     *             .owners("self")
     *             .filters(
     *                 GetSnapshotFilterArgs.builder()
     *                     .name("volume-size")
     *                     .values("40")
     *                     .build(),
     *                 GetSnapshotFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ebsVolume:
     *     fn::invoke:
     *       Function: aws:ebs:getSnapshot
     *       Arguments:
     *         mostRecent: true
     *         owners:
     *           - self
     *         filters:
     *           - name: volume-size
     *             values:
     *               - '40'
     *           - name: tag:Name
     *             values:
     *               - Example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     * @param mostRecent If more than one result is returned, use the most recent snapshot.
     * @param owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     * @param restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
     * @param snapshotIds Returns information on a specific snapshot_id.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(
        filters: List<GetSnapshotFilter>? = null,
        mostRecent: Boolean? = null,
        owners: List<String>? = null,
        restorableByUserIds: List<String>? = null,
        snapshotIds: List<String>? = null,
        tags: Map<String, String>? = null,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            filters = filters,
            mostRecent = mostRecent,
            owners = owners,
            restorableByUserIds = restorableByUserIds,
            snapshotIds = snapshotIds,
            tags = tags,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit): GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of EBS Snapshot IDs matching the specified
     * criteria.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ebsVolumes = aws.ebs.getSnapshotIds({
     *     owners: ["self"],
     *     filters: [
     *         {
     *             name: "volume-size",
     *             values: ["40"],
     *         },
     *         {
     *             name: "tag:Name",
     *             values: ["Example"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ebs_volumes = aws.ebs.get_snapshot_ids(owners=["self"],
     *     filters=[
     *         {
     *             "name": "volume-size",
     *             "values": ["40"],
     *         },
     *         {
     *             "name": "tag:Name",
     *             "values": ["Example"],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ebsVolumes = Aws.Ebs.GetSnapshotIds.Invoke(new()
     *     {
     *         Owners = new[]
     *         {
     *             "self",
     *         },
     *         Filters = new[]
     *         {
     *             new Aws.Ebs.Inputs.GetSnapshotIdsFilterInputArgs
     *             {
     *                 Name = "volume-size",
     *                 Values = new[]
     *                 {
     *                     "40",
     *                 },
     *             },
     *             new Aws.Ebs.Inputs.GetSnapshotIdsFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "Example",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.GetSnapshotIds(ctx, &ebs.GetSnapshotIdsArgs{
     * 			Owners: []string{
     * 				"self",
     * 			},
     * 			Filters: []ebs.GetSnapshotIdsFilter{
     * 				{
     * 					Name: "volume-size",
     * 					Values: []string{
     * 						"40",
     * 					},
     * 				},
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"Example",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetSnapshotIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolumes = EbsFunctions.getSnapshotIds(GetSnapshotIdsArgs.builder()
     *             .owners("self")
     *             .filters(
     *                 GetSnapshotIdsFilterArgs.builder()
     *                     .name("volume-size")
     *                     .values("40")
     *                     .build(),
     *                 GetSnapshotIdsFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ebsVolumes:
     *     fn::invoke:
     *       Function: aws:ebs:getSnapshotIds
     *       Arguments:
     *         owners:
     *           - self
     *         filters:
     *           - name: volume-size
     *             values:
     *               - '40'
     *           - name: tag:Name
     *             values:
     *               - Example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshotIds.
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(argument: GetSnapshotIdsPlainArgs): GetSnapshotIdsResult =
        getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshotIds].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     * @param owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     * @param restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(
        filters: List<GetSnapshotIdsFilter>? = null,
        owners: List<String>? = null,
        restorableByUserIds: List<String>? = null,
    ): GetSnapshotIdsResult {
        val argument = GetSnapshotIdsPlainArgs(
            filters = filters,
            owners = owners,
            restorableByUserIds = restorableByUserIds,
        )
        return getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshotIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetSnapshotIdsPlainArgs].
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(argument: suspend GetSnapshotIdsPlainArgsBuilder.() -> Unit): GetSnapshotIdsResult {
        val builder = GetSnapshotIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an EBS volume for use in other
     * resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ebsVolume = aws.ebs.getVolume({
     *     mostRecent: true,
     *     filters: [
     *         {
     *             name: "volume-type",
     *             values: ["gp2"],
     *         },
     *         {
     *             name: "tag:Name",
     *             values: ["Example"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ebs_volume = aws.ebs.get_volume(most_recent=True,
     *     filters=[
     *         {
     *             "name": "volume-type",
     *             "values": ["gp2"],
     *         },
     *         {
     *             "name": "tag:Name",
     *             "values": ["Example"],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ebsVolume = Aws.Ebs.GetVolume.Invoke(new()
     *     {
     *         MostRecent = true,
     *         Filters = new[]
     *         {
     *             new Aws.Ebs.Inputs.GetVolumeFilterInputArgs
     *             {
     *                 Name = "volume-type",
     *                 Values = new[]
     *                 {
     *                     "gp2",
     *                 },
     *             },
     *             new Aws.Ebs.Inputs.GetVolumeFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "Example",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.LookupVolume(ctx, &ebs.LookupVolumeArgs{
     * 			MostRecent: pulumi.BoolRef(true),
     * 			Filters: []ebs.GetVolumeFilter{
     * 				{
     * 					Name: "volume-type",
     * 					Values: []string{
     * 						"gp2",
     * 					},
     * 				},
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"Example",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetVolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolume = EbsFunctions.getVolume(GetVolumeArgs.builder()
     *             .mostRecent(true)
     *             .filters(
     *                 GetVolumeFilterArgs.builder()
     *                     .name("volume-type")
     *                     .values("gp2")
     *                     .build(),
     *                 GetVolumeFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ebsVolume:
     *     fn::invoke:
     *       Function: aws:ebs:getVolume
     *       Arguments:
     *         mostRecent: true
     *         filters:
     *           - name: volume-type
     *             values:
     *               - gp2
     *           - name: tag:Name
     *             values:
     *               - Example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVolume.
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     * @param mostRecent If more than one result is returned, use the most
     * recent Volume.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(
        filters: List<GetVolumeFilter>? = null,
        mostRecent: Boolean? = null,
        tags: Map<String, String>? = null,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            filters = filters,
            mostRecent = mostRecent,
            tags = tags,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit): GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }
}
