@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.kotlin.outputs.FastSnapshotRestoreTimeouts
import com.pulumi.aws.ebs.kotlin.outputs.FastSnapshotRestoreTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FastSnapshotRestore].
 */
@PulumiTagMarker
public class FastSnapshotRestoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FastSnapshotRestoreArgs = FastSnapshotRestoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FastSnapshotRestoreArgsBuilder.() -> Unit) {
        val builder = FastSnapshotRestoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FastSnapshotRestore {
        val builtJavaResource = com.pulumi.aws.ebs.FastSnapshotRestore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FastSnapshotRestore(builtJavaResource)
    }
}

/**
 * Resource for managing an EBS (Elastic Block Storage) Fast Snapshot Restore.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.FastSnapshotRestore("example", {
 *     availabilityZone: "us-west-2a",
 *     snapshotId: exampleAwsEbsSnapshot.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.FastSnapshotRestore("example",
 *     availability_zone="us-west-2a",
 *     snapshot_id=example_aws_ebs_snapshot["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.FastSnapshotRestore("example", new()
 *     {
 *         AvailabilityZone = "us-west-2a",
 *         SnapshotId = exampleAwsEbsSnapshot.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewFastSnapshotRestore(ctx, "example", &ebs.FastSnapshotRestoreArgs{
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			SnapshotId:       pulumi.Any(exampleAwsEbsSnapshot.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.FastSnapshotRestore;
 * import com.pulumi.aws.ebs.FastSnapshotRestoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FastSnapshotRestore("example", FastSnapshotRestoreArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .snapshotId(exampleAwsEbsSnapshot.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:FastSnapshotRestore
 *     properties:
 *       availabilityZone: us-west-2a
 *       snapshotId: ${exampleAwsEbsSnapshot.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EC2 (Elastic Compute Cloud) EBS Fast Snapshot Restore using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ebs/fastSnapshotRestore:FastSnapshotRestore example us-west-2a,snap-abcdef123456
 * ```
 */
public class FastSnapshotRestore internal constructor(
    override val javaResource: com.pulumi.aws.ebs.FastSnapshotRestore,
) : KotlinCustomResource(javaResource, FastSnapshotRestoreMapper) {
    /**
     * Availability zone in which to enable fast snapshot restores.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * ID of the snapshot.
     */
    public val snapshotId: Output<String>
        get() = javaResource.snapshotId().applyValue({ args0 -> args0 })

    /**
     * State of fast snapshot restores. Valid values are `enabling`, `optimizing`, `enabled`, `disabling`, `disabled`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    public val timeouts: Output<FastSnapshotRestoreTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object FastSnapshotRestoreMapper : ResourceMapper<FastSnapshotRestore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.FastSnapshotRestore::class == javaResource::class

    override fun map(javaResource: Resource): FastSnapshotRestore = FastSnapshotRestore(
        javaResource
            as com.pulumi.aws.ebs.FastSnapshotRestore,
    )
}

/**
 * @see [FastSnapshotRestore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FastSnapshotRestore].
 */
public suspend fun fastSnapshotRestore(
    name: String,
    block: suspend FastSnapshotRestoreResourceBuilder.() -> Unit,
): FastSnapshotRestore {
    val builder = FastSnapshotRestoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FastSnapshotRestore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fastSnapshotRestore(name: String): FastSnapshotRestore {
    val builder = FastSnapshotRestoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
