@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.FastSnapshotRestoreArgs.builder
import com.pulumi.aws.ebs.kotlin.inputs.FastSnapshotRestoreTimeoutsArgs
import com.pulumi.aws.ebs.kotlin.inputs.FastSnapshotRestoreTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an EBS (Elastic Block Storage) Fast Snapshot Restore.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.FastSnapshotRestore("example", {
 *     availabilityZone: "us-west-2a",
 *     snapshotId: exampleAwsEbsSnapshot.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.FastSnapshotRestore("example",
 *     availability_zone="us-west-2a",
 *     snapshot_id=example_aws_ebs_snapshot["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.FastSnapshotRestore("example", new()
 *     {
 *         AvailabilityZone = "us-west-2a",
 *         SnapshotId = exampleAwsEbsSnapshot.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewFastSnapshotRestore(ctx, "example", &ebs.FastSnapshotRestoreArgs{
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			SnapshotId:       pulumi.Any(exampleAwsEbsSnapshot.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.FastSnapshotRestore;
 * import com.pulumi.aws.ebs.FastSnapshotRestoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FastSnapshotRestore("example", FastSnapshotRestoreArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .snapshotId(exampleAwsEbsSnapshot.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:FastSnapshotRestore
 *     properties:
 *       availabilityZone: us-west-2a
 *       snapshotId: ${exampleAwsEbsSnapshot.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EC2 (Elastic Compute Cloud) EBS Fast Snapshot Restore using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ebs/fastSnapshotRestore:FastSnapshotRestore example us-west-2a,snap-abcdef123456
 * ```
 * @property availabilityZone Availability zone in which to enable fast snapshot restores.
 * @property snapshotId ID of the snapshot.
 * @property timeouts
 */
public data class FastSnapshotRestoreArgs(
    public val availabilityZone: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val timeouts: Output<FastSnapshotRestoreTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.FastSnapshotRestoreArgs> {
    override fun toJava(): com.pulumi.aws.ebs.FastSnapshotRestoreArgs =
        com.pulumi.aws.ebs.FastSnapshotRestoreArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FastSnapshotRestoreArgs].
 */
@PulumiTagMarker
public class FastSnapshotRestoreArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var timeouts: Output<FastSnapshotRestoreTimeoutsArgs>? = null

    /**
     * @param value Availability zone in which to enable fast snapshot restores.
     */
    @JvmName("wcekualimacpeuww")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value ID of the snapshot.
     */
    @JvmName("ffweaudndiujnnrl")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value
     */
    @JvmName("unbarlxhaonmfkmi")
    public suspend fun timeouts(`value`: Output<FastSnapshotRestoreTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Availability zone in which to enable fast snapshot restores.
     */
    @JvmName("uuynylspbpptfftx")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value ID of the snapshot.
     */
    @JvmName("pmpblvvdcseygyjg")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value
     */
    @JvmName("cwqexmdheyeykcqn")
    public suspend fun timeouts(`value`: FastSnapshotRestoreTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yavbavmjvohbeiph")
    public suspend fun timeouts(argument: suspend FastSnapshotRestoreTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = FastSnapshotRestoreTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): FastSnapshotRestoreArgs = FastSnapshotRestoreArgs(
        availabilityZone = availabilityZone,
        snapshotId = snapshotId,
        timeouts = timeouts,
    )
}
