@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.aws.ebs.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Creates a Snapshot of an EBS Volume.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.Volume("example", {
 *     availabilityZone: "us-west-2a",
 *     size: 40,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * const exampleSnapshot = new aws.ebs.Snapshot("example_snapshot", {
 *     volumeId: example.id,
 *     tags: {
 *         Name: "HelloWorld_snap",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.Volume("example",
 *     availability_zone="us-west-2a",
 *     size=40,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * example_snapshot = aws.ebs.Snapshot("example_snapshot",
 *     volume_id=example.id,
 *     tags={
 *         "Name": "HelloWorld_snap",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.Volume("example", new()
 *     {
 *         AvailabilityZone = "us-west-2a",
 *         Size = 40,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 *     var exampleSnapshot = new Aws.Ebs.Snapshot("example_snapshot", new()
 *     {
 *         VolumeId = example.Id,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld_snap" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ebs.NewVolume(ctx, "example", &ebs.VolumeArgs{
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Size:             pulumi.Int(40),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewSnapshot(ctx, "example_snapshot", &ebs.SnapshotArgs{
 * 			VolumeId: example.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld_snap"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ebs.Snapshot;
 * import com.pulumi.aws.ebs.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .volumeId(example.id())
 *             .tags(Map.of("Name", "HelloWorld_snap"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:Volume
 *     properties:
 *       availabilityZone: us-west-2a
 *       size: 40
 *       tags:
 *         Name: HelloWorld
 *   exampleSnapshot:
 *     type: aws:ebs:Snapshot
 *     name: example_snapshot
 *     properties:
 *       volumeId: ${example.id}
 *       tags:
 *         Name: HelloWorld_snap
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EBS Snapshot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ebs/snapshot:Snapshot id snap-049df61146c4d7901
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.aws.ebs.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * Amazon Resource Name (ARN) of the EBS Snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The data encryption key identifier for the snapshot.
     */
    public val dataEncryptionKeyId: Output<String>
        get() = javaResource.dataEncryptionKeyId().applyValue({ args0 -> args0 })

    /**
     * A description of what the snapshot is.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the snapshot is encrypted.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     */
    public val outpostArn: Output<String>?
        get() = javaResource.outpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
     */
    public val ownerAlias: Output<String>
        get() = javaResource.ownerAlias().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the EBS snapshot owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to permanently restore an archived snapshot.
     */
    public val permanentRestore: Output<Boolean>?
        get() = javaResource.permanentRestore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    public val storageTier: Output<String>
        get() = javaResource.storageTier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    public val temporaryRestoreDays: Output<Int>?
        get() = javaResource.temporaryRestoreDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Volume ID of which to make a snapshot.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })

    /**
     * The size of the drive in GiBs.
     */
    public val volumeSize: Output<Int>
        get() = javaResource.volumeSize().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.aws.ebs.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
