@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Snapshot of an EBS Volume.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.Volume("example", {
 *     availabilityZone: "us-west-2a",
 *     size: 40,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * const exampleSnapshot = new aws.ebs.Snapshot("example_snapshot", {
 *     volumeId: example.id,
 *     tags: {
 *         Name: "HelloWorld_snap",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.Volume("example",
 *     availability_zone="us-west-2a",
 *     size=40,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * example_snapshot = aws.ebs.Snapshot("example_snapshot",
 *     volume_id=example.id,
 *     tags={
 *         "Name": "HelloWorld_snap",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.Volume("example", new()
 *     {
 *         AvailabilityZone = "us-west-2a",
 *         Size = 40,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 *     var exampleSnapshot = new Aws.Ebs.Snapshot("example_snapshot", new()
 *     {
 *         VolumeId = example.Id,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld_snap" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ebs.NewVolume(ctx, "example", &ebs.VolumeArgs{
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Size:             pulumi.Int(40),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ebs.NewSnapshot(ctx, "example_snapshot", &ebs.SnapshotArgs{
 * 			VolumeId: example.ID(),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld_snap"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ebs.Snapshot;
 * import com.pulumi.aws.ebs.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .volumeId(example.id())
 *             .tags(Map.of("Name", "HelloWorld_snap"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:Volume
 *     properties:
 *       availabilityZone: us-west-2a
 *       size: 40
 *       tags:
 *         Name: HelloWorld
 *   exampleSnapshot:
 *     type: aws:ebs:Snapshot
 *     name: example_snapshot
 *     properties:
 *       volumeId: ${example.id}
 *       tags:
 *         Name: HelloWorld_snap
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EBS Snapshot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ebs/snapshot:Snapshot id snap-049df61146c4d7901
 * ```
 * @property description A description of what the snapshot is.
 * @property outpostArn The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
 * @property permanentRestore Indicates whether to permanently restore an archived snapshot.
 * @property storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
 * @property tags A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
 * @property volumeId The Volume ID of which to make a snapshot.
 */
public data class SnapshotArgs(
    public val description: Output<String>? = null,
    public val outpostArn: Output<String>? = null,
    public val permanentRestore: Output<Boolean>? = null,
    public val storageTier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val temporaryRestoreDays: Output<Int>? = null,
    public val volumeId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.SnapshotArgs> {
    override fun toJava(): com.pulumi.aws.ebs.SnapshotArgs = com.pulumi.aws.ebs.SnapshotArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .outpostArn(outpostArn?.applyValue({ args0 -> args0 }))
        .permanentRestore(permanentRestore?.applyValue({ args0 -> args0 }))
        .storageTier(storageTier?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .temporaryRestoreDays(temporaryRestoreDays?.applyValue({ args0 -> args0 }))
        .volumeId(volumeId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var outpostArn: Output<String>? = null

    private var permanentRestore: Output<Boolean>? = null

    private var storageTier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var temporaryRestoreDays: Output<Int>? = null

    private var volumeId: Output<String>? = null

    /**
     * @param value A description of what the snapshot is.
     */
    @JvmName("tuloudyfigrtdkeu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     */
    @JvmName("pjatxncwhpogimjo")
    public suspend fun outpostArn(`value`: Output<String>) {
        this.outpostArn = value
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("jkxniklhuuxktbhr")
    public suspend fun permanentRestore(`value`: Output<Boolean>) {
        this.permanentRestore = value
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("eiwoncjqcaplpjqq")
    public suspend fun storageTier(`value`: Output<String>) {
        this.storageTier = value
    }

    /**
     * @param value A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hunnoxkobompuilu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("oifcroahxomuekxw")
    public suspend fun temporaryRestoreDays(`value`: Output<Int>) {
        this.temporaryRestoreDays = value
    }

    /**
     * @param value The Volume ID of which to make a snapshot.
     */
    @JvmName("ivvcrpgfyasjrunw")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value A description of what the snapshot is.
     */
    @JvmName("miwcfaclgqnnedav")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost on which to create a local snapshot.
     */
    @JvmName("isnwbwvcfsweoqvh")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostArn = mapped
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("tlhmwnnoscutmlpn")
    public suspend fun permanentRestore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permanentRestore = mapped
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("obvrddushpdghtpi")
    public suspend fun storageTier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTier = mapped
    }

    /**
     * @param value A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tjapbjxqjoajgfda")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the snapshot. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqsfstcxgufxkvlk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("yfyutefkorkseayv")
    public suspend fun temporaryRestoreDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryRestoreDays = mapped
    }

    /**
     * @param value The Volume ID of which to make a snapshot.
     */
    @JvmName("eddvvnhrjrspxctx")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        description = description,
        outpostArn = outpostArn,
        permanentRestore = permanentRestore,
        storageTier = storageTier,
        tags = tags,
        temporaryRestoreDays = temporaryRestoreDays,
        volumeId = volumeId,
    )
}
