@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SnapshotBlockPublicAccess].
 */
@PulumiTagMarker
public class SnapshotBlockPublicAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotBlockPublicAccessArgs = SnapshotBlockPublicAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotBlockPublicAccessArgsBuilder.() -> Unit) {
        val builder = SnapshotBlockPublicAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotBlockPublicAccess {
        val builtJavaResource = com.pulumi.aws.ebs.SnapshotBlockPublicAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotBlockPublicAccess(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.SnapshotBlockPublicAccess("example", {state: "block-all-sharing"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.SnapshotBlockPublicAccess("example", state="block-all-sharing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.SnapshotBlockPublicAccess("example", new()
 *     {
 *         State = "block-all-sharing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewSnapshotBlockPublicAccess(ctx, "example", &ebs.SnapshotBlockPublicAccessArgs{
 * 			State: pulumi.String("block-all-sharing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.SnapshotBlockPublicAccess;
 * import com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotBlockPublicAccess("example", SnapshotBlockPublicAccessArgs.builder()
 *             .state("block-all-sharing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:SnapshotBlockPublicAccess
 *     properties:
 *       state: block-all-sharing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the state. For example:
 * ```sh
 * $ pulumi import aws:ebs/snapshotBlockPublicAccess:SnapshotBlockPublicAccess example default
 * ```
 */
public class SnapshotBlockPublicAccess internal constructor(
    override val javaResource: com.pulumi.aws.ebs.SnapshotBlockPublicAccess,
) : KotlinCustomResource(javaResource, SnapshotBlockPublicAccessMapper) {
    /**
     * The mode in which to enable "Block public access for snapshots" for the region. Allowed values are `block-all`, `block-new-sharing`, `unblocked`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object SnapshotBlockPublicAccessMapper : ResourceMapper<SnapshotBlockPublicAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.SnapshotBlockPublicAccess::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotBlockPublicAccess =
        SnapshotBlockPublicAccess(javaResource as com.pulumi.aws.ebs.SnapshotBlockPublicAccess)
}

/**
 * @see [SnapshotBlockPublicAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotBlockPublicAccess].
 */
public suspend fun snapshotBlockPublicAccess(
    name: String,
    block: suspend SnapshotBlockPublicAccessResourceBuilder.() -> Unit,
): SnapshotBlockPublicAccess {
    val builder = SnapshotBlockPublicAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotBlockPublicAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotBlockPublicAccess(name: String): SnapshotBlockPublicAccess {
    val builder = SnapshotBlockPublicAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
