@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.SnapshotBlockPublicAccess("example", {state: "block-all-sharing"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.SnapshotBlockPublicAccess("example", state="block-all-sharing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.SnapshotBlockPublicAccess("example", new()
 *     {
 *         State = "block-all-sharing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewSnapshotBlockPublicAccess(ctx, "example", &ebs.SnapshotBlockPublicAccessArgs{
 * 			State: pulumi.String("block-all-sharing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.SnapshotBlockPublicAccess;
 * import com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotBlockPublicAccess("example", SnapshotBlockPublicAccessArgs.builder()
 *             .state("block-all-sharing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:SnapshotBlockPublicAccess
 *     properties:
 *       state: block-all-sharing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the state. For example:
 * ```sh
 * $ pulumi import aws:ebs/snapshotBlockPublicAccess:SnapshotBlockPublicAccess example default
 * ```
 * @property state The mode in which to enable "Block public access for snapshots" for the region. Allowed values are `block-all`, `block-new-sharing`, `unblocked`.
 */
public data class SnapshotBlockPublicAccessArgs(
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs> {
    override fun toJava(): com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs =
        com.pulumi.aws.ebs.SnapshotBlockPublicAccessArgs.builder()
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotBlockPublicAccessArgs].
 */
@PulumiTagMarker
public class SnapshotBlockPublicAccessArgsBuilder internal constructor() {
    private var state: Output<String>? = null

    /**
     * @param value The mode in which to enable "Block public access for snapshots" for the region. Allowed values are `block-all`, `block-new-sharing`, `unblocked`.
     */
    @JvmName("ybswfqeikpaggibs")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The mode in which to enable "Block public access for snapshots" for the region. Allowed values are `block-all`, `block-new-sharing`, `unblocked`.
     */
    @JvmName("kcwptsautggmbwkr")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SnapshotBlockPublicAccessArgs = SnapshotBlockPublicAccessArgs(
        state = state,
    )
}
