@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.kotlin.outputs.SnapshotImportClientData
import com.pulumi.aws.ebs.kotlin.outputs.SnapshotImportDiskContainer
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ebs.kotlin.outputs.SnapshotImportClientData.Companion.toKotlin as snapshotImportClientDataToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.SnapshotImportDiskContainer.Companion.toKotlin as snapshotImportDiskContainerToKotlin

/**
 * Builder for [SnapshotImport].
 */
@PulumiTagMarker
public class SnapshotImportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotImportArgs = SnapshotImportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotImportArgsBuilder.() -> Unit) {
        val builder = SnapshotImportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SnapshotImport {
        val builtJavaResource = com.pulumi.aws.ebs.SnapshotImport(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SnapshotImport(builtJavaResource)
    }
}

/**
 * Imports a disk image from S3 as a Snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.SnapshotImport("example", {
 *     diskContainer: {
 *         format: "VHD",
 *         userBucket: {
 *             s3Bucket: "disk-images",
 *             s3Key: "source.vhd",
 *         },
 *     },
 *     roleName: "disk-image-import",
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.SnapshotImport("example",
 *     disk_container={
 *         "format": "VHD",
 *         "user_bucket": {
 *             "s3_bucket": "disk-images",
 *             "s3_key": "source.vhd",
 *         },
 *     },
 *     role_name="disk-image-import",
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.SnapshotImport("example", new()
 *     {
 *         DiskContainer = new Aws.Ebs.Inputs.SnapshotImportDiskContainerArgs
 *         {
 *             Format = "VHD",
 *             UserBucket = new Aws.Ebs.Inputs.SnapshotImportDiskContainerUserBucketArgs
 *             {
 *                 S3Bucket = "disk-images",
 *                 S3Key = "source.vhd",
 *             },
 *         },
 *         RoleName = "disk-image-import",
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewSnapshotImport(ctx, "example", &ebs.SnapshotImportArgs{
 * 			DiskContainer: &ebs.SnapshotImportDiskContainerArgs{
 * 				Format: pulumi.String("VHD"),
 * 				UserBucket: &ebs.SnapshotImportDiskContainerUserBucketArgs{
 * 					S3Bucket: pulumi.String("disk-images"),
 * 					S3Key:    pulumi.String("source.vhd"),
 * 				},
 * 			},
 * 			RoleName: pulumi.String("disk-image-import"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.SnapshotImport;
 * import com.pulumi.aws.ebs.SnapshotImportArgs;
 * import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs;
 * import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotImport("example", SnapshotImportArgs.builder()
 *             .diskContainer(SnapshotImportDiskContainerArgs.builder()
 *                 .format("VHD")
 *                 .userBucket(SnapshotImportDiskContainerUserBucketArgs.builder()
 *                     .s3Bucket("disk-images")
 *                     .s3Key("source.vhd")
 *                     .build())
 *                 .build())
 *             .roleName("disk-image-import")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:SnapshotImport
 *     properties:
 *       diskContainer:
 *         format: VHD
 *         userBucket:
 *           s3Bucket: disk-images
 *           s3Key: source.vhd
 *       roleName: disk-image-import
 *       tags:
 *         Name: HelloWorld
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class SnapshotImport internal constructor(
    override val javaResource: com.pulumi.aws.ebs.SnapshotImport,
) : KotlinCustomResource(javaResource, SnapshotImportMapper) {
    /**
     * Amazon Resource Name (ARN) of the EBS Snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The client-specific data. Detailed below.
     */
    public val clientData: Output<SnapshotImportClientData>?
        get() = javaResource.clientData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    snapshotImportClientDataToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The data encryption key identifier for the snapshot.
     */
    public val dataEncryptionKeyId: Output<String>
        get() = javaResource.dataEncryptionKeyId().applyValue({ args0 -> args0 })

    /**
     * The description string for the import snapshot task.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Information about the disk container. Detailed below.
     */
    public val diskContainer: Output<SnapshotImportDiskContainer>
        get() = javaResource.diskContainer().applyValue({ args0 ->
            args0.let({ args0 ->
                snapshotImportDiskContainerToKotlin(args0)
            })
        })

    /**
     * Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    /**
     * Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
     */
    public val ownerAlias: Output<String>
        get() = javaResource.ownerAlias().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the EBS snapshot owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to permanently restore an archived snapshot.
     */
    public val permanentRestore: Output<Boolean>?
        get() = javaResource.permanentRestore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
     */
    public val roleName: Output<String>?
        get() = javaResource.roleName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    public val storageTier: Output<String>
        get() = javaResource.storageTier().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the snapshot.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    public val temporaryRestoreDays: Output<Int>?
        get() = javaResource.temporaryRestoreDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })

    /**
     * The size of the drive in GiBs.
     */
    public val volumeSize: Output<Int>
        get() = javaResource.volumeSize().applyValue({ args0 -> args0 })
}

public object SnapshotImportMapper : ResourceMapper<SnapshotImport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.SnapshotImport::class == javaResource::class

    override fun map(javaResource: Resource): SnapshotImport = SnapshotImport(
        javaResource as
            com.pulumi.aws.ebs.SnapshotImport,
    )
}

/**
 * @see [SnapshotImport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SnapshotImport].
 */
public suspend fun snapshotImport(
    name: String,
    block: suspend SnapshotImportResourceBuilder.() -> Unit,
): SnapshotImport {
    val builder = SnapshotImportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SnapshotImport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshotImport(name: String): SnapshotImport {
    val builder = SnapshotImportResourceBuilder()
    builder.name(name)
    return builder.build()
}
