@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.SnapshotImportArgs.builder
import com.pulumi.aws.ebs.kotlin.inputs.SnapshotImportClientDataArgs
import com.pulumi.aws.ebs.kotlin.inputs.SnapshotImportClientDataArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.SnapshotImportDiskContainerArgs
import com.pulumi.aws.ebs.kotlin.inputs.SnapshotImportDiskContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Imports a disk image from S3 as a Snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.SnapshotImport("example", {
 *     diskContainer: {
 *         format: "VHD",
 *         userBucket: {
 *             s3Bucket: "disk-images",
 *             s3Key: "source.vhd",
 *         },
 *     },
 *     roleName: "disk-image-import",
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.SnapshotImport("example",
 *     disk_container={
 *         "format": "VHD",
 *         "user_bucket": {
 *             "s3_bucket": "disk-images",
 *             "s3_key": "source.vhd",
 *         },
 *     },
 *     role_name="disk-image-import",
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.SnapshotImport("example", new()
 *     {
 *         DiskContainer = new Aws.Ebs.Inputs.SnapshotImportDiskContainerArgs
 *         {
 *             Format = "VHD",
 *             UserBucket = new Aws.Ebs.Inputs.SnapshotImportDiskContainerUserBucketArgs
 *             {
 *                 S3Bucket = "disk-images",
 *                 S3Key = "source.vhd",
 *             },
 *         },
 *         RoleName = "disk-image-import",
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewSnapshotImport(ctx, "example", &ebs.SnapshotImportArgs{
 * 			DiskContainer: &ebs.SnapshotImportDiskContainerArgs{
 * 				Format: pulumi.String("VHD"),
 * 				UserBucket: &ebs.SnapshotImportDiskContainerUserBucketArgs{
 * 					S3Bucket: pulumi.String("disk-images"),
 * 					S3Key:    pulumi.String("source.vhd"),
 * 				},
 * 			},
 * 			RoleName: pulumi.String("disk-image-import"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.SnapshotImport;
 * import com.pulumi.aws.ebs.SnapshotImportArgs;
 * import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs;
 * import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SnapshotImport("example", SnapshotImportArgs.builder()
 *             .diskContainer(SnapshotImportDiskContainerArgs.builder()
 *                 .format("VHD")
 *                 .userBucket(SnapshotImportDiskContainerUserBucketArgs.builder()
 *                     .s3Bucket("disk-images")
 *                     .s3Key("source.vhd")
 *                     .build())
 *                 .build())
 *             .roleName("disk-image-import")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:SnapshotImport
 *     properties:
 *       diskContainer:
 *         format: VHD
 *         userBucket:
 *           s3Bucket: disk-images
 *           s3Key: source.vhd
 *       roleName: disk-image-import
 *       tags:
 *         Name: HelloWorld
 * ```
 * <!--End PulumiCodeChooser -->
 * @property clientData The client-specific data. Detailed below.
 * @property description The description string for the import snapshot task.
 * @property diskContainer Information about the disk container. Detailed below.
 * @property encrypted Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
 * @property kmsKeyId An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
 * @property permanentRestore Indicates whether to permanently restore an archived snapshot.
 * @property roleName The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
 * @property storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
 * @property tags A map of tags to assign to the snapshot.
 * @property temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
 */
public data class SnapshotImportArgs(
    public val clientData: Output<SnapshotImportClientDataArgs>? = null,
    public val description: Output<String>? = null,
    public val diskContainer: Output<SnapshotImportDiskContainerArgs>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val permanentRestore: Output<Boolean>? = null,
    public val roleName: Output<String>? = null,
    public val storageTier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val temporaryRestoreDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.SnapshotImportArgs> {
    override fun toJava(): com.pulumi.aws.ebs.SnapshotImportArgs =
        com.pulumi.aws.ebs.SnapshotImportArgs.builder()
            .clientData(clientData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .diskContainer(diskContainer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .permanentRestore(permanentRestore?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .storageTier(storageTier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .temporaryRestoreDays(temporaryRestoreDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotImportArgs].
 */
@PulumiTagMarker
public class SnapshotImportArgsBuilder internal constructor() {
    private var clientData: Output<SnapshotImportClientDataArgs>? = null

    private var description: Output<String>? = null

    private var diskContainer: Output<SnapshotImportDiskContainerArgs>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var permanentRestore: Output<Boolean>? = null

    private var roleName: Output<String>? = null

    private var storageTier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var temporaryRestoreDays: Output<Int>? = null

    /**
     * @param value The client-specific data. Detailed below.
     */
    @JvmName("odhtvvuuwingdqmv")
    public suspend fun clientData(`value`: Output<SnapshotImportClientDataArgs>) {
        this.clientData = value
    }

    /**
     * @param value The description string for the import snapshot task.
     */
    @JvmName("juuokhfyputtnooq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Information about the disk container. Detailed below.
     */
    @JvmName("fpfnpahsotmncddq")
    public suspend fun diskContainer(`value`: Output<SnapshotImportDiskContainerArgs>) {
        this.diskContainer = value
    }

    /**
     * @param value Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
     */
    @JvmName("gecicrlidilpuxgh")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
     */
    @JvmName("ybqpeechdeluifdh")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("vbawilyowyhttkpx")
    public suspend fun permanentRestore(`value`: Output<Boolean>) {
        this.permanentRestore = value
    }

    /**
     * @param value The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
     */
    @JvmName("cmgpmdbrvtabvfie")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("kqoxegoqkgqcgkgv")
    public suspend fun storageTier(`value`: Output<String>) {
        this.storageTier = value
    }

    /**
     * @param value A map of tags to assign to the snapshot.
     */
    @JvmName("dsdkagkjrrpgvaqe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("afpymljwlaxoccqi")
    public suspend fun temporaryRestoreDays(`value`: Output<Int>) {
        this.temporaryRestoreDays = value
    }

    /**
     * @param value The client-specific data. Detailed below.
     */
    @JvmName("qxccfvvgevxqgtig")
    public suspend fun clientData(`value`: SnapshotImportClientDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientData = mapped
    }

    /**
     * @param argument The client-specific data. Detailed below.
     */
    @JvmName("stopxwhoaihkxlvw")
    public suspend fun clientData(argument: suspend SnapshotImportClientDataArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotImportClientDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientData = mapped
    }

    /**
     * @param value The description string for the import snapshot task.
     */
    @JvmName("fnmyoaguibdumker")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Information about the disk container. Detailed below.
     */
    @JvmName("jbgglernyqmivcgt")
    public suspend fun diskContainer(`value`: SnapshotImportDiskContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskContainer = mapped
    }

    /**
     * @param argument Information about the disk container. Detailed below.
     */
    @JvmName("jtobppmgiigwtybg")
    public suspend fun diskContainer(argument: suspend SnapshotImportDiskContainerArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotImportDiskContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskContainer = mapped
    }

    /**
     * @param value Specifies whether the destination snapshot of the imported image should be encrypted. The default KMS key for EBS is used unless you specify a non-default KMS key using KmsKeyId.
     */
    @JvmName("ypvwlwgjqxfhtgwh")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value An identifier for the symmetric KMS key to use when creating the encrypted snapshot. This parameter is only required if you want to use a non-default KMS key; if this parameter is not specified, the default KMS key for EBS is used. If a KmsKeyId is specified, the Encrypted flag must also be set.
     */
    @JvmName("oonmlnwyilpuwrit")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("tubuuhtmkdnflhuv")
    public suspend fun permanentRestore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permanentRestore = mapped
    }

    /**
     * @param value The name of the IAM Role the VM Import/Export service will assume. This role needs certain permissions. See https://docs.aws.amazon.com/vm-import/latest/userguide/vmie_prereqs.html#vmimport-role. Default: `vmimport`
     */
    @JvmName("xpgmfebhvadxmepm")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("txlrwepcbsapcgwj")
    public suspend fun storageTier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTier = mapped
    }

    /**
     * @param value A map of tags to assign to the snapshot.
     */
    @JvmName("msogcvpxsaticheu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the snapshot.
     */
    @JvmName("cwxflugdjvyfykie")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("jlrheskdihxiidyr")
    public suspend fun temporaryRestoreDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryRestoreDays = mapped
    }

    internal fun build(): SnapshotImportArgs = SnapshotImportArgs(
        clientData = clientData,
        description = description,
        diskContainer = diskContainer,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        permanentRestore = permanentRestore,
        roleName = roleName,
        storageTier = storageTier,
        tags = tags,
        temporaryRestoreDays = temporaryRestoreDays,
    )
}
