@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Volume].
 */
@PulumiTagMarker
public class VolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VolumeArgs = VolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VolumeArgsBuilder.() -> Unit) {
        val builder = VolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Volume {
        val builtJavaResource = com.pulumi.aws.ebs.Volume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Volume(builtJavaResource)
    }
}

/**
 * Manages a single EBS volume.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ebs.Volume("example", {
 *     availabilityZone: "us-west-2a",
 *     size: 40,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ebs.Volume("example",
 *     availability_zone="us-west-2a",
 *     size=40,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ebs.Volume("example", new()
 *     {
 *         AvailabilityZone = "us-west-2a",
 *         Size = 40,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.NewVolume(ctx, "example", &ebs.VolumeArgs{
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Size:             pulumi.Int(40),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ebs:Volume
 *     properties:
 *       availabilityZone: us-west-2a
 *       size: 40
 *       tags:
 *         Name: HelloWorld
 * ```
 * <!--End PulumiCodeChooser -->
 * > **NOTE:** At least one of `size` or `snapshot_id` is required when specifying an EBS volume
 * ## Import
 * Using `pulumi import`, import EBS Volumes using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ebs/volume:Volume id vol-049df61146c4d7901
 * ```
 */
public class Volume internal constructor(
    override val javaResource: com.pulumi.aws.ebs.Volume,
) : KotlinCustomResource(javaResource, VolumeMapper) {
    /**
     * The volume ARN (e.g., arn:aws:ec2:us-east-1:0123456789012:volume/vol-59fcb34e).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AZ where the EBS volume will exist.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * If true, the disk will be encrypted.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * If true, snapshot will be created before volume deletion. Any tags on the volume will be migrated to the snapshot. By default set to false
     */
    public val finalSnapshot: Output<Boolean>?
        get() = javaResource.finalSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The amount of IOPS to provision for the disk. Only valid for `type` of `io1`, `io2` or `gp3`.
     */
    public val iops: Output<Int>
        get() = javaResource.iops().applyValue({ args0 -> args0 })

    /**
     * The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true. Note: The provider must be running with credentials which have the `GenerateDataKeyWithoutPlaintext` permission on the specified KMS key as required by the [EBS KMS CMK volume provisioning process](https://docs.aws.amazon.com/kms/latest/developerguide/services-ebs.html#ebs-cmk) to prevent a volume from being created and almost immediately deleted.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable Amazon EBS Multi-Attach. Multi-Attach is supported on `io1` and `io2` volumes.
     */
    public val multiAttachEnabled: Output<Boolean>?
        get() = javaResource.multiAttachEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    public val outpostArn: Output<String>?
        get() = javaResource.outpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the drive in GiBs.
     */
    public val size: Output<Int>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * A snapshot to base the EBS volume off of.
     */
    public val snapshotId: Output<String>
        get() = javaResource.snapshotId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The throughput that the volume supports, in MiB/s. Only valid for `type` of `gp3`.
     * > **NOTE:** When changing the `size`, `iops` or `type` of an instance, there are [considerations](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/considerations.html) to be aware of.
     */
    public val throughput: Output<Int>
        get() = javaResource.throughput().applyValue({ args0 -> args0 })

    /**
     * The type of EBS volume. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `gp2`).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VolumeMapper : ResourceMapper<Volume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.Volume::class == javaResource::class

    override fun map(javaResource: Resource): Volume = Volume(
        javaResource as
            com.pulumi.aws.ebs.Volume,
    )
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Volume].
 */
public suspend fun volume(name: String, block: suspend VolumeResourceBuilder.() -> Unit): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Volume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun volume(name: String): Volume {
    val builder = VolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
