@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.GetEbsVolumesFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the field to filter by, as defined by
 * [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html).
 * For example, if matching against the `size` filter, use:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tenOrTwentyGbVolumes = aws.ebs.getEbsVolumes({
 *     filters: [{
 *         name: "size",
 *         values: [
 *             "10",
 *             "20",
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ten_or_twenty_gb_volumes = aws.ebs.get_ebs_volumes(filters=[{
 *     "name": "size",
 *     "values": [
 *         "10",
 *         "20",
 *     ],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tenOrTwentyGbVolumes = Aws.Ebs.GetEbsVolumes.Invoke(new()
 *     {
 *         Filters = new[]
 *         {
 *             new Aws.Ebs.Inputs.GetEbsVolumesFilterInputArgs
 *             {
 *                 Name = "size",
 *                 Values = new[]
 *                 {
 *                     "10",
 *                     "20",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ebs.GetEbsVolumes(ctx, &ebs.GetEbsVolumesArgs{
 * 			Filters: []ebs.GetEbsVolumesFilter{
 * 				{
 * 					Name: "size",
 * 					Values: []string{
 * 						"10",
 * 						"20",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.EbsFunctions;
 * import com.pulumi.aws.ebs.inputs.GetEbsVolumesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var tenOrTwentyGbVolumes = EbsFunctions.getEbsVolumes(GetEbsVolumesArgs.builder()
 *             .filters(GetEbsVolumesFilterArgs.builder()
 *                 .name("size")
 *                 .values(
 *                     "10",
 *                     "20")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   tenOrTwentyGbVolumes:
 *     fn::invoke:
 *       Function: aws:ebs:getEbsVolumes
 *       Arguments:
 *         filters:
 *           - name: size
 *             values:
 *               - '10'
 *               - '20'
 * ```
 * <!--End PulumiCodeChooser -->
 * @property values Set of values that are accepted for the given field.
 * EBS Volume IDs will be selected if any one of the given values match.
 */
public data class GetEbsVolumesFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.GetEbsVolumesFilter> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.GetEbsVolumesFilter =
        com.pulumi.aws.ebs.inputs.GetEbsVolumesFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetEbsVolumesFilter].
 */
@PulumiTagMarker
public class GetEbsVolumesFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the field to filter by, as defined by
     * [the underlying AWS API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html).
     * For example, if matching against the `size` filter, use:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const tenOrTwentyGbVolumes = aws.ebs.getEbsVolumes({
     *     filters: [{
     *         name: "size",
     *         values: [
     *             "10",
     *             "20",
     *         ],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ten_or_twenty_gb_volumes = aws.ebs.get_ebs_volumes(filters=[{
     *     "name": "size",
     *     "values": [
     *         "10",
     *         "20",
     *     ],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var tenOrTwentyGbVolumes = Aws.Ebs.GetEbsVolumes.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ebs.Inputs.GetEbsVolumesFilterInputArgs
     *             {
     *                 Name = "size",
     *                 Values = new[]
     *                 {
     *                     "10",
     *                     "20",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ebs"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ebs.GetEbsVolumes(ctx, &ebs.GetEbsVolumesArgs{
     * 			Filters: []ebs.GetEbsVolumesFilter{
     * 				{
     * 					Name: "size",
     * 					Values: []string{
     * 						"10",
     * 						"20",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetEbsVolumesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var tenOrTwentyGbVolumes = EbsFunctions.getEbsVolumes(GetEbsVolumesArgs.builder()
     *             .filters(GetEbsVolumesFilterArgs.builder()
     *                 .name("size")
     *                 .values(
     *                     "10",
     *                     "20")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   tenOrTwentyGbVolumes:
     *     fn::invoke:
     *       Function: aws:ebs:getEbsVolumes
     *       Arguments:
     *         filters:
     *           - name: size
     *             values:
     *               - '10'
     *               - '20'
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("jybawirmypdnxeno")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     * EBS Volume IDs will be selected if any one of the given values match.
     */
    @JvmName("kfuqfjnexwimxyle")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     * EBS Volume IDs will be selected if any one of the given values match.
     */
    @JvmName("wutgolnijlsranjp")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetEbsVolumesFilter = GetEbsVolumesFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
