@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.GetSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshot.
 * @property filters One or more name/value pairs to filter off of. There are
 * several valid keys, for a full reference, check out
 * [describe-snapshots in the AWS CLI reference][1].
 * @property mostRecent If more than one result is returned, use the most recent snapshot.
 * @property owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
 * @property restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
 * @property snapshotIds Returns information on a specific snapshot_id.
 * @property tags Map of tags for the resource.
 */
public data class GetSnapshotPlainArgs(
    public val filters: List<GetSnapshotFilter>? = null,
    public val mostRecent: Boolean? = null,
    public val owners: List<String>? = null,
    public val restorableByUserIds: List<String>? = null,
    public val snapshotIds: List<String>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.GetSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.GetSnapshotPlainArgs =
        com.pulumi.aws.ebs.inputs.GetSnapshotPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .owners(owners?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .restorableByUserIds(restorableByUserIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .snapshotIds(snapshotIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotPlainArgsBuilder internal constructor() {
    private var filters: List<GetSnapshotFilter>? = null

    private var mostRecent: Boolean? = null

    private var owners: List<String>? = null

    private var restorableByUserIds: List<String>? = null

    private var snapshotIds: List<String>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     */
    @JvmName("vsawcremllwmqmoq")
    public suspend fun filters(`value`: List<GetSnapshotFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     */
    @JvmName("jfodiunvmrskldjy")
    public suspend fun filters(argument: List<suspend GetSnapshotFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSnapshotFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     */
    @JvmName("sqgrujibdccwvplj")
    public suspend fun filters(vararg argument: suspend GetSnapshotFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSnapshotFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     */
    @JvmName("nqpqqxtoyqpqkeef")
    public suspend fun filters(argument: suspend GetSnapshotFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSnapshotFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     */
    @JvmName("fywggaplgjmjmhpk")
    public suspend fun filters(vararg values: GetSnapshotFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If more than one result is returned, use the most recent snapshot.
     */
    @JvmName("ruarjidrpdhploai")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     */
    @JvmName("hljredprvtqcutph")
    public suspend fun owners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param values Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     */
    @JvmName("kpmqaponvkddhdwq")
    public suspend fun owners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param value One or more AWS accounts IDs that can create volumes from the snapshot.
     */
    @JvmName("nquwvkexlamxeicc")
    public suspend fun restorableByUserIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.restorableByUserIds = mapped
    }

    /**
     * @param values One or more AWS accounts IDs that can create volumes from the snapshot.
     */
    @JvmName("knjnhfpmjpfhfbmv")
    public suspend fun restorableByUserIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restorableByUserIds = mapped
    }

    /**
     * @param value Returns information on a specific snapshot_id.
     */
    @JvmName("tlrrervtqhyxptou")
    public suspend fun snapshotIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotIds = mapped
    }

    /**
     * @param values Returns information on a specific snapshot_id.
     */
    @JvmName("sprsknuesbvfcqrk")
    public suspend fun snapshotIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotIds = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("asrrtwbcbswjcwbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("bdsjxemfvciacpcq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSnapshotPlainArgs = GetSnapshotPlainArgs(
        filters = filters,
        mostRecent = mostRecent,
        owners = owners,
        restorableByUserIds = restorableByUserIds,
        snapshotIds = snapshotIds,
        tags = tags,
    )
}
