@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.SnapshotImportClientDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comment A user-defined comment about the disk upload.
 * @property uploadEnd The time that the disk upload ends.
 * @property uploadSize The size of the uploaded disk image, in GiB.
 * @property uploadStart The time that the disk upload starts.
 */
public data class SnapshotImportClientDataArgs(
    public val comment: Output<String>? = null,
    public val uploadEnd: Output<String>? = null,
    public val uploadSize: Output<Double>? = null,
    public val uploadStart: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.SnapshotImportClientDataArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.SnapshotImportClientDataArgs =
        com.pulumi.aws.ebs.inputs.SnapshotImportClientDataArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .uploadEnd(uploadEnd?.applyValue({ args0 -> args0 }))
            .uploadSize(uploadSize?.applyValue({ args0 -> args0 }))
            .uploadStart(uploadStart?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotImportClientDataArgs].
 */
@PulumiTagMarker
public class SnapshotImportClientDataArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var uploadEnd: Output<String>? = null

    private var uploadSize: Output<Double>? = null

    private var uploadStart: Output<String>? = null

    /**
     * @param value A user-defined comment about the disk upload.
     */
    @JvmName("xsoonnlyasueopqm")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value The time that the disk upload ends.
     */
    @JvmName("unkeucegvokmncyv")
    public suspend fun uploadEnd(`value`: Output<String>) {
        this.uploadEnd = value
    }

    /**
     * @param value The size of the uploaded disk image, in GiB.
     */
    @JvmName("ohnphybpvsbdewop")
    public suspend fun uploadSize(`value`: Output<Double>) {
        this.uploadSize = value
    }

    /**
     * @param value The time that the disk upload starts.
     */
    @JvmName("kltogdxogeobqotf")
    public suspend fun uploadStart(`value`: Output<String>) {
        this.uploadStart = value
    }

    /**
     * @param value A user-defined comment about the disk upload.
     */
    @JvmName("lnjnkcljjxksklvn")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value The time that the disk upload ends.
     */
    @JvmName("dhnidutoaltxytgo")
    public suspend fun uploadEnd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadEnd = mapped
    }

    /**
     * @param value The size of the uploaded disk image, in GiB.
     */
    @JvmName("utvpvqudpgahqvxp")
    public suspend fun uploadSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadSize = mapped
    }

    /**
     * @param value The time that the disk upload starts.
     */
    @JvmName("kteqjbmrlgmsdyhb")
    public suspend fun uploadStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uploadStart = mapped
    }

    internal fun build(): SnapshotImportClientDataArgs = SnapshotImportClientDataArgs(
        comment = comment,
        uploadEnd = uploadEnd,
        uploadSize = uploadSize,
        uploadStart = uploadStart,
    )
}
