@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property description The description of the disk image being imported.
 * @property format The format of the disk image being imported. One of `VHD` or `VMDK`.
 * @property url The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon S3 URL (s3://..). One of `url` or `user_bucket` must be set.
 * @property userBucket The Amazon S3 bucket for the disk image. One of `url` or `user_bucket` must be set. Detailed below.
 */
public data class SnapshotImportDiskContainerArgs(
    public val description: Output<String>? = null,
    public val format: Output<String>,
    public val url: Output<String>? = null,
    public val userBucket: Output<SnapshotImportDiskContainerUserBucketArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs =
        com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .format(format.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 }))
            .userBucket(userBucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SnapshotImportDiskContainerArgs].
 */
@PulumiTagMarker
public class SnapshotImportDiskContainerArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var format: Output<String>? = null

    private var url: Output<String>? = null

    private var userBucket: Output<SnapshotImportDiskContainerUserBucketArgs>? = null

    /**
     * @param value The description of the disk image being imported.
     */
    @JvmName("jhwfymifeqflaiki")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The format of the disk image being imported. One of `VHD` or `VMDK`.
     */
    @JvmName("fmkifpuiswfpofmd")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon S3 URL (s3://..). One of `url` or `user_bucket` must be set.
     */
    @JvmName("owyyyisgeikbojum")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The Amazon S3 bucket for the disk image. One of `url` or `user_bucket` must be set. Detailed below.
     */
    @JvmName("mvahmdnljpvwwrfw")
    public suspend fun userBucket(`value`: Output<SnapshotImportDiskContainerUserBucketArgs>) {
        this.userBucket = value
    }

    /**
     * @param value The description of the disk image being imported.
     */
    @JvmName("mfikkfguonpkepgd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The format of the disk image being imported. One of `VHD` or `VMDK`.
     */
    @JvmName("yjkcuxdxjpiketnl")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon S3 URL (s3://..). One of `url` or `user_bucket` must be set.
     */
    @JvmName("mofyebyxpxjnijcn")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value The Amazon S3 bucket for the disk image. One of `url` or `user_bucket` must be set. Detailed below.
     */
    @JvmName("ykkwldsesdxtikjr")
    public suspend fun userBucket(`value`: SnapshotImportDiskContainerUserBucketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userBucket = mapped
    }

    /**
     * @param argument The Amazon S3 bucket for the disk image. One of `url` or `user_bucket` must be set. Detailed below.
     */
    @JvmName("bxfkpxlldrviysvh")
    public suspend fun userBucket(argument: suspend SnapshotImportDiskContainerUserBucketArgsBuilder.() -> Unit) {
        val toBeMapped = SnapshotImportDiskContainerUserBucketArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userBucket = mapped
    }

    internal fun build(): SnapshotImportDiskContainerArgs = SnapshotImportDiskContainerArgs(
        description = description,
        format = format ?: throw PulumiNullFieldException("format"),
        url = url,
        userBucket = userBucket,
    )
}
