@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEncryptionByDefault.
 * @property enabled Whether or not default EBS encryption is enabled. Returns as `true` or `false`.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetEncryptionByDefaultResult(
    public val enabled: Boolean,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetEncryptionByDefaultResult): GetEncryptionByDefaultResult = GetEncryptionByDefaultResult(
            enabled = javaType.enabled(),
            id = javaType.id(),
        )
    }
}
