@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSnapshot.
 * @property arn ARN of the EBS Snapshot.
 * @property dataEncryptionKeyId The data encryption key identifier for the snapshot.
 * @property description Description for the snapshot
 * @property encrypted Whether the snapshot is encrypted.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId ARN for the KMS encryption key.
 * @property mostRecent
 * @property outpostArn ARN of the Outpost on which the snapshot is stored.
 * @property ownerAlias Value from an Amazon-maintained list (`amazon`, `aws-marketplace`, `microsoft`) of snapshot owners.
 * @property ownerId AWS account ID of the EBS snapshot owner.
 * @property owners
 * @property restorableByUserIds
 * @property snapshotId Snapshot ID (e.g., snap-59fcb34e).
 * @property snapshotIds
 * @property state Snapshot state.
 * @property storageTier Storage tier in which the snapshot is stored.
 * @property tags Map of tags for the resource.
 * @property volumeId Volume ID (e.g., vol-59fcb34e).
 * @property volumeSize Size of the drive in GiBs.
 */
public data class GetSnapshotResult(
    public val arn: String,
    public val dataEncryptionKeyId: String,
    public val description: String,
    public val encrypted: Boolean,
    public val filters: List<GetSnapshotFilter>? = null,
    public val id: String,
    public val kmsKeyId: String,
    public val mostRecent: Boolean? = null,
    public val outpostArn: String,
    public val ownerAlias: String,
    public val ownerId: String,
    public val owners: List<String>? = null,
    public val restorableByUserIds: List<String>? = null,
    public val snapshotId: String,
    public val snapshotIds: List<String>? = null,
    public val state: String,
    public val storageTier: String,
    public val tags: Map<String, String>,
    public val volumeId: String,
    public val volumeSize: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetSnapshotResult): GetSnapshotResult =
            GetSnapshotResult(
                arn = javaType.arn(),
                dataEncryptionKeyId = javaType.dataEncryptionKeyId(),
                description = javaType.description(),
                encrypted = javaType.encrypted(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                kmsKeyId = javaType.kmsKeyId(),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                outpostArn = javaType.outpostArn(),
                ownerAlias = javaType.ownerAlias(),
                ownerId = javaType.ownerId(),
                owners = javaType.owners().map({ args0 -> args0 }),
                restorableByUserIds = javaType.restorableByUserIds().map({ args0 -> args0 }),
                snapshotId = javaType.snapshotId(),
                snapshotIds = javaType.snapshotIds().map({ args0 -> args0 }),
                state = javaType.state(),
                storageTier = javaType.storageTier(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                volumeId = javaType.volumeId(),
                volumeSize = javaType.volumeSize(),
            )
    }
}
