@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comment A user-defined comment about the disk upload.
 * @property uploadEnd The time that the disk upload ends.
 * @property uploadSize The size of the uploaded disk image, in GiB.
 * @property uploadStart The time that the disk upload starts.
 */
public data class SnapshotImportClientData(
    public val comment: String? = null,
    public val uploadEnd: String? = null,
    public val uploadSize: Double? = null,
    public val uploadStart: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.SnapshotImportClientData): SnapshotImportClientData = SnapshotImportClientData(
            comment = javaType.comment().map({ args0 -> args0 }).orElse(null),
            uploadEnd = javaType.uploadEnd().map({ args0 -> args0 }).orElse(null),
            uploadSize = javaType.uploadSize().map({ args0 -> args0 }).orElse(null),
            uploadStart = javaType.uploadStart().map({ args0 -> args0 }).orElse(null),
        )
    }
}
