@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the disk image being imported.
 * @property format The format of the disk image being imported. One of `VHD` or `VMDK`.
 * @property url The URL to the Amazon S3-based disk image being imported. It can either be a https URL (https://..) or an Amazon S3 URL (s3://..). One of `url` or `user_bucket` must be set.
 * @property userBucket The Amazon S3 bucket for the disk image. One of `url` or `user_bucket` must be set. Detailed below.
 */
public data class SnapshotImportDiskContainer(
    public val description: String? = null,
    public val format: String,
    public val url: String? = null,
    public val userBucket: SnapshotImportDiskContainerUserBucket? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.SnapshotImportDiskContainer): SnapshotImportDiskContainer = SnapshotImportDiskContainer(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            format = javaType.format(),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
            userBucket = javaType.userBucket().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ebs.kotlin.outputs.SnapshotImportDiskContainerUserBucket.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
