@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.AmiEbsBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.AmiEphemeralBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.AmiEbsBlockDevice.Companion.toKotlin as amiEbsBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.AmiEphemeralBlockDevice.Companion.toKotlin as amiEphemeralBlockDeviceToKotlin

/**
 * Builder for [Ami].
 */
@PulumiTagMarker
public class AmiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmiArgs = AmiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmiArgsBuilder.() -> Unit) {
        val builder = AmiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ami {
        val builtJavaResource = com.pulumi.aws.ec2.Ami(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ami(builtJavaResource)
    }
}

/**
 * The AMI resource allows the creation and management of a completely-custom
 * *Amazon Machine Image* (AMI).
 * If you just want to duplicate an existing AMI, possibly copying it to another
 * region, it's better to use `aws.ec2.AmiCopy` instead.
 * If you just want to share an existing AMI with another AWS account,
 * it's better to use `aws.ec2.AmiLaunchPermission` instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create an AMI that will start a machine whose root device is backed by
 * // an EBS volume populated from a snapshot. We assume that such a snapshot
 * // already exists with the id "snap-xxxxxxxx".
 * const example = new aws.ec2.Ami("example", {
 *     name: "example",
 *     virtualizationType: "hvm",
 *     rootDeviceName: "/dev/xvda",
 *     imdsSupport: "v2.0",
 *     ebsBlockDevices: [{
 *         deviceName: "/dev/xvda",
 *         snapshotId: "snap-xxxxxxxx",
 *         volumeSize: 8,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create an AMI that will start a machine whose root device is backed by
 * # an EBS volume populated from a snapshot. We assume that such a snapshot
 * # already exists with the id "snap-xxxxxxxx".
 * example = aws.ec2.Ami("example",
 *     name="example",
 *     virtualization_type="hvm",
 *     root_device_name="/dev/xvda",
 *     imds_support="v2.0",
 *     ebs_block_devices=[{
 *         "device_name": "/dev/xvda",
 *         "snapshot_id": "snap-xxxxxxxx",
 *         "volume_size": 8,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create an AMI that will start a machine whose root device is backed by
 *     // an EBS volume populated from a snapshot. We assume that such a snapshot
 *     // already exists with the id "snap-xxxxxxxx".
 *     var example = new Aws.Ec2.Ami("example", new()
 *     {
 *         Name = "example",
 *         VirtualizationType = "hvm",
 *         RootDeviceName = "/dev/xvda",
 *         ImdsSupport = "v2.0",
 *         EbsBlockDevices = new[]
 *         {
 *             new Aws.Ec2.Inputs.AmiEbsBlockDeviceArgs
 *             {
 *                 DeviceName = "/dev/xvda",
 *                 SnapshotId = "snap-xxxxxxxx",
 *                 VolumeSize = 8,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create an AMI that will start a machine whose root device is backed by
 * 		// an EBS volume populated from a snapshot. We assume that such a snapshot
 * 		// already exists with the id "snap-xxxxxxxx".
 * 		_, err := ec2.NewAmi(ctx, "example", &ec2.AmiArgs{
 * 			Name:               pulumi.String("example"),
 * 			VirtualizationType: pulumi.String("hvm"),
 * 			RootDeviceName:     pulumi.String("/dev/xvda"),
 * 			ImdsSupport:        pulumi.String("v2.0"),
 * 			EbsBlockDevices: ec2.AmiEbsBlockDeviceArray{
 * 				&ec2.AmiEbsBlockDeviceArgs{
 * 					DeviceName: pulumi.String("/dev/xvda"),
 * 					SnapshotId: pulumi.String("snap-xxxxxxxx"),
 * 					VolumeSize: pulumi.Int(8),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ami;
 * import com.pulumi.aws.ec2.AmiArgs;
 * import com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create an AMI that will start a machine whose root device is backed by
 *         // an EBS volume populated from a snapshot. We assume that such a snapshot
 *         // already exists with the id "snap-xxxxxxxx".
 *         var example = new Ami("example", AmiArgs.builder()
 *             .name("example")
 *             .virtualizationType("hvm")
 *             .rootDeviceName("/dev/xvda")
 *             .imdsSupport("v2.0")
 *             .ebsBlockDevices(AmiEbsBlockDeviceArgs.builder()
 *                 .deviceName("/dev/xvda")
 *                 .snapshotId("snap-xxxxxxxx")
 *                 .volumeSize(8)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create an AMI that will start a machine whose root device is backed by
 *   # an EBS volume populated from a snapshot. We assume that such a snapshot
 *   # already exists with the id "snap-xxxxxxxx".
 *   example:
 *     type: aws:ec2:Ami
 *     properties:
 *       name: example
 *       virtualizationType: hvm
 *       rootDeviceName: /dev/xvda
 *       imdsSupport: v2.0
 *       ebsBlockDevices:
 *         - deviceName: /dev/xvda
 *           snapshotId: snap-xxxxxxxx
 *           volumeSize: 8
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ami` using the ID of the AMI. For example:
 * ```sh
 * $ pulumi import aws:ec2/ami:Ami example ami-12345678
 * ```
 */
public class Ami internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Ami,
) : KotlinCustomResource(javaResource, AmiMapper) {
    /**
     * Machine architecture for created instances. Defaults to "x86_64".
     */
    public val architecture: Output<String>?
        get() = javaResource.architecture().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the AMI.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val bootMode: Output<String>?
        get() = javaResource.bootMode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val deprecationTime: Output<String>?
        get() = javaResource.deprecationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Longer, human-readable description for the AMI.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    public val ebsBlockDevices: Output<List<AmiEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    public val enaSupport: Output<Boolean>?
        get() = javaResource.enaSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    public val ephemeralBlockDevices: Output<List<AmiEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Hypervisor type of the image.
     */
    public val hypervisor: Output<String>
        get() = javaResource.hypervisor().applyValue({ args0 -> args0 })

    public val imageLocation: Output<String>
        get() = javaResource.imageLocation().applyValue({ args0 -> args0 })

    /**
     * AWS account alias (for example, amazon, self) or the AWS account ID of the AMI owner.
     */
    public val imageOwnerAlias: Output<String>
        get() = javaResource.imageOwnerAlias().applyValue({ args0 -> args0 })

    /**
     * Type of image.
     */
    public val imageType: Output<String>
        get() = javaResource.imageType().applyValue({ args0 -> args0 })

    /**
     * If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    public val imdsSupport: Output<String>?
        get() = javaResource.imdsSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val kernelId: Output<String>?
        get() = javaResource.kernelId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val manageEbsSnapshots: Output<Boolean>
        get() = javaResource.manageEbsSnapshots().applyValue({ args0 -> args0 })

    /**
     * Region-unique name for the AMI.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * AWS account ID of the image owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * This value is set to windows for Windows AMIs; otherwise, it is blank.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Platform details associated with the billing code of the AMI.
     */
    public val platformDetails: Output<String>
        get() = javaResource.platformDetails().applyValue({ args0 -> args0 })

    /**
     * Whether the image has public launch permissions.
     */
    public val `public`: Output<Boolean>
        get() = javaResource.public_().applyValue({ args0 -> args0 })

    public val ramdiskId: Output<String>?
        get() = javaResource.ramdiskId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    public val rootDeviceName: Output<String>?
        get() = javaResource.rootDeviceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Snapshot ID for the root volume (for EBS-backed AMIs)
     */
    public val rootSnapshotId: Output<String>
        get() = javaResource.rootSnapshotId().applyValue({ args0 -> args0 })

    public val sriovNetSupport: Output<String>?
        get() = javaResource.sriovNetSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val tpmSupport: Output<String>?
        get() = javaResource.tpmSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
     */
    public val usageOperation: Output<String>
        get() = javaResource.usageOperation().applyValue({ args0 -> args0 })

    /**
     * Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    public val virtualizationType: Output<String>?
        get() = javaResource.virtualizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AmiMapper : ResourceMapper<Ami> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Ami::class == javaResource::class

    override fun map(javaResource: Resource): Ami = Ami(javaResource as com.pulumi.aws.ec2.Ami)
}

/**
 * @see [Ami].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ami].
 */
public suspend fun ami(name: String, block: suspend AmiResourceBuilder.() -> Unit): Ami {
    val builder = AmiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ami].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ami(name: String): Ami {
    val builder = AmiResourceBuilder()
    builder.name(name)
    return builder.build()
}
