@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.AmiEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.AmiEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiEphemeralBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AMI resource allows the creation and management of a completely-custom
 * *Amazon Machine Image* (AMI).
 * If you just want to duplicate an existing AMI, possibly copying it to another
 * region, it's better to use `aws.ec2.AmiCopy` instead.
 * If you just want to share an existing AMI with another AWS account,
 * it's better to use `aws.ec2.AmiLaunchPermission` instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create an AMI that will start a machine whose root device is backed by
 * // an EBS volume populated from a snapshot. We assume that such a snapshot
 * // already exists with the id "snap-xxxxxxxx".
 * const example = new aws.ec2.Ami("example", {
 *     name: "example",
 *     virtualizationType: "hvm",
 *     rootDeviceName: "/dev/xvda",
 *     imdsSupport: "v2.0",
 *     ebsBlockDevices: [{
 *         deviceName: "/dev/xvda",
 *         snapshotId: "snap-xxxxxxxx",
 *         volumeSize: 8,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create an AMI that will start a machine whose root device is backed by
 * # an EBS volume populated from a snapshot. We assume that such a snapshot
 * # already exists with the id "snap-xxxxxxxx".
 * example = aws.ec2.Ami("example",
 *     name="example",
 *     virtualization_type="hvm",
 *     root_device_name="/dev/xvda",
 *     imds_support="v2.0",
 *     ebs_block_devices=[{
 *         "device_name": "/dev/xvda",
 *         "snapshot_id": "snap-xxxxxxxx",
 *         "volume_size": 8,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create an AMI that will start a machine whose root device is backed by
 *     // an EBS volume populated from a snapshot. We assume that such a snapshot
 *     // already exists with the id "snap-xxxxxxxx".
 *     var example = new Aws.Ec2.Ami("example", new()
 *     {
 *         Name = "example",
 *         VirtualizationType = "hvm",
 *         RootDeviceName = "/dev/xvda",
 *         ImdsSupport = "v2.0",
 *         EbsBlockDevices = new[]
 *         {
 *             new Aws.Ec2.Inputs.AmiEbsBlockDeviceArgs
 *             {
 *                 DeviceName = "/dev/xvda",
 *                 SnapshotId = "snap-xxxxxxxx",
 *                 VolumeSize = 8,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create an AMI that will start a machine whose root device is backed by
 * 		// an EBS volume populated from a snapshot. We assume that such a snapshot
 * 		// already exists with the id "snap-xxxxxxxx".
 * 		_, err := ec2.NewAmi(ctx, "example", &ec2.AmiArgs{
 * 			Name:               pulumi.String("example"),
 * 			VirtualizationType: pulumi.String("hvm"),
 * 			RootDeviceName:     pulumi.String("/dev/xvda"),
 * 			ImdsSupport:        pulumi.String("v2.0"),
 * 			EbsBlockDevices: ec2.AmiEbsBlockDeviceArray{
 * 				&ec2.AmiEbsBlockDeviceArgs{
 * 					DeviceName: pulumi.String("/dev/xvda"),
 * 					SnapshotId: pulumi.String("snap-xxxxxxxx"),
 * 					VolumeSize: pulumi.Int(8),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ami;
 * import com.pulumi.aws.ec2.AmiArgs;
 * import com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create an AMI that will start a machine whose root device is backed by
 *         // an EBS volume populated from a snapshot. We assume that such a snapshot
 *         // already exists with the id "snap-xxxxxxxx".
 *         var example = new Ami("example", AmiArgs.builder()
 *             .name("example")
 *             .virtualizationType("hvm")
 *             .rootDeviceName("/dev/xvda")
 *             .imdsSupport("v2.0")
 *             .ebsBlockDevices(AmiEbsBlockDeviceArgs.builder()
 *                 .deviceName("/dev/xvda")
 *                 .snapshotId("snap-xxxxxxxx")
 *                 .volumeSize(8)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create an AMI that will start a machine whose root device is backed by
 *   # an EBS volume populated from a snapshot. We assume that such a snapshot
 *   # already exists with the id "snap-xxxxxxxx".
 *   example:
 *     type: aws:ec2:Ami
 *     properties:
 *       name: example
 *       virtualizationType: hvm
 *       rootDeviceName: /dev/xvda
 *       imdsSupport: v2.0
 *       ebsBlockDevices:
 *         - deviceName: /dev/xvda
 *           snapshotId: snap-xxxxxxxx
 *           volumeSize: 8
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ami` using the ID of the AMI. For example:
 * ```sh
 * $ pulumi import aws:ec2/ami:Ami example ami-12345678
 * ```
 * @property architecture Machine architecture for created instances. Defaults to "x86_64".
 * @property bootMode Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
 * @property deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property description Longer, human-readable description for the AMI.
 * @property ebsBlockDevices Nested block describing an EBS block device that should be
 * attached to created instances. The structure of this block is described below.
 * @property enaSupport Whether enhanced networking with ENA is enabled. Defaults to `false`.
 * @property ephemeralBlockDevices Nested block describing an ephemeral block device that
 * should be attached to created instances. The structure of this block is described below.
 * @property imageLocation
 * @property imdsSupport If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
 * @property kernelId
 * @property name Region-unique name for the AMI.
 * @property ramdiskId
 * @property rootDeviceName Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
 * @property sriovNetSupport
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tpmSupport If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
 * @property virtualizationType Keyword to choose what virtualization mode created instances
 * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
 * changes the set of further arguments that are required, as described below.
 */
public data class AmiArgs(
    public val architecture: Output<String>? = null,
    public val bootMode: Output<String>? = null,
    public val deprecationTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ebsBlockDevices: Output<List<AmiEbsBlockDeviceArgs>>? = null,
    public val enaSupport: Output<Boolean>? = null,
    public val ephemeralBlockDevices: Output<List<AmiEphemeralBlockDeviceArgs>>? = null,
    public val imageLocation: Output<String>? = null,
    public val imdsSupport: Output<String>? = null,
    public val kernelId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ramdiskId: Output<String>? = null,
    public val rootDeviceName: Output<String>? = null,
    public val sriovNetSupport: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tpmSupport: Output<String>? = null,
    public val virtualizationType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiArgs = com.pulumi.aws.ec2.AmiArgs.builder()
        .architecture(architecture?.applyValue({ args0 -> args0 }))
        .bootMode(bootMode?.applyValue({ args0 -> args0 }))
        .deprecationTime(deprecationTime?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .ebsBlockDevices(
            ebsBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .enaSupport(enaSupport?.applyValue({ args0 -> args0 }))
        .ephemeralBlockDevices(
            ephemeralBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .imageLocation(imageLocation?.applyValue({ args0 -> args0 }))
        .imdsSupport(imdsSupport?.applyValue({ args0 -> args0 }))
        .kernelId(kernelId?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .ramdiskId(ramdiskId?.applyValue({ args0 -> args0 }))
        .rootDeviceName(rootDeviceName?.applyValue({ args0 -> args0 }))
        .sriovNetSupport(sriovNetSupport?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tpmSupport(tpmSupport?.applyValue({ args0 -> args0 }))
        .virtualizationType(virtualizationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiArgs].
 */
@PulumiTagMarker
public class AmiArgsBuilder internal constructor() {
    private var architecture: Output<String>? = null

    private var bootMode: Output<String>? = null

    private var deprecationTime: Output<String>? = null

    private var description: Output<String>? = null

    private var ebsBlockDevices: Output<List<AmiEbsBlockDeviceArgs>>? = null

    private var enaSupport: Output<Boolean>? = null

    private var ephemeralBlockDevices: Output<List<AmiEphemeralBlockDeviceArgs>>? = null

    private var imageLocation: Output<String>? = null

    private var imdsSupport: Output<String>? = null

    private var kernelId: Output<String>? = null

    private var name: Output<String>? = null

    private var ramdiskId: Output<String>? = null

    private var rootDeviceName: Output<String>? = null

    private var sriovNetSupport: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tpmSupport: Output<String>? = null

    private var virtualizationType: Output<String>? = null

    /**
     * @param value Machine architecture for created instances. Defaults to "x86_64".
     */
    @JvmName("hbkupbfgfsfasrlt")
    public suspend fun architecture(`value`: Output<String>) {
        this.architecture = value
    }

    /**
     * @param value Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("iutusdljnumlqiel")
    public suspend fun bootMode(`value`: Output<String>) {
        this.bootMode = value
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("rplbnhdxlweuayey")
    public suspend fun deprecationTime(`value`: Output<String>) {
        this.deprecationTime = value
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("hwxhkdehaaqdmgaa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("afykqgofmvihvqba")
    public suspend fun ebsBlockDevices(`value`: Output<List<AmiEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("bucapobnqmcfpwsk")
    public suspend fun ebsBlockDevices(vararg values: Output<AmiEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("wlhkueufgdwefvmu")
    public suspend fun ebsBlockDevices(values: List<Output<AmiEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    @JvmName("lxxtnfvmqcryqbsf")
    public suspend fun enaSupport(`value`: Output<Boolean>) {
        this.enaSupport = value
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("orfuojnfsmbejfyr")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<AmiEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("gbtoxjgsqfnlndtt")
    public suspend fun ephemeralBlockDevices(vararg values: Output<AmiEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("ujtovtxmddmmqecl")
    public suspend fun ephemeralBlockDevices(values: List<Output<AmiEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nlhirwthenhdmjdw")
    public suspend fun imageLocation(`value`: Output<String>) {
        this.imageLocation = value
    }

    /**
     * @param value If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    @JvmName("cnpjofqtsawrmmpa")
    public suspend fun imdsSupport(`value`: Output<String>) {
        this.imdsSupport = value
    }

    /**
     * @param value
     */
    @JvmName("kenegghwxpcbqycg")
    public suspend fun kernelId(`value`: Output<String>) {
        this.kernelId = value
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("fvpejhhugesxbtqa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("mdxwtwkndbrejlnl")
    public suspend fun ramdiskId(`value`: Output<String>) {
        this.ramdiskId = value
    }

    /**
     * @param value Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    @JvmName("rvjxygytjeyialcb")
    public suspend fun rootDeviceName(`value`: Output<String>) {
        this.rootDeviceName = value
    }

    /**
     * @param value
     */
    @JvmName("leutnotokfuteyns")
    public suspend fun sriovNetSupport(`value`: Output<String>) {
        this.sriovNetSupport = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("scwvywbxflmpinwc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("pelvgbalksggttel")
    public suspend fun tpmSupport(`value`: Output<String>) {
        this.tpmSupport = value
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    @JvmName("hmwkionhgboprkfh")
    public suspend fun virtualizationType(`value`: Output<String>) {
        this.virtualizationType = value
    }

    /**
     * @param value Machine architecture for created instances. Defaults to "x86_64".
     */
    @JvmName("vqcexqdkiybrqbmh")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("cdvvhxngdpgjofvj")
    public suspend fun bootMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootMode = mapped
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("djbwbyobhxavwdyj")
    public suspend fun deprecationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecationTime = mapped
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("ypqaguvqeeyjuuvw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("baoxyptspgmehytl")
    public suspend fun ebsBlockDevices(`value`: List<AmiEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("cevxyaysdkyrhffk")
    public suspend fun ebsBlockDevices(argument: List<suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("ecbexlfokbsxtwwq")
    public suspend fun ebsBlockDevices(vararg argument: suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AmiEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("wlayfuotkfimrhoq")
    public suspend fun ebsBlockDevices(argument: suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AmiEbsBlockDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("riyvkbecomyttwvn")
    public suspend fun ebsBlockDevices(vararg values: AmiEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    @JvmName("mmmqlreyjkanrlyp")
    public suspend fun enaSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enaSupport = mapped
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("vqspaxovaveyvfee")
    public suspend fun ephemeralBlockDevices(`value`: List<AmiEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("sjofmsgbctlcpgvb")
    public suspend fun ephemeralBlockDevices(argument: List<suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("wfvbewaldtaqqwqg")
    public suspend fun ephemeralBlockDevices(vararg argument: suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("kavmjxmdlcjbbdqt")
    public suspend fun ephemeralBlockDevices(argument: suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("byvscxjaxltpkvuh")
    public suspend fun ephemeralBlockDevices(vararg values: AmiEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value
     */
    @JvmName("vuncsquulqiwhcai")
    public suspend fun imageLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageLocation = mapped
    }

    /**
     * @param value If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    @JvmName("hifjetjmjikxupuc")
    public suspend fun imdsSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imdsSupport = mapped
    }

    /**
     * @param value
     */
    @JvmName("sovhaxxgfwnimfjo")
    public suspend fun kernelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelId = mapped
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("inpxnmtobrewdpto")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("jhnsgpmypysrmdrg")
    public suspend fun ramdiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramdiskId = mapped
    }

    /**
     * @param value Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    @JvmName("ltgmqcfwuechymaw")
    public suspend fun rootDeviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDeviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("idmujjoshfrtjhnw")
    public suspend fun sriovNetSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sriovNetSupport = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qoljkatbxblchiiv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("grxqgmhyyyhkxaeu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("nbblisikcfkotecf")
    public suspend fun tpmSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tpmSupport = mapped
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    @JvmName("bfxwqlupdnquqngq")
    public suspend fun virtualizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualizationType = mapped
    }

    internal fun build(): AmiArgs = AmiArgs(
        architecture = architecture,
        bootMode = bootMode,
        deprecationTime = deprecationTime,
        description = description,
        ebsBlockDevices = ebsBlockDevices,
        enaSupport = enaSupport,
        ephemeralBlockDevices = ephemeralBlockDevices,
        imageLocation = imageLocation,
        imdsSupport = imdsSupport,
        kernelId = kernelId,
        name = name,
        ramdiskId = ramdiskId,
        rootDeviceName = rootDeviceName,
        sriovNetSupport = sriovNetSupport,
        tags = tags,
        tpmSupport = tpmSupport,
        virtualizationType = virtualizationType,
    )
}
