@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.AmiCopyEbsBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.AmiCopyEphemeralBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.AmiCopyEbsBlockDevice.Companion.toKotlin as amiCopyEbsBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.AmiCopyEphemeralBlockDevice.Companion.toKotlin as amiCopyEphemeralBlockDeviceToKotlin

/**
 * Builder for [AmiCopy].
 */
@PulumiTagMarker
public class AmiCopyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmiCopyArgs = AmiCopyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmiCopyArgsBuilder.() -> Unit) {
        val builder = AmiCopyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AmiCopy {
        val builtJavaResource = com.pulumi.aws.ec2.AmiCopy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AmiCopy(builtJavaResource)
    }
}

/**
 * The "AMI copy" resource allows duplication of an Amazon Machine Image (AMI),
 * including cross-region copies.
 * If the source AMI has associated EBS snapshots, those will also be duplicated
 * along with the AMI.
 * This is useful for taking a single AMI provisioned in one region and making
 * it available in another for a multi-region deployment.
 * Copying an AMI can take several minutes. The creation of this resource will
 * block until the new AMI is available for use on new instances.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.AmiCopy("example", {
 *     name: "example",
 *     description: "A copy of ami-xxxxxxxx",
 *     sourceAmiId: "ami-xxxxxxxx",
 *     sourceAmiRegion: "us-west-1",
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.AmiCopy("example",
 *     name="example",
 *     description="A copy of ami-xxxxxxxx",
 *     source_ami_id="ami-xxxxxxxx",
 *     source_ami_region="us-west-1",
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.AmiCopy("example", new()
 *     {
 *         Name = "example",
 *         Description = "A copy of ami-xxxxxxxx",
 *         SourceAmiId = "ami-xxxxxxxx",
 *         SourceAmiRegion = "us-west-1",
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewAmiCopy(ctx, "example", &ec2.AmiCopyArgs{
 * 			Name:            pulumi.String("example"),
 * 			Description:     pulumi.String("A copy of ami-xxxxxxxx"),
 * 			SourceAmiId:     pulumi.String("ami-xxxxxxxx"),
 * 			SourceAmiRegion: pulumi.String("us-west-1"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiCopy;
 * import com.pulumi.aws.ec2.AmiCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiCopy("example", AmiCopyArgs.builder()
 *             .name("example")
 *             .description("A copy of ami-xxxxxxxx")
 *             .sourceAmiId("ami-xxxxxxxx")
 *             .sourceAmiRegion("us-west-1")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:AmiCopy
 *     properties:
 *       name: example
 *       description: A copy of ami-xxxxxxxx
 *       sourceAmiId: ami-xxxxxxxx
 *       sourceAmiRegion: us-west-1
 *       tags:
 *         Name: HelloWorld
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class AmiCopy internal constructor(
    override val javaResource: com.pulumi.aws.ec2.AmiCopy,
) : KotlinCustomResource(javaResource, AmiCopyMapper) {
    /**
     * Machine architecture for created instances. Defaults to "x86_64".
     */
    public val architecture: Output<String>
        get() = javaResource.architecture().applyValue({ args0 -> args0 })

    /**
     * ARN of the AMI.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val bootMode: Output<String>
        get() = javaResource.bootMode().applyValue({ args0 -> args0 })

    /**
     * Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val deprecationTime: Output<String>?
        get() = javaResource.deprecationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Longer, human-readable description for the AMI.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the Outpost to which to copy the AMI.
     * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
     */
    public val destinationOutpostArn: Output<String>?
        get() = javaResource.destinationOutpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    public val ebsBlockDevices: Output<List<AmiCopyEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiCopyEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    public val enaSupport: Output<Boolean>
        get() = javaResource.enaSupport().applyValue({ args0 -> args0 })

    /**
     * Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    public val ephemeralBlockDevices: Output<List<AmiCopyEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiCopyEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    public val hypervisor: Output<String>
        get() = javaResource.hypervisor().applyValue({ args0 -> args0 })

    /**
     * Path to an S3 object containing an image manifest, e.g., created
     * by the `ec2-upload-bundle` command in the EC2 command line tools.
     */
    public val imageLocation: Output<String>
        get() = javaResource.imageLocation().applyValue({ args0 -> args0 })

    public val imageOwnerAlias: Output<String>
        get() = javaResource.imageOwnerAlias().applyValue({ args0 -> args0 })

    public val imageType: Output<String>
        get() = javaResource.imageType().applyValue({ args0 -> args0 })

    /**
     * If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    public val imdsSupport: Output<String>
        get() = javaResource.imdsSupport().applyValue({ args0 -> args0 })

    /**
     * ID of the kernel image (AKI) that will be used as the paravirtual
     * kernel in created instances.
     */
    public val kernelId: Output<String>
        get() = javaResource.kernelId().applyValue({ args0 -> args0 })

    /**
     * Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    public val manageEbsSnapshots: Output<Boolean>
        get() = javaResource.manageEbsSnapshots().applyValue({ args0 -> args0 })

    /**
     * Region-unique name for the AMI.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    public val platformDetails: Output<String>
        get() = javaResource.platformDetails().applyValue({ args0 -> args0 })

    public val `public`: Output<Boolean>
        get() = javaResource.public_().applyValue({ args0 -> args0 })

    /**
     * ID of an initrd image (ARI) that will be used when booting the
     * created instances.
     */
    public val ramdiskId: Output<String>
        get() = javaResource.ramdiskId().applyValue({ args0 -> args0 })

    /**
     * Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    public val rootDeviceName: Output<String>
        get() = javaResource.rootDeviceName().applyValue({ args0 -> args0 })

    public val rootSnapshotId: Output<String>
        get() = javaResource.rootSnapshotId().applyValue({ args0 -> args0 })

    /**
     * Id of the AMI to copy. This id must be valid in the region
     * given by `source_ami_region`.
     */
    public val sourceAmiId: Output<String>
        get() = javaResource.sourceAmiId().applyValue({ args0 -> args0 })

    /**
     * Region from which the AMI will be copied. This may be the
     * same as the AWS provider region in order to create a copy within the same region.
     */
    public val sourceAmiRegion: Output<String>
        get() = javaResource.sourceAmiRegion().applyValue({ args0 -> args0 })

    /**
     * When set to "simple" (the default), enables enhanced networking
     * for created instances. No other value is supported at this time.
     */
    public val sriovNetSupport: Output<String>
        get() = javaResource.sriovNetSupport().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val tpmSupport: Output<String>
        get() = javaResource.tpmSupport().applyValue({ args0 -> args0 })

    public val usageOperation: Output<String>
        get() = javaResource.usageOperation().applyValue({ args0 -> args0 })

    /**
     * Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    public val virtualizationType: Output<String>
        get() = javaResource.virtualizationType().applyValue({ args0 -> args0 })
}

public object AmiCopyMapper : ResourceMapper<AmiCopy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.AmiCopy::class == javaResource::class

    override fun map(javaResource: Resource): AmiCopy = AmiCopy(
        javaResource as
            com.pulumi.aws.ec2.AmiCopy,
    )
}

/**
 * @see [AmiCopy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AmiCopy].
 */
public suspend fun amiCopy(name: String, block: suspend AmiCopyResourceBuilder.() -> Unit): AmiCopy {
    val builder = AmiCopyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AmiCopy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun amiCopy(name: String): AmiCopy {
    val builder = AmiCopyResourceBuilder()
    builder.name(name)
    return builder.build()
}
