@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.AmiFromInstanceEbsBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.AmiFromInstanceEphemeralBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.AmiFromInstanceEbsBlockDevice.Companion.toKotlin as amiFromInstanceEbsBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.AmiFromInstanceEphemeralBlockDevice.Companion.toKotlin as amiFromInstanceEphemeralBlockDeviceToKotlin

/**
 * Builder for [AmiFromInstance].
 */
@PulumiTagMarker
public class AmiFromInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmiFromInstanceArgs = AmiFromInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmiFromInstanceArgsBuilder.() -> Unit) {
        val builder = AmiFromInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AmiFromInstance {
        val builtJavaResource = com.pulumi.aws.ec2.AmiFromInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AmiFromInstance(builtJavaResource)
    }
}

/**
 * The "AMI from instance" resource allows the creation of an Amazon Machine
 * Image (AMI) modeled after an existing EBS-backed EC2 instance.
 * The created AMI will refer to implicitly-created snapshots of the instance's
 * EBS volumes and mimick its assigned block device configuration at the time
 * the resource is created.
 * This resource is best applied to an instance that is stopped when this instance
 * is created, so that the contents of the created image are predictable. When
 * applied to an instance that is running, *the instance will be stopped before taking
 * the snapshots and then started back up again*, resulting in a period of
 * downtime.
 * Note that the source instance is inspected only at the initial creation of this
 * resource. Ongoing updates to the referenced instance will not be propagated into
 * the generated AMI. Users may taint or otherwise recreate the resource in order
 * to produce a fresh snapshot.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.AmiFromInstance("example", {
 *     name: "example",
 *     sourceInstanceId: "i-xxxxxxxx",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.AmiFromInstance("example",
 *     name="example",
 *     source_instance_id="i-xxxxxxxx")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.AmiFromInstance("example", new()
 *     {
 *         Name = "example",
 *         SourceInstanceId = "i-xxxxxxxx",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewAmiFromInstance(ctx, "example", &ec2.AmiFromInstanceArgs{
 * 			Name:             pulumi.String("example"),
 * 			SourceInstanceId: pulumi.String("i-xxxxxxxx"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiFromInstance;
 * import com.pulumi.aws.ec2.AmiFromInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiFromInstance("example", AmiFromInstanceArgs.builder()
 *             .name("example")
 *             .sourceInstanceId("i-xxxxxxxx")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:AmiFromInstance
 *     properties:
 *       name: example
 *       sourceInstanceId: i-xxxxxxxx
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class AmiFromInstance internal constructor(
    override val javaResource: com.pulumi.aws.ec2.AmiFromInstance,
) : KotlinCustomResource(javaResource, AmiFromInstanceMapper) {
    /**
     * Machine architecture for created instances. Defaults to "x86_64".
     */
    public val architecture: Output<String>
        get() = javaResource.architecture().applyValue({ args0 -> args0 })

    /**
     * ARN of the AMI.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val bootMode: Output<String>
        get() = javaResource.bootMode().applyValue({ args0 -> args0 })

    /**
     * Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val deprecationTime: Output<String>?
        get() = javaResource.deprecationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Longer, human-readable description for the AMI.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    public val ebsBlockDevices: Output<List<AmiFromInstanceEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiFromInstanceEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    public val enaSupport: Output<Boolean>
        get() = javaResource.enaSupport().applyValue({ args0 -> args0 })

    /**
     * Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    public val ephemeralBlockDevices: Output<List<AmiFromInstanceEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> amiFromInstanceEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    public val hypervisor: Output<String>
        get() = javaResource.hypervisor().applyValue({ args0 -> args0 })

    /**
     * Path to an S3 object containing an image manifest, e.g., created
     * by the `ec2-upload-bundle` command in the EC2 command line tools.
     */
    public val imageLocation: Output<String>
        get() = javaResource.imageLocation().applyValue({ args0 -> args0 })

    public val imageOwnerAlias: Output<String>
        get() = javaResource.imageOwnerAlias().applyValue({ args0 -> args0 })

    public val imageType: Output<String>
        get() = javaResource.imageType().applyValue({ args0 -> args0 })

    /**
     * If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    public val imdsSupport: Output<String>
        get() = javaResource.imdsSupport().applyValue({ args0 -> args0 })

    /**
     * ID of the kernel image (AKI) that will be used as the paravirtual
     * kernel in created instances.
     */
    public val kernelId: Output<String>
        get() = javaResource.kernelId().applyValue({ args0 -> args0 })

    public val manageEbsSnapshots: Output<Boolean>
        get() = javaResource.manageEbsSnapshots().applyValue({ args0 -> args0 })

    /**
     * Region-unique name for the AMI.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    public val platformDetails: Output<String>
        get() = javaResource.platformDetails().applyValue({ args0 -> args0 })

    public val `public`: Output<Boolean>
        get() = javaResource.public_().applyValue({ args0 -> args0 })

    /**
     * ID of an initrd image (ARI) that will be used when booting the
     * created instances.
     */
    public val ramdiskId: Output<String>
        get() = javaResource.ramdiskId().applyValue({ args0 -> args0 })

    /**
     * Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    public val rootDeviceName: Output<String>
        get() = javaResource.rootDeviceName().applyValue({ args0 -> args0 })

    public val rootSnapshotId: Output<String>
        get() = javaResource.rootSnapshotId().applyValue({ args0 -> args0 })

    /**
     * Boolean that overrides the behavior of stopping
     * the instance before snapshotting. This is risky since it may cause a snapshot of an
     * inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
     * guarantees that no filesystem writes will be underway at the time of snapshot.
     */
    public val snapshotWithoutReboot: Output<Boolean>?
        get() = javaResource.snapshotWithoutReboot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the instance to use as the basis of the AMI.
     */
    public val sourceInstanceId: Output<String>
        get() = javaResource.sourceInstanceId().applyValue({ args0 -> args0 })

    /**
     * When set to "simple" (the default), enables enhanced networking
     * for created instances. No other value is supported at this time.
     */
    public val sriovNetSupport: Output<String>
        get() = javaResource.sriovNetSupport().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    public val tpmSupport: Output<String>
        get() = javaResource.tpmSupport().applyValue({ args0 -> args0 })

    public val usageOperation: Output<String>
        get() = javaResource.usageOperation().applyValue({ args0 -> args0 })

    /**
     * Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    public val virtualizationType: Output<String>
        get() = javaResource.virtualizationType().applyValue({ args0 -> args0 })
}

public object AmiFromInstanceMapper : ResourceMapper<AmiFromInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.AmiFromInstance::class == javaResource::class

    override fun map(javaResource: Resource): AmiFromInstance = AmiFromInstance(
        javaResource as
            com.pulumi.aws.ec2.AmiFromInstance,
    )
}

/**
 * @see [AmiFromInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AmiFromInstance].
 */
public suspend fun amiFromInstance(
    name: String,
    block: suspend AmiFromInstanceResourceBuilder.() -> Unit,
): AmiFromInstance {
    val builder = AmiFromInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AmiFromInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun amiFromInstance(name: String): AmiFromInstance {
    val builder = AmiFromInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
