@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiLaunchPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds a launch permission to an Amazon Machine Image (AMI).
 * ## Example Usage
 * ### AWS Account ID
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.AmiLaunchPermission("example", {
 *     imageId: "ami-12345678",
 *     accountId: "123456789012",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.AmiLaunchPermission("example",
 *     image_id="ami-12345678",
 *     account_id="123456789012")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.AmiLaunchPermission("example", new()
 *     {
 *         ImageId = "ami-12345678",
 *         AccountId = "123456789012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewAmiLaunchPermission(ctx, "example", &ec2.AmiLaunchPermissionArgs{
 * 			ImageId:   pulumi.String("ami-12345678"),
 * 			AccountId: pulumi.String("123456789012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .imageId("ami-12345678")
 *             .accountId("123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:AmiLaunchPermission
 *     properties:
 *       imageId: ami-12345678
 *       accountId: '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.AmiLaunchPermission("example", {
 *     imageId: "ami-12345678",
 *     group: "all",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.AmiLaunchPermission("example",
 *     image_id="ami-12345678",
 *     group="all")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.AmiLaunchPermission("example", new()
 *     {
 *         ImageId = "ami-12345678",
 *         Group = "all",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewAmiLaunchPermission(ctx, "example", &ec2.AmiLaunchPermissionArgs{
 * 			ImageId: pulumi.String("ami-12345678"),
 * 			Group:   pulumi.String("all"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .imageId("ami-12345678")
 *             .group("all")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:AmiLaunchPermission
 *     properties:
 *       imageId: ami-12345678
 *       group: all
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Organization Access
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.organizations.getOrganization({});
 * const example = new aws.ec2.AmiLaunchPermission("example", {
 *     imageId: "ami-12345678",
 *     organizationArn: current.then(current => current.arn),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.organizations.get_organization()
 * example = aws.ec2.AmiLaunchPermission("example",
 *     image_id="ami-12345678",
 *     organization_arn=current.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.Organizations.GetOrganization.Invoke();
 *     var example = new Aws.Ec2.AmiLaunchPermission("example", new()
 *     {
 *         ImageId = "ami-12345678",
 *         OrganizationArn = current.Apply(getOrganizationResult => getOrganizationResult.Arn),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := organizations.LookupOrganization(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewAmiLaunchPermission(ctx, "example", &ec2.AmiLaunchPermissionArgs{
 * 			ImageId:         pulumi.String("ami-12345678"),
 * 			OrganizationArn: pulumi.String(current.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationsFunctions;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = OrganizationsFunctions.getOrganization();
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .imageId("ami-12345678")
 *             .organizationArn(current.applyValue(getOrganizationResult -> getOrganizationResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:AmiLaunchPermission
 *     properties:
 *       imageId: ami-12345678
 *       organizationArn: ${current.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:organizations:getOrganization
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:
 * ```sh
 * $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
 * ```
 * @property accountId AWS account ID for the launch permission.
 * @property group Name of the group for the launch permission. Valid values: `"all"`.
 * @property imageId ID of the AMI.
 * @property organizationArn ARN of an organization for the launch permission.
 * @property organizationalUnitArn ARN of an organizational unit for the launch permission.
 */
public data class AmiLaunchPermissionArgs(
    public val accountId: Output<String>? = null,
    public val group: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val organizationArn: Output<String>? = null,
    public val organizationalUnitArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiLaunchPermissionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiLaunchPermissionArgs =
        com.pulumi.aws.ec2.AmiLaunchPermissionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .organizationArn(organizationArn?.applyValue({ args0 -> args0 }))
            .organizationalUnitArn(organizationalUnitArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiLaunchPermissionArgs].
 */
@PulumiTagMarker
public class AmiLaunchPermissionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var group: Output<String>? = null

    private var imageId: Output<String>? = null

    private var organizationArn: Output<String>? = null

    private var organizationalUnitArn: Output<String>? = null

    /**
     * @param value AWS account ID for the launch permission.
     */
    @JvmName("qlssymxlrofseluy")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Name of the group for the launch permission. Valid values: `"all"`.
     */
    @JvmName("wotdoglvdqyqwbyv")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value ID of the AMI.
     */
    @JvmName("sslsohjbrkbqlksx")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value ARN of an organization for the launch permission.
     */
    @JvmName("rsecdsexmnddfxqg")
    public suspend fun organizationArn(`value`: Output<String>) {
        this.organizationArn = value
    }

    /**
     * @param value ARN of an organizational unit for the launch permission.
     */
    @JvmName("kmdunuwhtmhulrry")
    public suspend fun organizationalUnitArn(`value`: Output<String>) {
        this.organizationalUnitArn = value
    }

    /**
     * @param value AWS account ID for the launch permission.
     */
    @JvmName("cjsrtepbjuqxdilq")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Name of the group for the launch permission. Valid values: `"all"`.
     */
    @JvmName("xdnbfohhbjgohyjb")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value ID of the AMI.
     */
    @JvmName("wkpvmdmnfknyakbx")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value ARN of an organization for the launch permission.
     */
    @JvmName("wmldjgiqfvbefpvm")
    public suspend fun organizationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationArn = mapped
    }

    /**
     * @param value ARN of an organizational unit for the launch permission.
     */
    @JvmName("badcrphoywdjexwq")
    public suspend fun organizationalUnitArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitArn = mapped
    }

    internal fun build(): AmiLaunchPermissionArgs = AmiLaunchPermissionArgs(
        accountId = accountId,
        group = group,
        imageId = imageId,
        organizationArn = organizationArn,
        organizationalUnitArn = organizationalUnitArn,
    )
}
