@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.CapacityBlockReservationTimeouts
import com.pulumi.aws.ec2.kotlin.outputs.CapacityBlockReservationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CapacityBlockReservation].
 */
@PulumiTagMarker
public class CapacityBlockReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityBlockReservationArgs = CapacityBlockReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityBlockReservationArgsBuilder.() -> Unit) {
        val builder = CapacityBlockReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CapacityBlockReservation {
        val builtJavaResource = com.pulumi.aws.ec2.CapacityBlockReservation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CapacityBlockReservation(builtJavaResource)
    }
}

/**
 * Provides an EC2 Capacity Block Reservation. This allows you to purchase capacity block for your Amazon EC2 instances in a specific Availability Zone for machine learning (ML) Workloads.
 * > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `capacity_block_offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [EC2 Capacity Block Reservation Documentation](https://aws&#46;amazon&#46;com/ec2/instance-types/p5/) and [PurchaseReservedDBInstancesOffering](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-blocks-pricing-billing.html).
 * > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.ec2.getCapacityBlockOffering({
 *     capacityDurationHours: 24,
 *     endDateRange: "2024-05-30T15:04:05Z",
 *     instanceCount: 1,
 *     instanceType: "p4d.24xlarge",
 *     startDateRange: "2024-04-28T15:04:05Z",
 * });
 * const example = new aws.ec2.CapacityBlockReservation("example", {
 *     capacityBlockOfferingId: test.then(test => test.capacityBlockOfferingId),
 *     instancePlatform: "Linux/UNIX",
 *     tags: {
 *         Environment: "dev",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.get_capacity_block_offering(capacity_duration_hours=24,
 *     end_date_range="2024-05-30T15:04:05Z",
 *     instance_count=1,
 *     instance_type="p4d.24xlarge",
 *     start_date_range="2024-04-28T15:04:05Z")
 * example = aws.ec2.CapacityBlockReservation("example",
 *     capacity_block_offering_id=test.capacity_block_offering_id,
 *     instance_platform="Linux/UNIX",
 *     tags={
 *         "Environment": "dev",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Ec2.GetCapacityBlockOffering.Invoke(new()
 *     {
 *         CapacityDurationHours = 24,
 *         EndDateRange = "2024-05-30T15:04:05Z",
 *         InstanceCount = 1,
 *         InstanceType = "p4d.24xlarge",
 *         StartDateRange = "2024-04-28T15:04:05Z",
 *     });
 *     var example = new Aws.Ec2.CapacityBlockReservation("example", new()
 *     {
 *         CapacityBlockOfferingId = test.Apply(getCapacityBlockOfferingResult => getCapacityBlockOfferingResult.CapacityBlockOfferingId),
 *         InstancePlatform = "Linux/UNIX",
 *         Tags =
 *         {
 *             { "Environment", "dev" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := ec2.GetCapacityBlockOffering(ctx, &ec2.GetCapacityBlockOfferingArgs{
 * 			CapacityDurationHours: 24,
 * 			EndDateRange:          pulumi.StringRef("2024-05-30T15:04:05Z"),
 * 			InstanceCount:         1,
 * 			InstanceType:          "p4d.24xlarge",
 * 			StartDateRange:        pulumi.StringRef("2024-04-28T15:04:05Z"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewCapacityBlockReservation(ctx, "example", &ec2.CapacityBlockReservationArgs{
 * 			CapacityBlockOfferingId: pulumi.String(test.CapacityBlockOfferingId),
 * 			InstancePlatform:        pulumi.String("Linux/UNIX"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingArgs;
 * import com.pulumi.aws.ec2.CapacityBlockReservation;
 * import com.pulumi.aws.ec2.CapacityBlockReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = Ec2Functions.getCapacityBlockOffering(GetCapacityBlockOfferingArgs.builder()
 *             .capacityDurationHours(24)
 *             .endDateRange("2024-05-30T15:04:05Z")
 *             .instanceCount(1)
 *             .instanceType("p4d.24xlarge")
 *             .startDateRange("2024-04-28T15:04:05Z")
 *             .build());
 *         var example = new CapacityBlockReservation("example", CapacityBlockReservationArgs.builder()
 *             .capacityBlockOfferingId(test.applyValue(getCapacityBlockOfferingResult -> getCapacityBlockOfferingResult.capacityBlockOfferingId()))
 *             .instancePlatform("Linux/UNIX")
 *             .tags(Map.of("Environment", "dev"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:CapacityBlockReservation
 *     properties:
 *       capacityBlockOfferingId: ${test.capacityBlockOfferingId}
 *       instancePlatform: Linux/UNIX
 *       tags:
 *         Environment: dev
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:ec2:getCapacityBlockOffering
 *       Arguments:
 *         capacityDurationHours: 24
 *         endDateRange: 2024-05-30T15:04:05Z
 *         instanceCount: 1
 *         instanceType: p4d.24xlarge
 *         startDateRange: 2024-04-28T15:04:05Z
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class CapacityBlockReservation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.CapacityBlockReservation,
) : KotlinCustomResource(javaResource, CapacityBlockReservationMapper) {
    /**
     * The ARN of the reservation.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create the Capacity Block Reservation.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The Capacity Block Reservation ID.
     */
    public val capacityBlockOfferingId: Output<String>
        get() = javaResource.capacityBlockOfferingId().applyValue({ args0 -> args0 })

    /**
     * The date and time at which the Capacity Block Reservation was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances.
     */
    public val ebsOptimized: Output<Boolean>
        get() = javaResource.ebsOptimized().applyValue({ args0 -> args0 })

    /**
     * The date and time at which the Capacity Block Reservation expires. When a Capacity Block Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val endDate: Output<String>
        get() = javaResource.endDate().applyValue({ args0 -> args0 })

    /**
     * Indicates the way in which the Capacity Reservation ends.
     */
    public val endDateType: Output<String>
        get() = javaResource.endDateType().applyValue({ args0 -> args0 })

    /**
     * The number of instances for which to reserve capacity.
     */
    public val instanceCount: Output<Int>
        get() = javaResource.instanceCount().applyValue({ args0 -> args0 })

    /**
     * The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    public val instancePlatform: Output<String>
        get() = javaResource.instancePlatform().applyValue({ args0 -> args0 })

    /**
     * The instance type for which to reserve capacity.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Outpost on which to create the Capacity Block Reservation.
     */
    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the placement group in which to create the Capacity Block Reservation.
     */
    public val placementGroupArn: Output<String>
        get() = javaResource.placementGroupArn().applyValue({ args0 -> args0 })

    /**
     * The type of Capacity Reservation.
     */
    public val reservationType: Output<String>
        get() = javaResource.reservationType().applyValue({ args0 -> args0 })

    /**
     * The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val startDate: Output<String>
        get() = javaResource.startDate().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Indicates the tenancy of the Capacity Block Reservation. Specify either `default` or `dedicated`.
     */
    public val tenancy: Output<String>
        get() = javaResource.tenancy().applyValue({ args0 -> args0 })

    public val timeouts: Output<CapacityBlockReservationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object CapacityBlockReservationMapper : ResourceMapper<CapacityBlockReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.CapacityBlockReservation::class == javaResource::class

    override fun map(javaResource: Resource): CapacityBlockReservation =
        CapacityBlockReservation(javaResource as com.pulumi.aws.ec2.CapacityBlockReservation)
}

/**
 * @see [CapacityBlockReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityBlockReservation].
 */
public suspend fun capacityBlockReservation(
    name: String,
    block: suspend CapacityBlockReservationResourceBuilder.() -> Unit,
): CapacityBlockReservation {
    val builder = CapacityBlockReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityBlockReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityBlockReservation(name: String): CapacityBlockReservation {
    val builder = CapacityBlockReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
