@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.CapacityBlockReservationArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.CapacityBlockReservationTimeoutsArgs
import com.pulumi.aws.ec2.kotlin.inputs.CapacityBlockReservationTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 Capacity Block Reservation. This allows you to purchase capacity block for your Amazon EC2 instances in a specific Availability Zone for machine learning (ML) Workloads.
 * > **NOTE:** Once created, a reservation is valid for the `duration` of the provided `capacity_block_offering_id` and cannot be deleted. Performing a `destroy` will only remove the resource from state. For more information see [EC2 Capacity Block Reservation Documentation](https://aws&#46;amazon&#46;com/ec2/instance-types/p5/) and [PurchaseReservedDBInstancesOffering](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-blocks-pricing-billing.html).
 * > **NOTE:** Due to the expense of testing this resource, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.ec2.getCapacityBlockOffering({
 *     capacityDurationHours: 24,
 *     endDateRange: "2024-05-30T15:04:05Z",
 *     instanceCount: 1,
 *     instanceType: "p4d.24xlarge",
 *     startDateRange: "2024-04-28T15:04:05Z",
 * });
 * const example = new aws.ec2.CapacityBlockReservation("example", {
 *     capacityBlockOfferingId: test.then(test => test.capacityBlockOfferingId),
 *     instancePlatform: "Linux/UNIX",
 *     tags: {
 *         Environment: "dev",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.ec2.get_capacity_block_offering(capacity_duration_hours=24,
 *     end_date_range="2024-05-30T15:04:05Z",
 *     instance_count=1,
 *     instance_type="p4d.24xlarge",
 *     start_date_range="2024-04-28T15:04:05Z")
 * example = aws.ec2.CapacityBlockReservation("example",
 *     capacity_block_offering_id=test.capacity_block_offering_id,
 *     instance_platform="Linux/UNIX",
 *     tags={
 *         "Environment": "dev",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.Ec2.GetCapacityBlockOffering.Invoke(new()
 *     {
 *         CapacityDurationHours = 24,
 *         EndDateRange = "2024-05-30T15:04:05Z",
 *         InstanceCount = 1,
 *         InstanceType = "p4d.24xlarge",
 *         StartDateRange = "2024-04-28T15:04:05Z",
 *     });
 *     var example = new Aws.Ec2.CapacityBlockReservation("example", new()
 *     {
 *         CapacityBlockOfferingId = test.Apply(getCapacityBlockOfferingResult => getCapacityBlockOfferingResult.CapacityBlockOfferingId),
 *         InstancePlatform = "Linux/UNIX",
 *         Tags =
 *         {
 *             { "Environment", "dev" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := ec2.GetCapacityBlockOffering(ctx, &ec2.GetCapacityBlockOfferingArgs{
 * 			CapacityDurationHours: 24,
 * 			EndDateRange:          pulumi.StringRef("2024-05-30T15:04:05Z"),
 * 			InstanceCount:         1,
 * 			InstanceType:          "p4d.24xlarge",
 * 			StartDateRange:        pulumi.StringRef("2024-04-28T15:04:05Z"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewCapacityBlockReservation(ctx, "example", &ec2.CapacityBlockReservationArgs{
 * 			CapacityBlockOfferingId: pulumi.String(test.CapacityBlockOfferingId),
 * 			InstancePlatform:        pulumi.String("Linux/UNIX"),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("dev"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingArgs;
 * import com.pulumi.aws.ec2.CapacityBlockReservation;
 * import com.pulumi.aws.ec2.CapacityBlockReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = Ec2Functions.getCapacityBlockOffering(GetCapacityBlockOfferingArgs.builder()
 *             .capacityDurationHours(24)
 *             .endDateRange("2024-05-30T15:04:05Z")
 *             .instanceCount(1)
 *             .instanceType("p4d.24xlarge")
 *             .startDateRange("2024-04-28T15:04:05Z")
 *             .build());
 *         var example = new CapacityBlockReservation("example", CapacityBlockReservationArgs.builder()
 *             .capacityBlockOfferingId(test.applyValue(getCapacityBlockOfferingResult -> getCapacityBlockOfferingResult.capacityBlockOfferingId()))
 *             .instancePlatform("Linux/UNIX")
 *             .tags(Map.of("Environment", "dev"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:CapacityBlockReservation
 *     properties:
 *       capacityBlockOfferingId: ${test.capacityBlockOfferingId}
 *       instancePlatform: Linux/UNIX
 *       tags:
 *         Environment: dev
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:ec2:getCapacityBlockOffering
 *       Arguments:
 *         capacityDurationHours: 24
 *         endDateRange: 2024-05-30T15:04:05Z
 *         instanceCount: 1
 *         instanceType: p4d.24xlarge
 *         startDateRange: 2024-04-28T15:04:05Z
 * ```
 * <!--End PulumiCodeChooser -->
 * @property capacityBlockOfferingId The Capacity Block Reservation ID.
 * @property instancePlatform The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class CapacityBlockReservationArgs(
    public val capacityBlockOfferingId: Output<String>? = null,
    public val instancePlatform: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<CapacityBlockReservationTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.CapacityBlockReservationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.CapacityBlockReservationArgs =
        com.pulumi.aws.ec2.CapacityBlockReservationArgs.builder()
            .capacityBlockOfferingId(capacityBlockOfferingId?.applyValue({ args0 -> args0 }))
            .instancePlatform(instancePlatform?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CapacityBlockReservationArgs].
 */
@PulumiTagMarker
public class CapacityBlockReservationArgsBuilder internal constructor() {
    private var capacityBlockOfferingId: Output<String>? = null

    private var instancePlatform: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<CapacityBlockReservationTimeoutsArgs>? = null

    /**
     * @param value The Capacity Block Reservation ID.
     */
    @JvmName("omaknwtabdmpaptn")
    public suspend fun capacityBlockOfferingId(`value`: Output<String>) {
        this.capacityBlockOfferingId = value
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("brhmsmkvdvtmtrbb")
    public suspend fun instancePlatform(`value`: Output<String>) {
        this.instancePlatform = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hlgyjlpvqylvhtqn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("nwimcywgdrbdsjqo")
    public suspend fun timeouts(`value`: Output<CapacityBlockReservationTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Capacity Block Reservation ID.
     */
    @JvmName("hwgcdwppkncpbibd")
    public suspend fun capacityBlockOfferingId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityBlockOfferingId = mapped
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("nhbdknocbiptoanm")
    public suspend fun instancePlatform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePlatform = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmqyncylharwepmd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ormbjqbepqouvlii")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hslcxgmjcadoikqp")
    public suspend fun timeouts(`value`: CapacityBlockReservationTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ypixeyfjmkwyinkx")
    public suspend fun timeouts(argument: suspend CapacityBlockReservationTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = CapacityBlockReservationTimeoutsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): CapacityBlockReservationArgs = CapacityBlockReservationArgs(
        capacityBlockOfferingId = capacityBlockOfferingId,
        instancePlatform = instancePlatform,
        tags = tags,
        timeouts = timeouts,
    )
}
