@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CarrierGateway].
 */
@PulumiTagMarker
public class CarrierGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CarrierGatewayArgs = CarrierGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CarrierGatewayArgsBuilder.() -> Unit) {
        val builder = CarrierGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CarrierGateway {
        val builtJavaResource = com.pulumi.aws.ec2.CarrierGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CarrierGateway(builtJavaResource)
    }
}

/**
 * Manages an EC2 Carrier Gateway. See the AWS [documentation](https://docs.aws.amazon.com/vpc/latest/userguide/Carrier_Gateway.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.CarrierGateway("example", {
 *     vpcId: exampleAwsVpc.id,
 *     tags: {
 *         Name: "example-carrier-gateway",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.CarrierGateway("example",
 *     vpc_id=example_aws_vpc["id"],
 *     tags={
 *         "Name": "example-carrier-gateway",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.CarrierGateway("example", new()
 *     {
 *         VpcId = exampleAwsVpc.Id,
 *         Tags =
 *         {
 *             { "Name", "example-carrier-gateway" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewCarrierGateway(ctx, "example", &ec2.CarrierGatewayArgs{
 * 			VpcId: pulumi.Any(exampleAwsVpc.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-carrier-gateway"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.CarrierGateway;
 * import com.pulumi.aws.ec2.CarrierGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CarrierGateway("example", CarrierGatewayArgs.builder()
 *             .vpcId(exampleAwsVpc.id())
 *             .tags(Map.of("Name", "example-carrier-gateway"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:CarrierGateway
 *     properties:
 *       vpcId: ${exampleAwsVpc.id}
 *       tags:
 *         Name: example-carrier-gateway
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_carrier_gateway` using the carrier gateway's ID. For example:
 * ```sh
 * $ pulumi import aws:ec2/carrierGateway:CarrierGateway example cgw-12345
 * ```
 */
public class CarrierGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.CarrierGateway,
) : KotlinCustomResource(javaResource, CarrierGatewayMapper) {
    /**
     * The ARN of the carrier gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the owner of the carrier gateway.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC to associate with the carrier gateway.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object CarrierGatewayMapper : ResourceMapper<CarrierGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.CarrierGateway::class == javaResource::class

    override fun map(javaResource: Resource): CarrierGateway = CarrierGateway(
        javaResource as
            com.pulumi.aws.ec2.CarrierGateway,
    )
}

/**
 * @see [CarrierGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CarrierGateway].
 */
public suspend fun carrierGateway(
    name: String,
    block: suspend CarrierGatewayResourceBuilder.() -> Unit,
): CarrierGateway {
    val builder = CarrierGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CarrierGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun carrierGateway(name: String): CarrierGateway {
    val builder = CarrierGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
