@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.CustomerGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a customer gateway inside a VPC. These objects can be connected to VPN gateways via VPN connections, and allow you to establish tunnels between your network and the VPC.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.CustomerGateway("main", {
 *     bgpAsn: "65000",
 *     ipAddress: "172.83.124.10",
 *     type: "ipsec.1",
 *     tags: {
 *         Name: "main-customer-gateway",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.CustomerGateway("main",
 *     bgp_asn="65000",
 *     ip_address="172.83.124.10",
 *     type="ipsec.1",
 *     tags={
 *         "Name": "main-customer-gateway",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.CustomerGateway("main", new()
 *     {
 *         BgpAsn = "65000",
 *         IpAddress = "172.83.124.10",
 *         Type = "ipsec.1",
 *         Tags =
 *         {
 *             { "Name", "main-customer-gateway" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewCustomerGateway(ctx, "main", &ec2.CustomerGatewayArgs{
 * 			BgpAsn:    pulumi.String("65000"),
 * 			IpAddress: pulumi.String("172.83.124.10"),
 * 			Type:      pulumi.String("ipsec.1"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main-customer-gateway"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new CustomerGateway("main", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.83.124.10")
 *             .type("ipsec.1")
 *             .tags(Map.of("Name", "main-customer-gateway"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   main:
 *     type: aws:ec2:CustomerGateway
 *     properties:
 *       bgpAsn: 65000
 *       ipAddress: 172.83.124.10
 *       type: ipsec.1
 *       tags:
 *         Name: main-customer-gateway
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Customer Gateways using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/customerGateway:CustomerGateway main cgw-b4dc3961
 * ```
 * @property bgpAsn The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `1` to `2147483647`. Conflicts with `bgp_asn_extended`.
 * @property bgpAsnExtended The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `2147483648` to `4294967295` Conflicts with `bgp_asn`.
 * @property certificateArn The Amazon Resource Name (ARN) for the customer gateway certificate.
 * @property deviceName A name for the customer gateway device.
 * @property ipAddress The IPv4 address for the customer gateway device's outside interface.
 * @property tags Tags to apply to the gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of customer gateway. The only type AWS
 * supports at this time is "ipsec.1".
 */
public data class CustomerGatewayArgs(
    public val bgpAsn: Output<String>? = null,
    public val bgpAsnExtended: Output<String>? = null,
    public val certificateArn: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.CustomerGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2.CustomerGatewayArgs =
        com.pulumi.aws.ec2.CustomerGatewayArgs.builder()
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAsnExtended(bgpAsnExtended?.applyValue({ args0 -> args0 }))
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerGatewayArgs].
 */
@PulumiTagMarker
public class CustomerGatewayArgsBuilder internal constructor() {
    private var bgpAsn: Output<String>? = null

    private var bgpAsnExtended: Output<String>? = null

    private var certificateArn: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `1` to `2147483647`. Conflicts with `bgp_asn_extended`.
     */
    @JvmName("nbxbaqbhhxchlvgb")
    public suspend fun bgpAsn(`value`: Output<String>) {
        this.bgpAsn = value
    }

    /**
     * @param value The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `2147483648` to `4294967295` Conflicts with `bgp_asn`.
     */
    @JvmName("wxigpgcrqtpgigwi")
    public suspend fun bgpAsnExtended(`value`: Output<String>) {
        this.bgpAsnExtended = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    @JvmName("oxxqsapahtdkndep")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value A name for the customer gateway device.
     */
    @JvmName("ocvornhrglxjtaqe")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value The IPv4 address for the customer gateway device's outside interface.
     */
    @JvmName("crgrtbflugiptjvm")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Tags to apply to the gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oniycchmrsiifldf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of customer gateway. The only type AWS
     * supports at this time is "ipsec.1".
     */
    @JvmName("hlnaksqycltwhvxq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `1` to `2147483647`. Conflicts with `bgp_asn_extended`.
     */
    @JvmName("xcycesxafwkvtvwe")
    public suspend fun bgpAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN). Valid values are from  `2147483648` to `4294967295` Conflicts with `bgp_asn`.
     */
    @JvmName("dyjosbupmfdlcfbu")
    public suspend fun bgpAsnExtended(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsnExtended = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    @JvmName("rdrkkhtfvawsppbm")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value A name for the customer gateway device.
     */
    @JvmName("jvspsooivevauvlk")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value The IPv4 address for the customer gateway device's outside interface.
     */
    @JvmName("cgoqyxvbbhqeejrh")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Tags to apply to the gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ywdyptdpjmcnhbdl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fujvryjylvsnjviu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of customer gateway. The only type AWS
     * supports at this time is "ipsec.1".
     */
    @JvmName("acpbqpepuduqocwp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CustomerGatewayArgs = CustomerGatewayArgs(
        bgpAsn = bgpAsn,
        bgpAsnExtended = bgpAsnExtended,
        certificateArn = certificateArn,
        deviceName = deviceName,
        ipAddress = ipAddress,
        tags = tags,
        type = type,
    )
}
