@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DedicatedHostArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 Host resource. This allows Dedicated Hosts to be allocated, modified, and released.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new host with instance type of c5.18xlarge with Auto Placement
 * // and Host Recovery enabled.
 * const test = new aws.ec2.DedicatedHost("test", {
 *     instanceType: "c5.18xlarge",
 *     availabilityZone: "us-west-2a",
 *     hostRecovery: "on",
 *     autoPlacement: "on",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new host with instance type of c5.18xlarge with Auto Placement
 * # and Host Recovery enabled.
 * test = aws.ec2.DedicatedHost("test",
 *     instance_type="c5.18xlarge",
 *     availability_zone="us-west-2a",
 *     host_recovery="on",
 *     auto_placement="on")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new host with instance type of c5.18xlarge with Auto Placement
 *     // and Host Recovery enabled.
 *     var test = new Aws.Ec2.DedicatedHost("test", new()
 *     {
 *         InstanceType = "c5.18xlarge",
 *         AvailabilityZone = "us-west-2a",
 *         HostRecovery = "on",
 *         AutoPlacement = "on",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new host with instance type of c5.18xlarge with Auto Placement
 * 		// and Host Recovery enabled.
 * 		_, err := ec2.NewDedicatedHost(ctx, "test", &ec2.DedicatedHostArgs{
 * 			InstanceType:     pulumi.String("c5.18xlarge"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			HostRecovery:     pulumi.String("on"),
 * 			AutoPlacement:    pulumi.String("on"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DedicatedHost;
 * import com.pulumi.aws.ec2.DedicatedHostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new host with instance type of c5.18xlarge with Auto Placement
 *         // and Host Recovery enabled.
 *         var test = new DedicatedHost("test", DedicatedHostArgs.builder()
 *             .instanceType("c5.18xlarge")
 *             .availabilityZone("us-west-2a")
 *             .hostRecovery("on")
 *             .autoPlacement("on")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new host with instance type of c5.18xlarge with Auto Placement
 *   # and Host Recovery enabled.
 *   test:
 *     type: aws:ec2:DedicatedHost
 *     properties:
 *       instanceType: c5.18xlarge
 *       availabilityZone: us-west-2a
 *       hostRecovery: on
 *       autoPlacement: on
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import hosts using the host `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/dedicatedHost:DedicatedHost example h-0385a99d0e4b20cbb
 * ```
 * @property assetId The ID of the Outpost hardware asset on which to allocate the Dedicated Hosts. This parameter is supported only if you specify OutpostArn. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
 * @property autoPlacement Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. Valid values: `on`, `off`. Default: `on`.
 * @property availabilityZone The Availability Zone in which to allocate the Dedicated Host.
 * @property hostRecovery Indicates whether to enable or disable host recovery for the Dedicated Host. Valid values: `on`, `off`. Default: `off`.
 * @property instanceFamily Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. Exactly one of `instance_family` or `instance_type` must be specified.
 * @property instanceType Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. Exactly one of `instance_family` or `instance_type` must be specified.
 * @property outpostArn The Amazon Resource Name (ARN) of the AWS Outpost on which to allocate the Dedicated Host.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DedicatedHostArgs(
    public val assetId: Output<String>? = null,
    public val autoPlacement: Output<String>? = null,
    public val availabilityZone: Output<String>? = null,
    public val hostRecovery: Output<String>? = null,
    public val instanceFamily: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val outpostArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DedicatedHostArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DedicatedHostArgs =
        com.pulumi.aws.ec2.DedicatedHostArgs.builder()
            .assetId(assetId?.applyValue({ args0 -> args0 }))
            .autoPlacement(autoPlacement?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .hostRecovery(hostRecovery?.applyValue({ args0 -> args0 }))
            .instanceFamily(instanceFamily?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .outpostArn(outpostArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DedicatedHostArgs].
 */
@PulumiTagMarker
public class DedicatedHostArgsBuilder internal constructor() {
    private var assetId: Output<String>? = null

    private var autoPlacement: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var hostRecovery: Output<String>? = null

    private var instanceFamily: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var outpostArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the Outpost hardware asset on which to allocate the Dedicated Hosts. This parameter is supported only if you specify OutpostArn. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
     */
    @JvmName("gnaaiqchdckovqxu")
    public suspend fun assetId(`value`: Output<String>) {
        this.assetId = value
    }

    /**
     * @param value Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. Valid values: `on`, `off`. Default: `on`.
     */
    @JvmName("aijehajddmtxwqjg")
    public suspend fun autoPlacement(`value`: Output<String>) {
        this.autoPlacement = value
    }

    /**
     * @param value The Availability Zone in which to allocate the Dedicated Host.
     */
    @JvmName("qtgujtycpjodsyrt")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Indicates whether to enable or disable host recovery for the Dedicated Host. Valid values: `on`, `off`. Default: `off`.
     */
    @JvmName("wxivlcxaaoxrrpxh")
    public suspend fun hostRecovery(`value`: Output<String>) {
        this.hostRecovery = value
    }

    /**
     * @param value Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    @JvmName("hehhaosuahsfmnvn")
    public suspend fun instanceFamily(`value`: Output<String>) {
        this.instanceFamily = value
    }

    /**
     * @param value Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    @JvmName("rdwoublyehytscrm")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Outpost on which to allocate the Dedicated Host.
     */
    @JvmName("vaieishldpfqyqsv")
    public suspend fun outpostArn(`value`: Output<String>) {
        this.outpostArn = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fycukftpwcahxkqr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Outpost hardware asset on which to allocate the Dedicated Hosts. This parameter is supported only if you specify OutpostArn. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
     */
    @JvmName("nfeadevbqxiutsmm")
    public suspend fun assetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetId = mapped
    }

    /**
     * @param value Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. Valid values: `on`, `off`. Default: `on`.
     */
    @JvmName("jdpnxkxalmpohfqr")
    public suspend fun autoPlacement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPlacement = mapped
    }

    /**
     * @param value The Availability Zone in which to allocate the Dedicated Host.
     */
    @JvmName("skbfvncctnilpqvb")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Indicates whether to enable or disable host recovery for the Dedicated Host. Valid values: `on`, `off`. Default: `off`.
     */
    @JvmName("kcjxfvnqvvnufwcv")
    public suspend fun hostRecovery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostRecovery = mapped
    }

    /**
     * @param value Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    @JvmName("liwvlgakgbfdykdi")
    public suspend fun instanceFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceFamily = mapped
    }

    /**
     * @param value Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    @JvmName("slcxurgaxnkkbiyn")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Outpost on which to allocate the Dedicated Host.
     */
    @JvmName("fsebkkxajtiriciv")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostArn = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rjdkmjolcqypmqag")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwxvonoaululmswo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DedicatedHostArgs = DedicatedHostArgs(
        assetId = assetId,
        autoPlacement = autoPlacement,
        availabilityZone = availabilityZone,
        hostRecovery = hostRecovery,
        instanceFamily = instanceFamily,
        instanceType = instanceType,
        outpostArn = outpostArn,
        tags = tags,
    )
}
