@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.DefaultRouteTableRoute
import com.pulumi.aws.ec2.kotlin.outputs.DefaultRouteTableRoute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DefaultRouteTable].
 */
@PulumiTagMarker
public class DefaultRouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultRouteTableArgs = DefaultRouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultRouteTableArgsBuilder.() -> Unit) {
        val builder = DefaultRouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefaultRouteTable {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultRouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultRouteTable(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a default route table of a VPC. This resource can manage the default route table of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultRouteTable` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management. **Do not** use both `aws.ec2.DefaultRouteTable` to manage a default route table **and** `aws.ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See aws.ec2.MainRouteTableAssociation documentation for more details.
 * Every VPC has a default route table that can be managed but not destroyed. When the provider first adopts a default route table, it **immediately removes all defined routes**. It then proceeds to create any routes specified in the configuration. This step is required so that only the routes specified in the configuration exist in the default route table.
 * For more information, see the Amazon VPC User Guide on [Route Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html). For information about managing normal route tables in this provider, see `aws.ec2.RouteTable`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DefaultRouteTable("example", {
 *     defaultRouteTableId: exampleAwsVpc.defaultRouteTableId,
 *     routes: [
 *         {
 *             cidrBlock: "10.0.1.0/24",
 *             gatewayId: exampleAwsInternetGateway.id,
 *         },
 *         {
 *             ipv6CidrBlock: "::/0",
 *             egressOnlyGatewayId: exampleAwsEgressOnlyInternetGateway.id,
 *         },
 *     ],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DefaultRouteTable("example",
 *     default_route_table_id=example_aws_vpc["defaultRouteTableId"],
 *     routes=[
 *         {
 *             "cidr_block": "10.0.1.0/24",
 *             "gateway_id": example_aws_internet_gateway["id"],
 *         },
 *         {
 *             "ipv6_cidr_block": "::/0",
 *             "egress_only_gateway_id": example_aws_egress_only_internet_gateway["id"],
 *         },
 *     ],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DefaultRouteTable("example", new()
 *     {
 *         DefaultRouteTableId = exampleAwsVpc.DefaultRouteTableId,
 *         Routes = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultRouteTableRouteArgs
 *             {
 *                 CidrBlock = "10.0.1.0/24",
 *                 GatewayId = exampleAwsInternetGateway.Id,
 *             },
 *             new Aws.Ec2.Inputs.DefaultRouteTableRouteArgs
 *             {
 *                 Ipv6CidrBlock = "::/0",
 *                 EgressOnlyGatewayId = exampleAwsEgressOnlyInternetGateway.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewDefaultRouteTable(ctx, "example", &ec2.DefaultRouteTableArgs{
 * 			DefaultRouteTableId: pulumi.Any(exampleAwsVpc.DefaultRouteTableId),
 * 			Routes: ec2.DefaultRouteTableRouteArray{
 * 				&ec2.DefaultRouteTableRouteArgs{
 * 					CidrBlock: pulumi.String("10.0.1.0/24"),
 * 					GatewayId: pulumi.Any(exampleAwsInternetGateway.Id),
 * 				},
 * 				&ec2.DefaultRouteTableRouteArgs{
 * 					Ipv6CidrBlock:       pulumi.String("::/0"),
 * 					EgressOnlyGatewayId: pulumi.Any(exampleAwsEgressOnlyInternetGateway.Id),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultRouteTable;
 * import com.pulumi.aws.ec2.DefaultRouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DefaultRouteTable("example", DefaultRouteTableArgs.builder()
 *             .defaultRouteTableId(exampleAwsVpc.defaultRouteTableId())
 *             .routes(
 *                 DefaultRouteTableRouteArgs.builder()
 *                     .cidrBlock("10.0.1.0/24")
 *                     .gatewayId(exampleAwsInternetGateway.id())
 *                     .build(),
 *                 DefaultRouteTableRouteArgs.builder()
 *                     .ipv6CidrBlock("::/0")
 *                     .egressOnlyGatewayId(exampleAwsEgressOnlyInternetGateway.id())
 *                     .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DefaultRouteTable
 *     properties:
 *       defaultRouteTableId: ${exampleAwsVpc.defaultRouteTableId}
 *       routes:
 *         - cidrBlock: 10.0.1.0/24
 *           gatewayId: ${exampleAwsInternetGateway.id}
 *         - ipv6CidrBlock: ::/0
 *           egressOnlyGatewayId: ${exampleAwsEgressOnlyInternetGateway.id}
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * To subsequently remove all managed routes:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DefaultRouteTable("example", {
 *     defaultRouteTableId: exampleAwsVpc.defaultRouteTableId,
 *     routes: [],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DefaultRouteTable("example",
 *     default_route_table_id=example_aws_vpc["defaultRouteTableId"],
 *     routes=[],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DefaultRouteTable("example", new()
 *     {
 *         DefaultRouteTableId = exampleAwsVpc.DefaultRouteTableId,
 *         Routes = new[] {},
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewDefaultRouteTable(ctx, "example", &ec2.DefaultRouteTableArgs{
 * 			DefaultRouteTableId: pulumi.Any(exampleAwsVpc.DefaultRouteTableId),
 * 			Routes:              ec2.DefaultRouteTableRouteArray{},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultRouteTable;
 * import com.pulumi.aws.ec2.DefaultRouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DefaultRouteTable("example", DefaultRouteTableArgs.builder()
 *             .defaultRouteTableId(exampleAwsVpc.defaultRouteTableId())
 *             .routes()
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DefaultRouteTable
 *     properties:
 *       defaultRouteTableId: ${exampleAwsVpc.defaultRouteTableId}
 *       routes: []
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Default VPC route tables using the `vpc_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/defaultRouteTable:DefaultRouteTable example vpc-33cc44dd
 * ```
 */
public class DefaultRouteTable internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultRouteTable,
) : KotlinCustomResource(javaResource, DefaultRouteTableMapper) {
    /**
     * The ARN of the route table.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ID of the default route table.
     * The following arguments are optional:
     */
    public val defaultRouteTableId: Output<String>
        get() = javaResource.defaultRouteTableId().applyValue({ args0 -> args0 })

    /**
     * ID of the AWS account that owns the route table.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * List of virtual gateways for propagation.
     */
    public val propagatingVgws: Output<List<String>>?
        get() = javaResource.propagatingVgws().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Set of objects. Detailed below
     */
    public val routes: Output<List<DefaultRouteTableRoute>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DefaultRouteTableMapper : ResourceMapper<DefaultRouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultRouteTable::class == javaResource::class

    override fun map(javaResource: Resource): DefaultRouteTable = DefaultRouteTable(
        javaResource as
            com.pulumi.aws.ec2.DefaultRouteTable,
    )
}

/**
 * @see [DefaultRouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultRouteTable].
 */
public suspend fun defaultRouteTable(
    name: String,
    block: suspend DefaultRouteTableResourceBuilder.() -> Unit,
): DefaultRouteTable {
    val builder = DefaultRouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultRouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultRouteTable(name: String): DefaultRouteTable {
    val builder = DefaultRouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
