@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultRouteTableArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.DefaultRouteTableRouteArgs
import com.pulumi.aws.ec2.kotlin.inputs.DefaultRouteTableRouteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a default route table of a VPC. This resource can manage the default route table of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultRouteTable` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management. **Do not** use both `aws.ec2.DefaultRouteTable` to manage a default route table **and** `aws.ec2.MainRouteTableAssociation` with the same VPC due to possible route conflicts. See aws.ec2.MainRouteTableAssociation documentation for more details.
 * Every VPC has a default route table that can be managed but not destroyed. When the provider first adopts a default route table, it **immediately removes all defined routes**. It then proceeds to create any routes specified in the configuration. This step is required so that only the routes specified in the configuration exist in the default route table.
 * For more information, see the Amazon VPC User Guide on [Route Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html). For information about managing normal route tables in this provider, see `aws.ec2.RouteTable`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DefaultRouteTable("example", {
 *     defaultRouteTableId: exampleAwsVpc.defaultRouteTableId,
 *     routes: [
 *         {
 *             cidrBlock: "10.0.1.0/24",
 *             gatewayId: exampleAwsInternetGateway.id,
 *         },
 *         {
 *             ipv6CidrBlock: "::/0",
 *             egressOnlyGatewayId: exampleAwsEgressOnlyInternetGateway.id,
 *         },
 *     ],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DefaultRouteTable("example",
 *     default_route_table_id=example_aws_vpc["defaultRouteTableId"],
 *     routes=[
 *         {
 *             "cidr_block": "10.0.1.0/24",
 *             "gateway_id": example_aws_internet_gateway["id"],
 *         },
 *         {
 *             "ipv6_cidr_block": "::/0",
 *             "egress_only_gateway_id": example_aws_egress_only_internet_gateway["id"],
 *         },
 *     ],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DefaultRouteTable("example", new()
 *     {
 *         DefaultRouteTableId = exampleAwsVpc.DefaultRouteTableId,
 *         Routes = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultRouteTableRouteArgs
 *             {
 *                 CidrBlock = "10.0.1.0/24",
 *                 GatewayId = exampleAwsInternetGateway.Id,
 *             },
 *             new Aws.Ec2.Inputs.DefaultRouteTableRouteArgs
 *             {
 *                 Ipv6CidrBlock = "::/0",
 *                 EgressOnlyGatewayId = exampleAwsEgressOnlyInternetGateway.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewDefaultRouteTable(ctx, "example", &ec2.DefaultRouteTableArgs{
 * 			DefaultRouteTableId: pulumi.Any(exampleAwsVpc.DefaultRouteTableId),
 * 			Routes: ec2.DefaultRouteTableRouteArray{
 * 				&ec2.DefaultRouteTableRouteArgs{
 * 					CidrBlock: pulumi.String("10.0.1.0/24"),
 * 					GatewayId: pulumi.Any(exampleAwsInternetGateway.Id),
 * 				},
 * 				&ec2.DefaultRouteTableRouteArgs{
 * 					Ipv6CidrBlock:       pulumi.String("::/0"),
 * 					EgressOnlyGatewayId: pulumi.Any(exampleAwsEgressOnlyInternetGateway.Id),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultRouteTable;
 * import com.pulumi.aws.ec2.DefaultRouteTableArgs;
 * import com.pulumi.aws.ec2.inputs.DefaultRouteTableRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DefaultRouteTable("example", DefaultRouteTableArgs.builder()
 *             .defaultRouteTableId(exampleAwsVpc.defaultRouteTableId())
 *             .routes(
 *                 DefaultRouteTableRouteArgs.builder()
 *                     .cidrBlock("10.0.1.0/24")
 *                     .gatewayId(exampleAwsInternetGateway.id())
 *                     .build(),
 *                 DefaultRouteTableRouteArgs.builder()
 *                     .ipv6CidrBlock("::/0")
 *                     .egressOnlyGatewayId(exampleAwsEgressOnlyInternetGateway.id())
 *                     .build())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DefaultRouteTable
 *     properties:
 *       defaultRouteTableId: ${exampleAwsVpc.defaultRouteTableId}
 *       routes:
 *         - cidrBlock: 10.0.1.0/24
 *           gatewayId: ${exampleAwsInternetGateway.id}
 *         - ipv6CidrBlock: ::/0
 *           egressOnlyGatewayId: ${exampleAwsEgressOnlyInternetGateway.id}
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * To subsequently remove all managed routes:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.DefaultRouteTable("example", {
 *     defaultRouteTableId: exampleAwsVpc.defaultRouteTableId,
 *     routes: [],
 *     tags: {
 *         Name: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.DefaultRouteTable("example",
 *     default_route_table_id=example_aws_vpc["defaultRouteTableId"],
 *     routes=[],
 *     tags={
 *         "Name": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.DefaultRouteTable("example", new()
 *     {
 *         DefaultRouteTableId = exampleAwsVpc.DefaultRouteTableId,
 *         Routes = new[] {},
 *         Tags =
 *         {
 *             { "Name", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewDefaultRouteTable(ctx, "example", &ec2.DefaultRouteTableArgs{
 * 			DefaultRouteTableId: pulumi.Any(exampleAwsVpc.DefaultRouteTableId),
 * 			Routes:              ec2.DefaultRouteTableRouteArray{},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultRouteTable;
 * import com.pulumi.aws.ec2.DefaultRouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DefaultRouteTable("example", DefaultRouteTableArgs.builder()
 *             .defaultRouteTableId(exampleAwsVpc.defaultRouteTableId())
 *             .routes()
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:DefaultRouteTable
 *     properties:
 *       defaultRouteTableId: ${exampleAwsVpc.defaultRouteTableId}
 *       routes: []
 *       tags:
 *         Name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Default VPC route tables using the `vpc_id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/defaultRouteTable:DefaultRouteTable example vpc-33cc44dd
 * ```
 * @property defaultRouteTableId ID of the default route table.
 * The following arguments are optional:
 * @property propagatingVgws List of virtual gateways for propagation.
 * @property routes Set of objects. Detailed below
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DefaultRouteTableArgs(
    public val defaultRouteTableId: Output<String>? = null,
    public val propagatingVgws: Output<List<String>>? = null,
    public val routes: Output<List<DefaultRouteTableRouteArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultRouteTableArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultRouteTableArgs =
        com.pulumi.aws.ec2.DefaultRouteTableArgs.builder()
            .defaultRouteTableId(defaultRouteTableId?.applyValue({ args0 -> args0 }))
            .propagatingVgws(propagatingVgws?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DefaultRouteTableArgs].
 */
@PulumiTagMarker
public class DefaultRouteTableArgsBuilder internal constructor() {
    private var defaultRouteTableId: Output<String>? = null

    private var propagatingVgws: Output<List<String>>? = null

    private var routes: Output<List<DefaultRouteTableRouteArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ID of the default route table.
     * The following arguments are optional:
     */
    @JvmName("susefcfxlivgjjaf")
    public suspend fun defaultRouteTableId(`value`: Output<String>) {
        this.defaultRouteTableId = value
    }

    /**
     * @param value List of virtual gateways for propagation.
     */
    @JvmName("wokomduhqkeipggl")
    public suspend fun propagatingVgws(`value`: Output<List<String>>) {
        this.propagatingVgws = value
    }

    @JvmName("psktrfxfhvpsbcmx")
    public suspend fun propagatingVgws(vararg values: Output<String>) {
        this.propagatingVgws = Output.all(values.asList())
    }

    /**
     * @param values List of virtual gateways for propagation.
     */
    @JvmName("isfrepjxkabmtdev")
    public suspend fun propagatingVgws(values: List<Output<String>>) {
        this.propagatingVgws = Output.all(values)
    }

    /**
     * @param value Set of objects. Detailed below
     */
    @JvmName("fgxymeqsgwxpergn")
    public suspend fun routes(`value`: Output<List<DefaultRouteTableRouteArgs>>) {
        this.routes = value
    }

    @JvmName("ealmmxncwwalswgt")
    public suspend fun routes(vararg values: Output<DefaultRouteTableRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Set of objects. Detailed below
     */
    @JvmName("kwgkuhirdpigqlio")
    public suspend fun routes(values: List<Output<DefaultRouteTableRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gimkepfdfawskpuu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the default route table.
     * The following arguments are optional:
     */
    @JvmName("pybuxxjocjjvuhkh")
    public suspend fun defaultRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteTableId = mapped
    }

    /**
     * @param value List of virtual gateways for propagation.
     */
    @JvmName("xlijpwfgsepcjlkr")
    public suspend fun propagatingVgws(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagatingVgws = mapped
    }

    /**
     * @param values List of virtual gateways for propagation.
     */
    @JvmName("etlifwatyjecrcrb")
    public suspend fun propagatingVgws(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propagatingVgws = mapped
    }

    /**
     * @param value Set of objects. Detailed below
     */
    @JvmName("xhdiddqownxlbdgm")
    public suspend fun routes(`value`: List<DefaultRouteTableRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Set of objects. Detailed below
     */
    @JvmName("flwqkkanciukneow")
    public suspend fun routes(argument: List<suspend DefaultRouteTableRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DefaultRouteTableRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Set of objects. Detailed below
     */
    @JvmName("jwbhogqgoicxwqjt")
    public suspend fun routes(vararg argument: suspend DefaultRouteTableRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DefaultRouteTableRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Set of objects. Detailed below
     */
    @JvmName("pkcugjlpscrfjwly")
    public suspend fun routes(argument: suspend DefaultRouteTableRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DefaultRouteTableRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Set of objects. Detailed below
     */
    @JvmName("iueqlsgydvbrprii")
    public suspend fun routes(vararg values: DefaultRouteTableRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lrejpqcdvrmvmhoc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fctmbkvbwqykwiln")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DefaultRouteTableArgs = DefaultRouteTableArgs(
        defaultRouteTableId = defaultRouteTableId,
        propagatingVgws = propagatingVgws,
        routes = routes,
        tags = tags,
    )
}
