@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupEgress
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupIngress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupEgress.Companion.toKotlin as defaultSecurityGroupEgressToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupIngress.Companion.toKotlin as defaultSecurityGroupIngressToKotlin

/**
 * Builder for [DefaultSecurityGroup].
 */
@PulumiTagMarker
public class DefaultSecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultSecurityGroupArgs = DefaultSecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultSecurityGroupArgsBuilder.() -> Unit) {
        val builder = DefaultSecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefaultSecurityGroup {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultSecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultSecurityGroup(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a default security group. This resource can manage the default security group of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultSecurityGroup` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management.
 * When the provider first begins managing the default security group, it **immediately removes all ingress and egress rules in the Security Group**. It then creates any rules specified in the configuration. This way only the rules specified in the configuration are created.
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diff shown. For these reasons, this resource is incompatible with the `aws.ec2.SecurityGroupRule` resource.
 * For more information about default security groups, see the AWS documentation on [Default Security Groups][aws-default-security-groups]. To manage normal security groups, see the `aws.ec2.SecurityGroup` resource.
 * ## Example Usage
 * The following config gives the default security group the same rules that AWS provides by default but under management by this provider. This means that any ingress or egress rules added or changed will be detected as drift.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mainvpc = new aws.ec2.Vpc("mainvpc", {cidrBlock: "10.1.0.0/16"});
 * const _default = new aws.ec2.DefaultSecurityGroup("default", {
 *     vpcId: mainvpc.id,
 *     ingress: [{
 *         protocol: "-1",
 *         self: true,
 *         fromPort: 0,
 *         toPort: 0,
 *     }],
 *     egress: [{
 *         fromPort: 0,
 *         toPort: 0,
 *         protocol: "-1",
 *         cidrBlocks: ["0&#46;0&#46;0&#46;0/0"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mainvpc = aws.ec2.Vpc("mainvpc", cidr_block="10.1.0.0/16")
 * default = aws.ec2.DefaultSecurityGroup("default",
 *     vpc_id=mainvpc.id,
 *     ingress=[{
 *         "protocol": "-1",
 *         "self": True,
 *         "from_port": 0,
 *         "to_port": 0,
 *     }],
 *     egress=[{
 *         "from_port": 0,
 *         "to_port": 0,
 *         "protocol": "-1",
 *         "cidr_blocks": ["0&#46;0&#46;0&#46;0/0"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mainvpc = new Aws.Ec2.Vpc("mainvpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var @default = new Aws.Ec2.DefaultSecurityGroup("default", new()
 *     {
 *         VpcId = mainvpc.Id,
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupIngressArgs
 *             {
 *                 Protocol = "-1",
 *                 Self = true,
 *                 FromPort = 0,
 *                 ToPort = 0,
 *             },
 *         },
 *         Egress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupEgressArgs
 *             {
 *                 FromPort = 0,
 *                 ToPort = 0,
 *                 Protocol = "-1",
 *                 CidrBlocks = new[]
 *                 {
 *                     "0.0.0.0/0",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mainvpc, err := ec2.NewVpc(ctx, "mainvpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewDefaultSecurityGroup(ctx, "default", &ec2.DefaultSecurityGroupArgs{
 * 			VpcId: mainvpc.ID(),
 * 			Ingress: ec2.DefaultSecurityGroupIngressArray{
 * 				&ec2.DefaultSecurityGroupIngressArgs{
 * 					Protocol: pulumi.String("-1"),
 * 					Self:     pulumi.Bool(true),
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 				},
 * 			},
 * 			Egress: ec2.DefaultSecurityGroupEgressArray{
 * 				&ec2.DefaultSecurityGroupEgressArgs{
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 					Protocol: pulumi.String("-1"),
 * 					CidrBlocks: pulumi.StringArray{
 * 						pulumi.String("0.0.0.0/0"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   mainvpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   default:
 *     type: aws:ec2:DefaultSecurityGroup
 *     properties:
 *       vpcId: ${mainvpc.id}
 *       ingress:
 *         - protocol: -1
 *           self: true
 *           fromPort: 0
 *           toPort: 0
 *       egress:
 *         - fromPort: 0
 *           toPort: 0
 *           protocol: '-1'
 *           cidrBlocks:
 *             - 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Config To Deny All Egress Traffic, Allowing Ingress
 * The following denies all Egress traffic by omitting any `egress` rules, while including the default `ingress` rule to allow all traffic.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mainvpc = new aws.ec2.Vpc("mainvpc", {cidrBlock: "10.1.0.0/16"});
 * const _default = new aws.ec2.DefaultSecurityGroup("default", {
 *     vpcId: mainvpc.id,
 *     ingress: [{
 *         protocol: "-1",
 *         self: true,
 *         fromPort: 0,
 *         toPort: 0,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mainvpc = aws.ec2.Vpc("mainvpc", cidr_block="10.1.0.0/16")
 * default = aws.ec2.DefaultSecurityGroup("default",
 *     vpc_id=mainvpc.id,
 *     ingress=[{
 *         "protocol": "-1",
 *         "self": True,
 *         "from_port": 0,
 *         "to_port": 0,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mainvpc = new Aws.Ec2.Vpc("mainvpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var @default = new Aws.Ec2.DefaultSecurityGroup("default", new()
 *     {
 *         VpcId = mainvpc.Id,
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupIngressArgs
 *             {
 *                 Protocol = "-1",
 *                 Self = true,
 *                 FromPort = 0,
 *                 ToPort = 0,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mainvpc, err := ec2.NewVpc(ctx, "mainvpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewDefaultSecurityGroup(ctx, "default", &ec2.DefaultSecurityGroupArgs{
 * 			VpcId: mainvpc.ID(),
 * 			Ingress: ec2.DefaultSecurityGroupIngressArray{
 * 				&ec2.DefaultSecurityGroupIngressArgs{
 * 					Protocol: pulumi.String("-1"),
 * 					Self:     pulumi.Bool(true),
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   mainvpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   default:
 *     type: aws:ec2:DefaultSecurityGroup
 *     properties:
 *       vpcId: ${mainvpc.id}
 *       ingress:
 *         - protocol: -1
 *           self: true
 *           fromPort: 0
 *           toPort: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Removing `aws.ec2.DefaultSecurityGroup` From Your Configuration
 * Removing this resource from your configuration will remove it from your statefile and management, but will not destroy the Security Group. All ingress or egress rules will be left as they are at the time of removal. You can resume managing them via the AWS Console.
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/defaultSecurityGroup:DefaultSecurityGroup default_sg sg-903004f8
 * ```
 */
public class DefaultSecurityGroup internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultSecurityGroup,
) : KotlinCustomResource(javaResource, DefaultSecurityGroupMapper) {
    /**
     * ARN of the security group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the security group.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val egress: Output<List<DefaultSecurityGroupEgress>>
        get() = javaResource.egress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    defaultSecurityGroupEgressToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block. Detailed below.
     */
    public val ingress: Output<List<DefaultSecurityGroupIngress>>
        get() = javaResource.ingress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    defaultSecurityGroupIngressToKotlin(args0)
                })
            })
        })

    /**
     * Name of the security group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Owner ID.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val revokeRulesOnDelete: Output<Boolean>?
        get() = javaResource.revokeRulesOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DefaultSecurityGroupMapper : ResourceMapper<DefaultSecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultSecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): DefaultSecurityGroup = DefaultSecurityGroup(
        javaResource
            as com.pulumi.aws.ec2.DefaultSecurityGroup,
    )
}

/**
 * @see [DefaultSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultSecurityGroup].
 */
public suspend fun defaultSecurityGroup(
    name: String,
    block: suspend DefaultSecurityGroupResourceBuilder.() -> Unit,
): DefaultSecurityGroup {
    val builder = DefaultSecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultSecurityGroup(name: String): DefaultSecurityGroup {
    val builder = DefaultSecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
