@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultSecurityGroupArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupEgressArgs
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupEgressArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupIngressArgs
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupIngressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a default security group. This resource can manage the default security group of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultSecurityGroup` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management.
 * When the provider first begins managing the default security group, it **immediately removes all ingress and egress rules in the Security Group**. It then creates any rules specified in the configuration. This way only the rules specified in the configuration are created.
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diff shown. For these reasons, this resource is incompatible with the `aws.ec2.SecurityGroupRule` resource.
 * For more information about default security groups, see the AWS documentation on [Default Security Groups][aws-default-security-groups]. To manage normal security groups, see the `aws.ec2.SecurityGroup` resource.
 * ## Example Usage
 * The following config gives the default security group the same rules that AWS provides by default but under management by this provider. This means that any ingress or egress rules added or changed will be detected as drift.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mainvpc = new aws.ec2.Vpc("mainvpc", {cidrBlock: "10.1.0.0/16"});
 * const _default = new aws.ec2.DefaultSecurityGroup("default", {
 *     vpcId: mainvpc.id,
 *     ingress: [{
 *         protocol: "-1",
 *         self: true,
 *         fromPort: 0,
 *         toPort: 0,
 *     }],
 *     egress: [{
 *         fromPort: 0,
 *         toPort: 0,
 *         protocol: "-1",
 *         cidrBlocks: ["0&#46;0&#46;0&#46;0/0"],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mainvpc = aws.ec2.Vpc("mainvpc", cidr_block="10.1.0.0/16")
 * default = aws.ec2.DefaultSecurityGroup("default",
 *     vpc_id=mainvpc.id,
 *     ingress=[{
 *         "protocol": "-1",
 *         "self": True,
 *         "from_port": 0,
 *         "to_port": 0,
 *     }],
 *     egress=[{
 *         "from_port": 0,
 *         "to_port": 0,
 *         "protocol": "-1",
 *         "cidr_blocks": ["0&#46;0&#46;0&#46;0/0"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mainvpc = new Aws.Ec2.Vpc("mainvpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var @default = new Aws.Ec2.DefaultSecurityGroup("default", new()
 *     {
 *         VpcId = mainvpc.Id,
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupIngressArgs
 *             {
 *                 Protocol = "-1",
 *                 Self = true,
 *                 FromPort = 0,
 *                 ToPort = 0,
 *             },
 *         },
 *         Egress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupEgressArgs
 *             {
 *                 FromPort = 0,
 *                 ToPort = 0,
 *                 Protocol = "-1",
 *                 CidrBlocks = new[]
 *                 {
 *                     "0.0.0.0/0",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mainvpc, err := ec2.NewVpc(ctx, "mainvpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewDefaultSecurityGroup(ctx, "default", &ec2.DefaultSecurityGroupArgs{
 * 			VpcId: mainvpc.ID(),
 * 			Ingress: ec2.DefaultSecurityGroupIngressArray{
 * 				&ec2.DefaultSecurityGroupIngressArgs{
 * 					Protocol: pulumi.String("-1"),
 * 					Self:     pulumi.Bool(true),
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 				},
 * 			},
 * 			Egress: ec2.DefaultSecurityGroupEgressArray{
 * 				&ec2.DefaultSecurityGroupEgressArgs{
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 					Protocol: pulumi.String("-1"),
 * 					CidrBlocks: pulumi.StringArray{
 * 						pulumi.String("0.0.0.0/0"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   mainvpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   default:
 *     type: aws:ec2:DefaultSecurityGroup
 *     properties:
 *       vpcId: ${mainvpc.id}
 *       ingress:
 *         - protocol: -1
 *           self: true
 *           fromPort: 0
 *           toPort: 0
 *       egress:
 *         - fromPort: 0
 *           toPort: 0
 *           protocol: '-1'
 *           cidrBlocks:
 *             - 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example Config To Deny All Egress Traffic, Allowing Ingress
 * The following denies all Egress traffic by omitting any `egress` rules, while including the default `ingress` rule to allow all traffic.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const mainvpc = new aws.ec2.Vpc("mainvpc", {cidrBlock: "10.1.0.0/16"});
 * const _default = new aws.ec2.DefaultSecurityGroup("default", {
 *     vpcId: mainvpc.id,
 *     ingress: [{
 *         protocol: "-1",
 *         self: true,
 *         fromPort: 0,
 *         toPort: 0,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * mainvpc = aws.ec2.Vpc("mainvpc", cidr_block="10.1.0.0/16")
 * default = aws.ec2.DefaultSecurityGroup("default",
 *     vpc_id=mainvpc.id,
 *     ingress=[{
 *         "protocol": "-1",
 *         "self": True,
 *         "from_port": 0,
 *         "to_port": 0,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mainvpc = new Aws.Ec2.Vpc("mainvpc", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var @default = new Aws.Ec2.DefaultSecurityGroup("default", new()
 *     {
 *         VpcId = mainvpc.Id,
 *         Ingress = new[]
 *         {
 *             new Aws.Ec2.Inputs.DefaultSecurityGroupIngressArgs
 *             {
 *                 Protocol = "-1",
 *                 Self = true,
 *                 FromPort = 0,
 *                 ToPort = 0,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		mainvpc, err := ec2.NewVpc(ctx, "mainvpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewDefaultSecurityGroup(ctx, "default", &ec2.DefaultSecurityGroupArgs{
 * 			VpcId: mainvpc.ID(),
 * 			Ingress: ec2.DefaultSecurityGroupIngressArray{
 * 				&ec2.DefaultSecurityGroupIngressArgs{
 * 					Protocol: pulumi.String("-1"),
 * 					Self:     pulumi.Bool(true),
 * 					FromPort: pulumi.Int(0),
 * 					ToPort:   pulumi.Int(0),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```yaml
 * resources:
 *   mainvpc:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   default:
 *     type: aws:ec2:DefaultSecurityGroup
 *     properties:
 *       vpcId: ${mainvpc.id}
 *       ingress:
 *         - protocol: -1
 *           self: true
 *           fromPort: 0
 *           toPort: 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Removing `aws.ec2.DefaultSecurityGroup` From Your Configuration
 * Removing this resource from your configuration will remove it from your statefile and management, but will not destroy the Security Group. All ingress or egress rules will be left as they are at the time of removal. You can resume managing them via the AWS Console.
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/defaultSecurityGroup:DefaultSecurityGroup default_sg sg-903004f8
 * ```
 * @property egress Configuration block. Detailed below.
 * @property ingress Configuration block. Detailed below.
 * @property revokeRulesOnDelete
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
 */
public data class DefaultSecurityGroupArgs(
    public val egress: Output<List<DefaultSecurityGroupEgressArgs>>? = null,
    public val ingress: Output<List<DefaultSecurityGroupIngressArgs>>? = null,
    public val revokeRulesOnDelete: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultSecurityGroupArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultSecurityGroupArgs =
        com.pulumi.aws.ec2.DefaultSecurityGroupArgs.builder()
            .egress(egress?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ingress(
                ingress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .revokeRulesOnDelete(revokeRulesOnDelete?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultSecurityGroupArgs].
 */
@PulumiTagMarker
public class DefaultSecurityGroupArgsBuilder internal constructor() {
    private var egress: Output<List<DefaultSecurityGroupEgressArgs>>? = null

    private var ingress: Output<List<DefaultSecurityGroupIngressArgs>>? = null

    private var revokeRulesOnDelete: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("sxrwmoaeblfejotp")
    public suspend fun egress(`value`: Output<List<DefaultSecurityGroupEgressArgs>>) {
        this.egress = value
    }

    @JvmName("tcsbijvlghrnhtlu")
    public suspend fun egress(vararg values: Output<DefaultSecurityGroupEgressArgs>) {
        this.egress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("rrimrqnnxxftwtve")
    public suspend fun egress(values: List<Output<DefaultSecurityGroupEgressArgs>>) {
        this.egress = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("dpatdskyapntqqul")
    public suspend fun ingress(`value`: Output<List<DefaultSecurityGroupIngressArgs>>) {
        this.ingress = value
    }

    @JvmName("hsxcblfevpidrudh")
    public suspend fun ingress(vararg values: Output<DefaultSecurityGroupIngressArgs>) {
        this.ingress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("vsjvmloyquwkvfic")
    public suspend fun ingress(values: List<Output<DefaultSecurityGroupIngressArgs>>) {
        this.ingress = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("seubrnrbautdfrnq")
    public suspend fun revokeRulesOnDelete(`value`: Output<Boolean>) {
        this.revokeRulesOnDelete = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tbgxylaevwkgkgjo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    @JvmName("xenebdbwtbynrufa")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("oqaaxikdcxrenjsj")
    public suspend fun egress(`value`: List<DefaultSecurityGroupEgressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("cngedlmrkekypesr")
    public suspend fun egress(argument: List<suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("rfssvhiedsxmklwn")
    public suspend fun egress(vararg argument: suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("trvcglmacclgsxjh")
    public suspend fun egress(argument: suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("pqaeqcrpmpyyjbsj")
    public suspend fun egress(vararg values: DefaultSecurityGroupEgressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("rnhrfrglgxilqcdv")
    public suspend fun ingress(`value`: List<DefaultSecurityGroupIngressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("jeqmuwnhdtubfccb")
    public suspend fun ingress(argument: List<suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("sfjarmiylpafaune")
    public suspend fun ingress(vararg argument: suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("tiefcldwpxvnmdnn")
    public suspend fun ingress(argument: suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("afldcgateagqtety")
    public suspend fun ingress(vararg values: DefaultSecurityGroupIngressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param value
     */
    @JvmName("hbumewbqtmbvjmxj")
    public suspend fun revokeRulesOnDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revokeRulesOnDelete = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gykeafkwkgdyiiwm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ehkhfyeqgerooayr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    @JvmName("pgqbquxotsmtclmw")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DefaultSecurityGroupArgs = DefaultSecurityGroupArgs(
        egress = egress,
        ingress = ingress,
        revokeRulesOnDelete = revokeRulesOnDelete,
        tags = tags,
        vpcId = vpcId,
    )
}
