@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the [default AWS VPC](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html)
 * in the current AWS Region.
 * If you created your AWS account after 2013-12-04 you have a default VPC in each AWS Region.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultVpc` resource behaves differently from normal resources in that if a default VPC exists, this provider does not _create_ this resource, but instead "adopts" it into management.
 * If no default VPC exists, the provider creates a new default VPC, which leads to the implicit creation of [other resources](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#default-vpc-components).
 * By default, `pulumi destroy` does not delete the default VPC but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default VPC.
 * ## Example Usage
 * Basic usage with tags:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.ec2.DefaultVpc("default", {tags: {
 *     Name: "Default VPC",
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.ec2.DefaultVpc("default", tags={
 *     "Name": "Default VPC",
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Ec2.DefaultVpc("default", new()
 *     {
 *         Tags =
 *         {
 *             { "Name", "Default VPC" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewDefaultVpc(ctx, "default", &ec2.DefaultVpcArgs{
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Default VPC"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpc;
 * import com.pulumi.aws.ec2.DefaultVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpc("default", DefaultVpcArgs.builder()
 *             .tags(Map.of("Name", "Default VPC"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:ec2:DefaultVpc
 *     properties:
 *       tags:
 *         Name: Default VPC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Default VPCs using the VPC `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/defaultVpc:DefaultVpc default vpc-a01106c2
 * ```
 * @property assignGeneratedIpv6CidrBlock
 * @property enableDnsHostnames
 * @property enableDnsSupport
 * @property enableNetworkAddressUsageMetrics
 * @property forceDestroy Whether destroying the resource deletes the default VPC. Default: `false`
 * @property ipv6CidrBlock
 * @property ipv6CidrBlockNetworkBorderGroup
 * @property ipv6IpamPoolId
 * @property ipv6NetmaskLength
 * @property tags
 */
public data class DefaultVpcArgs(
    public val assignGeneratedIpv6CidrBlock: Output<Boolean>? = null,
    public val enableDnsHostnames: Output<Boolean>? = null,
    public val enableDnsSupport: Output<Boolean>? = null,
    public val enableNetworkAddressUsageMetrics: Output<Boolean>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6CidrBlockNetworkBorderGroup: Output<String>? = null,
    public val ipv6IpamPoolId: Output<String>? = null,
    public val ipv6NetmaskLength: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultVpcArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultVpcArgs =
        com.pulumi.aws.ec2.DefaultVpcArgs.builder()
            .assignGeneratedIpv6CidrBlock(assignGeneratedIpv6CidrBlock?.applyValue({ args0 -> args0 }))
            .enableDnsHostnames(enableDnsHostnames?.applyValue({ args0 -> args0 }))
            .enableDnsSupport(enableDnsSupport?.applyValue({ args0 -> args0 }))
            .enableNetworkAddressUsageMetrics(enableNetworkAddressUsageMetrics?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlockNetworkBorderGroup(ipv6CidrBlockNetworkBorderGroup?.applyValue({ args0 -> args0 }))
            .ipv6IpamPoolId(ipv6IpamPoolId?.applyValue({ args0 -> args0 }))
            .ipv6NetmaskLength(ipv6NetmaskLength?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DefaultVpcArgs].
 */
@PulumiTagMarker
public class DefaultVpcArgsBuilder internal constructor() {
    private var assignGeneratedIpv6CidrBlock: Output<Boolean>? = null

    private var enableDnsHostnames: Output<Boolean>? = null

    private var enableDnsSupport: Output<Boolean>? = null

    private var enableNetworkAddressUsageMetrics: Output<Boolean>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6CidrBlockNetworkBorderGroup: Output<String>? = null

    private var ipv6IpamPoolId: Output<String>? = null

    private var ipv6NetmaskLength: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("imkoiehgussspwbm")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Output<Boolean>) {
        this.assignGeneratedIpv6CidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("appoulxdmdefnorq")
    public suspend fun enableDnsHostnames(`value`: Output<Boolean>) {
        this.enableDnsHostnames = value
    }

    /**
     * @param value
     */
    @JvmName("odgxcjqllkponkjb")
    public suspend fun enableDnsSupport(`value`: Output<Boolean>) {
        this.enableDnsSupport = value
    }

    /**
     * @param value
     */
    @JvmName("wtfhkeoxwookoooq")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Output<Boolean>) {
        this.enableNetworkAddressUsageMetrics = value
    }

    /**
     * @param value Whether destroying the resource deletes the default VPC. Default: `false`
     */
    @JvmName("lgclspkfttnwgfqq")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value
     */
    @JvmName("dhswklxikxsbvmvg")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("dlhtheuhijtccudp")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: Output<String>) {
        this.ipv6CidrBlockNetworkBorderGroup = value
    }

    /**
     * @param value
     */
    @JvmName("xmnkkxwrdbfpgasj")
    public suspend fun ipv6IpamPoolId(`value`: Output<String>) {
        this.ipv6IpamPoolId = value
    }

    /**
     * @param value
     */
    @JvmName("cclypianycotsxov")
    public suspend fun ipv6NetmaskLength(`value`: Output<Int>) {
        this.ipv6NetmaskLength = value
    }

    /**
     * @param value
     */
    @JvmName("lhcyeencacxqvbwn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("oimtypbsobeipsww")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignGeneratedIpv6CidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("qoxmvjpdyblpdcxb")
    public suspend fun enableDnsHostnames(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsHostnames = mapped
    }

    /**
     * @param value
     */
    @JvmName("jahakwrecjdervtq")
    public suspend fun enableDnsSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsSupport = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmppubaiktqhcwrr")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkAddressUsageMetrics = mapped
    }

    /**
     * @param value Whether destroying the resource deletes the default VPC. Default: `false`
     */
    @JvmName("ejsvqtdujmfaiixf")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value
     */
    @JvmName("hegnlhssohctomlj")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("dhdbngqbpgejjmfx")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlockNetworkBorderGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("lhoytfgkgagexqhg")
    public suspend fun ipv6IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6IpamPoolId = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwjawuqujwswabnp")
    public suspend fun ipv6NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NetmaskLength = mapped
    }

    /**
     * @param value
     */
    @JvmName("gvaikylnqjqwfkxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("endeieaxrgjwoyqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DefaultVpcArgs = DefaultVpcArgs(
        assignGeneratedIpv6CidrBlock = assignGeneratedIpv6CidrBlock,
        enableDnsHostnames = enableDnsHostnames,
        enableDnsSupport = enableDnsSupport,
        enableNetworkAddressUsageMetrics = enableNetworkAddressUsageMetrics,
        forceDestroy = forceDestroy,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup,
        ipv6IpamPoolId = ipv6IpamPoolId,
        ipv6NetmaskLength = ipv6NetmaskLength,
        tags = tags,
    )
}
