@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.Ec2Functions.getAmiIdsPlain
import com.pulumi.aws.ec2.Ec2Functions.getAmiPlain
import com.pulumi.aws.ec2.Ec2Functions.getCapacityBlockOfferingPlain
import com.pulumi.aws.ec2.Ec2Functions.getCoipPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getCoipPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getCustomerGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getDedicatedHostPlain
import com.pulumi.aws.ec2.Ec2Functions.getEipsPlain
import com.pulumi.aws.ec2.Ec2Functions.getElasticIpPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstancePlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypeOfferingPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypeOfferingsPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypePlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypesPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstancesPlain
import com.pulumi.aws.ec2.Ec2Functions.getInternetGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getIpamPreviewNextCidrPlain
import com.pulumi.aws.ec2.Ec2Functions.getKeyPairPlain
import com.pulumi.aws.ec2.Ec2Functions.getLaunchConfigurationPlain
import com.pulumi.aws.ec2.Ec2Functions.getLaunchTemplatePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayRouteTablePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfaceGroupPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfaceGroupsPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfacePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewaysPlain
import com.pulumi.aws.ec2.Ec2Functions.getManagedPrefixListPlain
import com.pulumi.aws.ec2.Ec2Functions.getManagedPrefixListsPlain
import com.pulumi.aws.ec2.Ec2Functions.getNatGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getNatGatewaysPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkAclsPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInsightsAnalysisPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInsightsPathPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInterfacePlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInterfacesPlain
import com.pulumi.aws.ec2.Ec2Functions.getPrefixListPlain
import com.pulumi.aws.ec2.Ec2Functions.getPublicIpv4PoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getPublicIpv4PoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getRoutePlain
import com.pulumi.aws.ec2.Ec2Functions.getRouteTablePlain
import com.pulumi.aws.ec2.Ec2Functions.getRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getSecurityGroupPlain
import com.pulumi.aws.ec2.Ec2Functions.getSecurityGroupsPlain
import com.pulumi.aws.ec2.Ec2Functions.getSerialConsoleAccessPlain
import com.pulumi.aws.ec2.Ec2Functions.getSpotPricePlain
import com.pulumi.aws.ec2.Ec2Functions.getSubnetPlain
import com.pulumi.aws.ec2.Ec2Functions.getSubnetsPlain
import com.pulumi.aws.ec2.Ec2Functions.getTransitGatewayRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcDhcpOptionsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcEndpointPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcEndpointServicePlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolCidrsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolCidrsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPeeringConnectionPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPeeringConnectionsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpnGatewayPlain
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCapacityBlockOfferingPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCapacityBlockOfferingPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetIpamPreviewNextCidrPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetIpamPreviewNextCidrPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchConfigurationPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchConfigurationPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplateFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplatePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplatePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTableFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfacePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfacePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfaceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRoutePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRoutePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTableFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPriceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPricePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPricePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServiceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServicePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServicePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiIdsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCapacityBlockOfferingResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCustomerGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetDedicatedHostResult
import com.pulumi.aws.ec2.kotlin.outputs.GetEipsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetElasticIpResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetIpamPreviewNextCidrResult
import com.pulumi.aws.ec2.kotlin.outputs.GetKeyPairResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTableResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewaysResult
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListResult
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewaysResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkAclsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsPathResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfaceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfacesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPrefixListResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSerialConsoleAccessResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSpotPriceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetTransitGatewayRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcDhcpOptionsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointServiceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpnGatewayResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiIdsResult.Companion.toKotlin as getAmiIdsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiResult.Companion.toKotlin as getAmiResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCapacityBlockOfferingResult.Companion.toKotlin as getCapacityBlockOfferingResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolResult.Companion.toKotlin as getCoipPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolsResult.Companion.toKotlin as getCoipPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCustomerGatewayResult.Companion.toKotlin as getCustomerGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetDedicatedHostResult.Companion.toKotlin as getDedicatedHostResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetEipsResult.Companion.toKotlin as getEipsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetElasticIpResult.Companion.toKotlin as getElasticIpResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingResult.Companion.toKotlin as getInstanceTypeOfferingResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingsResult.Companion.toKotlin as getInstanceTypeOfferingsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeResult.Companion.toKotlin as getInstanceTypeResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypesResult.Companion.toKotlin as getInstanceTypesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayResult.Companion.toKotlin as getInternetGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetIpamPreviewNextCidrResult.Companion.toKotlin as getIpamPreviewNextCidrResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetKeyPairResult.Companion.toKotlin as getKeyPairResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationResult.Companion.toKotlin as getLaunchConfigurationResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateResult.Companion.toKotlin as getLaunchTemplateResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayResult.Companion.toKotlin as getLocalGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTableResult.Companion.toKotlin as getLocalGatewayRouteTableResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTablesResult.Companion.toKotlin as getLocalGatewayRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceGroupResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupsResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceGroupsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewaysResult.Companion.toKotlin as getLocalGatewaysResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListResult.Companion.toKotlin as getManagedPrefixListResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListsResult.Companion.toKotlin as getManagedPrefixListsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewayResult.Companion.toKotlin as getNatGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewaysResult.Companion.toKotlin as getNatGatewaysResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkAclsResult.Companion.toKotlin as getNetworkAclsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisResult.Companion.toKotlin as getNetworkInsightsAnalysisResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsPathResult.Companion.toKotlin as getNetworkInsightsPathResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfaceResult.Companion.toKotlin as getNetworkInterfaceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfacesResult.Companion.toKotlin as getNetworkInterfacesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPrefixListResult.Companion.toKotlin as getPrefixListResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolResult.Companion.toKotlin as getPublicIpv4PoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolsResult.Companion.toKotlin as getPublicIpv4PoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteResult.Companion.toKotlin as getRouteResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableResult.Companion.toKotlin as getRouteTableResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTablesResult.Companion.toKotlin as getRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupResult.Companion.toKotlin as getSecurityGroupResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupsResult.Companion.toKotlin as getSecurityGroupsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSerialConsoleAccessResult.Companion.toKotlin as getSerialConsoleAccessResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSpotPriceResult.Companion.toKotlin as getSpotPriceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetResult.Companion.toKotlin as getSubnetResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetsResult.Companion.toKotlin as getSubnetsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetTransitGatewayRouteTablesResult.Companion.toKotlin as getTransitGatewayRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcDhcpOptionsResult.Companion.toKotlin as getVpcDhcpOptionsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointResult.Companion.toKotlin as getVpcEndpointResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointServiceResult.Companion.toKotlin as getVpcEndpointServiceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsResult.Companion.toKotlin as getVpcIamPoolCidrsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolResult.Companion.toKotlin as getVpcIamPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsResult.Companion.toKotlin as getVpcIamPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsResult.Companion.toKotlin as getVpcIpamPoolCidrsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolResult.Companion.toKotlin as getVpcIpamPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsResult.Companion.toKotlin as getVpcIpamPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionResult.Companion.toKotlin as getVpcPeeringConnectionResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionsResult.Companion.toKotlin as getVpcPeeringConnectionsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcResult.Companion.toKotlin as getVpcResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcsResult.Companion.toKotlin as getVpcsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpnGatewayResult.Companion.toKotlin as getVpnGatewayResultToKotlin

public object Ec2Functions {
    /**
     * Use this data source to get the ID of a registered AMI for use in other
     * resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getAmi({
     *     executableUsers: ["self"],
     *     mostRecent: true,
     *     nameRegex: "^myami-\\d{3}",
     *     owners: ["self"],
     *     filters: [
     *         {
     *             name: "name",
     *             values: ["myami-*"],
     *         },
     *         {
     *             name: "root-device-type",
     *             values: ["ebs"],
     *         },
     *         {
     *             name: "virtualization-type",
     *             values: ["hvm"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_ami(executable_users=["self"],
     *     most_recent=True,
     *     name_regex="^myami-\\d{3}",
     *     owners=["self"],
     *     filters=[
     *         {
     *             "name": "name",
     *             "values": ["myami-*"],
     *         },
     *         {
     *             "name": "root-device-type",
     *             "values": ["ebs"],
     *         },
     *         {
     *             "name": "virtualization-type",
     *             "values": ["hvm"],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetAmi.Invoke(new()
     *     {
     *         ExecutableUsers = new[]
     *         {
     *             "self",
     *         },
     *         MostRecent = true,
     *         NameRegex = "^myami-\\d{3}",
     *         Owners = new[]
     *         {
     *             "self",
     *         },
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
     *             {
     *                 Name = "name",
     *                 Values = new[]
     *                 {
     *                     "myami-*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
     *             {
     *                 Name = "root-device-type",
     *                 Values = new[]
     *                 {
     *                     "ebs",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
     *             {
     *                 Name = "virtualization-type",
     *                 Values = new[]
     *                 {
     *                     "hvm",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupAmi(ctx, &ec2.LookupAmiArgs{
     * 			ExecutableUsers: []string{
     * 				"self",
     * 			},
     * 			MostRecent: pulumi.BoolRef(true),
     * 			NameRegex:  pulumi.StringRef("^myami-\\d{3}"),
     * 			Owners: []string{
     * 				"self",
     * 			},
     * 			Filters: []ec2.GetAmiFilter{
     * 				{
     * 					Name: "name",
     * 					Values: []string{
     * 						"myami-*",
     * 					},
     * 				},
     * 				{
     * 					Name: "root-device-type",
     * 					Values: []string{
     * 						"ebs",
     * 					},
     * 				},
     * 				{
     * 					Name: "virtualization-type",
     * 					Values: []string{
     * 						"hvm",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getAmi(GetAmiArgs.builder()
     *             .executableUsers("self")
     *             .mostRecent(true)
     *             .nameRegex("^myami-\\d{3}")
     *             .owners("self")
     *             .filters(
     *                 GetAmiFilterArgs.builder()
     *                     .name("name")
     *                     .values("myami-*")
     *                     .build(),
     *                 GetAmiFilterArgs.builder()
     *                     .name("root-device-type")
     *                     .values("ebs")
     *                     .build(),
     *                 GetAmiFilterArgs.builder()
     *                     .name("virtualization-type")
     *                     .values("hvm")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getAmi
     *       Arguments:
     *         executableUsers:
     *           - self
     *         mostRecent: true
     *         nameRegex: ^myami-\d{3}
     *         owners:
     *           - self
     *         filters:
     *           - name: name
     *             values:
     *               - myami-*
     *           - name: root-device-type
     *             values:
     *               - ebs
     *           - name: virtualization-type
     *             values:
     *               - hvm
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAmi.
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(argument: GetAmiPlainArgs): GetAmiResult =
        getAmiResultToKotlin(getAmiPlain(argument.toJava()).await())

    /**
     * @see [getAmi].
     * @param executableUsers Limit search to users with *explicit* launch permission on
     * the image. Valid items are the numeric account ID or `self`.
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     * @param includeDeprecated If true, all deprecated AMIs are included in the response. If false, no deprecated AMIs are included in the response. If no value is specified, the default value is false.
     * @param mostRecent If more than one result is returned, use the most
     * recent AMI.
     * @param nameRegex Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API. This
     * filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     * > **NOTE:** If more or less than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single AMI ID only, or use `most_recent` to choose the most recent one. If
     * you want to match multiple AMIs, use the `aws.ec2.getAmiIds` data source instead.
     * @param owners List of AMI owners to limit search. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     * @param tags Any tags assigned to the image.
     * * `tags.#.key` - Key name of the tag.
     * * `tags.#.value` - Value of the tag.
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(
        executableUsers: List<String>? = null,
        filters: List<GetAmiFilter>? = null,
        includeDeprecated: Boolean? = null,
        mostRecent: Boolean? = null,
        nameRegex: String? = null,
        owners: List<String>? = null,
        tags: Map<String, String>? = null,
    ): GetAmiResult {
        val argument = GetAmiPlainArgs(
            executableUsers = executableUsers,
            filters = filters,
            includeDeprecated = includeDeprecated,
            mostRecent = mostRecent,
            nameRegex = nameRegex,
            owners = owners,
            tags = tags,
        )
        return getAmiResultToKotlin(getAmiPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmi].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetAmiPlainArgs].
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(argument: suspend GetAmiPlainArgsBuilder.() -> Unit): GetAmiResult {
        val builder = GetAmiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmiResultToKotlin(getAmiPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of AMI IDs matching the specified criteria.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ubuntu = aws.ec2.getAmiIds({
     *     owners: ["099720109477"],
     *     filters: [{
     *         name: "name",
     *         values: ["ubuntu/images/ubuntu-*-*-amd64-server-*"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ubuntu = aws.ec2.get_ami_ids(owners=["099720109477"],
     *     filters=[{
     *         "name": "name",
     *         "values": ["ubuntu/images/ubuntu-*-*-amd64-server-*"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ubuntu = Aws.Ec2.GetAmiIds.Invoke(new()
     *     {
     *         Owners = new[]
     *         {
     *             "099720109477",
     *         },
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetAmiIdsFilterInputArgs
     *             {
     *                 Name = "name",
     *                 Values = new[]
     *                 {
     *                     "ubuntu/images/ubuntu-*-*-amd64-server-*",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetAmiIds(ctx, &ec2.GetAmiIdsArgs{
     * 			Owners: []string{
     * 				"099720109477",
     * 			},
     * 			Filters: []ec2.GetAmiIdsFilter{
     * 				{
     * 					Name: "name",
     * 					Values: []string{
     * 						"ubuntu/images/ubuntu-*-*-amd64-server-*",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetAmiIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ubuntu = Ec2Functions.getAmiIds(GetAmiIdsArgs.builder()
     *             .owners("099720109477")
     *             .filters(GetAmiIdsFilterArgs.builder()
     *                 .name("name")
     *                 .values("ubuntu/images/ubuntu-*-*-amd64-server-*")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ubuntu:
     *     fn::invoke:
     *       Function: aws:ec2:getAmiIds
     *       Arguments:
     *         owners:
     *           - '099720109477'
     *         filters:
     *           - name: name
     *             values:
     *               - ubuntu/images/ubuntu-*-*-amd64-server-*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAmiIds.
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: GetAmiIdsPlainArgs): GetAmiIdsResult =
        getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())

    /**
     * @see [getAmiIds].
     * @param executableUsers Limit search to users with *explicit* launch
     * permission on  the image. Valid items are the numeric account ID or `self`.
     * @param filters One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     * @param includeDeprecated If true, all deprecated AMIs are included in the response.
     * If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
     * @param nameRegex Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API.
     * This filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     * @param owners List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     * @param sortAscending Used to sort AMIs by creation time.
     * If no value is specified, the default value is `false`.
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(
        executableUsers: List<String>? = null,
        filters: List<GetAmiIdsFilter>? = null,
        includeDeprecated: Boolean? = null,
        nameRegex: String? = null,
        owners: List<String>,
        sortAscending: Boolean? = null,
    ): GetAmiIdsResult {
        val argument = GetAmiIdsPlainArgs(
            executableUsers = executableUsers,
            filters = filters,
            includeDeprecated = includeDeprecated,
            nameRegex = nameRegex,
            owners = owners,
            sortAscending = sortAscending,
        )
        return getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmiIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetAmiIdsPlainArgs].
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: suspend GetAmiIdsPlainArgsBuilder.() -> Unit): GetAmiIdsResult {
        val builder = GetAmiIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmiIdsResultToKotlin(getAmiIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about a single EC2 Capacity Block Offering.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getCapacityBlockOffering({
     *     capacityDurationHours: 24,
     *     endDateRange: "2024-05-30T15:04:05Z",
     *     instanceCount: 1,
     *     instanceType: "p4d.24xlarge",
     *     startDateRange: "2024-04-28T15:04:05Z",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_capacity_block_offering(capacity_duration_hours=24,
     *     end_date_range="2024-05-30T15:04:05Z",
     *     instance_count=1,
     *     instance_type="p4d.24xlarge",
     *     start_date_range="2024-04-28T15:04:05Z")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetCapacityBlockOffering.Invoke(new()
     *     {
     *         CapacityDurationHours = 24,
     *         EndDateRange = "2024-05-30T15:04:05Z",
     *         InstanceCount = 1,
     *         InstanceType = "p4d.24xlarge",
     *         StartDateRange = "2024-04-28T15:04:05Z",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetCapacityBlockOffering(ctx, &ec2.GetCapacityBlockOfferingArgs{
     * 			CapacityDurationHours: 24,
     * 			EndDateRange:          pulumi.StringRef("2024-05-30T15:04:05Z"),
     * 			InstanceCount:         1,
     * 			InstanceType:          "p4d.24xlarge",
     * 			StartDateRange:        pulumi.StringRef("2024-04-28T15:04:05Z"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetCapacityBlockOfferingArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getCapacityBlockOffering(GetCapacityBlockOfferingArgs.builder()
     *             .capacityDurationHours(24)
     *             .endDateRange("2024-05-30T15:04:05Z")
     *             .instanceCount(1)
     *             .instanceType("p4d.24xlarge")
     *             .startDateRange("2024-04-28T15:04:05Z")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getCapacityBlockOffering
     *       Arguments:
     *         capacityDurationHours: 24
     *         endDateRange: 2024-05-30T15:04:05Z
     *         instanceCount: 1
     *         instanceType: p4d.24xlarge
     *         startDateRange: 2024-04-28T15:04:05Z
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCapacityBlockOffering.
     * @return A collection of values returned by getCapacityBlockOffering.
     */
    public suspend fun getCapacityBlockOffering(argument: GetCapacityBlockOfferingPlainArgs): GetCapacityBlockOfferingResult =
        getCapacityBlockOfferingResultToKotlin(getCapacityBlockOfferingPlain(argument.toJava()).await())

    /**
     * @see [getCapacityBlockOffering].
     * @param capacityDurationHours The amount of time of the Capacity Block reservation in hours.
     * @param endDateRange The date and time at which the Capacity Block Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     * @param instanceCount The number of instances for which to reserve capacity.
     * @param instanceType The instance type for which to reserve capacity.
     * @param startDateRange The date and time at which the Capacity Block Reservation starts. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     * @return A collection of values returned by getCapacityBlockOffering.
     */
    public suspend fun getCapacityBlockOffering(
        capacityDurationHours: Int,
        endDateRange: String? = null,
        instanceCount: Int,
        instanceType: String,
        startDateRange: String? = null,
    ): GetCapacityBlockOfferingResult {
        val argument = GetCapacityBlockOfferingPlainArgs(
            capacityDurationHours = capacityDurationHours,
            endDateRange = endDateRange,
            instanceCount = instanceCount,
            instanceType = instanceType,
            startDateRange = startDateRange,
        )
        return getCapacityBlockOfferingResultToKotlin(getCapacityBlockOfferingPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityBlockOffering].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCapacityBlockOfferingPlainArgs].
     * @return A collection of values returned by getCapacityBlockOffering.
     */
    public suspend fun getCapacityBlockOffering(argument: suspend GetCapacityBlockOfferingPlainArgsBuilder.() -> Unit): GetCapacityBlockOfferingResult {
        val builder = GetCapacityBlockOfferingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityBlockOfferingResultToKotlin(getCapacityBlockOfferingPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific EC2 Customer-Owned IP Pool.
     * This data source can prove useful when a module accepts a coip pool id as
     * an input variable and needs to, for example, determine the CIDR block of that
     * COIP Pool.
     * ## Example Usage
     * The following example returns a specific coip pool ID
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetCoipPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var coipPoolId = config.get("coipPoolId");
     *         final var selected = Ec2Functions.getCoipPool(GetCoipPoolArgs.builder()
     *             .id(coipPoolId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   coipPoolId:
     *     type: dynamic
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getCoipPool
     *       Arguments:
     *         id: ${coipPoolId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCoipPool.
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(argument: GetCoipPoolPlainArgs): GetCoipPoolResult =
        getCoipPoolResultToKotlin(getCoipPoolPlain(argument.toJava()).await())

    /**
     * @see [getCoipPool].
     * @param filters
     * @param localGatewayRouteTableId Local Gateway Route Table Id assigned to desired COIP Pool
     * @param poolId ID of the specific COIP Pool to retrieve.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired COIP Pool.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(
        filters: List<GetCoipPoolFilter>? = null,
        localGatewayRouteTableId: String? = null,
        poolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetCoipPoolResult {
        val argument = GetCoipPoolPlainArgs(
            filters = filters,
            localGatewayRouteTableId = localGatewayRouteTableId,
            poolId = poolId,
            tags = tags,
        )
        return getCoipPoolResultToKotlin(getCoipPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoipPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCoipPoolPlainArgs].
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(argument: suspend GetCoipPoolPlainArgsBuilder.() -> Unit): GetCoipPoolResult {
        val builder = GetCoipPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoipPoolResultToKotlin(getCoipPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Customer-Owned IP Pools, such as their identifiers.
     * @param argument A collection of arguments for invoking getCoipPools.
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(argument: GetCoipPoolsPlainArgs): GetCoipPoolsResult =
        getCoipPoolsResultToKotlin(getCoipPoolsPlain(argument.toJava()).await())

    /**
     * @see [getCoipPools].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired aws_ec2_coip_pools.
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(
        filters: List<GetCoipPoolsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetCoipPoolsResult {
        val argument = GetCoipPoolsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getCoipPoolsResultToKotlin(getCoipPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoipPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCoipPoolsPlainArgs].
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(argument: suspend GetCoipPoolsPlainArgsBuilder.() -> Unit): GetCoipPoolsResult {
        val builder = GetCoipPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoipPoolsResultToKotlin(getCoipPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an existing AWS Customer Gateway.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.ec2.getCustomerGateway({
     *     filters: [{
     *         name: "tag:Name",
     *         values: ["foo-prod"],
     *     }],
     * });
     * const main = new aws.ec2.VpnGateway("main", {
     *     vpcId: mainAwsVpc.id,
     *     amazonSideAsn: "7224",
     * });
     * const transit = new aws.ec2.VpnConnection("transit", {
     *     vpnGatewayId: main.id,
     *     customerGatewayId: foo.then(foo => foo.id),
     *     type: foo.then(foo => foo.type),
     *     staticRoutesOnly: false,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_customer_gateway(filters=[{
     *     "name": "tag:Name",
     *     "values": ["foo-prod"],
     * }])
     * main = aws.ec2.VpnGateway("main",
     *     vpc_id=main_aws_vpc["id"],
     *     amazon_side_asn="7224")
     * transit = aws.ec2.VpnConnection("transit",
     *     vpn_gateway_id=main.id,
     *     customer_gateway_id=foo.id,
     *     type=foo.type,
     *     static_routes_only=False)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ec2.GetCustomerGateway.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetCustomerGatewayFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "foo-prod",
     *                 },
     *             },
     *         },
     *     });
     *     var main = new Aws.Ec2.VpnGateway("main", new()
     *     {
     *         VpcId = mainAwsVpc.Id,
     *         AmazonSideAsn = "7224",
     *     });
     *     var transit = new Aws.Ec2.VpnConnection("transit", new()
     *     {
     *         VpnGatewayId = main.Id,
     *         CustomerGatewayId = foo.Apply(getCustomerGatewayResult => getCustomerGatewayResult.Id),
     *         Type = foo.Apply(getCustomerGatewayResult => getCustomerGatewayResult.Type),
     *         StaticRoutesOnly = false,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := ec2.LookupCustomerGateway(ctx, &ec2.LookupCustomerGatewayArgs{
     * 			Filters: []ec2.GetCustomerGatewayFilter{
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"foo-prod",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		main, err := ec2.NewVpnGateway(ctx, "main", &ec2.VpnGatewayArgs{
     * 			VpcId:         pulumi.Any(mainAwsVpc.Id),
     * 			AmazonSideAsn: pulumi.String("7224"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewVpnConnection(ctx, "transit", &ec2.VpnConnectionArgs{
     * 			VpnGatewayId:      main.ID(),
     * 			CustomerGatewayId: pulumi.String(foo.Id),
     * 			Type:              pulumi.String(foo.Type),
     * 			StaticRoutesOnly:  pulumi.Bool(false),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetCustomerGatewayArgs;
     * import com.pulumi.aws.ec2.VpnGateway;
     * import com.pulumi.aws.ec2.VpnGatewayArgs;
     * import com.pulumi.aws.ec2.VpnConnection;
     * import com.pulumi.aws.ec2.VpnConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getCustomerGateway(GetCustomerGatewayArgs.builder()
     *             .filters(GetCustomerGatewayFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("foo-prod")
     *                 .build())
     *             .build());
     *         var main = new VpnGateway("main", VpnGatewayArgs.builder()
     *             .vpcId(mainAwsVpc.id())
     *             .amazonSideAsn(7224)
     *             .build());
     *         var transit = new VpnConnection("transit", VpnConnectionArgs.builder()
     *             .vpnGatewayId(main.id())
     *             .customerGatewayId(foo.applyValue(getCustomerGatewayResult -> getCustomerGatewayResult.id()))
     *             .type(foo.applyValue(getCustomerGatewayResult -> getCustomerGatewayResult.type()))
     *             .staticRoutesOnly(false)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   main:
     *     type: aws:ec2:VpnGateway
     *     properties:
     *       vpcId: ${mainAwsVpc.id}
     *       amazonSideAsn: 7224
     *   transit:
     *     type: aws:ec2:VpnConnection
     *     properties:
     *       vpnGatewayId: ${main.id}
     *       customerGatewayId: ${foo.id}
     *       type: ${foo.type}
     *       staticRoutesOnly: false
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ec2:getCustomerGateway
     *       Arguments:
     *         filters:
     *           - name: tag:Name
     *             values:
     *               - foo-prod
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCustomerGateway.
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend fun getCustomerGateway(argument: GetCustomerGatewayPlainArgs): GetCustomerGatewayResult =
        getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(argument.toJava()).await())

    /**
     * @see [getCustomerGateway].
     * @param filters One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     * @param id ID of the gateway.
     * @param tags Map of key-value pairs assigned to the gateway.
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend fun getCustomerGateway(
        filters: List<GetCustomerGatewayFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetCustomerGatewayResult {
        val argument = GetCustomerGatewayPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomerGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCustomerGatewayPlainArgs].
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend fun getCustomerGateway(argument: suspend GetCustomerGatewayPlainArgsBuilder.() -> Unit): GetCustomerGatewayResult {
        val builder = GetCustomerGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an EC2 Dedicated Host.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const testDedicatedHost = new aws.ec2.DedicatedHost("test", {
     *     instanceType: "c5.18xlarge",
     *     availabilityZone: "us-west-2a",
     * });
     * const test = aws.ec2.getDedicatedHostOutput({
     *     hostId: testDedicatedHost.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test_dedicated_host = aws.ec2.DedicatedHost("test",
     *     instance_type="c5.18xlarge",
     *     availability_zone="us-west-2a")
     * test = aws.ec2.get_dedicated_host_output(host_id=test_dedicated_host.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var testDedicatedHost = new Aws.Ec2.DedicatedHost("test", new()
     *     {
     *         InstanceType = "c5.18xlarge",
     *         AvailabilityZone = "us-west-2a",
     *     });
     *     var test = Aws.Ec2.GetDedicatedHost.Invoke(new()
     *     {
     *         HostId = testDedicatedHost.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		testDedicatedHost, err := ec2.NewDedicatedHost(ctx, "test", &ec2.DedicatedHostArgs{
     * 			InstanceType:     pulumi.String("c5.18xlarge"),
     * 			AvailabilityZone: pulumi.String("us-west-2a"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = ec2.LookupDedicatedHostOutput(ctx, ec2.GetDedicatedHostOutputArgs{
     * 			HostId: testDedicatedHost.ID(),
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.DedicatedHost;
     * import com.pulumi.aws.ec2.DedicatedHostArgs;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetDedicatedHostArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var testDedicatedHost = new DedicatedHost("testDedicatedHost", DedicatedHostArgs.builder()
     *             .instanceType("c5.18xlarge")
     *             .availabilityZone("us-west-2a")
     *             .build());
     *         final var test = Ec2Functions.getDedicatedHost(GetDedicatedHostArgs.builder()
     *             .hostId(testDedicatedHost.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testDedicatedHost:
     *     type: aws:ec2:DedicatedHost
     *     name: test
     *     properties:
     *       instanceType: c5.18xlarge
     *       availabilityZone: us-west-2a
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getDedicatedHost
     *       Arguments:
     *         hostId: ${testDedicatedHost.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter Example
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getDedicatedHost({
     *     filters: [{
     *         name: "instance-type",
     *         values: ["c5&#46;18xlarge"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_dedicated_host(filters=[{
     *     "name": "instance-type",
     *     "values": ["c5&#46;18xlarge"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetDedicatedHost.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetDedicatedHostFilterInputArgs
     *             {
     *                 Name = "instance-type",
     *                 Values = new[]
     *                 {
     *                     "c5.18xlarge",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupDedicatedHost(ctx, &ec2.LookupDedicatedHostArgs{
     * 			Filters: []ec2.GetDedicatedHostFilter{
     * 				{
     * 					Name: "instance-type",
     * 					Values: []string{
     * 						"c5.18xlarge",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetDedicatedHostArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getDedicatedHost(GetDedicatedHostArgs.builder()
     *             .filters(GetDedicatedHostFilterArgs.builder()
     *                 .name("instance-type")
     *                 .values("c5.18xlarge")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getDedicatedHost
     *       Arguments:
     *         filters:
     *           - name: instance-type
     *             values:
     *               - c5.18xlarge
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedHost.
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend fun getDedicatedHost(argument: GetDedicatedHostPlainArgs): GetDedicatedHostResult =
        getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHost].
     * @param filters Configuration block. Detailed below.
     * @param hostId ID of the Dedicated Host.
     * @param tags
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend fun getDedicatedHost(
        filters: List<GetDedicatedHostFilter>? = null,
        hostId: String? = null,
        tags: Map<String, String>? = null,
    ): GetDedicatedHostResult {
        val argument = GetDedicatedHostPlainArgs(
            filters = filters,
            hostId = hostId,
            tags = tags,
        )
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHost].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetDedicatedHostPlainArgs].
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend fun getDedicatedHost(argument: suspend GetDedicatedHostPlainArgsBuilder.() -> Unit): GetDedicatedHostResult {
        val builder = GetDedicatedHostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a list of Elastic IPs in a region.
     * ## Example Usage
     * The following shows outputting all Elastic IPs with the a specific tag value.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getEips({
     *     tags: {
     *         Env: "dev",
     *     },
     * });
     * export const allocationIds = example.then(example => example.allocationIds);
     * export const publicIps = example.then(example => example.publicIps);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_eips(tags={
     *     "Env": "dev",
     * })
     * pulumi.export("allocationIds", example.allocation_ids)
     * pulumi.export("publicIps", example.public_ips)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetEips.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Env", "dev" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["allocationIds"] = example.Apply(getEipsResult => getEipsResult.AllocationIds),
     *         ["publicIps"] = example.Apply(getEipsResult => getEipsResult.PublicIps),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.GetEips(ctx, &ec2.GetEipsArgs{
     * 			Tags: map[string]interface{}{
     * 				"Env": "dev",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("allocationIds", example.AllocationIds)
     * 		ctx.Export("publicIps", example.PublicIps)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetEipsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getEips(GetEipsArgs.builder()
     *             .tags(Map.of("Env", "dev"))
     *             .build());
     *         ctx.export("allocationIds", example.applyValue(getEipsResult -> getEipsResult.allocationIds()));
     *         ctx.export("publicIps", example.applyValue(getEipsResult -> getEipsResult.publicIps()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getEips
     *       Arguments:
     *         tags:
     *           Env: dev
     * outputs:
     *   # VPC EIPs.
     *   allocationIds: ${example.allocationIds}
     *   # EC2-Classic EIPs.
     *   publicIps: ${example.publicIps}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEips.
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(argument: GetEipsPlainArgs): GetEipsResult =
        getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())

    /**
     * @see [getEips].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(
        filters: List<GetEipsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetEipsResult {
        val argument = GetEipsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEips].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetEipsPlainArgs].
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(argument: suspend GetEipsPlainArgsBuilder.() -> Unit): GetEipsResult {
        val builder = GetEipsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEipsResultToKotlin(getEipsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Eip` provides details about a specific Elastic IP.
     * ## Example Usage
     * ### Search By Allocation ID (VPC only)
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const byAllocationId = aws.ec2.getElasticIp({
     *     id: "eipalloc-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_allocation_id = aws.ec2.get_elastic_ip(id="eipalloc-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var byAllocationId = Aws.Ec2.GetElasticIp.Invoke(new()
     *     {
     *         Id = "eipalloc-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetElasticIp(ctx, &ec2.GetElasticIpArgs{
     * 			Id: pulumi.StringRef("eipalloc-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byAllocationId = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .id("eipalloc-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   byAllocationId:
     *     fn::invoke:
     *       Function: aws:ec2:getElasticIp
     *       Arguments:
     *         id: eipalloc-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Search By Filters (EC2-Classic or VPC)
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const byFilter = aws.ec2.getElasticIp({
     *     filters: [{
     *         name: "tag:Name",
     *         values: ["exampleNameTagValue"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_filter = aws.ec2.get_elastic_ip(filters=[{
     *     "name": "tag:Name",
     *     "values": ["exampleNameTagValue"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var byFilter = Aws.Ec2.GetElasticIp.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetElasticIpFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "exampleNameTagValue",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetElasticIp(ctx, &ec2.GetElasticIpArgs{
     * 			Filters: []ec2.GetElasticIpFilter{
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"exampleNameTagValue",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byFilter = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .filters(GetElasticIpFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("exampleNameTagValue")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   byFilter:
     *     fn::invoke:
     *       Function: aws:ec2:getElasticIp
     *       Arguments:
     *         filters:
     *           - name: tag:Name
     *             values:
     *               - exampleNameTagValue
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Search By Public IP (EC2-Classic or VPC)
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const byPublicIp = aws.ec2.getElasticIp({
     *     publicIp: "1.2.3.4",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_public_ip = aws.ec2.get_elastic_ip(public_ip="1.2.3.4")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var byPublicIp = Aws.Ec2.GetElasticIp.Invoke(new()
     *     {
     *         PublicIp = "1.2.3.4",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetElasticIp(ctx, &ec2.GetElasticIpArgs{
     * 			PublicIp: pulumi.StringRef("1.2.3.4"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byPublicIp = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .publicIp("1.2.3.4")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   byPublicIp:
     *     fn::invoke:
     *       Function: aws:ec2:getElasticIp
     *       Arguments:
     *         publicIp: 1.2.3.4
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Search By Tags (EC2-Classic or VPC)
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const byTags = aws.ec2.getElasticIp({
     *     tags: {
     *         Name: "exampleNameTagValue",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_tags = aws.ec2.get_elastic_ip(tags={
     *     "Name": "exampleNameTagValue",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var byTags = Aws.Ec2.GetElasticIp.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Name", "exampleNameTagValue" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetElasticIp(ctx, &ec2.GetElasticIpArgs{
     * 			Tags: map[string]interface{}{
     * 				"Name": "exampleNameTagValue",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byTags = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .tags(Map.of("Name", "exampleNameTagValue"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   byTags:
     *     fn::invoke:
     *       Function: aws:ec2:getElasticIp
     *       Arguments:
     *         tags:
     *           Name: exampleNameTagValue
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getElasticIp.
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(argument: GetElasticIpPlainArgs): GetElasticIpResult =
        getElasticIpResultToKotlin(getElasticIpPlain(argument.toJava()).await())

    /**
     * @see [getElasticIp].
     * @param filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     * @param id Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
     * @param publicIp Public IP of the specific EIP to retrieve.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IP
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(
        filters: List<GetElasticIpFilter>? = null,
        id: String? = null,
        publicIp: String? = null,
        tags: Map<String, String>? = null,
    ): GetElasticIpResult {
        val argument = GetElasticIpPlainArgs(
            filters = filters,
            id = id,
            publicIp = publicIp,
            tags = tags,
        )
        return getElasticIpResultToKotlin(getElasticIpPlain(argument.toJava()).await())
    }

    /**
     * @see [getElasticIp].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetElasticIpPlainArgs].
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(argument: suspend GetElasticIpPlainArgsBuilder.() -> Unit): GetElasticIpResult {
        val builder = GetElasticIpPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getElasticIpResultToKotlin(getElasticIpPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ID of an Amazon EC2 Instance for use in other resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.ec2.getInstance({
     *     instanceId: "i-instanceid",
     *     filters: [
     *         {
     *             name: "image-id",
     *             values: ["ami-xxxxxxxx"],
     *         },
     *         {
     *             name: "tag:Name",
     *             values: ["instance-name-tag"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_instance(instance_id="i-instanceid",
     *     filters=[
     *         {
     *             "name": "image-id",
     *             "values": ["ami-xxxxxxxx"],
     *         },
     *         {
     *             "name": "tag:Name",
     *             "values": ["instance-name-tag"],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ec2.GetInstance.Invoke(new()
     *     {
     *         InstanceId = "i-instanceid",
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInstanceFilterInputArgs
     *             {
     *                 Name = "image-id",
     *                 Values = new[]
     *                 {
     *                     "ami-xxxxxxxx",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetInstanceFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "instance-name-tag",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupInstance(ctx, &ec2.LookupInstanceArgs{
     * 			InstanceId: pulumi.StringRef("i-instanceid"),
     * 			Filters: []ec2.GetInstanceFilter{
     * 				{
     * 					Name: "image-id",
     * 					Values: []string{
     * 						"ami-xxxxxxxx",
     * 					},
     * 				},
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"instance-name-tag",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getInstance(GetInstanceArgs.builder()
     *             .instanceId("i-instanceid")
     *             .filters(
     *                 GetInstanceFilterArgs.builder()
     *                     .name("image-id")
     *                     .values("ami-xxxxxxxx")
     *                     .build(),
     *                 GetInstanceFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("instance-name-tag")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ec2:getInstance
     *       Arguments:
     *         instanceId: i-instanceid
     *         filters:
     *           - name: image-id
     *             values:
     *               - ami-xxxxxxxx
     *           - name: tag:Name
     *             values:
     *               - instance-name-tag
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     * @param getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * @param getUserData Retrieve Base64 encoded User Data contents into the `user_data_base64` attribute. A SHA-1 hash of the User Data contents will always be present in the `user_data` attribute. Defaults to `false`.
     * > **NOTE:** At least one of `filter`, `instance_tags`, or `instance_id` must be specified.
     * > **NOTE:** If anything other than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single Instance ID only.
     * @param instanceId Specify the exact Instance ID with which to populate the data source.
     * @param instanceTags Map of tags, each pair of which must
     * exactly match a pair on the desired Instance.
     * @param tags Map of tags assigned to the Instance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(
        filters: List<GetInstanceFilter>? = null,
        getPasswordData: Boolean? = null,
        getUserData: Boolean? = null,
        instanceId: String? = null,
        instanceTags: Map<String, String>? = null,
        tags: Map<String, String>? = null,
    ): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            filters = filters,
            getPasswordData = getPasswordData,
            getUserData = getUserData,
            instanceId = instanceId,
            instanceTags = instanceTags,
            tags = tags,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit): GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get characteristics for a single EC2 Instance Type.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getInstanceType({
     *     instanceType: "t2.micro",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_instance_type(instance_type="t2.micro")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetInstanceType.Invoke(new()
     *     {
     *         InstanceType = "t2.micro",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetInstanceType(ctx, &ec2.GetInstanceTypeArgs{
     * 			InstanceType: "t2.micro",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceType(GetInstanceTypeArgs.builder()
     *             .instanceType("t2.micro")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getInstanceType
     *       Arguments:
     *         instanceType: t2.micro
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceType.
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(argument: GetInstanceTypePlainArgs): GetInstanceTypeResult =
        getInstanceTypeResultToKotlin(getInstanceTypePlain(argument.toJava()).await())

    /**
     * @see [getInstanceType].
     * @param instanceType Instance
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(instanceType: String): GetInstanceTypeResult {
        val argument = GetInstanceTypePlainArgs(
            instanceType = instanceType,
        )
        return getInstanceTypeResultToKotlin(getInstanceTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceType].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypePlainArgs].
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(argument: suspend GetInstanceTypePlainArgsBuilder.() -> Unit): GetInstanceTypeResult {
        val builder = GetInstanceTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeResultToKotlin(getInstanceTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Information about single EC2 Instance Type Offering.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getInstanceTypeOffering({
     *     filters: [{
     *         name: "instance-type",
     *         values: [
     *             "t2.micro",
     *             "t3.micro",
     *         ],
     *     }],
     *     preferredInstanceTypes: [
     *         "t3.micro",
     *         "t2.micro",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_instance_type_offering(filters=[{
     *         "name": "instance-type",
     *         "values": [
     *             "t2.micro",
     *             "t3.micro",
     *         ],
     *     }],
     *     preferred_instance_types=[
     *         "t3.micro",
     *         "t2.micro",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetInstanceTypeOffering.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInstanceTypeOfferingFilterInputArgs
     *             {
     *                 Name = "instance-type",
     *                 Values = new[]
     *                 {
     *                     "t2.micro",
     *                     "t3.micro",
     *                 },
     *             },
     *         },
     *         PreferredInstanceTypes = new[]
     *         {
     *             "t3.micro",
     *             "t2.micro",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetInstanceTypeOffering(ctx, &ec2.GetInstanceTypeOfferingArgs{
     * 			Filters: []ec2.GetInstanceTypeOfferingFilter{
     * 				{
     * 					Name: "instance-type",
     * 					Values: []string{
     * 						"t2.micro",
     * 						"t3.micro",
     * 					},
     * 				},
     * 			},
     * 			PreferredInstanceTypes: []string{
     * 				"t3.micro",
     * 				"t2.micro",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceTypeOffering(GetInstanceTypeOfferingArgs.builder()
     *             .filters(GetInstanceTypeOfferingFilterArgs.builder()
     *                 .name("instance-type")
     *                 .values(
     *                     "t2.micro",
     *                     "t3.micro")
     *                 .build())
     *             .preferredInstanceTypes(
     *                 "t3.micro",
     *                 "t2.micro")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getInstanceTypeOffering
     *       Arguments:
     *         filters:
     *           - name: instance-type
     *             values:
     *               - t2.micro
     *               - t3.micro
     *         preferredInstanceTypes:
     *           - t3.micro
     *           - t2.micro
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypeOffering.
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend fun getInstanceTypeOffering(argument: GetInstanceTypeOfferingPlainArgs): GetInstanceTypeOfferingResult =
        getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOffering].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     * @param locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     * @param preferredInstanceTypes Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend fun getInstanceTypeOffering(
        filters: List<GetInstanceTypeOfferingFilter>? = null,
        locationType: String? = null,
        preferredInstanceTypes: List<String>? = null,
    ): GetInstanceTypeOfferingResult {
        val argument = GetInstanceTypeOfferingPlainArgs(
            filters = filters,
            locationType = locationType,
            preferredInstanceTypes = preferredInstanceTypes,
        )
        return getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOffering].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingPlainArgs].
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend fun getInstanceTypeOffering(argument: suspend GetInstanceTypeOfferingPlainArgsBuilder.() -> Unit): GetInstanceTypeOfferingResult {
        val builder = GetInstanceTypeOfferingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about EC2 Instance Type Offerings.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getInstanceTypeOfferings({
     *     filters: [
     *         {
     *             name: "instance-type",
     *             values: [
     *                 "t2.micro",
     *                 "t3.micro",
     *             ],
     *         },
     *         {
     *             name: "location",
     *             values: ["usw2-az4"],
     *         },
     *     ],
     *     locationType: "availability-zone-id",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_instance_type_offerings(filters=[
     *         {
     *             "name": "instance-type",
     *             "values": [
     *                 "t2.micro",
     *                 "t3.micro",
     *             ],
     *         },
     *         {
     *             "name": "location",
     *             "values": ["usw2-az4"],
     *         },
     *     ],
     *     location_type="availability-zone-id")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetInstanceTypeOfferings.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInstanceTypeOfferingsFilterInputArgs
     *             {
     *                 Name = "instance-type",
     *                 Values = new[]
     *                 {
     *                     "t2.micro",
     *                     "t3.micro",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetInstanceTypeOfferingsFilterInputArgs
     *             {
     *                 Name = "location",
     *                 Values = new[]
     *                 {
     *                     "usw2-az4",
     *                 },
     *             },
     *         },
     *         LocationType = "availability-zone-id",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetInstanceTypeOfferings(ctx, &ec2.GetInstanceTypeOfferingsArgs{
     * 			Filters: []ec2.GetInstanceTypeOfferingsFilter{
     * 				{
     * 					Name: "instance-type",
     * 					Values: []string{
     * 						"t2.micro",
     * 						"t3.micro",
     * 					},
     * 				},
     * 				{
     * 					Name: "location",
     * 					Values: []string{
     * 						"usw2-az4",
     * 					},
     * 				},
     * 			},
     * 			LocationType: pulumi.StringRef("availability-zone-id"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .filters(
     *                 GetInstanceTypeOfferingsFilterArgs.builder()
     *                     .name("instance-type")
     *                     .values(
     *                         "t2.micro",
     *                         "t3.micro")
     *                     .build(),
     *                 GetInstanceTypeOfferingsFilterArgs.builder()
     *                     .name("location")
     *                     .values("usw2-az4")
     *                     .build())
     *             .locationType("availability-zone-id")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getInstanceTypeOfferings
     *       Arguments:
     *         filters:
     *           - name: instance-type
     *             values:
     *               - t2.micro
     *               - t3.micro
     *           - name: location
     *             values:
     *               - usw2-az4
     *         locationType: availability-zone-id
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypeOfferings.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: GetInstanceTypeOfferingsPlainArgs): GetInstanceTypeOfferingsResult =
        getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOfferings].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     * @param locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(
        filters: List<GetInstanceTypeOfferingsFilter>? = null,
        locationType: String? = null,
    ): GetInstanceTypeOfferingsResult {
        val argument = GetInstanceTypeOfferingsPlainArgs(
            filters = filters,
            locationType = locationType,
        )
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOfferings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingsPlainArgs].
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: suspend GetInstanceTypeOfferingsPlainArgsBuilder.() -> Unit): GetInstanceTypeOfferingsResult {
        val builder = GetInstanceTypeOfferingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about EC2 Instance Types.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getInstanceTypes({
     *     filters: [
     *         {
     *             name: "auto-recovery-supported",
     *             values: ["true"],
     *         },
     *         {
     *             name: "network-info.encryption-in-transit-supported",
     *             values: ["true"],
     *         },
     *         {
     *             name: "instance-storage-supported",
     *             values: ["true"],
     *         },
     *         {
     *             name: "instance-type",
     *             values: [
     *                 "g5.2xlarge",
     *                 "g5.4xlarge",
     *             ],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_instance_types(filters=[
     *     {
     *         "name": "auto-recovery-supported",
     *         "values": ["true"],
     *     },
     *     {
     *         "name": "network-info.encryption-in-transit-supported",
     *         "values": ["true"],
     *     },
     *     {
     *         "name": "instance-storage-supported",
     *         "values": ["true"],
     *     },
     *     {
     *         "name": "instance-type",
     *         "values": [
     *             "g5.2xlarge",
     *             "g5.4xlarge",
     *         ],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetInstanceTypes.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInstanceTypesFilterInputArgs
     *             {
     *                 Name = "auto-recovery-supported",
     *                 Values = new[]
     *                 {
     *                     "true",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetInstanceTypesFilterInputArgs
     *             {
     *                 Name = "network-info.encryption-in-transit-supported",
     *                 Values = new[]
     *                 {
     *                     "true",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetInstanceTypesFilterInputArgs
     *             {
     *                 Name = "instance-storage-supported",
     *                 Values = new[]
     *                 {
     *                     "true",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetInstanceTypesFilterInputArgs
     *             {
     *                 Name = "instance-type",
     *                 Values = new[]
     *                 {
     *                     "g5.2xlarge",
     *                     "g5.4xlarge",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetInstanceTypes(ctx, &ec2.GetInstanceTypesArgs{
     * 			Filters: []ec2.GetInstanceTypesFilter{
     * 				{
     * 					Name: "auto-recovery-supported",
     * 					Values: []string{
     * 						"true",
     * 					},
     * 				},
     * 				{
     * 					Name: "network-info.encryption-in-transit-supported",
     * 					Values: []string{
     * 						"true",
     * 					},
     * 				},
     * 				{
     * 					Name: "instance-storage-supported",
     * 					Values: []string{
     * 						"true",
     * 					},
     * 				},
     * 				{
     * 					Name: "instance-type",
     * 					Values: []string{
     * 						"g5.2xlarge",
     * 						"g5.4xlarge",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getInstanceTypes(GetInstanceTypesArgs.builder()
     *             .filters(
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("auto-recovery-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("network-info.encryption-in-transit-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("instance-storage-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("instance-type")
     *                     .values(
     *                         "g5.2xlarge",
     *                         "g5.4xlarge")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getInstanceTypes
     *       Arguments:
     *         filters:
     *           - name: auto-recovery-supported
     *             values:
     *               - 'true'
     *           - name: network-info.encryption-in-transit-supported
     *             values:
     *               - 'true'
     *           - name: instance-storage-supported
     *             values:
     *               - 'true'
     *           - name: instance-type
     *             values:
     *               - g5.2xlarge
     *               - g5.4xlarge
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceTypes.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: GetInstanceTypesPlainArgs): GetInstanceTypesResult =
        getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypes].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(filters: List<GetInstanceTypesFilter>? = null): GetInstanceTypesResult {
        val argument = GetInstanceTypesPlainArgs(
            filters = filters,
        )
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypesPlainArgs].
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: suspend GetInstanceTypesPlainArgsBuilder.() -> Unit): GetInstanceTypesResult {
        val builder = GetInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs or IPs of Amazon EC2 instances to be referenced elsewhere,
     * e.g., to allow easier migration from another management solution
     * or to make it easier for an operator to connect through bastion host(s).
     * > **Note:** It's strongly discouraged to use this data source for querying ephemeral
     * instances (e.g., managed via autoscaling group), as the output may change at any time
     * and you'd need to re-run `apply` every time an instance comes up or dies.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const test = await aws.ec2.getInstances({
     *         instanceTags: {
     *             Role: "HardWorker",
     *         },
     *         filters: [{
     *             name: "instance.group-id",
     *             values: ["sg-12345678"],
     *         }],
     *         instanceStateNames: [
     *             "running",
     *             "stopped",
     *         ],
     *     });
     *     const testEip: aws.ec2.Eip[] = [];
     *     for (const range = {value: 0}; range.value < test.ids.length; range.value++) {
     *         testEip.push(new aws.ec2.Eip(`test-${range.value}`, {instance: test.ids[range&#46;value]}));
     *     }
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_instances(instance_tags={
     *         "Role": "HardWorker",
     *     },
     *     filters=[{
     *         "name": "instance.group-id",
     *         "values": ["sg-12345678"],
     *     }],
     *     instance_state_names=[
     *         "running",
     *         "stopped",
     *     ])
     * test_eip = []
     * for range in [{"value": i} for i in range(0, len(test&#46;ids))]:
     *     test_eip.append(aws.ec2.Eip(f"test-{range['value']}", instance=test&#46;ids[range["value"]]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Threading.Tasks;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(async() =>
     * {
     *     var test = await Aws.Ec2.GetInstances.InvokeAsync(new()
     *     {
     *         InstanceTags =
     *         {
     *             { "Role", "HardWorker" },
     *         },
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInstancesFilterInputArgs
     *             {
     *                 Name = "instance.group-id",
     *                 Values = new[]
     *                 {
     *                     "sg-12345678",
     *                 },
     *             },
     *         },
     *         InstanceStateNames = new[]
     *         {
     *             "running",
     *             "stopped",
     *         },
     *     });
     *     var testEip = new List<Aws.Ec2.Eip>();
     *     for (var rangeIndex = 0; rangeIndex < test.Ids.Length; rangeIndex++)
     *     {
     *         var range = new { Value = rangeIndex };
     *         testEip.Add(new Aws.Ec2.Eip($"test-{range.Value}", new()
     *         {
     *             Instance = test.Ids[range&#46;Value],
     *         }));
     *     }
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		test, err := ec2.GetInstances(ctx, &ec2.GetInstancesArgs{
     * 			InstanceTags: map[string]interface{}{
     * 				"Role": "HardWorker",
     * 			},
     * 			Filters: []ec2.GetInstancesFilter{
     * 				{
     * 					Name: "instance.group-id",
     * 					Values: []string{
     * 						"sg-12345678",
     * 					},
     * 				},
     * 			},
     * 			InstanceStateNames: []string{
     * 				"running",
     * 				"stopped",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		var testEip []*ec2.Eip
     * 		for index := 0; index < int(len(test.Ids)); index++ {
     * 			key0 := index
     * 			val0 := index
     * 			__res, err := ec2.NewEip(ctx, fmt.Sprintf("test-%v", key0), &ec2.EipArgs{
     * 				Instance: pulumi.String(test.Ids[val0]),
     * 			})
     * 			if err != nil {
     * 				return err
     * 			}
     * 			testEip = append(testEip, __res)
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstancesArgs;
     * import com.pulumi.aws.ec2.Eip;
     * import com.pulumi.aws.ec2.EipArgs;
     * import com.pulumi.codegen.internal.KeyedValue;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getInstances(GetInstancesArgs.builder()
     *             .instanceTags(Map.of("Role", "HardWorker"))
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("instance.group-id")
     *                 .values("sg-12345678")
     *                 .build())
     *             .instanceStateNames(
     *                 "running",
     *                 "stopped")
     *             .build());
     *         for (var i = 0; i < test.applyValue(getInstancesResult -> getInstancesResult.ids()).length(); i++) {
     *             new Eip("testEip-" + i, EipArgs.builder()
     *                 .instance(test.applyValue(getInstancesResult -> getInstancesResult.ids())[range&#46;value()])
     *                 .build());
     * }
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     * @param instanceStateNames List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
     * @param instanceTags Map of tags, each pair of which must
     * exactly match a pair on desired instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        filters: List<GetInstancesFilter>? = null,
        instanceStateNames: List<String>? = null,
        instanceTags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
            instanceStateNames = instanceStateNames,
            instanceTags = instanceTags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.InternetGateway` provides details about a specific Internet Gateway.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const vpcId = config.requireObject("vpcId");
     * const default = aws.ec2.getInternetGateway({
     *     filters: [{
     *         name: "attachment.vpc-id",
     *         values: [vpcId],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * vpc_id = config.require_object("vpcId")
     * default = aws.ec2.get_internet_gateway(filters=[{
     *     "name": "attachment.vpc-id",
     *     "values": [vpc_id],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var vpcId = config.RequireObject<dynamic>("vpcId");
     *     var @default = Aws.Ec2.GetInternetGateway.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetInternetGatewayFilterInputArgs
     *             {
     *                 Name = "attachment.vpc-id",
     *                 Values = new[]
     *                 {
     *                     vpcId,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * vpcId := cfg.RequireObject("vpcId")
     * _, err := ec2.LookupInternetGateway(ctx, &ec2.LookupInternetGatewayArgs{
     * Filters: []ec2.GetInternetGatewayFilter{
     * {
     * Name: "attachment.vpc-id",
     * Values: interface{}{
     * vpcId,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInternetGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var vpcId = config.get("vpcId");
     *         final var default = Ec2Functions.getInternetGateway(GetInternetGatewayArgs.builder()
     *             .filters(GetInternetGatewayFilterArgs.builder()
     *                 .name("attachment.vpc-id")
     *                 .values(vpcId)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   vpcId:
     *     type: dynamic
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: aws:ec2:getInternetGateway
     *       Arguments:
     *         filters:
     *           - name: attachment.vpc-id
     *             values:
     *               - ${vpcId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInternetGateway.
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend fun getInternetGateway(argument: GetInternetGatewayPlainArgs): GetInternetGatewayResult =
        getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())

    /**
     * @see [getInternetGateway].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param internetGatewayId ID of the specific Internet Gateway to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired Internet Gateway.
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend fun getInternetGateway(
        filters: List<GetInternetGatewayFilter>? = null,
        internetGatewayId: String? = null,
        tags: Map<String, String>? = null,
    ): GetInternetGatewayResult {
        val argument = GetInternetGatewayPlainArgs(
            filters = filters,
            internetGatewayId = internetGatewayId,
            tags = tags,
        )
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getInternetGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInternetGatewayPlainArgs].
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend fun getInternetGateway(argument: suspend GetInternetGatewayPlainArgsBuilder.() -> Unit): GetInternetGatewayResult {
        val builder = GetInternetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Previews a CIDR from an IPAM address pool. Only works for private IPv4.
     * > **NOTE:** This functionality is also encapsulated in a resource sharing the same name. The data source can be used when you need to use the cidr in a calculation of the same Root module, `count` for example. However, once a cidr range has been allocated that was previewed, the next refresh will find a **new** cidr and may force new resources downstream. Make sure to use `ignore_changes` if this is undesirable.
     * ## Example Usage
     * Basic usage:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getIpamPreviewNextCidr({
     *     ipamPoolId: testAwsVpcIpamPool.id,
     *     netmaskLength: 28,
     * });
     * const testVpcIpamPoolCidrAllocation = new aws.ec2.VpcIpamPoolCidrAllocation("test", {
     *     ipamPoolId: testAwsVpcIpamPool.id,
     *     cidr: test.then(test => test.cidr),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_ipam_preview_next_cidr(ipam_pool_id=test_aws_vpc_ipam_pool["id"],
     *     netmask_length=28)
     * test_vpc_ipam_pool_cidr_allocation = aws.ec2.VpcIpamPoolCidrAllocation("test",
     *     ipam_pool_id=test_aws_vpc_ipam_pool["id"],
     *     cidr=test.cidr)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetIpamPreviewNextCidr.Invoke(new()
     *     {
     *         IpamPoolId = testAwsVpcIpamPool.Id,
     *         NetmaskLength = 28,
     *     });
     *     var testVpcIpamPoolCidrAllocation = new Aws.Ec2.VpcIpamPoolCidrAllocation("test", new()
     *     {
     *         IpamPoolId = testAwsVpcIpamPool.Id,
     *         Cidr = test.Apply(getIpamPreviewNextCidrResult => getIpamPreviewNextCidrResult.Cidr),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		test, err := ec2.GetIpamPreviewNextCidr(ctx, &ec2.GetIpamPreviewNextCidrArgs{
     * 			IpamPoolId:    testAwsVpcIpamPool.Id,
     * 			NetmaskLength: pulumi.IntRef(28),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewVpcIpamPoolCidrAllocation(ctx, "test", &ec2.VpcIpamPoolCidrAllocationArgs{
     * 			IpamPoolId: pulumi.Any(testAwsVpcIpamPool.Id),
     * 			Cidr:       pulumi.String(test.Cidr),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrArgs;
     * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
     * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getIpamPreviewNextCidr(GetIpamPreviewNextCidrArgs.builder()
     *             .ipamPoolId(testAwsVpcIpamPool.id())
     *             .netmaskLength(28)
     *             .build());
     *         var testVpcIpamPoolCidrAllocation = new VpcIpamPoolCidrAllocation("testVpcIpamPoolCidrAllocation", VpcIpamPoolCidrAllocationArgs.builder()
     *             .ipamPoolId(testAwsVpcIpamPool.id())
     *             .cidr(test.applyValue(getIpamPreviewNextCidrResult -> getIpamPreviewNextCidrResult.cidr()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testVpcIpamPoolCidrAllocation:
     *     type: aws:ec2:VpcIpamPoolCidrAllocation
     *     name: test
     *     properties:
     *       ipamPoolId: ${testAwsVpcIpamPool.id}
     *       cidr: ${test.cidr}
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getIpamPreviewNextCidr
     *       Arguments:
     *         ipamPoolId: ${testAwsVpcIpamPool.id}
     *         netmaskLength: 28
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpamPreviewNextCidr.
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend fun getIpamPreviewNextCidr(argument: GetIpamPreviewNextCidrPlainArgs): GetIpamPreviewNextCidrResult =
        getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(argument.toJava()).await())

    /**
     * @see [getIpamPreviewNextCidr].
     * @param disallowedCidrs Exclude a particular CIDR range from being returned by the pool.
     * @param ipamPoolId ID of the pool to which you want to assign a CIDR.
     * @param netmaskLength Netmask length of the CIDR you would like to preview from the IPAM pool.
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend fun getIpamPreviewNextCidr(
        disallowedCidrs: List<String>? = null,
        ipamPoolId: String,
        netmaskLength: Int? = null,
    ): GetIpamPreviewNextCidrResult {
        val argument = GetIpamPreviewNextCidrPlainArgs(
            disallowedCidrs = disallowedCidrs,
            ipamPoolId = ipamPoolId,
            netmaskLength = netmaskLength,
        )
        return getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpamPreviewNextCidr].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetIpamPreviewNextCidrPlainArgs].
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend fun getIpamPreviewNextCidr(argument: suspend GetIpamPreviewNextCidrPlainArgsBuilder.() -> Unit): GetIpamPreviewNextCidrResult {
        val builder = GetIpamPreviewNextCidrPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a specific EC2 Key Pair.
     * ## Example Usage
     * The following example shows how to get a EC2 Key Pair including the public key material from its name.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getKeyPair({
     *     keyName: "test",
     *     includePublicKey: true,
     *     filters: [{
     *         name: "tag:Component",
     *         values: ["web"],
     *     }],
     * });
     * export const fingerprint = example.then(example => example.fingerprint);
     * export const name = example.then(example => example.keyName);
     * export const id = example.then(example => example.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_key_pair(key_name="test",
     *     include_public_key=True,
     *     filters=[{
     *         "name": "tag:Component",
     *         "values": ["web"],
     *     }])
     * pulumi.export("fingerprint", example.fingerprint)
     * pulumi.export("name", example.key_name)
     * pulumi.export("id", example.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetKeyPair.Invoke(new()
     *     {
     *         KeyName = "test",
     *         IncludePublicKey = true,
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetKeyPairFilterInputArgs
     *             {
     *                 Name = "tag:Component",
     *                 Values = new[]
     *                 {
     *                     "web",
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["fingerprint"] = example.Apply(getKeyPairResult => getKeyPairResult.Fingerprint),
     *         ["name"] = example.Apply(getKeyPairResult => getKeyPairResult.KeyName),
     *         ["id"] = example.Apply(getKeyPairResult => getKeyPairResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.LookupKeyPair(ctx, &ec2.LookupKeyPairArgs{
     * 			KeyName:          pulumi.StringRef("test"),
     * 			IncludePublicKey: pulumi.BoolRef(true),
     * 			Filters: []ec2.GetKeyPairFilter{
     * 				{
     * 					Name: "tag:Component",
     * 					Values: []string{
     * 						"web",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("fingerprint", example.Fingerprint)
     * 		ctx.Export("name", example.KeyName)
     * 		ctx.Export("id", example.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetKeyPairArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getKeyPair(GetKeyPairArgs.builder()
     *             .keyName("test")
     *             .includePublicKey(true)
     *             .filters(GetKeyPairFilterArgs.builder()
     *                 .name("tag:Component")
     *                 .values("web")
     *                 .build())
     *             .build());
     *         ctx.export("fingerprint", example.applyValue(getKeyPairResult -> getKeyPairResult.fingerprint()));
     *         ctx.export("name", example.applyValue(getKeyPairResult -> getKeyPairResult.keyName()));
     *         ctx.export("id", example.applyValue(getKeyPairResult -> getKeyPairResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getKeyPair
     *       Arguments:
     *         keyName: test
     *         includePublicKey: true
     *         filters:
     *           - name: tag:Component
     *             values:
     *               - web
     * outputs:
     *   fingerprint: ${example.fingerprint}
     *   name: ${example.keyName}
     *   id: ${example.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeyPair.
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(argument: GetKeyPairPlainArgs): GetKeyPairResult =
        getKeyPairResultToKotlin(getKeyPairPlain(argument.toJava()).await())

    /**
     * @see [getKeyPair].
     * @param filters Custom filter block as described below.
     * @param includePublicKey Whether to include the public key material in the response.
     * @param keyName Key Pair name.
     * @param keyPairId Key Pair ID.
     * @param tags Any tags assigned to the Key Pair.
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(
        filters: List<GetKeyPairFilter>? = null,
        includePublicKey: Boolean? = null,
        keyName: String? = null,
        keyPairId: String? = null,
        tags: Map<String, String>? = null,
    ): GetKeyPairResult {
        val argument = GetKeyPairPlainArgs(
            filters = filters,
            includePublicKey = includePublicKey,
            keyName = keyName,
            keyPairId = keyPairId,
            tags = tags,
        )
        return getKeyPairResultToKotlin(getKeyPairPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyPair].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetKeyPairPlainArgs].
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(argument: suspend GetKeyPairPlainArgsBuilder.() -> Unit): GetKeyPairResult {
        val builder = GetKeyPairPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyPairResultToKotlin(getKeyPairPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Launch Configuration.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ubuntu = aws.ec2.getLaunchConfiguration({
     *     name: "test-launch-config",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ubuntu = aws.ec2.get_launch_configuration(name="test-launch-config")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ubuntu = Aws.Ec2.GetLaunchConfiguration.Invoke(new()
     *     {
     *         Name = "test-launch-config",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupLaunchConfiguration(ctx, &ec2.LookupLaunchConfigurationArgs{
     * 			Name: "test-launch-config",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ubuntu = Ec2Functions.getLaunchConfiguration(GetLaunchConfigurationArgs.builder()
     *             .name("test-launch-config")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ubuntu:
     *     fn::invoke:
     *       Function: aws:ec2:getLaunchConfiguration
     *       Arguments:
     *         name: test-launch-config
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLaunchConfiguration.
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend fun getLaunchConfiguration(argument: GetLaunchConfigurationPlainArgs): GetLaunchConfigurationResult =
        getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getLaunchConfiguration].
     * @param name Name of the launch configuration.
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend fun getLaunchConfiguration(name: String): GetLaunchConfigurationResult {
        val argument = GetLaunchConfigurationPlainArgs(
            name = name,
        )
        return getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLaunchConfigurationPlainArgs].
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend fun getLaunchConfiguration(argument: suspend GetLaunchConfigurationPlainArgsBuilder.() -> Unit): GetLaunchConfigurationResult {
        val builder = GetLaunchConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Launch Template.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const default = aws.ec2.getLaunchTemplate({
     *     name: "my-launch-template",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * default = aws.ec2.get_launch_template(name="my-launch-template")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = Aws.Ec2.GetLaunchTemplate.Invoke(new()
     *     {
     *         Name = "my-launch-template",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupLaunchTemplate(ctx, &ec2.LookupLaunchTemplateArgs{
     * 			Name: pulumi.StringRef("my-launch-template"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getLaunchTemplate(GetLaunchTemplateArgs.builder()
     *             .name("my-launch-template")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: aws:ec2:getLaunchTemplate
     *       Arguments:
     *         name: my-launch-template
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getLaunchTemplate({
     *     filters: [{
     *         name: "launch-template-name",
     *         values: ["some-template"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_launch_template(filters=[{
     *     "name": "launch-template-name",
     *     "values": ["some-template"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetLaunchTemplate.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetLaunchTemplateFilterInputArgs
     *             {
     *                 Name = "launch-template-name",
     *                 Values = new[]
     *                 {
     *                     "some-template",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupLaunchTemplate(ctx, &ec2.LookupLaunchTemplateArgs{
     * 			Filters: []ec2.GetLaunchTemplateFilter{
     * 				{
     * 					Name: "launch-template-name",
     * 					Values: []string{
     * 						"some-template",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getLaunchTemplate(GetLaunchTemplateArgs.builder()
     *             .filters(GetLaunchTemplateFilterArgs.builder()
     *                 .name("launch-template-name")
     *                 .values("some-template")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getLaunchTemplate
     *       Arguments:
     *         filters:
     *           - name: launch-template-name
     *             values:
     *               - some-template
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLaunchTemplate.
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend fun getLaunchTemplate(argument: GetLaunchTemplatePlainArgs): GetLaunchTemplateResult =
        getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(argument.toJava()).await())

    /**
     * @see [getLaunchTemplate].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param id ID of the specific launch template to retrieve.
     * @param name Name of the launch template.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend fun getLaunchTemplate(
        filters: List<GetLaunchTemplateFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetLaunchTemplateResult {
        val argument = GetLaunchTemplatePlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
        )
        return getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLaunchTemplatePlainArgs].
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend fun getLaunchTemplate(argument: suspend GetLaunchTemplatePlainArgsBuilder.() -> Unit): GetLaunchTemplateResult {
        val builder = GetLaunchTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway.
     * ## Example Usage
     * The following example shows how one might accept a local gateway id as a variable.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const localGatewayId = config.requireObject("localGatewayId");
     * const selected = aws.ec2.getLocalGateway({
     *     id: localGatewayId,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * local_gateway_id = config.require_object("localGatewayId")
     * selected = aws.ec2.get_local_gateway(id=local_gateway_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var localGatewayId = config.RequireObject<dynamic>("localGatewayId");
     *     var selected = Aws.Ec2.GetLocalGateway.Invoke(new()
     *     {
     *         Id = localGatewayId,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		localGatewayId := cfg.RequireObject("localGatewayId")
     * 		_, err := ec2.GetLocalGateway(ctx, &ec2.GetLocalGatewayArgs{
     * 			Id: pulumi.StringRef(localGatewayId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var localGatewayId = config.get("localGatewayId");
     *         final var selected = Ec2Functions.getLocalGateway(GetLocalGatewayArgs.builder()
     *             .id(localGatewayId)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   localGatewayId:
     *     type: dynamic
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGateway
     *       Arguments:
     *         id: ${localGatewayId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGateway.
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(argument: GetLocalGatewayPlainArgs): GetLocalGatewayResult =
        getLocalGatewayResultToKotlin(getLocalGatewayPlain(argument.toJava()).await())

    /**
     * @see [getLocalGateway].
     * @param filters Custom filter block as described below.
     * @param id Id of the specific Local Gateway to retrieve.
     * @param state Current state of the desired Local Gateway.
     * Can be either `"pending"` or `"available"`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired Local Gateway.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(
        filters: List<GetLocalGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayResult {
        val argument = GetLocalGatewayPlainArgs(
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getLocalGatewayResultToKotlin(getLocalGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayPlainArgs].
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(argument: suspend GetLocalGatewayPlainArgsBuilder.() -> Unit): GetLocalGatewayResult {
        val builder = GetLocalGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayResultToKotlin(getLocalGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Route Table.
     * This data source can prove useful when a module accepts a local gateway route table id as
     * an input variable and needs to, for example, find the associated Outpost or Local Gateway.
     * ## Example Usage
     * The following example returns a specific local gateway route table ID
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const awsEc2LocalGatewayRouteTable = config.requireObject("awsEc2LocalGatewayRouteTable");
     * const selected = aws.ec2.getLocalGatewayRouteTable({
     *     localGatewayRouteTableId: awsEc2LocalGatewayRouteTable,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * aws_ec2_local_gateway_route_table = config.require_object("awsEc2LocalGatewayRouteTable")
     * selected = aws.ec2.get_local_gateway_route_table(local_gateway_route_table_id=aws_ec2_local_gateway_route_table)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var awsEc2LocalGatewayRouteTable = config.RequireObject<dynamic>("awsEc2LocalGatewayRouteTable");
     *     var selected = Aws.Ec2.GetLocalGatewayRouteTable.Invoke(new()
     *     {
     *         LocalGatewayRouteTableId = awsEc2LocalGatewayRouteTable,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		awsEc2LocalGatewayRouteTable := cfg.RequireObject("awsEc2LocalGatewayRouteTable")
     * 		_, err := ec2.GetLocalGatewayRouteTable(ctx, &ec2.GetLocalGatewayRouteTableArgs{
     * 			LocalGatewayRouteTableId: pulumi.StringRef(awsEc2LocalGatewayRouteTable),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var awsEc2LocalGatewayRouteTable = config.get("awsEc2LocalGatewayRouteTable");
     *         final var selected = Ec2Functions.getLocalGatewayRouteTable(GetLocalGatewayRouteTableArgs.builder()
     *             .localGatewayRouteTableId(awsEc2LocalGatewayRouteTable)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   awsEc2LocalGatewayRouteTable:
     *     type: dynamic
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGatewayRouteTable
     *       Arguments:
     *         localGatewayRouteTableId: ${awsEc2LocalGatewayRouteTable}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGatewayRouteTable.
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend fun getLocalGatewayRouteTable(argument: GetLocalGatewayRouteTablePlainArgs): GetLocalGatewayRouteTableResult =
        getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayRouteTable].
     * @param filters
     * @param localGatewayId ID of the specific local gateway route table to retrieve.
     * @param localGatewayRouteTableId Local Gateway Route Table Id assigned to desired local gateway route table
     * @param outpostArn ARN of the Outpost the local gateway route table is associated with.
     * @param state State of the local gateway route table.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend fun getLocalGatewayRouteTable(
        filters: List<GetLocalGatewayRouteTableFilter>? = null,
        localGatewayId: String? = null,
        localGatewayRouteTableId: String? = null,
        outpostArn: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayRouteTableResult {
        val argument = GetLocalGatewayRouteTablePlainArgs(
            filters = filters,
            localGatewayId = localGatewayId,
            localGatewayRouteTableId = localGatewayRouteTableId,
            outpostArn = outpostArn,
            state = state,
            tags = tags,
        )
        return getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayRouteTablePlainArgs].
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend fun getLocalGatewayRouteTable(argument: suspend GetLocalGatewayRouteTablePlainArgsBuilder.() -> Unit): GetLocalGatewayRouteTableResult {
        val builder = GetLocalGatewayRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Local Gateway Route Tables, such as their identifiers.
     * ## Example Usage
     * The following shows outputting all Local Gateway Route Table Ids.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const foo = await aws.ec2.getLocalGatewayRouteTables({});
     *     return {
     *         foo: foo.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_local_gateway_route_tables()
     * pulumi.export("foo", foo.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ec2.GetLocalGatewayRouteTables.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["foo"] = foo.Apply(getLocalGatewayRouteTablesResult => getLocalGatewayRouteTablesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := ec2.GetLocalGatewayRouteTables(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("foo", foo.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getLocalGatewayRouteTables();
     *         ctx.export("foo", foo.applyValue(getLocalGatewayRouteTablesResult -> getLocalGatewayRouteTablesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGatewayRouteTables
     *       Arguments: {}
     * outputs:
     *   foo: ${foo.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGatewayRouteTables.
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend fun getLocalGatewayRouteTables(argument: GetLocalGatewayRouteTablesPlainArgs): GetLocalGatewayRouteTablesResult =
        getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayRouteTables].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend fun getLocalGatewayRouteTables(
        filters: List<GetLocalGatewayRouteTablesFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayRouteTablesResult {
        val argument = GetLocalGatewayRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayRouteTablesPlainArgs].
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend fun getLocalGatewayRouteTables(argument: suspend GetLocalGatewayRouteTablesPlainArgsBuilder.() -> Unit): GetLocalGatewayRouteTablesResult {
        val builder = GetLocalGatewayRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Virtual Interface. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = .reduce((__obj, [, ]) => ({ &#46;&#46;&#46;__obj, [__key]: aws.ec2.getLocalGatewayVirtualInterface({
     *     id: __value,
     * }) }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = {__key: aws.ec2.get_local_gateway_virtual_interface(id=__value) for __key, __value in example_aws_ec2_local_gateway_virtual_interface_group["localGatewayVirtualInterfaceIds"]}
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = .ToDictionary(item => {
     *         var __key = item.Key;
     *         return __key;
     *     }, item => {
     *         var __value = item.Value;
     *         return Aws.Ec2.GetLocalGatewayVirtualInterface.Invoke(new()
     *         {
     *             Id = __value,
     *         });
     *     });
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterface.
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend fun getLocalGatewayVirtualInterface(argument: GetLocalGatewayVirtualInterfacePlainArgs): GetLocalGatewayVirtualInterfaceResult =
        getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterface].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     * @param id Identifier of EC2 Local Gateway Virtual Interface.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend fun getLocalGatewayVirtualInterface(
        filters: List<GetLocalGatewayVirtualInterfaceFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceResult {
        val argument = GetLocalGatewayVirtualInterfacePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterface].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfacePlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend fun getLocalGatewayVirtualInterface(argument: suspend GetLocalGatewayVirtualInterfacePlainArgsBuilder.() -> Unit): GetLocalGatewayVirtualInterfaceResult {
        val builder = GetLocalGatewayVirtualInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Virtual Interface Group. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getLocalGatewayVirtualInterfaceGroup({
     *     localGatewayId: exampleAwsEc2LocalGateway.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_local_gateway_virtual_interface_group(local_gateway_id=example_aws_ec2_local_gateway["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetLocalGatewayVirtualInterfaceGroup.Invoke(new()
     *     {
     *         LocalGatewayId = exampleAwsEc2LocalGateway.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetLocalGatewayVirtualInterfaceGroup(ctx, &ec2.GetLocalGatewayVirtualInterfaceGroupArgs{
     * 			LocalGatewayId: pulumi.StringRef(exampleAwsEc2LocalGateway.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getLocalGatewayVirtualInterfaceGroup(GetLocalGatewayVirtualInterfaceGroupArgs.builder()
     *             .localGatewayId(exampleAwsEc2LocalGateway.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGatewayVirtualInterfaceGroup
     *       Arguments:
     *         localGatewayId: ${exampleAwsEc2LocalGateway.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroup.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroup(argument: GetLocalGatewayVirtualInterfaceGroupPlainArgs): GetLocalGatewayVirtualInterfaceGroupResult =
        getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterfaceGroup].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     * @param id Identifier of EC2 Local Gateway Virtual Interface Group.
     * @param localGatewayId Identifier of EC2 Local Gateway.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroup(
        filters: List<GetLocalGatewayVirtualInterfaceGroupFilter>? = null,
        id: String? = null,
        localGatewayId: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceGroupResult {
        val argument = GetLocalGatewayVirtualInterfaceGroupPlainArgs(
            filters = filters,
            id = id,
            localGatewayId = localGatewayId,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterfaceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfaceGroupPlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroup(argument: suspend GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder.() -> Unit): GetLocalGatewayVirtualInterfaceGroupResult {
        val builder = GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple EC2 Local Gateway Virtual Interface Groups, such as identifiers. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const all = aws.ec2.getLocalGatewayVirtualInterfaceGroups({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * all = aws.ec2.get_local_gateway_virtual_interface_groups()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var all = Aws.Ec2.GetLocalGatewayVirtualInterfaceGroups.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetLocalGatewayVirtualInterfaceGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = Ec2Functions.getLocalGatewayVirtualInterfaceGroups();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   all:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGatewayVirtualInterfaceGroups
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroups.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroups(argument: GetLocalGatewayVirtualInterfaceGroupsPlainArgs): GetLocalGatewayVirtualInterfaceGroupsResult =
        getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterfaceGroups].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroups(
        filters: List<GetLocalGatewayVirtualInterfaceGroupsFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceGroupsResult {
        val argument = GetLocalGatewayVirtualInterfaceGroupsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterfaceGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfaceGroupsPlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroups(argument: suspend GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder.() -> Unit): GetLocalGatewayVirtualInterfaceGroupsResult {
        val builder = GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Local Gateways, such as their identifiers.
     * ## Example Usage
     * The following example retrieves Local Gateways with a resource tag of `service` set to `production`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const foo = await aws.ec2.getLocalGateways({
     *         tags: {
     *             service: "production",
     *         },
     *     });
     *     return {
     *         foo: foo.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_local_gateways(tags={
     *     "service": "production",
     * })
     * pulumi.export("foo", foo.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ec2.GetLocalGateways.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "service", "production" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["foo"] = foo.Apply(getLocalGatewaysResult => getLocalGatewaysResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := ec2.GetLocalGateways(ctx, &ec2.GetLocalGatewaysArgs{
     * 			Tags: map[string]interface{}{
     * 				"service": "production",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("foo", foo.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getLocalGateways(GetLocalGatewaysArgs.builder()
     *             .tags(Map.of("service", "production"))
     *             .build());
     *         ctx.export("foo", foo.applyValue(getLocalGatewaysResult -> getLocalGatewaysResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ec2:getLocalGateways
     *       Arguments:
     *         tags:
     *           service: production
     * outputs:
     *   foo: ${foo.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLocalGateways.
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend fun getLocalGateways(argument: GetLocalGatewaysPlainArgs): GetLocalGatewaysResult =
        getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getLocalGateways].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local_gateways.
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend fun getLocalGateways(
        filters: List<GetLocalGatewaysFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewaysResult {
        val argument = GetLocalGatewaysPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGateways].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewaysPlainArgs].
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend fun getLocalGateways(argument: suspend GetLocalGatewaysPlainArgsBuilder.() -> Unit): GetLocalGatewaysResult {
        val builder = GetLocalGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
     * customer-managed prefix list in the current region.
     * ## Example Usage
     * ### Find the regional DynamoDB prefix list
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegion({});
     * const example = current.then(current => aws.ec2.getManagedPrefixList({
     *     name: `com.amazonaws.${current.name}.dynamodb`,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_region()
     * example = aws.ec2.get_managed_prefix_list(name=f"com.amazonaws.{current.name}.dynamodb")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegion.Invoke();
     *     var example = Aws.Ec2.GetManagedPrefixList.Invoke(new()
     *     {
     *         Name = $"com.amazonaws.{current.Apply(getRegionResult => getRegionResult.Name)}.dynamodb",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetRegion(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.LookupManagedPrefixList(ctx, &ec2.LookupManagedPrefixListArgs{
     * 			Name: pulumi.StringRef(fmt.Sprintf("com.amazonaws.%v.dynamodb", current.Name)),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetManagedPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *         final var example = Ec2Functions.getManagedPrefixList(GetManagedPrefixListArgs.builder()
     *             .name(String.format("com.amazonaws.%s.dynamodb", current.applyValue(getRegionResult -> getRegionResult.name())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegion
     *       Arguments: {}
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getManagedPrefixList
     *       Arguments:
     *         name: com.amazonaws.${current.name}.dynamodb
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Find a managed prefix list using filters
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getManagedPrefixList({
     *     filters: [{
     *         name: "prefix-list-name",
     *         values: ["my-prefix-list"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_managed_prefix_list(filters=[{
     *     "name": "prefix-list-name",
     *     "values": ["my-prefix-list"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetManagedPrefixList.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetManagedPrefixListFilterInputArgs
     *             {
     *                 Name = "prefix-list-name",
     *                 Values = new[]
     *                 {
     *                     "my-prefix-list",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupManagedPrefixList(ctx, &ec2.LookupManagedPrefixListArgs{
     * 			Filters: []ec2.GetManagedPrefixListFilter{
     * 				{
     * 					Name: "prefix-list-name",
     * 					Values: []string{
     * 						"my-prefix-list",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetManagedPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getManagedPrefixList(GetManagedPrefixListArgs.builder()
     *             .filters(GetManagedPrefixListFilterArgs.builder()
     *                 .name("prefix-list-name")
     *                 .values("my-prefix-list")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getManagedPrefixList
     *       Arguments:
     *         filters:
     *           - name: prefix-list-name
     *             values:
     *               - my-prefix-list
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getManagedPrefixList.
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend fun getManagedPrefixList(argument: GetManagedPrefixListPlainArgs): GetManagedPrefixListResult =
        getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrefixList].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param id ID of the prefix list to select.
     * @param name Name of the prefix list to select.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend fun getManagedPrefixList(
        filters: List<GetManagedPrefixListFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetManagedPrefixListResult {
        val argument = GetManagedPrefixListPlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
        )
        return getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrefixList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetManagedPrefixListPlainArgs].
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend fun getManagedPrefixList(argument: suspend GetManagedPrefixListPlainArgsBuilder.() -> Unit): GetManagedPrefixListResult {
        val builder = GetManagedPrefixListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of managed prefix list ids to be referenced elsewhere.
     * ## Example Usage
     * The following returns all managed prefix lists filtered by tags
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const testEnv = aws.ec2.getManagedPrefixLists({
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * const testEnvGetManagedPrefixList = .map(__index => (aws.ec2.getManagedPrefixList({
     *     id: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test_env = aws.ec2.get_managed_prefix_lists(tags={
     *     "Env": "test",
     * })
     * test_env_get_managed_prefix_list = [aws&#46;ec2&#46;get_managed_prefix_list(id=test_env&#46;ids[__index]) for __index in range(len(test_env&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var testEnv = Aws.Ec2.GetManagedPrefixLists.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     *     var testEnvGetManagedPrefixList = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getManagedPrefixLists.
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend fun getManagedPrefixLists(argument: GetManagedPrefixListsPlainArgs): GetManagedPrefixListsResult =
        getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrefixLists].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired .
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend fun getManagedPrefixLists(
        filters: List<GetManagedPrefixListsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetManagedPrefixListsResult {
        val argument = GetManagedPrefixListsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrefixLists].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetManagedPrefixListsPlainArgs].
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend fun getManagedPrefixLists(argument: suspend GetManagedPrefixListsPlainArgsBuilder.() -> Unit): GetManagedPrefixListsResult {
        val builder = GetManagedPrefixListsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific VPC NAT Gateway.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const default = aws.ec2.getNatGateway({
     *     subnetId: _public.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * default = aws.ec2.get_nat_gateway(subnet_id=public["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = Aws.Ec2.GetNatGateway.Invoke(new()
     *     {
     *         SubnetId = @public.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupNatGateway(ctx, &ec2.LookupNatGatewayArgs{
     * 			SubnetId: pulumi.StringRef(public.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNatGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getNatGateway(GetNatGatewayArgs.builder()
     *             .subnetId(public_.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: aws:ec2:getNatGateway
     *       Arguments:
     *         subnetId: ${public.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With tags
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const default = aws.ec2.getNatGateway({
     *     subnetId: _public.id,
     *     tags: {
     *         Name: "gw NAT",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * default = aws.ec2.get_nat_gateway(subnet_id=public["id"],
     *     tags={
     *         "Name": "gw NAT",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = Aws.Ec2.GetNatGateway.Invoke(new()
     *     {
     *         SubnetId = @public.Id,
     *         Tags =
     *         {
     *             { "Name", "gw NAT" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupNatGateway(ctx, &ec2.LookupNatGatewayArgs{
     * 			SubnetId: pulumi.StringRef(public.Id),
     * 			Tags: map[string]interface{}{
     * 				"Name": "gw NAT",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNatGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getNatGateway(GetNatGatewayArgs.builder()
     *             .subnetId(public_.id())
     *             .tags(Map.of("Name", "gw NAT"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: aws:ec2:getNatGateway
     *       Arguments:
     *         subnetId: ${public.id}
     *         tags:
     *           Name: gw NAT
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNatGateway.
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(argument: GetNatGatewayPlainArgs): GetNatGatewayResult =
        getNatGatewayResultToKotlin(getNatGatewayPlain(argument.toJava()).await())

    /**
     * @see [getNatGateway].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param id ID of the specific NAT Gateway to retrieve.
     * @param state State of the NAT Gateway (pending | failed | available | deleting | deleted ).
     * @param subnetId ID of subnet that the NAT Gateway resides in.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateway.
     * @param vpcId ID of the VPC that the NAT Gateway resides in.
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(
        filters: List<GetNatGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        subnetId: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNatGatewayResult {
        val argument = GetNatGatewayPlainArgs(
            filters = filters,
            id = id,
            state = state,
            subnetId = subnetId,
            tags = tags,
            vpcId = vpcId,
        )
        return getNatGatewayResultToKotlin(getNatGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNatGatewayPlainArgs].
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(argument: suspend GetNatGatewayPlainArgsBuilder.() -> Unit): GetNatGatewayResult {
        val builder = GetNatGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatGatewayResultToKotlin(getNatGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of NAT gateway ids to be referenced elsewhere.
     * ## Example Usage
     * The following returns all NAT gateways in a specified VPC that are marked as available
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const ngws = aws.ec2.getNatGateways({
     *     vpcId: vpcId,
     *     filters: [{
     *         name: "state",
     *         values: ["available"],
     *     }],
     * });
     * const ngw = .map(__index => (aws.ec2.getNatGateway({
     *     id: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * ngws = aws.ec2.get_nat_gateways(vpc_id=vpc_id,
     *     filters=[{
     *         "name": "state",
     *         "values": ["available"],
     *     }])
     * ngw = [aws&#46;ec2&#46;get_nat_gateway(id=ngws&#46;ids[__index]) for __index in range(len(ngws&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ngws = Aws.Ec2.GetNatGateways.Invoke(new()
     *     {
     *         VpcId = vpcId,
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetNatGatewaysFilterInputArgs
     *             {
     *                 Name = "state",
     *                 Values = new[]
     *                 {
     *                     "available",
     *                 },
     *             },
     *         },
     *     });
     *     var ngw = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNatGateways.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: GetNatGatewaysPlainArgs): GetNatGatewaysResult =
        getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getNatGateways].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateways.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(
        filters: List<GetNatGatewaysFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNatGatewaysResult {
        val argument = GetNatGatewaysPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatGateways].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNatGatewaysPlainArgs].
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: suspend GetNatGatewaysPlainArgsBuilder.() -> Unit): GetNatGatewaysResult {
        val builder = GetNatGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * The following shows outputting all network ACL ids in a vpc.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.ec2.getNetworkAcls({
     *         vpcId: vpcId,
     *     });
     *     return {
     *         example: example.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_acls(vpc_id=vpc_id)
     * pulumi.export("example", example.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkAcls.Invoke(new()
     *     {
     *         VpcId = vpcId,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getNetworkAclsResult => getNetworkAclsResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.GetNetworkAcls(ctx, &ec2.GetNetworkAclsArgs{
     * 			VpcId: pulumi.StringRef(vpcId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example", example.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkAcls(GetNetworkAclsArgs.builder()
     *             .vpcId(vpcId)
     *             .build());
     *         ctx.export("example", example.applyValue(getNetworkAclsResult -> getNetworkAclsResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkAcls
     *       Arguments:
     *         vpcId: ${vpcId}
     * outputs:
     *   example: ${example.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * The following example retrieves a list of all network ACL ids in a VPC with a custom
     * tag of `Tier` set to a value of "Private".
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getNetworkAcls({
     *     vpcId: vpcId,
     *     tags: {
     *         Tier: "Private",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_acls(vpc_id=vpc_id,
     *     tags={
     *         "Tier": "Private",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkAcls.Invoke(new()
     *     {
     *         VpcId = vpcId,
     *         Tags =
     *         {
     *             { "Tier", "Private" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetNetworkAcls(ctx, &ec2.GetNetworkAclsArgs{
     * 			VpcId: pulumi.StringRef(vpcId),
     * 			Tags: map[string]interface{}{
     * 				"Tier": "Private",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkAcls(GetNetworkAclsArgs.builder()
     *             .vpcId(vpcId)
     *             .tags(Map.of("Tier", "Private"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkAcls
     *       Arguments:
     *         vpcId: ${vpcId}
     *         tags:
     *           Tier: Private
     * ```
     * <!--End PulumiCodeChooser -->
     * The following example retrieves a network ACL id in a VPC which associated
     * with specific subnet.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getNetworkAcls({
     *     vpcId: vpcId,
     *     filters: [{
     *         name: "association.subnet-id",
     *         values: [test&#46;id],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_acls(vpc_id=vpc_id,
     *     filters=[{
     *         "name": "association.subnet-id",
     *         "values": [test["id"]],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkAcls.Invoke(new()
     *     {
     *         VpcId = vpcId,
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetNetworkAclsFilterInputArgs
     *             {
     *                 Name = "association.subnet-id",
     *                 Values = new[]
     *                 {
     *                     test.Id,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := ec2.GetNetworkAcls(ctx, &ec2.GetNetworkAclsArgs{
     * VpcId: pulumi.StringRef(vpcId),
     * Filters: []ec2.GetNetworkAclsFilter{
     * {
     * Name: "association.subnet-id",
     * Values: interface{}{
     * test.Id,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkAcls(GetNetworkAclsArgs.builder()
     *             .vpcId(vpcId)
     *             .filters(GetNetworkAclsFilterArgs.builder()
     *                 .name("association.subnet-id")
     *                 .values(test.id())
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkAcls
     *       Arguments:
     *         vpcId: ${vpcId}
     *         filters:
     *           - name: association.subnet-id
     *             values:
     *               - ${test.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkAcls.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: GetNetworkAclsPlainArgs): GetNetworkAclsResult =
        getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())

    /**
     * @see [getNetworkAcls].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired network ACLs.
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(
        filters: List<GetNetworkAclsFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNetworkAclsResult {
        val argument = GetNetworkAclsPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkAcls].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkAclsPlainArgs].
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: suspend GetNetworkAclsPlainArgsBuilder.() -> Unit): GetNetworkAclsResult {
        val builder = GetNetworkAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.NetworkInsightsAnalysis` provides details about a specific Network Insights Analysis.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getNetworkInsightsAnalysis({
     *     networkInsightsAnalysisId: exampleAwsEc2NetworkInsightsAnalysis.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_insights_analysis(network_insights_analysis_id=example_aws_ec2_network_insights_analysis["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkInsightsAnalysis.Invoke(new()
     *     {
     *         NetworkInsightsAnalysisId = exampleAwsEc2NetworkInsightsAnalysis.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupNetworkInsightsAnalysis(ctx, &ec2.LookupNetworkInsightsAnalysisArgs{
     * 			NetworkInsightsAnalysisId: pulumi.StringRef(exampleAwsEc2NetworkInsightsAnalysis.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInsightsAnalysis(GetNetworkInsightsAnalysisArgs.builder()
     *             .networkInsightsAnalysisId(exampleAwsEc2NetworkInsightsAnalysis.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInsightsAnalysis
     *       Arguments:
     *         networkInsightsAnalysisId: ${exampleAwsEc2NetworkInsightsAnalysis.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkInsightsAnalysis.
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend fun getNetworkInsightsAnalysis(argument: GetNetworkInsightsAnalysisPlainArgs): GetNetworkInsightsAnalysisResult =
        getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInsightsAnalysis].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param networkInsightsAnalysisId ID of the Network Insights Analysis to select.
     * @param tags
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend fun getNetworkInsightsAnalysis(
        filters: List<GetNetworkInsightsAnalysisFilter>? = null,
        networkInsightsAnalysisId: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInsightsAnalysisResult {
        val argument = GetNetworkInsightsAnalysisPlainArgs(
            filters = filters,
            networkInsightsAnalysisId = networkInsightsAnalysisId,
            tags = tags,
        )
        return getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInsightsAnalysis].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInsightsAnalysisPlainArgs].
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend fun getNetworkInsightsAnalysis(argument: suspend GetNetworkInsightsAnalysisPlainArgsBuilder.() -> Unit): GetNetworkInsightsAnalysisResult {
        val builder = GetNetworkInsightsAnalysisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.NetworkInsightsPath` provides details about a specific Network Insights Path.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getNetworkInsightsPath({
     *     networkInsightsPathId: exampleAwsEc2NetworkInsightsPath.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_insights_path(network_insights_path_id=example_aws_ec2_network_insights_path["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkInsightsPath.Invoke(new()
     *     {
     *         NetworkInsightsPathId = exampleAwsEc2NetworkInsightsPath.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupNetworkInsightsPath(ctx, &ec2.LookupNetworkInsightsPathArgs{
     * 			NetworkInsightsPathId: pulumi.StringRef(exampleAwsEc2NetworkInsightsPath.Id),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInsightsPath(GetNetworkInsightsPathArgs.builder()
     *             .networkInsightsPathId(exampleAwsEc2NetworkInsightsPath.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInsightsPath
     *       Arguments:
     *         networkInsightsPathId: ${exampleAwsEc2NetworkInsightsPath.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkInsightsPath.
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend fun getNetworkInsightsPath(argument: GetNetworkInsightsPathPlainArgs): GetNetworkInsightsPathResult =
        getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInsightsPath].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param networkInsightsPathId ID of the Network Insights Path to select.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend fun getNetworkInsightsPath(
        filters: List<GetNetworkInsightsPathFilter>? = null,
        networkInsightsPathId: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInsightsPathResult {
        val argument = GetNetworkInsightsPathPlainArgs(
            filters = filters,
            networkInsightsPathId = networkInsightsPathId,
            tags = tags,
        )
        return getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInsightsPath].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInsightsPathPlainArgs].
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend fun getNetworkInsightsPath(argument: suspend GetNetworkInsightsPathPlainArgsBuilder.() -> Unit): GetNetworkInsightsPathResult {
        val builder = GetNetworkInsightsPathPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a Network Interface.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const bar = aws.ec2.getNetworkInterface({
     *     id: "eni-01234567",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * bar = aws.ec2.get_network_interface(id="eni-01234567")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bar = Aws.Ec2.GetNetworkInterface.Invoke(new()
     *     {
     *         Id = "eni-01234567",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupNetworkInterface(ctx, &ec2.LookupNetworkInterfaceArgs{
     * 			Id: pulumi.StringRef("eni-01234567"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bar = Ec2Functions.getNetworkInterface(GetNetworkInterfaceArgs.builder()
     *             .id("eni-01234567")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   bar:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInterface
     *       Arguments:
     *         id: eni-01234567
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkInterface.
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend fun getNetworkInterface(argument: GetNetworkInterfacePlainArgs): GetNetworkInterfaceResult =
        getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterface].
     * @param filters One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     * @param id Identifier for the network interface.
     * @param tags Any tags assigned to the network interface.
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend fun getNetworkInterface(
        filters: List<GetNetworkInterfaceFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInterfaceResult {
        val argument = GetNetworkInterfacePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterface].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInterfacePlainArgs].
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend fun getNetworkInterface(argument: suspend GetNetworkInterfacePlainArgsBuilder.() -> Unit): GetNetworkInterfaceResult {
        val builder = GetNetworkInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * The following shows outputting all network interface ids in a region.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.ec2.getNetworkInterfaces({});
     *     return {
     *         example: example.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_interfaces()
     * pulumi.export("example", example.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkInterfaces.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getNetworkInterfacesResult => getNetworkInterfacesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.GetNetworkInterfaces(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example", example.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInterfaces();
     *         ctx.export("example", example.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInterfaces
     *       Arguments: {}
     * outputs:
     *   example: ${example.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * The following example retrieves a list of all network interface ids with a custom tag of `Name` set to a value of `test`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getNetworkInterfaces({
     *     tags: {
     *         Name: "test",
     *     },
     * });
     * export const example1 = example.then(example => example.ids);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_interfaces(tags={
     *     "Name": "test",
     * })
     * pulumi.export("example1", example.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkInterfaces.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Name", "test" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["example1"] = example.Apply(getNetworkInterfacesResult => getNetworkInterfacesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.GetNetworkInterfaces(ctx, &ec2.GetNetworkInterfacesArgs{
     * 			Tags: map[string]interface{}{
     * 				"Name": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example1", example.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInterfaces(GetNetworkInterfacesArgs.builder()
     *             .tags(Map.of("Name", "test"))
     *             .build());
     *         ctx.export("example1", example.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInterfaces
     *       Arguments:
     *         tags:
     *           Name: test
     * outputs:
     *   example1: ${example.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * The following example retrieves a network interface ids which associated
     * with specific subnet.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.ec2.getNetworkInterfaces({
     *         filters: [{
     *             name: "subnet-id",
     *             values: [test&#46;id],
     *         }],
     *     });
     *     return {
     *         example: example.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_network_interfaces(filters=[{
     *     "name": "subnet-id",
     *     "values": [test["id"]],
     * }])
     * pulumi.export("example", example.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetNetworkInterfaces.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetNetworkInterfacesFilterInputArgs
     *             {
     *                 Name = "subnet-id",
     *                 Values = new[]
     *                 {
     *                     test.Id,
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getNetworkInterfacesResult => getNetworkInterfacesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * example, err := ec2.GetNetworkInterfaces(ctx, &ec2.GetNetworkInterfacesArgs{
     * Filters: []ec2.GetNetworkInterfacesFilter{
     * {
     * Name: "subnet-id",
     * Values: interface{}{
     * test.Id,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("example", example.Ids)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInterfaces(GetNetworkInterfacesArgs.builder()
     *             .filters(GetNetworkInterfacesFilterArgs.builder()
     *                 .name("subnet-id")
     *                 .values(test.id())
     *                 .build())
     *             .build());
     *         ctx.export("example", example.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInterfaces
     *       Arguments:
     *         filters:
     *           - name: subnet-id
     *             values:
     *               - ${test.id}
     * outputs:
     *   example: ${example.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNetworkInterfaces.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(argument: GetNetworkInterfacesPlainArgs): GetNetworkInterfacesResult =
        getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterfaces].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired network interfaces.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(
        filters: List<GetNetworkInterfacesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInterfacesResult {
        val argument = GetNetworkInterfacesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInterfacesPlainArgs].
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(argument: suspend GetNetworkInterfacesPlainArgsBuilder.() -> Unit): GetNetworkInterfacesResult {
        val builder = GetNetworkInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getPrefixList` provides details about a specific AWS prefix list (PL)
     * in the current region.
     * This can be used both to validate a prefix list given in a variable
     * and to obtain the CIDR blocks (IP address ranges) for the associated
     * AWS service. The latter may be useful e.g., for adding network ACL
     * rules.
     * The aws.ec2.ManagedPrefixList data source is normally more appropriate to use given it can return customer-managed prefix list info, as well as additional attributes.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const privateS3VpcEndpoint = new aws.ec2.VpcEndpoint("private_s3", {
     *     vpcId: foo.id,
     *     serviceName: "com.amazonaws.us-west-2.s3",
     * });
     * const privateS3 = aws.ec2.getPrefixListOutput({
     *     prefixListId: privateS3VpcEndpoint.prefixListId,
     * });
     * const bar = new aws.ec2.NetworkAcl("bar", {vpcId: foo.id});
     * const privateS3NetworkAclRule = new aws.ec2.NetworkAclRule("private_s3", {
     *     networkAclId: bar.id,
     *     ruleNumber: 200,
     *     egress: false,
     *     protocol: "tcp",
     *     ruleAction: "allow",
     *     cidrBlock: privateS3.apply(privateS3 => privateS3.cidrBlocks?.[0]),
     *     fromPort: 443,
     *     toPort: 443,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * private_s3_vpc_endpoint = aws.ec2.VpcEndpoint("private_s3",
     *     vpc_id=foo["id"],
     *     service_name="com.amazonaws.us-west-2.s3")
     * private_s3 = aws.ec2.get_prefix_list_output(prefix_list_id=private_s3_vpc_endpoint.prefix_list_id)
     * bar = aws.ec2.NetworkAcl("bar", vpc_id=foo["id"])
     * private_s3_network_acl_rule = aws.ec2.NetworkAclRule("private_s3",
     *     network_acl_id=bar.id,
     *     rule_number=200,
     *     egress=False,
     *     protocol="tcp",
     *     rule_action="allow",
     *     cidr_block=private_s3.cidr_blocks[0],
     *     from_port=443,
     *     to_port=443)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var privateS3VpcEndpoint = new Aws.Ec2.VpcEndpoint("private_s3", new()
     *     {
     *         VpcId = foo.Id,
     *         ServiceName = "com.amazonaws.us-west-2.s3",
     *     });
     *     var privateS3 = Aws.Ec2.GetPrefixList.Invoke(new()
     *     {
     *         PrefixListId = privateS3VpcEndpoint.PrefixListId,
     *     });
     *     var bar = new Aws.Ec2.NetworkAcl("bar", new()
     *     {
     *         VpcId = foo.Id,
     *     });
     *     var privateS3NetworkAclRule = new Aws.Ec2.NetworkAclRule("private_s3", new()
     *     {
     *         NetworkAclId = bar.Id,
     *         RuleNumber = 200,
     *         Egress = false,
     *         Protocol = "tcp",
     *         RuleAction = "allow",
     *         CidrBlock = privateS3.Apply(getPrefixListResult => getPrefixListResult.CidrBlocks[0]),
     *         FromPort = 443,
     *         ToPort = 443,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		privateS3VpcEndpoint, err := ec2.NewVpcEndpoint(ctx, "private_s3", &ec2.VpcEndpointArgs{
     * 			VpcId:       pulumi.Any(foo.Id),
     * 			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		privateS3 := ec2.GetPrefixListOutput(ctx, ec2.GetPrefixListOutputArgs{
     * 			PrefixListId: privateS3VpcEndpoint.PrefixListId,
     * 		}, nil)
     * 		bar, err := ec2.NewNetworkAcl(ctx, "bar", &ec2.NetworkAclArgs{
     * 			VpcId: pulumi.Any(foo.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewNetworkAclRule(ctx, "private_s3", &ec2.NetworkAclRuleArgs{
     * 			NetworkAclId: bar.ID(),
     * 			RuleNumber:   pulumi.Int(200),
     * 			Egress:       pulumi.Bool(false),
     * 			Protocol:     pulumi.String("tcp"),
     * 			RuleAction:   pulumi.String("allow"),
     * 			CidrBlock: pulumi.String(privateS3.ApplyT(func(privateS3 ec2.GetPrefixListResult) (*string, error) {
     * 				return &privateS3.CidrBlocks[0], nil
     * 			}).(pulumi.StringPtrOutput)),
     * 			FromPort: pulumi.Int(443),
     * 			ToPort:   pulumi.Int(443),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.VpcEndpoint;
     * import com.pulumi.aws.ec2.VpcEndpointArgs;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPrefixListArgs;
     * import com.pulumi.aws.ec2.NetworkAcl;
     * import com.pulumi.aws.ec2.NetworkAclArgs;
     * import com.pulumi.aws.ec2.NetworkAclRule;
     * import com.pulumi.aws.ec2.NetworkAclRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var privateS3VpcEndpoint = new VpcEndpoint("privateS3VpcEndpoint", VpcEndpointArgs.builder()
     *             .vpcId(foo.id())
     *             .serviceName("com.amazonaws.us-west-2.s3")
     *             .build());
     *         final var privateS3 = Ec2Functions.getPrefixList(GetPrefixListArgs.builder()
     *             .prefixListId(privateS3VpcEndpoint.prefixListId())
     *             .build());
     *         var bar = new NetworkAcl("bar", NetworkAclArgs.builder()
     *             .vpcId(foo.id())
     *             .build());
     *         var privateS3NetworkAclRule = new NetworkAclRule("privateS3NetworkAclRule", NetworkAclRuleArgs.builder()
     *             .networkAclId(bar.id())
     *             .ruleNumber(200)
     *             .egress(false)
     *             .protocol("tcp")
     *             .ruleAction("allow")
     *             .cidrBlock(privateS3.applyValue(getPrefixListResult -> getPrefixListResult).applyValue(privateS3 -> privateS3.applyValue(getPrefixListResult -> getPrefixListResult.cidrBlocks()[0])))
     *             .fromPort(443)
     *             .toPort(443)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   privateS3VpcEndpoint:
     *     type: aws:ec2:VpcEndpoint
     *     name: private_s3
     *     properties:
     *       vpcId: ${foo.id}
     *       serviceName: com.amazonaws.us-west-2.s3
     *   bar:
     *     type: aws:ec2:NetworkAcl
     *     properties:
     *       vpcId: ${foo.id}
     *   privateS3NetworkAclRule:
     *     type: aws:ec2:NetworkAclRule
     *     name: private_s3
     *     properties:
     *       networkAclId: ${bar.id}
     *       ruleNumber: 200
     *       egress: false
     *       protocol: tcp
     *       ruleAction: allow
     *       cidrBlock: ${privateS3.cidrBlocks[0]}
     *       fromPort: 443
     *       toPort: 443
     * variables:
     *   privateS3:
     *     fn::invoke:
     *       Function: aws:ec2:getPrefixList
     *       Arguments:
     *         prefixListId: ${privateS3VpcEndpoint.prefixListId}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getPrefixList({
     *     filters: [{
     *         name: "prefix-list-id",
     *         values: ["pl-68a54001"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_prefix_list(filters=[{
     *     "name": "prefix-list-id",
     *     "values": ["pl-68a54001"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetPrefixList.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetPrefixListFilterInputArgs
     *             {
     *                 Name = "prefix-list-id",
     *                 Values = new[]
     *                 {
     *                     "pl-68a54001",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetPrefixList(ctx, &ec2.GetPrefixListArgs{
     * 			Filters: []ec2.GetPrefixListFilter{
     * 				{
     * 					Name: "prefix-list-id",
     * 					Values: []string{
     * 						"pl-68a54001",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getPrefixList(GetPrefixListArgs.builder()
     *             .filters(GetPrefixListFilterArgs.builder()
     *                 .name("prefix-list-id")
     *                 .values("pl-68a54001")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getPrefixList
     *       Arguments:
     *         filters:
     *           - name: prefix-list-id
     *             values:
     *               - pl-68a54001
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrefixList.
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(argument: GetPrefixListPlainArgs): GetPrefixListResult =
        getPrefixListResultToKotlin(getPrefixListPlain(argument.toJava()).await())

    /**
     * @see [getPrefixList].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param name Name of the prefix list to select.
     * @param prefixListId ID of the prefix list to select.
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(
        filters: List<GetPrefixListFilter>? = null,
        name: String? = null,
        prefixListId: String? = null,
    ): GetPrefixListResult {
        val argument = GetPrefixListPlainArgs(
            filters = filters,
            name = name,
            prefixListId = prefixListId,
        )
        return getPrefixListResultToKotlin(getPrefixListPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefixList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPrefixListPlainArgs].
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(argument: suspend GetPrefixListPlainArgsBuilder.() -> Unit): GetPrefixListResult {
        val builder = GetPrefixListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixListResultToKotlin(getPrefixListPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific AWS EC2 Public IPv4 Pool.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getPublicIpv4Pool({
     *     poolId: "ipv4pool-ec2-000df99cff0c1ec10",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_public_ipv4_pool(pool_id="ipv4pool-ec2-000df99cff0c1ec10")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetPublicIpv4Pool.Invoke(new()
     *     {
     *         PoolId = "ipv4pool-ec2-000df99cff0c1ec10",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetPublicIpv4Pool(ctx, &ec2.GetPublicIpv4PoolArgs{
     * 			PoolId: "ipv4pool-ec2-000df99cff0c1ec10",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getPublicIpv4Pool(GetPublicIpv4PoolArgs.builder()
     *             .poolId("ipv4pool-ec2-000df99cff0c1ec10")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getPublicIpv4Pool
     *       Arguments:
     *         poolId: ipv4pool-ec2-000df99cff0c1ec10
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPublicIpv4Pool.
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend fun getPublicIpv4Pool(argument: GetPublicIpv4PoolPlainArgs): GetPublicIpv4PoolResult =
        getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpv4Pool].
     * @param poolId AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
     * @param tags Any tags for the address pool.
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend fun getPublicIpv4Pool(poolId: String, tags: Map<String, String>? = null): GetPublicIpv4PoolResult {
        val argument = GetPublicIpv4PoolPlainArgs(
            poolId = poolId,
            tags = tags,
        )
        return getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpv4Pool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPublicIpv4PoolPlainArgs].
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend fun getPublicIpv4Pool(argument: suspend GetPublicIpv4PoolPlainArgsBuilder.() -> Unit): GetPublicIpv4PoolResult {
        val builder = GetPublicIpv4PoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for getting information about AWS EC2 Public IPv4 Pools.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Returns all public IPv4 pools.
     * const example = aws.ec2.getPublicIpv4Pools({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Returns all public IPv4 pools.
     * example = aws.ec2.get_public_ipv4_pools()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Returns all public IPv4 pools.
     *     var example = Aws.Ec2.GetPublicIpv4Pools.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Returns all public IPv4 pools.
     * 		_, err := ec2.GetPublicIpv4Pools(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Returns all public IPv4 pools.
     *         final var example = Ec2Functions.getPublicIpv4Pools();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Returns all public IPv4 pools.
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getPublicIpv4Pools
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Usage with Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getPublicIpv4Pools({
     *     filters: [{
     *         name: "tag-key",
     *         values: ["ExampleTagKey"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_public_ipv4_pools(filters=[{
     *     "name": "tag-key",
     *     "values": ["ExampleTagKey"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetPublicIpv4Pools.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetPublicIpv4PoolsFilterInputArgs
     *             {
     *                 Name = "tag-key",
     *                 Values = new[]
     *                 {
     *                     "ExampleTagKey",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetPublicIpv4Pools(ctx, &ec2.GetPublicIpv4PoolsArgs{
     * 			Filters: []ec2.GetPublicIpv4PoolsFilter{
     * 				{
     * 					Name: "tag-key",
     * 					Values: []string{
     * 						"ExampleTagKey",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getPublicIpv4Pools(GetPublicIpv4PoolsArgs.builder()
     *             .filters(GetPublicIpv4PoolsFilterArgs.builder()
     *                 .name("tag-key")
     *                 .values("ExampleTagKey")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getPublicIpv4Pools
     *       Arguments:
     *         filters:
     *           - name: tag-key
     *             values:
     *               - ExampleTagKey
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPublicIpv4Pools.
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend fun getPublicIpv4Pools(argument: GetPublicIpv4PoolsPlainArgs): GetPublicIpv4PoolsResult =
        getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpv4Pools].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired pools.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend fun getPublicIpv4Pools(
        filters: List<GetPublicIpv4PoolsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetPublicIpv4PoolsResult {
        val argument = GetPublicIpv4PoolsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpv4Pools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPublicIpv4PoolsPlainArgs].
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend fun getPublicIpv4Pools(argument: suspend GetPublicIpv4PoolsPlainArgsBuilder.() -> Unit): GetPublicIpv4PoolsResult {
        val builder = GetPublicIpv4PoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Route` provides details about a specific Route.
     * This resource can prove useful when finding the resource associated with a CIDR. For example, finding the peering connection associated with a CIDR value.
     * ## Example Usage
     * The following example shows how one might use a CIDR value to find a network interface id and use this to create a data source of that network interface.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const subnetId = config.requireObject("subnetId");
     * const selected = aws.ec2.getRouteTable({
     *     subnetId: subnetId,
     * });
     * const route = aws.ec2.getRoute({
     *     routeTableId: selectedAwsRouteTable.id,
     *     destinationCidrBlock: "10.0.1.0/24",
     * });
     * const interface = route.then(route => aws.ec2.getNetworkInterface({
     *     id: route.networkInterfaceId,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * subnet_id = config.require_object("subnetId")
     * selected = aws.ec2.get_route_table(subnet_id=subnet_id)
     * route = aws.ec2.get_route(route_table_id=selected_aws_route_table["id"],
     *     destination_cidr_block="10.0.1.0/24")
     * interface = aws.ec2.get_network_interface(id=route.network_interface_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var subnetId = config.RequireObject<dynamic>("subnetId");
     *     var selected = Aws.Ec2.GetRouteTable.Invoke(new()
     *     {
     *         SubnetId = subnetId,
     *     });
     *     var route = Aws.Ec2.GetRoute.Invoke(new()
     *     {
     *         RouteTableId = selectedAwsRouteTable.Id,
     *         DestinationCidrBlock = "10.0.1.0/24",
     *     });
     *     var @interface = Aws.Ec2.GetNetworkInterface.Invoke(new()
     *     {
     *         Id = route.Apply(getRouteResult => getRouteResult.NetworkInterfaceId),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		subnetId := cfg.RequireObject("subnetId")
     * 		_, err := ec2.LookupRouteTable(ctx, &ec2.LookupRouteTableArgs{
     * 			SubnetId: pulumi.StringRef(subnetId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		route, err := ec2.LookupRoute(ctx, &ec2.LookupRouteArgs{
     * 			RouteTableId:         selectedAwsRouteTable.Id,
     * 			DestinationCidrBlock: pulumi.StringRef("10.0.1.0/24"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.LookupNetworkInterface(ctx, &ec2.LookupNetworkInterfaceArgs{
     * 			Id: pulumi.StringRef(route.NetworkInterfaceId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetRouteTableArgs;
     * import com.pulumi.aws.ec2.inputs.GetRouteArgs;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getRouteTable(GetRouteTableArgs.builder()
     *             .subnetId(subnetId)
     *             .build());
     *         final var route = Ec2Functions.getRoute(GetRouteArgs.builder()
     *             .routeTableId(selectedAwsRouteTable.id())
     *             .destinationCidrBlock("10.0.1.0/24")
     *             .build());
     *         final var interface = Ec2Functions.getNetworkInterface(GetNetworkInterfaceArgs.builder()
     *             .id(route.applyValue(getRouteResult -> getRouteResult.networkInterfaceId()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   subnetId:
     *     type: dynamic
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getRouteTable
     *       Arguments:
     *         subnetId: ${subnetId}
     *   route:
     *     fn::invoke:
     *       Function: aws:ec2:getRoute
     *       Arguments:
     *         routeTableId: ${selectedAwsRouteTable.id}
     *         destinationCidrBlock: 10.0.1.0/24
     *   interface:
     *     fn::invoke:
     *       Function: aws:ec2:getNetworkInterface
     *       Arguments:
     *         id: ${route.networkInterfaceId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoute.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: GetRoutePlainArgs): GetRouteResult =
        getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())

    /**
     * @see [getRoute].
     * @param carrierGatewayId EC2 Carrier Gateway ID of the Route belonging to the Route Table.
     * @param coreNetworkArn Core network ARN of the Route belonging to the Route Table.
     * @param destinationCidrBlock CIDR block of the Route belonging to the Route Table.
     * @param destinationIpv6CidrBlock IPv6 CIDR block of the Route belonging to the Route Table.
     * @param destinationPrefixListId ID of a managed prefix list destination of the Route belonging to the Route Table.
     * @param egressOnlyGatewayId Egress Only Gateway ID of the Route belonging to the Route Table.
     * @param gatewayId Gateway ID of the Route belonging to the Route Table.
     * @param instanceId Instance ID of the Route belonging to the Route Table.
     * @param localGatewayId Local Gateway ID of the Route belonging to the Route Table.
     * @param natGatewayId NAT Gateway ID of the Route belonging to the Route Table.
     * @param networkInterfaceId Network Interface ID of the Route belonging to the Route Table.
     * @param routeTableId ID of the specific Route Table containing the Route entry.
     * The following arguments are optional:
     * @param transitGatewayId EC2 Transit Gateway ID of the Route belonging to the Route Table.
     * @param vpcPeeringConnectionId VPC Peering Connection ID of the Route belonging to the Route Table.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(
        carrierGatewayId: String? = null,
        coreNetworkArn: String? = null,
        destinationCidrBlock: String? = null,
        destinationIpv6CidrBlock: String? = null,
        destinationPrefixListId: String? = null,
        egressOnlyGatewayId: String? = null,
        gatewayId: String? = null,
        instanceId: String? = null,
        localGatewayId: String? = null,
        natGatewayId: String? = null,
        networkInterfaceId: String? = null,
        routeTableId: String,
        transitGatewayId: String? = null,
        vpcPeeringConnectionId: String? = null,
    ): GetRouteResult {
        val argument = GetRoutePlainArgs(
            carrierGatewayId = carrierGatewayId,
            coreNetworkArn = coreNetworkArn,
            destinationCidrBlock = destinationCidrBlock,
            destinationIpv6CidrBlock = destinationIpv6CidrBlock,
            destinationPrefixListId = destinationPrefixListId,
            egressOnlyGatewayId = egressOnlyGatewayId,
            gatewayId = gatewayId,
            instanceId = instanceId,
            localGatewayId = localGatewayId,
            natGatewayId = natGatewayId,
            networkInterfaceId = networkInterfaceId,
            routeTableId = routeTableId,
            transitGatewayId = transitGatewayId,
            vpcPeeringConnectionId = vpcPeeringConnectionId,
        )
        return getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRoutePlainArgs].
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: suspend GetRoutePlainArgsBuilder.() -> Unit): GetRouteResult {
        val builder = GetRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteResultToKotlin(getRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.RouteTable` provides details about a specific Route Table.
     * This resource can prove useful when a module accepts a Subnet ID as an input variable and needs to, for example, add a route in the Route Table.
     * ## Example Usage
     * The following example shows how one might accept a Route Table ID as a variable and use this data source to obtain the data necessary to create a route.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const subnetId = config.requireObject("subnetId");
     * const selected = aws.ec2.getRouteTable({
     *     subnetId: subnetId,
     * });
     * const route = new aws.ec2.Route("route", {
     *     routeTableId: selected.then(selected => selected.id),
     *     destinationCidrBlock: "10.0.1.0/22",
     *     vpcPeeringConnectionId: "pcx-45ff3dc1",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * subnet_id = config.require_object("subnetId")
     * selected = aws.ec2.get_route_table(subnet_id=subnet_id)
     * route = aws.ec2.Route("route",
     *     route_table_id=selected.id,
     *     destination_cidr_block="10.0.1.0/22",
     *     vpc_peering_connection_id="pcx-45ff3dc1")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var subnetId = config.RequireObject<dynamic>("subnetId");
     *     var selected = Aws.Ec2.GetRouteTable.Invoke(new()
     *     {
     *         SubnetId = subnetId,
     *     });
     *     var route = new Aws.Ec2.Route("route", new()
     *     {
     *         RouteTableId = selected.Apply(getRouteTableResult => getRouteTableResult.Id),
     *         DestinationCidrBlock = "10.0.1.0/22",
     *         VpcPeeringConnectionId = "pcx-45ff3dc1",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		subnetId := cfg.RequireObject("subnetId")
     * 		selected, err := ec2.LookupRouteTable(ctx, &ec2.LookupRouteTableArgs{
     * 			SubnetId: pulumi.StringRef(subnetId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewRoute(ctx, "route", &ec2.RouteArgs{
     * 			RouteTableId:           pulumi.String(selected.Id),
     * 			DestinationCidrBlock:   pulumi.String("10.0.1.0/22"),
     * 			VpcPeeringConnectionId: pulumi.String("pcx-45ff3dc1"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetRouteTableArgs;
     * import com.pulumi.aws.ec2.Route;
     * import com.pulumi.aws.ec2.RouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getRouteTable(GetRouteTableArgs.builder()
     *             .subnetId(subnetId)
     *             .build());
     *         var route = new Route("route", RouteArgs.builder()
     *             .routeTableId(selected.applyValue(getRouteTableResult -> getRouteTableResult.id()))
     *             .destinationCidrBlock("10.0.1.0/22")
     *             .vpcPeeringConnectionId("pcx-45ff3dc1")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   subnetId:
     *     type: dynamic
     * resources:
     *   route:
     *     type: aws:ec2:Route
     *     properties:
     *       routeTableId: ${selected.id}
     *       destinationCidrBlock: 10.0.1.0/22
     *       vpcPeeringConnectionId: pcx-45ff3dc1
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getRouteTable
     *       Arguments:
     *         subnetId: ${subnetId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTable.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: GetRouteTablePlainArgs): GetRouteTableResult =
        getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getRouteTable].
     * @param filters Configuration block. Detailed below.
     * @param gatewayId ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
     * @param routeTableId ID of the specific Route Table to retrieve.
     * @param subnetId ID of a Subnet which is connected to the Route Table (not exported if not passed as a parameter).
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Route Table.
     * @param vpcId ID of the VPC that the desired Route Table belongs to.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(
        filters: List<GetRouteTableFilter>? = null,
        gatewayId: String? = null,
        routeTableId: String? = null,
        subnetId: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetRouteTableResult {
        val argument = GetRouteTablePlainArgs(
            filters = filters,
            gatewayId = gatewayId,
            routeTableId = routeTableId,
            subnetId = subnetId,
            tags = tags,
            vpcId = vpcId,
        )
        return getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRouteTablePlainArgs].
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: suspend GetRouteTablePlainArgsBuilder.() -> Unit): GetRouteTableResult {
        val builder = GetRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableResultToKotlin(getRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of route table ids to be referenced elsewhere.
     * ## Example Usage
     * The following adds a route for a particular cidr block to every (private
     * kops) route table in a specified vpc to use a particular vpc peering
     * connection.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const rts = await aws.ec2.getRouteTables({
     *         vpcId: vpcId,
     *         filters: [{
     *             name: "tag:kubernetes.io/kops/role",
     *             values: ["private*"],
     *         }],
     *     });
     *     const r: aws.ec2.Route[] = [];
     *     for (const range = {value: 0}; range.value < rts.ids.length; range.value++) {
     *         r.push(new aws.ec2.Route(`r-${range.value}`, {
     *             routeTableId: rts.ids[range&#46;value],
     *             destinationCidrBlock: "10.0.0.0/22",
     *             vpcPeeringConnectionId: "pcx-0e9a7a9ecd137dc54",
     *         }));
     *     }
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * rts = aws.ec2.get_route_tables(vpc_id=vpc_id,
     *     filters=[{
     *         "name": "tag:kubernetes.io/kops/role",
     *         "values": ["private*"],
     *     }])
     * r = []
     * for range in [{"value": i} for i in range(0, len(rts&#46;ids))]:
     *     r.append(aws.ec2.Route(f"r-{range['value']}",
     *         route_table_id=rts.ids[range["value"]],
     *         destination_cidr_block="10.0.0.0/22",
     *         vpc_peering_connection_id="pcx-0e9a7a9ecd137dc54"))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Threading.Tasks;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(async() =>
     * {
     *     var rts = await Aws.Ec2.GetRouteTables.InvokeAsync(new()
     *     {
     *         VpcId = vpcId,
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetRouteTablesFilterInputArgs
     *             {
     *                 Name = "tag:kubernetes.io/kops/role",
     *                 Values = new[]
     *                 {
     *                     "private*",
     *                 },
     *             },
     *         },
     *     });
     *     var r = new List<Aws.Ec2.Route>();
     *     for (var rangeIndex = 0; rangeIndex < rts.Ids.Length; rangeIndex++)
     *     {
     *         var range = new { Value = rangeIndex };
     *         r.Add(new Aws.Ec2.Route($"r-{range.Value}", new()
     *         {
     *             RouteTableId = rts.Ids[range&#46;Value],
     *             DestinationCidrBlock = "10.0.0.0/22",
     *             VpcPeeringConnectionId = "pcx-0e9a7a9ecd137dc54",
     *         }));
     *     }
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		rts, err := ec2.GetRouteTables(ctx, &ec2.GetRouteTablesArgs{
     * 			VpcId: pulumi.StringRef(vpcId),
     * 			Filters: []ec2.GetRouteTablesFilter{
     * 				{
     * 					Name: "tag:kubernetes.io/kops/role",
     * 					Values: []string{
     * 						"private*",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		var r []*ec2.Route
     * 		for index := 0; index < int(len(rts.Ids)); index++ {
     * 			key0 := index
     * 			val0 := index
     * 			__res, err := ec2.NewRoute(ctx, fmt.Sprintf("r-%v", key0), &ec2.RouteArgs{
     * 				RouteTableId:           pulumi.String(rts.Ids[val0]),
     * 				DestinationCidrBlock:   pulumi.String("10.0.0.0/22"),
     * 				VpcPeeringConnectionId: pulumi.String("pcx-0e9a7a9ecd137dc54"),
     * 			})
     * 			if err != nil {
     * 				return err
     * 			}
     * 			r = append(r, __res)
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetRouteTablesArgs;
     * import com.pulumi.aws.ec2.Route;
     * import com.pulumi.aws.ec2.RouteArgs;
     * import com.pulumi.codegen.internal.KeyedValue;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var rts = Ec2Functions.getRouteTables(GetRouteTablesArgs.builder()
     *             .vpcId(vpcId)
     *             .filters(GetRouteTablesFilterArgs.builder()
     *                 .name("tag:kubernetes.io/kops/role")
     *                 .values("private*")
     *                 .build())
     *             .build());
     *         for (var i = 0; i < rts.applyValue(getRouteTablesResult -> getRouteTablesResult.ids()).length(); i++) {
     *             new Route("r-" + i, RouteArgs.builder()
     *                 .routeTableId(rts.applyValue(getRouteTablesResult -> getRouteTablesResult.ids())[range&#46;value()])
     *                 .destinationCidrBlock("10.0.0.0/22")
     *                 .vpcPeeringConnectionId("pcx-0e9a7a9ecd137dc54")
     *                 .build());
     * }
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRouteTables.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: GetRouteTablesPlainArgs): GetRouteTablesResult =
        getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getRouteTables].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired route tables.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(
        filters: List<GetRouteTablesFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetRouteTablesResult {
        val argument = GetRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRouteTablesPlainArgs].
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: suspend GetRouteTablesPlainArgsBuilder.() -> Unit): GetRouteTablesResult {
        val builder = GetRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTablesResultToKotlin(getRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.SecurityGroup` provides details about a specific Security Group.
     * This resource can prove useful when a module accepts a Security Group id as
     * an input variable and needs to, for example, determine the id of the
     * VPC that the security group belongs to.
     * ## Example Usage
     * The following example shows how one might accept a Security Group id as a variable
     * and use this data source to obtain the data necessary to create a subnet.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const securityGroupId = config.requireObject("securityGroupId");
     * const selected = aws.ec2.getSecurityGroup({
     *     id: securityGroupId,
     * });
     * const subnet = new aws.ec2.Subnet("subnet", {
     *     vpcId: selected.then(selected => selected.vpcId),
     *     cidrBlock: "10.0.1.0/24",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * security_group_id = config.require_object("securityGroupId")
     * selected = aws.ec2.get_security_group(id=security_group_id)
     * subnet = aws.ec2.Subnet("subnet",
     *     vpc_id=selected.vpc_id,
     *     cidr_block="10.0.1.0/24")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var securityGroupId = config.RequireObject<dynamic>("securityGroupId");
     *     var selected = Aws.Ec2.GetSecurityGroup.Invoke(new()
     *     {
     *         Id = securityGroupId,
     *     });
     *     var subnet = new Aws.Ec2.Subnet("subnet", new()
     *     {
     *         VpcId = selected.Apply(getSecurityGroupResult => getSecurityGroupResult.VpcId),
     *         CidrBlock = "10.0.1.0/24",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		securityGroupId := cfg.RequireObject("securityGroupId")
     * 		selected, err := ec2.LookupSecurityGroup(ctx, &ec2.LookupSecurityGroupArgs{
     * 			Id: pulumi.StringRef(securityGroupId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewSubnet(ctx, "subnet", &ec2.SubnetArgs{
     * 			VpcId:     pulumi.String(selected.VpcId),
     * 			CidrBlock: pulumi.String("10.0.1.0/24"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSecurityGroupArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var securityGroupId = config.get("securityGroupId");
     *         final var selected = Ec2Functions.getSecurityGroup(GetSecurityGroupArgs.builder()
     *             .id(securityGroupId)
     *             .build());
     *         var subnet = new Subnet("subnet", SubnetArgs.builder()
     *             .vpcId(selected.applyValue(getSecurityGroupResult -> getSecurityGroupResult.vpcId()))
     *             .cidrBlock("10.0.1.0/24")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   securityGroupId:
     *     type: dynamic
     * resources:
     *   subnet:
     *     type: aws:ec2:Subnet
     *     properties:
     *       vpcId: ${selected.vpcId}
     *       cidrBlock: 10.0.1.0/24
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getSecurityGroup
     *       Arguments:
     *         id: ${securityGroupId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroup.
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend fun getSecurityGroup(argument: GetSecurityGroupPlainArgs): GetSecurityGroupResult =
        getSecurityGroupResultToKotlin(getSecurityGroupPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroup].
     * @param filters Custom filter block as described below.
     * @param id Id of the specific security group to retrieve.
     * @param name Name of the field to filter by, as defined by
     * [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired security group.
     * @param vpcId Id of the VPC that the desired security group belongs to.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend fun getSecurityGroup(
        filters: List<GetSecurityGroupFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetSecurityGroupResult {
        val argument = GetSecurityGroupPlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
            vpcId = vpcId,
        )
        return getSecurityGroupResultToKotlin(getSecurityGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSecurityGroupPlainArgs].
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend fun getSecurityGroup(argument: suspend GetSecurityGroupPlainArgsBuilder.() -> Unit): GetSecurityGroupResult {
        val builder = GetSecurityGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupResultToKotlin(getSecurityGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs and VPC membership of Security Groups that are created outside this provider.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getSecurityGroups({
     *     tags: {
     *         Application: "k8s",
     *         Environment: "dev",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_security_groups(tags={
     *     "Application": "k8s",
     *     "Environment": "dev",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetSecurityGroups.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Application", "k8s" },
     *             { "Environment", "dev" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetSecurityGroups(ctx, &ec2.GetSecurityGroupsArgs{
     * 			Tags: map[string]interface{}{
     * 				"Application": "k8s",
     * 				"Environment": "dev",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSecurityGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("Application", "k8s"),
     *                 Map.entry("Environment", "dev")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getSecurityGroups
     *       Arguments:
     *         tags:
     *           Application: k8s
     *           Environment: dev
     * ```
     * <!--End PulumiCodeChooser -->
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getSecurityGroups({
     *     filters: [
     *         {
     *             name: "group-name",
     *             values: ["*nodes*"],
     *         },
     *         {
     *             name: "vpc-id",
     *             values: [vpcId],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_security_groups(filters=[
     *     {
     *         "name": "group-name",
     *         "values": ["*nodes*"],
     *     },
     *     {
     *         "name": "vpc-id",
     *         "values": [vpc_id],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetSecurityGroups.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetSecurityGroupsFilterInputArgs
     *             {
     *                 Name = "group-name",
     *                 Values = new[]
     *                 {
     *                     "*nodes*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetSecurityGroupsFilterInputArgs
     *             {
     *                 Name = "vpc-id",
     *                 Values = new[]
     *                 {
     *                     vpcId,
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _, err := ec2.GetSecurityGroups(ctx, &ec2.GetSecurityGroupsArgs{
     * Filters: []ec2.GetSecurityGroupsFilter{
     * {
     * Name: "group-name",
     * Values: []string{
     * "*nodes*",
     * },
     * },
     * {
     * Name: "vpc-id",
     * Values: interface{}{
     * vpcId,
     * },
     * },
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSecurityGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .filters(
     *                 GetSecurityGroupsFilterArgs.builder()
     *                     .name("group-name")
     *                     .values("*nodes*")
     *                     .build(),
     *                 GetSecurityGroupsFilterArgs.builder()
     *                     .name("vpc-id")
     *                     .values(vpcId)
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getSecurityGroups
     *       Arguments:
     *         filters:
     *           - name: group-name
     *             values:
     *               - '*nodes*'
     *           - name: vpc-id
     *             values:
     *               - ${vpcId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityGroups.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(argument: GetSecurityGroupsPlainArgs): GetSecurityGroupsResult =
        getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroups].
     * @param filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     * @param tags Map of tags, each pair of which must exactly match for desired security groups.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(
        filters: List<GetSecurityGroupsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityGroupsResult {
        val argument = GetSecurityGroupsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSecurityGroupsPlainArgs].
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(argument: suspend GetSecurityGroupsPlainArgsBuilder.() -> Unit): GetSecurityGroupsResult {
        val builder = GetSecurityGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ec2.getSerialConsoleAccess({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ec2.get_serial_console_access()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ec2.GetSerialConsoleAccess.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupSerialConsoleAccess(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ec2:getSerialConsoleAccess
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.ec2.getSerialConsoleAccess({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.ec2.get_serial_console_access()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.Ec2.GetSerialConsoleAccess.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupSerialConsoleAccess(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:ec2:getSerialConsoleAccess
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getSerialConsoleAccess.
     */
    public suspend fun getSerialConsoleAccess(): GetSerialConsoleAccessResult =
        getSerialConsoleAccessResultToKotlin(getSerialConsoleAccessPlain().await())

    /**
     * Information about most recent Spot Price for a given EC2 instance.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getSpotPrice({
     *     instanceType: "t3.medium",
     *     availabilityZone: "us-west-2a",
     *     filters: [{
     *         name: "product-description",
     *         values: ["Linux/UNIX"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_spot_price(instance_type="t3.medium",
     *     availability_zone="us-west-2a",
     *     filters=[{
     *         "name": "product-description",
     *         "values": ["Linux/UNIX"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetSpotPrice.Invoke(new()
     *     {
     *         InstanceType = "t3.medium",
     *         AvailabilityZone = "us-west-2a",
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetSpotPriceFilterInputArgs
     *             {
     *                 Name = "product-description",
     *                 Values = new[]
     *                 {
     *                     "Linux/UNIX",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetSpotPrice(ctx, &ec2.GetSpotPriceArgs{
     * 			InstanceType:     pulumi.StringRef("t3.medium"),
     * 			AvailabilityZone: pulumi.StringRef("us-west-2a"),
     * 			Filters: []ec2.GetSpotPriceFilter{
     * 				{
     * 					Name: "product-description",
     * 					Values: []string{
     * 						"Linux/UNIX",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSpotPriceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getSpotPrice(GetSpotPriceArgs.builder()
     *             .instanceType("t3.medium")
     *             .availabilityZone("us-west-2a")
     *             .filters(GetSpotPriceFilterArgs.builder()
     *                 .name("product-description")
     *                 .values("Linux/UNIX")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getSpotPrice
     *       Arguments:
     *         instanceType: t3.medium
     *         availabilityZone: us-west-2a
     *         filters:
     *           - name: product-description
     *             values:
     *               - Linux/UNIX
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSpotPrice.
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(argument: GetSpotPricePlainArgs): GetSpotPriceResult =
        getSpotPriceResultToKotlin(getSpotPricePlain(argument.toJava()).await())

    /**
     * @see [getSpotPrice].
     * @param availabilityZone Availability zone in which to query Spot price information.
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     * @param instanceType Type of instance for which to query Spot Price information.
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(
        availabilityZone: String? = null,
        filters: List<GetSpotPriceFilter>? = null,
        instanceType: String? = null,
    ): GetSpotPriceResult {
        val argument = GetSpotPricePlainArgs(
            availabilityZone = availabilityZone,
            filters = filters,
            instanceType = instanceType,
        )
        return getSpotPriceResultToKotlin(getSpotPricePlain(argument.toJava()).await())
    }

    /**
     * @see [getSpotPrice].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSpotPricePlainArgs].
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(argument: suspend GetSpotPricePlainArgsBuilder.() -> Unit): GetSpotPriceResult {
        val builder = GetSpotPricePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSpotPriceResultToKotlin(getSpotPricePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Subnet` provides details about a specific VPC subnet.
     * This resource can prove useful when a module accepts a subnet ID as an input variable and needs to, for example, determine the ID of the VPC that the subnet belongs to.
     * ## Example Usage
     * The following example shows how one might accept a subnet ID as a variable and use this data source to obtain the data necessary to create a security group that allows connections from hosts in that subnet.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const config = new pulumi.Config();
     * const subnetId = config.requireObject("subnetId");
     * const selected = aws.ec2.getSubnet({
     *     id: subnetId,
     * });
     * const subnet = new aws.ec2.SecurityGroup("subnet", {
     *     vpcId: selected.then(selected => selected.vpcId),
     *     ingress: [{
     *         cidrBlocks: [selected&#46;then(selected => selected&#46;cidrBlock)],
     *         fromPort: 80,
     *         toPort: 80,
     *         protocol: "tcp",
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * config = pulumi.Config()
     * subnet_id = config.require_object("subnetId")
     * selected = aws.ec2.get_subnet(id=subnet_id)
     * subnet = aws.ec2.SecurityGroup("subnet",
     *     vpc_id=selected.vpc_id,
     *     ingress=[{
     *         "cidr_blocks": [selected&#46;cidr_block],
     *         "from_port": 80,
     *         "to_port": 80,
     *         "protocol": "tcp",
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var subnetId = config.RequireObject<dynamic>("subnetId");
     *     var selected = Aws.Ec2.GetSubnet.Invoke(new()
     *     {
     *         Id = subnetId,
     *     });
     *     var subnet = new Aws.Ec2.SecurityGroup("subnet", new()
     *     {
     *         VpcId = selected.Apply(getSubnetResult => getSubnetResult.VpcId),
     *         Ingress = new[]
     *         {
     *             new Aws.Ec2.Inputs.SecurityGroupIngressArgs
     *             {
     *                 CidrBlocks = new[]
     *                 {
     *                     selected.Apply(getSubnetResult => getSubnetResult.CidrBlock),
     *                 },
     *                 FromPort = 80,
     *                 ToPort = 80,
     *                 Protocol = "tcp",
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		subnetId := cfg.RequireObject("subnetId")
     * 		selected, err := ec2.LookupSubnet(ctx, &ec2.LookupSubnetArgs{
     * 			Id: pulumi.StringRef(subnetId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewSecurityGroup(ctx, "subnet", &ec2.SecurityGroupArgs{
     * 			VpcId: pulumi.String(selected.VpcId),
     * 			Ingress: ec2.SecurityGroupIngressArray{
     * 				&ec2.SecurityGroupIngressArgs{
     * 					CidrBlocks: pulumi.StringArray{
     * 						pulumi.String(selected.CidrBlock),
     * 					},
     * 					FromPort: pulumi.Int(80),
     * 					ToPort:   pulumi.Int(80),
     * 					Protocol: pulumi.String("tcp"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSubnetArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getSubnet(GetSubnetArgs.builder()
     *             .id(subnetId)
     *             .build());
     *         var subnet = new SecurityGroup("subnet", SecurityGroupArgs.builder()
     *             .vpcId(selected.applyValue(getSubnetResult -> getSubnetResult.vpcId()))
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .cidrBlocks(selected.applyValue(getSubnetResult -> getSubnetResult.cidrBlock()))
     *                 .fromPort(80)
     *                 .toPort(80)
     *                 .protocol("tcp")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   subnetId:
     *     type: dynamic
     * resources:
     *   subnet:
     *     type: aws:ec2:SecurityGroup
     *     properties:
     *       vpcId: ${selected.vpcId}
     *       ingress:
     *         - cidrBlocks:
     *             - ${selected.cidrBlock}
     *           fromPort: 80
     *           toPort: 80
     *           protocol: tcp
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getSubnet
     *       Arguments:
     *         id: ${subnetId}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter Example
     * If you want to match against tag `Name`, use:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.ec2.getSubnet({
     *     filters: [{
     *         name: "tag:Name",
     *         values: ["yakdriver"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.ec2.get_subnet(filters=[{
     *     "name": "tag:Name",
     *     "values": ["yakdriver"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.Ec2.GetSubnet.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetSubnetFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "yakdriver",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupSubnet(ctx, &ec2.LookupSubnetArgs{
     * 			Filters: []ec2.GetSubnetFilter{
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"yakdriver",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = Ec2Functions.getSubnet(GetSubnetArgs.builder()
     *             .filters(GetSubnetFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("yakdriver")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getSubnet
     *       Arguments:
     *         filters:
     *           - name: tag:Name
     *             values:
     *               - yakdriver
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnet.
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(argument: GetSubnetPlainArgs): GetSubnetResult =
        getSubnetResultToKotlin(getSubnetPlain(argument.toJava()).await())

    /**
     * @see [getSubnet].
     * @param availabilityZone Availability zone where the subnet must reside.
     * @param availabilityZoneId ID of the Availability Zone for the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
     * @param cidrBlock CIDR block of the desired subnet.
     * @param defaultForAz Whether the desired subnet must be the default subnet for its associated availability zone.
     * @param filters Configuration block. Detailed below.
     * @param id ID of the specific subnet to retrieve.
     * @param ipv6CidrBlock IPv6 CIDR block of the desired subnet.
     * @param state State that the desired subnet must have.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired subnet.
     * @param vpcId ID of the VPC that the desired subnet belongs to.
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(
        availabilityZone: String? = null,
        availabilityZoneId: String? = null,
        cidrBlock: String? = null,
        defaultForAz: Boolean? = null,
        filters: List<GetSubnetFilter>? = null,
        id: String? = null,
        ipv6CidrBlock: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetSubnetResult {
        val argument = GetSubnetPlainArgs(
            availabilityZone = availabilityZone,
            availabilityZoneId = availabilityZoneId,
            cidrBlock = cidrBlock,
            defaultForAz = defaultForAz,
            filters = filters,
            id = id,
            ipv6CidrBlock = ipv6CidrBlock,
            state = state,
            tags = tags,
            vpcId = vpcId,
        )
        return getSubnetResultToKotlin(getSubnetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSubnetPlainArgs].
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(argument: suspend GetSubnetPlainArgsBuilder.() -> Unit): GetSubnetResult {
        val builder = GetSubnetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetResultToKotlin(getSubnetPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a set of subnet IDs.
     * @param argument A collection of arguments for invoking getSubnets.
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: GetSubnetsPlainArgs): GetSubnetsResult =
        getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())

    /**
     * @see [getSubnets].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired subnets.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(
        filters: List<GetSubnetsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetSubnetsResult {
        val argument = GetSubnetsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSubnetsPlainArgs].
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: suspend GetSubnetsPlainArgsBuilder.() -> Unit): GetSubnetsResult {
        val builder = GetSubnetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetsResultToKotlin(getSubnetsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Tables, such as their identifiers.
     * ## Example Usage
     * The following shows outputting all Transit Gateway Route Table Ids.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.ec2.getTransitGatewayRouteTables({});
     *     return {
     *         example: example.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_transit_gateway_route_tables()
     * pulumi.export("example", example.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetTransitGatewayRouteTables.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getTransitGatewayRouteTablesResult => getTransitGatewayRouteTablesResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ec2.GetTransitGatewayRouteTables(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example", example.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getTransitGatewayRouteTables();
     *         ctx.export("example", example.applyValue(getTransitGatewayRouteTablesResult -> getTransitGatewayRouteTablesResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getTransitGatewayRouteTables
     *       Arguments: {}
     * outputs:
     *   example: ${example.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTransitGatewayRouteTables.
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend fun getTransitGatewayRouteTables(argument: GetTransitGatewayRouteTablesPlainArgs): GetTransitGatewayRouteTablesResult =
        getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getTransitGatewayRouteTables].
     * @param filters Custom filter block as described below.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired transit gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend fun getTransitGatewayRouteTables(
        filters: List<GetTransitGatewayRouteTablesFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetTransitGatewayRouteTablesResult {
        val argument = GetTransitGatewayRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitGatewayRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetTransitGatewayRouteTablesPlainArgs].
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend fun getTransitGatewayRouteTables(argument: suspend GetTransitGatewayRouteTablesPlainArgsBuilder.() -> Unit): GetTransitGatewayRouteTablesResult {
        val builder = GetTransitGatewayRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Vpc` provides details about a specific VPC.
     * This resource can prove useful when a module accepts a vpc id as
     * an input variable and needs to, for example, determine the CIDR block of that
     * VPC.
     * ## Example Usage
     * The following example shows how one might accept a VPC id as a variable
     * and use this data source to obtain the data necessary to create a subnet
     * within it.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * import * as std from "@pulumi/std";
     * const config = new pulumi.Config();
     * const vpcId = config.requireObject("vpcId");
     * const selected = aws.ec2.getVpc({
     *     id: vpcId,
     * });
     * const example = new aws.ec2.Subnet("example", {
     *     vpcId: selected.then(selected => selected.id),
     *     availabilityZone: "us-west-2a",
     *     cidrBlock: selected.then(selected => std.cidrsubnet({
     *         input: selected.cidrBlock,
     *         newbits: 4,
     *         netnum: 1,
     *     })).then(invoke => invoke.result),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * import pulumi_std as std
     * config = pulumi.Config()
     * vpc_id = config.require_object("vpcId")
     * selected = aws.ec2.get_vpc(id=vpc_id)
     * example = aws.ec2.Subnet("example",
     *     vpc_id=selected.id,
     *     availability_zone="us-west-2a",
     *     cidr_block=std.cidrsubnet(input=selected.cidr_block,
     *         newbits=4,
     *         netnum=1).result)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * using Std = Pulumi.Std;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var vpcId = config.RequireObject<dynamic>("vpcId");
     *     var selected = Aws.Ec2.GetVpc.Invoke(new()
     *     {
     *         Id = vpcId,
     *     });
     *     var example = new Aws.Ec2.Subnet("example", new()
     *     {
     *         VpcId = selected.Apply(getVpcResult => getVpcResult.Id),
     *         AvailabilityZone = "us-west-2a",
     *         CidrBlock = Std.Cidrsubnet.Invoke(new()
     *         {
     *             Input = selected.Apply(getVpcResult => getVpcResult.CidrBlock),
     *             Newbits = 4,
     *             Netnum = 1,
     *         }).Apply(invoke => invoke.Result),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi-std/sdk/go/std"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		vpcId := cfg.RequireObject("vpcId")
     * 		selected, err := ec2.LookupVpc(ctx, &ec2.LookupVpcArgs{
     * 			Id: pulumi.StringRef(vpcId),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		invokeCidrsubnet, err := std.Cidrsubnet(ctx, &std.CidrsubnetArgs{
     * 			Input:   selected.CidrBlock,
     * 			Newbits: 4,
     * 			Netnum:  1,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewSubnet(ctx, "example", &ec2.SubnetArgs{
     * 			VpcId:            pulumi.String(selected.Id),
     * 			AvailabilityZone: pulumi.String("us-west-2a"),
     * 			CidrBlock:        pulumi.String(invokeCidrsubnet.Result),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var vpcId = config.get("vpcId");
     *         final var selected = Ec2Functions.getVpc(GetVpcArgs.builder()
     *             .id(vpcId)
     *             .build());
     *         var example = new Subnet("example", SubnetArgs.builder()
     *             .vpcId(selected.applyValue(getVpcResult -> getVpcResult.id()))
     *             .availabilityZone("us-west-2a")
     *             .cidrBlock(StdFunctions.cidrsubnet(CidrsubnetArgs.builder()
     *                 .input(selected.applyValue(getVpcResult -> getVpcResult.cidrBlock()))
     *                 .newbits(4)
     *                 .netnum(1)
     *                 .build()).result())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   vpcId:
     *     type: dynamic
     * resources:
     *   example:
     *     type: aws:ec2:Subnet
     *     properties:
     *       vpcId: ${selected.id}
     *       availabilityZone: us-west-2a
     *       cidrBlock:
     *         fn::invoke:
     *           Function: std:cidrsubnet
     *           Arguments:
     *             input: ${selected.cidrBlock}
     *             newbits: 4
     *             netnum: 1
     *           Return: result
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getVpc
     *       Arguments:
     *         id: ${vpcId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpc.
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(argument: GetVpcPlainArgs): GetVpcResult =
        getVpcResultToKotlin(getVpcPlain(argument.toJava()).await())

    /**
     * @see [getVpc].
     * @param cidrBlock Cidr block of the desired VPC.
     * @param default Boolean constraint on whether the desired VPC is
     * the default VPC for the region.
     * @param dhcpOptionsId DHCP options id of the desired VPC.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC to retrieve.
     * @param state Current state of the desired VPC.
     * Can be either `"pending"` or `"available"`.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPC.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(
        cidrBlock: String? = null,
        default: Boolean? = null,
        dhcpOptionsId: String? = null,
        filters: List<GetVpcFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcResult {
        val argument = GetVpcPlainArgs(
            cidrBlock = cidrBlock,
            default = default,
            dhcpOptionsId = dhcpOptionsId,
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getVpcResultToKotlin(getVpcPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpc].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPlainArgs].
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(argument: suspend GetVpcPlainArgsBuilder.() -> Unit): GetVpcResult {
        val builder = GetVpcPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcResultToKotlin(getVpcPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an EC2 DHCP Options configuration.
     * ## Example Usage
     * ### Lookup by DHCP Options ID
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getVpcDhcpOptions({
     *     dhcpOptionsId: "dopts-12345678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_vpc_dhcp_options(dhcp_options_id="dopts-12345678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetVpcDhcpOptions.Invoke(new()
     *     {
     *         DhcpOptionsId = "dopts-12345678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupVpcDhcpOptions(ctx, &ec2.LookupVpcDhcpOptionsArgs{
     * 			DhcpOptionsId: pulumi.StringRef("dopts-12345678"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getVpcDhcpOptions(GetVpcDhcpOptionsArgs.builder()
     *             .dhcpOptionsId("dopts-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcDhcpOptions
     *       Arguments:
     *         dhcpOptionsId: dopts-12345678
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Lookup by Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ec2.getVpcDhcpOptions({
     *     filters: [
     *         {
     *             name: "key",
     *             values: ["domain-name"],
     *         },
     *         {
     *             name: "value",
     *             values: ["example&#46;com"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ec2.get_vpc_dhcp_options(filters=[
     *     {
     *         "name": "key",
     *         "values": ["domain-name"],
     *     },
     *     {
     *         "name": "value",
     *         "values": ["example&#46;com"],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Ec2.GetVpcDhcpOptions.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcDhcpOptionsFilterInputArgs
     *             {
     *                 Name = "key",
     *                 Values = new[]
     *                 {
     *                     "domain-name",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcDhcpOptionsFilterInputArgs
     *             {
     *                 Name = "value",
     *                 Values = new[]
     *                 {
     *                     "example.com",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupVpcDhcpOptions(ctx, &ec2.LookupVpcDhcpOptionsArgs{
     * 			Filters: []ec2.GetVpcDhcpOptionsFilter{
     * 				{
     * 					Name: "key",
     * 					Values: []string{
     * 						"domain-name",
     * 					},
     * 				},
     * 				{
     * 					Name: "value",
     * 					Values: []string{
     * 						"example.com",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getVpcDhcpOptions(GetVpcDhcpOptionsArgs.builder()
     *             .filters(
     *                 GetVpcDhcpOptionsFilterArgs.builder()
     *                     .name("key")
     *                     .values("domain-name")
     *                     .build(),
     *                 GetVpcDhcpOptionsFilterArgs.builder()
     *                     .name("value")
     *                     .values("example.com")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcDhcpOptions
     *       Arguments:
     *         filters:
     *           - name: key
     *             values:
     *               - domain-name
     *           - name: value
     *             values:
     *               - example.com
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcDhcpOptions.
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend fun getVpcDhcpOptions(argument: GetVpcDhcpOptionsPlainArgs): GetVpcDhcpOptionsResult =
        getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(argument.toJava()).await())

    /**
     * @see [getVpcDhcpOptions].
     * @param dhcpOptionsId EC2 DHCP Options ID.
     * @param filters List of custom filters as described below.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend fun getVpcDhcpOptions(
        dhcpOptionsId: String? = null,
        filters: List<GetVpcDhcpOptionsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetVpcDhcpOptionsResult {
        val argument = GetVpcDhcpOptionsPlainArgs(
            dhcpOptionsId = dhcpOptionsId,
            filters = filters,
            tags = tags,
        )
        return getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcDhcpOptions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcDhcpOptionsPlainArgs].
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend fun getVpcDhcpOptions(argument: suspend GetVpcDhcpOptionsPlainArgsBuilder.() -> Unit): GetVpcDhcpOptionsResult {
        val builder = GetVpcDhcpOptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Endpoint data source provides details about
     * a specific VPC endpoint.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const s3 = aws.ec2.getVpcEndpoint({
     *     vpcId: foo.id,
     *     serviceName: "com.amazonaws.us-west-2.s3",
     * });
     * const privateS3 = new aws.ec2.VpcEndpointRouteTableAssociation("private_s3", {
     *     vpcEndpointId: s3.then(s3 => s3.id),
     *     routeTableId: _private.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * s3 = aws.ec2.get_vpc_endpoint(vpc_id=foo["id"],
     *     service_name="com.amazonaws.us-west-2.s3")
     * private_s3 = aws.ec2.VpcEndpointRouteTableAssociation("private_s3",
     *     vpc_endpoint_id=s3.id,
     *     route_table_id=private["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var s3 = Aws.Ec2.GetVpcEndpoint.Invoke(new()
     *     {
     *         VpcId = foo.Id,
     *         ServiceName = "com.amazonaws.us-west-2.s3",
     *     });
     *     var privateS3 = new Aws.Ec2.VpcEndpointRouteTableAssociation("private_s3", new()
     *     {
     *         VpcEndpointId = s3.Apply(getVpcEndpointResult => getVpcEndpointResult.Id),
     *         RouteTableId = @private.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		s3, err := ec2.LookupVpcEndpoint(ctx, &ec2.LookupVpcEndpointArgs{
     * 			VpcId:       pulumi.StringRef(foo.Id),
     * 			ServiceName: pulumi.StringRef("com.amazonaws.us-west-2.s3"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewVpcEndpointRouteTableAssociation(ctx, "private_s3", &ec2.VpcEndpointRouteTableAssociationArgs{
     * 			VpcEndpointId: pulumi.String(s3.Id),
     * 			RouteTableId:  pulumi.Any(private.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointArgs;
     * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation;
     * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var s3 = Ec2Functions.getVpcEndpoint(GetVpcEndpointArgs.builder()
     *             .vpcId(foo.id())
     *             .serviceName("com.amazonaws.us-west-2.s3")
     *             .build());
     *         var privateS3 = new VpcEndpointRouteTableAssociation("privateS3", VpcEndpointRouteTableAssociationArgs.builder()
     *             .vpcEndpointId(s3.applyValue(getVpcEndpointResult -> getVpcEndpointResult.id()))
     *             .routeTableId(private_.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   privateS3:
     *     type: aws:ec2:VpcEndpointRouteTableAssociation
     *     name: private_s3
     *     properties:
     *       vpcEndpointId: ${s3.id}
     *       routeTableId: ${private.id}
     * variables:
     *   # Declare the data source
     *   s3:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcEndpoint
     *       Arguments:
     *         vpcId: ${foo.id}
     *         serviceName: com.amazonaws.us-west-2.s3
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpoint.
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(argument: GetVpcEndpointPlainArgs): GetVpcEndpointResult =
        getVpcEndpointResultToKotlin(getVpcEndpointPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpoint].
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC Endpoint to retrieve.
     * @param serviceName Service name of the specific VPC Endpoint to retrieve. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     * @param state State of the specific VPC Endpoint to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the specific VPC Endpoint to retrieve.
     * @param vpcId ID of the VPC in which the specific VPC Endpoint is used.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(
        filters: List<GetVpcEndpointFilter>? = null,
        id: String? = null,
        serviceName: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetVpcEndpointResult {
        val argument = GetVpcEndpointPlainArgs(
            filters = filters,
            id = id,
            serviceName = serviceName,
            state = state,
            tags = tags,
            vpcId = vpcId,
        )
        return getVpcEndpointResultToKotlin(getVpcEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcEndpointPlainArgs].
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(argument: suspend GetVpcEndpointPlainArgsBuilder.() -> Unit): GetVpcEndpointResult {
        val builder = GetVpcEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointResultToKotlin(getVpcEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Endpoint Service data source details about a specific service that
     * can be specified when creating a VPC endpoint within the region configured in the provider.
     * ## Example Usage
     * ### AWS Service
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const s3 = aws.ec2.getVpcEndpointService({
     *     service: "s3",
     *     serviceType: "Gateway",
     * });
     * // Create a VPC
     * const foo = new aws.ec2.Vpc("foo", {cidrBlock: "10.0.0.0/16"});
     * // Create a VPC endpoint
     * const ep = new aws.ec2.VpcEndpoint("ep", {
     *     vpcId: foo.id,
     *     serviceName: s3.then(s3 => s3.serviceName),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * s3 = aws.ec2.get_vpc_endpoint_service(service="s3",
     *     service_type="Gateway")
     * # Create a VPC
     * foo = aws.ec2.Vpc("foo", cidr_block="10.0.0.0/16")
     * # Create a VPC endpoint
     * ep = aws.ec2.VpcEndpoint("ep",
     *     vpc_id=foo.id,
     *     service_name=s3.service_name)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var s3 = Aws.Ec2.GetVpcEndpointService.Invoke(new()
     *     {
     *         Service = "s3",
     *         ServiceType = "Gateway",
     *     });
     *     // Create a VPC
     *     var foo = new Aws.Ec2.Vpc("foo", new()
     *     {
     *         CidrBlock = "10.0.0.0/16",
     *     });
     *     // Create a VPC endpoint
     *     var ep = new Aws.Ec2.VpcEndpoint("ep", new()
     *     {
     *         VpcId = foo.Id,
     *         ServiceName = s3.Apply(getVpcEndpointServiceResult => getVpcEndpointServiceResult.ServiceName),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		s3, err := ec2.LookupVpcEndpointService(ctx, &ec2.LookupVpcEndpointServiceArgs{
     * 			Service:     pulumi.StringRef("s3"),
     * 			ServiceType: pulumi.StringRef("Gateway"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a VPC
     * 		foo, err := ec2.NewVpc(ctx, "foo", &ec2.VpcArgs{
     * 			CidrBlock: pulumi.String("10.0.0.0/16"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a VPC endpoint
     * 		_, err = ec2.NewVpcEndpoint(ctx, "ep", &ec2.VpcEndpointArgs{
     * 			VpcId:       foo.ID(),
     * 			ServiceName: pulumi.String(s3.ServiceName),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import com.pulumi.aws.ec2.VpcEndpoint;
     * import com.pulumi.aws.ec2.VpcEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var s3 = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .service("s3")
     *             .serviceType("Gateway")
     *             .build());
     *         // Create a VPC
     *         var foo = new Vpc("foo", VpcArgs.builder()
     *             .cidrBlock("10.0.0.0/16")
     *             .build());
     *         // Create a VPC endpoint
     *         var ep = new VpcEndpoint("ep", VpcEndpointArgs.builder()
     *             .vpcId(foo.id())
     *             .serviceName(s3.applyValue(getVpcEndpointServiceResult -> getVpcEndpointServiceResult.serviceName()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Create a VPC
     *   foo:
     *     type: aws:ec2:Vpc
     *     properties:
     *       cidrBlock: 10.0.0.0/16
     *   # Create a VPC endpoint
     *   ep:
     *     type: aws:ec2:VpcEndpoint
     *     properties:
     *       vpcId: ${foo.id}
     *       serviceName: ${s3.serviceName}
     * variables:
     *   # Declare the data source
     *   s3:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcEndpointService
     *       Arguments:
     *         service: s3
     *         serviceType: Gateway
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Non-AWS Service
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const custome = aws.ec2.getVpcEndpointService({
     *     serviceName: "com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * custome = aws.ec2.get_vpc_endpoint_service(service_name="com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var custome = Aws.Ec2.GetVpcEndpointService.Invoke(new()
     *     {
     *         ServiceName = "com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupVpcEndpointService(ctx, &ec2.LookupVpcEndpointServiceArgs{
     * 			ServiceName: pulumi.StringRef("com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var custome = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .serviceName("com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   custome:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcEndpointService
     *       Arguments:
     *         serviceName: com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Filter
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getVpcEndpointService({
     *     filters: [{
     *         name: "service-name",
     *         values: ["some-service"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_vpc_endpoint_service(filters=[{
     *     "name": "service-name",
     *     "values": ["some-service"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetVpcEndpointService.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcEndpointServiceFilterInputArgs
     *             {
     *                 Name = "service-name",
     *                 Values = new[]
     *                 {
     *                     "some-service",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.LookupVpcEndpointService(ctx, &ec2.LookupVpcEndpointServiceArgs{
     * 			Filters: []ec2.GetVpcEndpointServiceFilter{
     * 				{
     * 					Name: "service-name",
     * 					Values: []string{
     * 						"some-service",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .filters(GetVpcEndpointServiceFilterArgs.builder()
     *                 .name("service-name")
     *                 .values("some-service")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcEndpointService
     *       Arguments:
     *         filters:
     *           - name: service-name
     *             values:
     *               - some-service
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointService.
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend fun getVpcEndpointService(argument: GetVpcEndpointServicePlainArgs): GetVpcEndpointServiceResult =
        getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointService].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param service Common name of an AWS service (e.g., `s3`).
     * @param serviceName Service name that is specified when creating a VPC endpoint. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     * @param serviceType Service type, `Gateway` or `Interface`.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired VPC Endpoint Service.
     * > **NOTE:** Specifying `service` will not work for non-AWS services or AWS services that don't follow the standard `service_name` pattern of `com.amazonaws.<region>.<service>`.
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend fun getVpcEndpointService(
        filters: List<GetVpcEndpointServiceFilter>? = null,
        service: String? = null,
        serviceName: String? = null,
        serviceType: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcEndpointServiceResult {
        val argument = GetVpcEndpointServicePlainArgs(
            filters = filters,
            service = service,
            serviceName = serviceName,
            serviceType = serviceType,
            tags = tags,
        )
        return getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcEndpointServicePlainArgs].
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend fun getVpcEndpointService(argument: suspend GetVpcEndpointServicePlainArgsBuilder.() -> Unit): GetVpcEndpointServiceResult {
        val builder = GetVpcEndpointServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.VpcIpamPool` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was created in another root
     * module and you need the pool's id as an input variable. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * The following example shows an account that has only 1 pool, perhaps shared
     * via RAM, and using that pool id to create a VPC with a CIDR derived from
     * AWS IPAM.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getVpcIpamPool({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*test*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * const testVpc = new aws.ec2.Vpc("test", {
     *     ipv4IpamPoolId: test.then(test => test.id),
     *     ipv4NetmaskLength: 28,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_vpc_ipam_pool(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*test*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * test_vpc = aws.ec2.Vpc("test",
     *     ipv4_ipam_pool_id=test.id,
     *     ipv4_netmask_length=28)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetVpcIpamPool.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*test*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     *     var testVpc = new Aws.Ec2.Vpc("test", new()
     *     {
     *         Ipv4IpamPoolId = test.Apply(getVpcIpamPoolResult => getVpcIpamPoolResult.Id),
     *         Ipv4NetmaskLength = 28,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		test, err := ec2.LookupVpcIpamPool(ctx, &ec2.LookupVpcIpamPoolArgs{
     * 			Filters: []ec2.GetVpcIpamPoolFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*test*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewVpc(ctx, "test", &ec2.VpcArgs{
     * 			Ipv4IpamPoolId:    pulumi.String(test.Id),
     * 			Ipv4NetmaskLength: pulumi.Int(28),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
     *             .ipv4IpamPoolId(test.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .ipv4NetmaskLength(28)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testVpc:
     *     type: aws:ec2:Vpc
     *     name: test
     *     properties:
     *       ipv4IpamPoolId: ${test.id}
     *       ipv4NetmaskLength: 28
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPool
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*test*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIamPool.
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(argument: GetVpcIamPoolPlainArgs): GetVpcIamPoolResult =
        getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPool].
     * @param allocationResourceTags Tags that are required to create resources in using this pool.
     * @param filters Custom filter block as described below.
     * @param id ID of the IPAM pool.
     * @param ipamPoolId ID of the IPAM pool you would like information on.
     * @param tags Map of tags to assigned to the resource.
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(
        allocationResourceTags: Map<String, String>? = null,
        filters: List<GetVpcIamPoolFilter>? = null,
        id: String? = null,
        ipamPoolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcIamPoolResult {
        val argument = GetVpcIamPoolPlainArgs(
            allocationResourceTags = allocationResourceTags,
            filters = filters,
            id = id,
            ipamPoolId = ipamPoolId,
            tags = tags,
        )
        return getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolPlainArgs].
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(argument: suspend GetVpcIamPoolPlainArgsBuilder.() -> Unit): GetVpcIamPoolResult {
        val builder = GetVpcIamPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPoolCidrs` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was shared to your account and you want to know all (or a filtered list) of the CIDRs that are provisioned into the pool.
     * ## Example Usage
     * Basic usage:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const p = aws.ec2.getVpcIpamPool({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*mypool*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * const c = p.then(p => aws.ec2.getVpcIpamPoolCidrs({
     *     ipamPoolId: p.id,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * p = aws.ec2.get_vpc_ipam_pool(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*mypool*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * c = aws.ec2.get_vpc_ipam_pool_cidrs(ipam_pool_id=p.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var p = Aws.Ec2.GetVpcIpamPool.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*mypool*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     *     var c = Aws.Ec2.GetVpcIpamPoolCidrs.Invoke(new()
     *     {
     *         IpamPoolId = p.Apply(getVpcIpamPoolResult => getVpcIpamPoolResult.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		p, err := ec2.LookupVpcIpamPool(ctx, &ec2.LookupVpcIpamPoolArgs{
     * 			Filters: []ec2.GetVpcIpamPoolFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*mypool*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.GetVpcIpamPoolCidrs(ctx, &ec2.GetVpcIpamPoolCidrsArgs{
     * 			IpamPoolId: p.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var p = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*mypool*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         final var c = Ec2Functions.getVpcIpamPoolCidrs(GetVpcIpamPoolCidrsArgs.builder()
     *             .ipamPoolId(p.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   c:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPoolCidrs
     *       Arguments:
     *         ipamPoolId: ${p.id}
     *   p:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPool
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*mypool*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * Filtering:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const c = aws.ec2.getVpcIpamPoolCidrs({
     *     ipamPoolId: "ipam-pool-123",
     *     filters: [{
     *         name: "cidr",
     *         values: ["10&#46;*"],
     *     }],
     * });
     * const mycidrs = c.then(c => .filter(cidr => cidr.state == "provisioned").map(cidr => (cidr.cidr)));
     * const pls = new aws.ec2.ManagedPrefixList("pls", {
     *     entries: mycidrs.map((v, k) => ({key: k, value: v})).then(entries => entries.map(entry => ({
     *         cidr: entry.value,
     *         description: entry.value,
     *     }))),
     *     name: `IPAM Pool (${test.id}) Cidrs`,
     *     addressFamily: "IPv4",
     *     maxEntries: mycidrs.length,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * c = aws.ec2.get_vpc_ipam_pool_cidrs(ipam_pool_id="ipam-pool-123",
     *     filters=[{
     *         "name": "cidr",
     *         "values": ["10&#46;*"],
     *     }])
     * mycidrs = [cidr&#46;cidr for cidr in c&#46;ipam_pool_cidrs if cidr&#46;state == "provisioned"]
     * pls = aws.ec2.ManagedPrefixList("pls",
     *     entries=[{
     *         "cidr": entry["value"],
     *         "description": entry["value"],
     *     } for entry in [{"key": k, "value": v} for k, v in mycidrs]],
     *     name=f"IPAM Pool ({test['id']}) Cidrs",
     *     address_family="IPv4",
     *     max_entries=len(mycidrs))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var c = Aws.Ec2.GetVpcIpamPoolCidrs.Invoke(new()
     *     {
     *         IpamPoolId = "ipam-pool-123",
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolCidrsFilterInputArgs
     *             {
     *                 Name = "cidr",
     *                 Values = new[]
     *                 {
     *                     "10.*",
     *                 },
     *             },
     *         },
     *     });
     *     var mycidrs = .Where(cidr => cidr.State == "provisioned").Select(cidr =>
     *     {
     *         return cidr.Cidr;
     *     }).ToList();
     *     var pls = new Aws.Ec2.ManagedPrefixList("pls", new()
     *     {
     *         Entries = mycidrs.Select((v, k) => new { Key = k, Value = v }).Apply(entries => entries.Select(entry =>
     *         {
     *             return
     *             {
     *                 { "cidr", entry.Value },
     *                 { "description", entry.Value },
     *             };
     *         }).ToList()),
     *         Name = $"IPAM Pool ({test.Id}) Cidrs",
     *         AddressFamily = "IPv4",
     *         MaxEntries = mycidrs.Length,
     *     });
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIamPoolCidrs.
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend fun getVpcIamPoolCidrs(argument: GetVpcIamPoolCidrsPlainArgs): GetVpcIamPoolCidrsResult =
        getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPoolCidrs].
     * @param filters Custom filter block as described below.
     * @param ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend fun getVpcIamPoolCidrs(
        filters: List<GetVpcIamPoolCidrsFilter>? = null,
        ipamPoolId: String,
    ): GetVpcIamPoolCidrsResult {
        val argument = GetVpcIamPoolCidrsPlainArgs(
            filters = filters,
            ipamPoolId = ipamPoolId,
        )
        return getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPoolCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolCidrsPlainArgs].
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend fun getVpcIamPoolCidrs(argument: suspend GetVpcIamPoolCidrsPlainArgsBuilder.() -> Unit): GetVpcIamPoolCidrsResult {
        val builder = GetVpcIamPoolCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPools` provides details about IPAM pools.
     * This resource can prove useful when IPAM pools are created in another root
     * module and you need the pool ids as input variables. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getVpcIpamPools({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*test*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_vpc_ipam_pools(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*test*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetVpcIpamPools.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolsFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*test*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolsFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetVpcIpamPools(ctx, &ec2.GetVpcIpamPoolsArgs{
     * 			Filters: []ec2.GetVpcIpamPoolsFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*test*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPools(GetVpcIpamPoolsArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPools
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*test*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIamPools.
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(argument: GetVpcIamPoolsPlainArgs): GetVpcIamPoolsResult =
        getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPools].
     * @param filters Custom filter block as described below.
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(filters: List<GetVpcIamPoolsFilter>? = null): GetVpcIamPoolsResult {
        val argument = GetVpcIamPoolsPlainArgs(
            filters = filters,
        )
        return getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolsPlainArgs].
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(argument: suspend GetVpcIamPoolsPlainArgsBuilder.() -> Unit): GetVpcIamPoolsResult {
        val builder = GetVpcIamPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.VpcIpamPool` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was created in another root
     * module and you need the pool's id as an input variable. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * The following example shows an account that has only 1 pool, perhaps shared
     * via RAM, and using that pool id to create a VPC with a CIDR derived from
     * AWS IPAM.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getVpcIpamPool({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*test*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * const testVpc = new aws.ec2.Vpc("test", {
     *     ipv4IpamPoolId: test.then(test => test.id),
     *     ipv4NetmaskLength: 28,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_vpc_ipam_pool(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*test*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * test_vpc = aws.ec2.Vpc("test",
     *     ipv4_ipam_pool_id=test.id,
     *     ipv4_netmask_length=28)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetVpcIpamPool.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*test*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     *     var testVpc = new Aws.Ec2.Vpc("test", new()
     *     {
     *         Ipv4IpamPoolId = test.Apply(getVpcIpamPoolResult => getVpcIpamPoolResult.Id),
     *         Ipv4NetmaskLength = 28,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		test, err := ec2.LookupVpcIpamPool(ctx, &ec2.LookupVpcIpamPoolArgs{
     * 			Filters: []ec2.GetVpcIpamPoolFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*test*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewVpc(ctx, "test", &ec2.VpcArgs{
     * 			Ipv4IpamPoolId:    pulumi.String(test.Id),
     * 			Ipv4NetmaskLength: pulumi.Int(28),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
     *             .ipv4IpamPoolId(test.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .ipv4NetmaskLength(28)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testVpc:
     *     type: aws:ec2:Vpc
     *     name: test
     *     properties:
     *       ipv4IpamPoolId: ${test.id}
     *       ipv4NetmaskLength: 28
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPool
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*test*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIpamPool.
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(argument: GetVpcIpamPoolPlainArgs): GetVpcIpamPoolResult =
        getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPool].
     * @param allocationResourceTags Tags that are required to create resources in using this pool.
     * @param filters Custom filter block as described below.
     * @param id ID of the IPAM pool.
     * @param ipamPoolId ID of the IPAM pool you would like information on.
     * @param tags Map of tags to assigned to the resource.
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(
        allocationResourceTags: Map<String, String>? = null,
        filters: List<GetVpcIpamPoolFilter>? = null,
        id: String? = null,
        ipamPoolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcIpamPoolResult {
        val argument = GetVpcIpamPoolPlainArgs(
            allocationResourceTags = allocationResourceTags,
            filters = filters,
            id = id,
            ipamPoolId = ipamPoolId,
            tags = tags,
        )
        return getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolPlainArgs].
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(argument: suspend GetVpcIpamPoolPlainArgsBuilder.() -> Unit): GetVpcIpamPoolResult {
        val builder = GetVpcIpamPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPoolCidrs` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was shared to your account and you want to know all (or a filtered list) of the CIDRs that are provisioned into the pool.
     * ## Example Usage
     * Basic usage:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const p = aws.ec2.getVpcIpamPool({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*mypool*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * const c = p.then(p => aws.ec2.getVpcIpamPoolCidrs({
     *     ipamPoolId: p.id,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * p = aws.ec2.get_vpc_ipam_pool(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*mypool*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * c = aws.ec2.get_vpc_ipam_pool_cidrs(ipam_pool_id=p.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var p = Aws.Ec2.GetVpcIpamPool.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*mypool*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     *     var c = Aws.Ec2.GetVpcIpamPoolCidrs.Invoke(new()
     *     {
     *         IpamPoolId = p.Apply(getVpcIpamPoolResult => getVpcIpamPoolResult.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		p, err := ec2.LookupVpcIpamPool(ctx, &ec2.LookupVpcIpamPoolArgs{
     * 			Filters: []ec2.GetVpcIpamPoolFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*mypool*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.GetVpcIpamPoolCidrs(ctx, &ec2.GetVpcIpamPoolCidrsArgs{
     * 			IpamPoolId: p.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolCidrsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var p = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*mypool*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         final var c = Ec2Functions.getVpcIpamPoolCidrs(GetVpcIpamPoolCidrsArgs.builder()
     *             .ipamPoolId(p.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   c:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPoolCidrs
     *       Arguments:
     *         ipamPoolId: ${p.id}
     *   p:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPool
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*mypool*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * Filtering:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const c = aws.ec2.getVpcIpamPoolCidrs({
     *     ipamPoolId: "ipam-pool-123",
     *     filters: [{
     *         name: "cidr",
     *         values: ["10&#46;*"],
     *     }],
     * });
     * const mycidrs = c.then(c => .filter(cidr => cidr.state == "provisioned").map(cidr => (cidr.cidr)));
     * const pls = new aws.ec2.ManagedPrefixList("pls", {
     *     entries: mycidrs.map((v, k) => ({key: k, value: v})).then(entries => entries.map(entry => ({
     *         cidr: entry.value,
     *         description: entry.value,
     *     }))),
     *     name: `IPAM Pool (${test.id}) Cidrs`,
     *     addressFamily: "IPv4",
     *     maxEntries: mycidrs.length,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * c = aws.ec2.get_vpc_ipam_pool_cidrs(ipam_pool_id="ipam-pool-123",
     *     filters=[{
     *         "name": "cidr",
     *         "values": ["10&#46;*"],
     *     }])
     * mycidrs = [cidr&#46;cidr for cidr in c&#46;ipam_pool_cidrs if cidr&#46;state == "provisioned"]
     * pls = aws.ec2.ManagedPrefixList("pls",
     *     entries=[{
     *         "cidr": entry["value"],
     *         "description": entry["value"],
     *     } for entry in [{"key": k, "value": v} for k, v in mycidrs]],
     *     name=f"IPAM Pool ({test['id']}) Cidrs",
     *     address_family="IPv4",
     *     max_entries=len(mycidrs))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var c = Aws.Ec2.GetVpcIpamPoolCidrs.Invoke(new()
     *     {
     *         IpamPoolId = "ipam-pool-123",
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolCidrsFilterInputArgs
     *             {
     *                 Name = "cidr",
     *                 Values = new[]
     *                 {
     *                     "10.*",
     *                 },
     *             },
     *         },
     *     });
     *     var mycidrs = .Where(cidr => cidr.State == "provisioned").Select(cidr =>
     *     {
     *         return cidr.Cidr;
     *     }).ToList();
     *     var pls = new Aws.Ec2.ManagedPrefixList("pls", new()
     *     {
     *         Entries = mycidrs.Select((v, k) => new { Key = k, Value = v }).Apply(entries => entries.Select(entry =>
     *         {
     *             return
     *             {
     *                 { "cidr", entry.Value },
     *                 { "description", entry.Value },
     *             };
     *         }).ToList()),
     *         Name = $"IPAM Pool ({test.Id}) Cidrs",
     *         AddressFamily = "IPv4",
     *         MaxEntries = mycidrs.Length,
     *     });
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIpamPoolCidrs.
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend fun getVpcIpamPoolCidrs(argument: GetVpcIpamPoolCidrsPlainArgs): GetVpcIpamPoolCidrsResult =
        getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPoolCidrs].
     * @param filters Custom filter block as described below.
     * @param ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend fun getVpcIpamPoolCidrs(
        filters: List<GetVpcIpamPoolCidrsFilter>? = null,
        ipamPoolId: String,
    ): GetVpcIpamPoolCidrsResult {
        val argument = GetVpcIpamPoolCidrsPlainArgs(
            filters = filters,
            ipamPoolId = ipamPoolId,
        )
        return getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPoolCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolCidrsPlainArgs].
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend fun getVpcIpamPoolCidrs(argument: suspend GetVpcIpamPoolCidrsPlainArgsBuilder.() -> Unit): GetVpcIpamPoolCidrsResult {
        val builder = GetVpcIpamPoolCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPools` provides details about IPAM pools.
     * This resource can prove useful when IPAM pools are created in another root
     * module and you need the pool ids as input variables. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.ec2.getVpcIpamPools({
     *     filters: [
     *         {
     *             name: "description",
     *             values: ["*test*"],
     *         },
     *         {
     *             name: "address-family",
     *             values: ["ipv4"],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.ec2.get_vpc_ipam_pools(filters=[
     *     {
     *         "name": "description",
     *         "values": ["*test*"],
     *     },
     *     {
     *         "name": "address-family",
     *         "values": ["ipv4"],
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Ec2.GetVpcIpamPools.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolsFilterInputArgs
     *             {
     *                 Name = "description",
     *                 Values = new[]
     *                 {
     *                     "*test*",
     *                 },
     *             },
     *             new Aws.Ec2.Inputs.GetVpcIpamPoolsFilterInputArgs
     *             {
     *                 Name = "address-family",
     *                 Values = new[]
     *                 {
     *                     "ipv4",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ec2.GetVpcIpamPools(ctx, &ec2.GetVpcIpamPoolsArgs{
     * 			Filters: []ec2.GetVpcIpamPoolsFilter{
     * 				{
     * 					Name: "description",
     * 					Values: []string{
     * 						"*test*",
     * 					},
     * 				},
     * 				{
     * 					Name: "address-family",
     * 					Values: []string{
     * 						"ipv4",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPools(GetVpcIpamPoolsArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcIpamPools
     *       Arguments:
     *         filters:
     *           - name: description
     *             values:
     *               - '*test*'
     *           - name: address-family
     *             values:
     *               - ipv4
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcIpamPools.
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(argument: GetVpcIpamPoolsPlainArgs): GetVpcIpamPoolsResult =
        getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPools].
     * @param filters Custom filter block as described below.
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(filters: List<GetVpcIpamPoolsFilter>? = null): GetVpcIpamPoolsResult {
        val argument = GetVpcIpamPoolsPlainArgs(
            filters = filters,
        )
        return getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolsPlainArgs].
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(argument: suspend GetVpcIpamPoolsPlainArgsBuilder.() -> Unit): GetVpcIpamPoolsResult {
        val builder = GetVpcIpamPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Peering Connection data source provides details about
     * a specific VPC peering connection.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const pc = aws.ec2.getVpcPeeringConnection({
     *     vpcId: foo.id,
     *     peerCidrBlock: "10.0.1.0/22",
     * });
     * // Create a route table
     * const rt = new aws.ec2.RouteTable("rt", {vpcId: foo.id});
     * // Create a route
     * const r = new aws.ec2.Route("r", {
     *     routeTableId: rt.id,
     *     destinationCidrBlock: pc.then(pc => pc.peerCidrBlock),
     *     vpcPeeringConnectionId: pc.then(pc => pc.id),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * pc = aws.ec2.get_vpc_peering_connection(vpc_id=foo["id"],
     *     peer_cidr_block="10.0.1.0/22")
     * # Create a route table
     * rt = aws.ec2.RouteTable("rt", vpc_id=foo["id"])
     * # Create a route
     * r = aws.ec2.Route("r",
     *     route_table_id=rt.id,
     *     destination_cidr_block=pc.peer_cidr_block,
     *     vpc_peering_connection_id=pc.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var pc = Aws.Ec2.GetVpcPeeringConnection.Invoke(new()
     *     {
     *         VpcId = foo.Id,
     *         PeerCidrBlock = "10.0.1.0/22",
     *     });
     *     // Create a route table
     *     var rt = new Aws.Ec2.RouteTable("rt", new()
     *     {
     *         VpcId = foo.Id,
     *     });
     *     // Create a route
     *     var r = new Aws.Ec2.Route("r", new()
     *     {
     *         RouteTableId = rt.Id,
     *         DestinationCidrBlock = pc.Apply(getVpcPeeringConnectionResult => getVpcPeeringConnectionResult.PeerCidrBlock),
     *         VpcPeeringConnectionId = pc.Apply(getVpcPeeringConnectionResult => getVpcPeeringConnectionResult.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		pc, err := ec2.LookupVpcPeeringConnection(ctx, &ec2.LookupVpcPeeringConnectionArgs{
     * 			VpcId:         pulumi.StringRef(foo.Id),
     * 			PeerCidrBlock: pulumi.StringRef("10.0.1.0/22"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a route table
     * 		rt, err := ec2.NewRouteTable(ctx, "rt", &ec2.RouteTableArgs{
     * 			VpcId: pulumi.Any(foo.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a route
     * 		_, err = ec2.NewRoute(ctx, "r", &ec2.RouteArgs{
     * 			RouteTableId:           rt.ID(),
     * 			DestinationCidrBlock:   pulumi.String(pc.PeerCidrBlock),
     * 			VpcPeeringConnectionId: pulumi.String(pc.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionArgs;
     * import com.pulumi.aws.ec2.RouteTable;
     * import com.pulumi.aws.ec2.RouteTableArgs;
     * import com.pulumi.aws.ec2.Route;
     * import com.pulumi.aws.ec2.RouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var pc = Ec2Functions.getVpcPeeringConnection(GetVpcPeeringConnectionArgs.builder()
     *             .vpcId(foo.id())
     *             .peerCidrBlock("10.0.1.0/22")
     *             .build());
     *         // Create a route table
     *         var rt = new RouteTable("rt", RouteTableArgs.builder()
     *             .vpcId(foo.id())
     *             .build());
     *         // Create a route
     *         var r = new Route("r", RouteArgs.builder()
     *             .routeTableId(rt.id())
     *             .destinationCidrBlock(pc.applyValue(getVpcPeeringConnectionResult -> getVpcPeeringConnectionResult.peerCidrBlock()))
     *             .vpcPeeringConnectionId(pc.applyValue(getVpcPeeringConnectionResult -> getVpcPeeringConnectionResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Create a route table
     *   rt:
     *     type: aws:ec2:RouteTable
     *     properties:
     *       vpcId: ${foo.id}
     *   # Create a route
     *   r:
     *     type: aws:ec2:Route
     *     properties:
     *       routeTableId: ${rt.id}
     *       destinationCidrBlock: ${pc.peerCidrBlock}
     *       vpcPeeringConnectionId: ${pc.id}
     * variables:
     *   # Declare the data source
     *   pc:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcPeeringConnection
     *       Arguments:
     *         vpcId: ${foo.id}
     *         peerCidrBlock: 10.0.1.0/22
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcPeeringConnection.
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend fun getVpcPeeringConnection(argument: GetVpcPeeringConnectionPlainArgs): GetVpcPeeringConnectionResult =
        getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(argument.toJava()).await())

    /**
     * @see [getVpcPeeringConnection].
     * @param cidrBlock Primary CIDR block of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC Peering Connection to retrieve.
     * @param ownerId AWS account ID of the owner of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param peerCidrBlock Primary CIDR block of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerOwnerId AWS account ID of the owner of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerRegion Region of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerVpcId ID of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param region Region of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param status Status of the specific VPC Peering Connection to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId ID of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend fun getVpcPeeringConnection(
        cidrBlock: String? = null,
        filters: List<GetVpcPeeringConnectionFilter>? = null,
        id: String? = null,
        ownerId: String? = null,
        peerCidrBlock: String? = null,
        peerOwnerId: String? = null,
        peerRegion: String? = null,
        peerVpcId: String? = null,
        region: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetVpcPeeringConnectionResult {
        val argument = GetVpcPeeringConnectionPlainArgs(
            cidrBlock = cidrBlock,
            filters = filters,
            id = id,
            ownerId = ownerId,
            peerCidrBlock = peerCidrBlock,
            peerOwnerId = peerOwnerId,
            peerRegion = peerRegion,
            peerVpcId = peerVpcId,
            region = region,
            status = status,
            tags = tags,
            vpcId = vpcId,
        )
        return getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcPeeringConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPeeringConnectionPlainArgs].
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend fun getVpcPeeringConnection(argument: suspend GetVpcPeeringConnectionPlainArgsBuilder.() -> Unit): GetVpcPeeringConnectionResult {
        val builder = GetVpcPeeringConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs of Amazon VPC peering connections
     * To get more details on each connection, use the data resource aws.ec2.VpcPeeringConnection
     * Note: To use this data source in a count, the resources should exist before trying to access
     * the data source.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const pcs = aws.ec2.getVpcPeeringConnections({
     *     filters: [{
     *         name: "requester-vpc-info.vpc-id",
     *         values: [foo&#46;id],
     *     }],
     * });
     * // get the details of each resource
     * const pc = .map(__index => (aws.ec2.getVpcPeeringConnection({
     *     id: _arg0_.ids[__index],
     * })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * pcs = aws.ec2.get_vpc_peering_connections(filters=[{
     *     "name": "requester-vpc-info.vpc-id",
     *     "values": [foo["id"]],
     * }])
     * # get the details of each resource
     * pc = [aws&#46;ec2&#46;get_vpc_peering_connection(id=pcs&#46;ids[__index]) for __index in range(len(pcs&#46;ids))]
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var pcs = Aws.Ec2.GetVpcPeeringConnections.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpcPeeringConnectionsFilterInputArgs
     *             {
     *                 Name = "requester-vpc-info.vpc-id",
     *                 Values = new[]
     *                 {
     *                     foo.Id,
     *                 },
     *             },
     *         },
     *     });
     *     // get the details of each resource
     *     var pc = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcPeeringConnections.
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend fun getVpcPeeringConnections(argument: GetVpcPeeringConnectionsPlainArgs): GetVpcPeeringConnectionsResult =
        getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getVpcPeeringConnections].
     * @param filters Custom filter block as described below.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend fun getVpcPeeringConnections(
        filters: List<GetVpcPeeringConnectionsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetVpcPeeringConnectionsResult {
        val argument = GetVpcPeeringConnectionsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcPeeringConnections].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPeeringConnectionsPlainArgs].
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend fun getVpcPeeringConnections(argument: suspend GetVpcPeeringConnectionsPlainArgsBuilder.() -> Unit): GetVpcPeeringConnectionsResult {
        val builder = GetVpcPeeringConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of VPC Ids for a region.
     * The following example retrieves a list of VPC Ids with a custom tag of `service` set to a value of "production".
     * ## Example Usage
     * The following shows outputting all VPC Ids.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const foo = await aws.ec2.getVpcs({
     *         tags: {
     *             service: "production",
     *         },
     *     });
     *     return {
     *         foo: foo.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_vpcs(tags={
     *     "service": "production",
     * })
     * pulumi.export("foo", foo.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Ec2.GetVpcs.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "service", "production" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["foo"] = foo.Apply(getVpcsResult => getVpcsResult.Ids),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := ec2.GetVpcs(ctx, &ec2.GetVpcsArgs{
     * 			Tags: map[string]interface{}{
     * 				"service": "production",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("foo", foo.Ids)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getVpcs(GetVpcsArgs.builder()
     *             .tags(Map.of("service", "production"))
     *             .build());
     *         ctx.export("foo", foo.applyValue(getVpcsResult -> getVpcsResult.ids()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:ec2:getVpcs
     *       Arguments:
     *         tags:
     *           service: production
     * outputs:
     *   foo: ${foo.ids}
     * ```
     * <!--End PulumiCodeChooser -->
     * An example use case would be interpolate the `aws.ec2.getVpcs` output into `count` of an aws.ec2.FlowLog resource.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const foo = await aws.ec2.getVpcs({});
     *     const fooGetVpc = .map(__index => (await aws.ec2.getVpc({
     *         id: foo.ids[__index],
     *     })));
     *     const testFlowLog: aws.ec2.FlowLog[] = [];
     *     for (const range = {value: 0}; range.value < foo.ids.length; range.value++) {
     *         testFlowLog.push(new aws.ec2.FlowLog(`test_flow_log-${range.value}`, {vpcId: fooGetVpc[range&#46;value].id}));
     *     }
     *     return {
     *         foo: foo.ids,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.ec2.get_vpcs()
     * foo_get_vpc = [aws&#46;ec2&#46;get_vpc(id=foo&#46;ids[__index]) for __index in range(len(foo&#46;ids))]
     * test_flow_log = []
     * for range in [{"value": i} for i in range(0, len(foo&#46;ids))]:
     *     test_flow_log.append(aws.ec2.FlowLog(f"test_flow_log-{range['value']}", vpc_id=foo_get_vpc[range["value"]].id))
     * pulumi.export("foo", foo.ids)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using System.Threading.Tasks;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(async() =>
     * {
     *     var foo = await Aws.Ec2.GetVpcs.InvokeAsync();
     *     var fooGetVpc = ;
     *     var testFlowLog = new List<Aws.Ec2.FlowLog>();
     *     for (var rangeIndex = 0; rangeIndex < foo.Ids.Length; rangeIndex++)
     *     {
     *         var range = new { Value = rangeIndex };
     *         testFlowLog.Add(new Aws.Ec2.FlowLog($"test_flow_log-{range.Value}", new()
     *         {
     *             VpcId = fooGetVpc[range&#46;Value].Id,
     *         }));
     *     }
     *     return new Dictionary<string, object?>
     *     {
     *         ["foo"] = foo.Ids,
     *     };
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcs.
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(argument: GetVpcsPlainArgs): GetVpcsResult =
        getVpcsResultToKotlin(getVpcsPlain(argument.toJava()).await())

    /**
     * @see [getVpcs].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired vpcs.
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(
        filters: List<GetVpcsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetVpcsResult {
        val argument = GetVpcsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getVpcsResultToKotlin(getVpcsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcsPlainArgs].
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(argument: suspend GetVpcsPlainArgsBuilder.() -> Unit): GetVpcsResult {
        val builder = GetVpcsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcsResultToKotlin(getVpcsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPN Gateway data source provides details about
     * a specific VPN gateway.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.ec2.getVpnGateway({
     *     filters: [{
     *         name: "tag:Name",
     *         values: ["vpn-gw"],
     *     }],
     * });
     * export const vpnGatewayId = selected.then(selected => selected.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.ec2.get_vpn_gateway(filters=[{
     *     "name": "tag:Name",
     *     "values": ["vpn-gw"],
     * }])
     * pulumi.export("vpnGatewayId", selected.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.Ec2.GetVpnGateway.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Ec2.Inputs.GetVpnGatewayFilterInputArgs
     *             {
     *                 Name = "tag:Name",
     *                 Values = new[]
     *                 {
     *                     "vpn-gw",
     *                 },
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vpnGatewayId"] = selected.Apply(getVpnGatewayResult => getVpnGatewayResult.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		selected, err := ec2.LookupVpnGateway(ctx, &ec2.LookupVpnGatewayArgs{
     * 			Filters: []ec2.GetVpnGatewayFilter{
     * 				{
     * 					Name: "tag:Name",
     * 					Values: []string{
     * 						"vpn-gw",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("vpnGatewayId", selected.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpnGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = Ec2Functions.getVpnGateway(GetVpnGatewayArgs.builder()
     *             .filters(GetVpnGatewayFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("vpn-gw")
     *                 .build())
     *             .build());
     *         ctx.export("vpnGatewayId", selected.applyValue(getVpnGatewayResult -> getVpnGatewayResult.id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:ec2:getVpnGateway
     *       Arguments:
     *         filters:
     *           - name: tag:Name
     *             values:
     *               - vpn-gw
     * outputs:
     *   vpnGatewayId: ${selected.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpnGateway.
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(argument: GetVpnGatewayPlainArgs): GetVpnGatewayResult =
        getVpnGatewayResultToKotlin(getVpnGatewayPlain(argument.toJava()).await())

    /**
     * @see [getVpnGateway].
     * @param amazonSideAsn Autonomous System Number (ASN) for the Amazon side of the specific VPN Gateway to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param attachedVpcId ID of a VPC attached to the specific VPN Gateway to retrieve.
     * @param availabilityZone Availability Zone of the specific VPN Gateway to retrieve.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPN Gateway to retrieve.
     * @param state State of the specific VPN Gateway to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPN Gateway.
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(
        amazonSideAsn: String? = null,
        attachedVpcId: String? = null,
        availabilityZone: String? = null,
        filters: List<GetVpnGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpnGatewayResult {
        val argument = GetVpnGatewayPlainArgs(
            amazonSideAsn = amazonSideAsn,
            attachedVpcId = attachedVpcId,
            availabilityZone = availabilityZone,
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getVpnGatewayResultToKotlin(getVpnGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpnGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpnGatewayPlainArgs].
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(argument: suspend GetVpnGatewayPlainArgsBuilder.() -> Unit): GetVpnGatewayResult {
        val builder = GetVpnGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpnGatewayResultToKotlin(getVpnGatewayPlain(builtArgument.toJava()).await())
    }
}
