@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EipAssociation].
 */
@PulumiTagMarker
public class EipAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipAssociationArgs = EipAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipAssociationArgsBuilder.() -> Unit) {
        val builder = EipAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EipAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.EipAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EipAssociation(builtJavaResource)
    }
}

/**
 * Provides an AWS EIP Association as a top level resource, to associate and
 * disassociate Elastic IPs from AWS Instances and Network Interfaces.
 * > **NOTE:** Do not use this resource to associate an EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * > **NOTE:** `aws.ec2.EipAssociation` is useful in scenarios where EIPs are either
 * pre-existing or distributed to customers or users and therefore cannot be changed.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const web = new aws.ec2.Instance("web", {
 *     ami: "ami-21f78e11",
 *     availabilityZone: "us-west-2a",
 *     instanceType: aws.ec2.InstanceType.T2_Micro,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * const example = new aws.ec2.Eip("example", {domain: "vpc"});
 * const eipAssoc = new aws.ec2.EipAssociation("eip_assoc", {
 *     instanceId: web.id,
 *     allocationId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * web = aws.ec2.Instance("web",
 *     ami="ami-21f78e11",
 *     availability_zone="us-west-2a",
 *     instance_type=aws.ec2.InstanceType.T2_MICRO,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * example = aws.ec2.Eip("example", domain="vpc")
 * eip_assoc = aws.ec2.EipAssociation("eip_assoc",
 *     instance_id=web.id,
 *     allocation_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var web = new Aws.Ec2.Instance("web", new()
 *     {
 *         Ami = "ami-21f78e11",
 *         AvailabilityZone = "us-west-2a",
 *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 *     var example = new Aws.Ec2.Eip("example", new()
 *     {
 *         Domain = "vpc",
 *     });
 *     var eipAssoc = new Aws.Ec2.EipAssociation("eip_assoc", new()
 *     {
 *         InstanceId = web.Id,
 *         AllocationId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		web, err := ec2.NewInstance(ctx, "web", &ec2.InstanceArgs{
 * 			Ami:              pulumi.String("ami-21f78e11"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			InstanceType:     pulumi.String(ec2.InstanceType_T2_Micro),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewEip(ctx, "example", &ec2.EipArgs{
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewEipAssociation(ctx, "eip_assoc", &ec2.EipAssociationArgs{
 * 			InstanceId:   web.ID(),
 * 			AllocationId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.ec2.EipAssociation;
 * import com.pulumi.aws.ec2.EipAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami("ami-21f78e11")
 *             .availabilityZone("us-west-2a")
 *             .instanceType("t2.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var eipAssoc = new EipAssociation("eipAssoc", EipAssociationArgs.builder()
 *             .instanceId(web.id())
 *             .allocationId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   eipAssoc:
 *     type: aws:ec2:EipAssociation
 *     name: eip_assoc
 *     properties:
 *       instanceId: ${web.id}
 *       allocationId: ${example.id}
 *   web:
 *     type: aws:ec2:Instance
 *     properties:
 *       ami: ami-21f78e11
 *       availabilityZone: us-west-2a
 *       instanceType: t2.micro
 *       tags:
 *         Name: HelloWorld
 *   example:
 *     type: aws:ec2:Eip
 *     properties:
 *       domain: vpc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EIP Assocations using their association IDs. For example:
 * ```sh
 * $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
 * ```
 */
public class EipAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.EipAssociation,
) : KotlinCustomResource(javaResource, EipAssociationMapper) {
    /**
     * The allocation ID. This is required for EC2-VPC.
     */
    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    /**
     * Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    public val allowReassociation: Output<Boolean>?
        get() = javaResource.allowReassociation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * The Elastic IP address. This is required for EC2-Classic.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })
}

public object EipAssociationMapper : ResourceMapper<EipAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.EipAssociation::class == javaResource::class

    override fun map(javaResource: Resource): EipAssociation = EipAssociation(
        javaResource as
            com.pulumi.aws.ec2.EipAssociation,
    )
}

/**
 * @see [EipAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EipAssociation].
 */
public suspend fun eipAssociation(
    name: String,
    block: suspend EipAssociationResourceBuilder.() -> Unit,
): EipAssociation {
    val builder = EipAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EipAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eipAssociation(name: String): EipAssociation {
    val builder = EipAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
