@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.EipAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS EIP Association as a top level resource, to associate and
 * disassociate Elastic IPs from AWS Instances and Network Interfaces.
 * > **NOTE:** Do not use this resource to associate an EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * > **NOTE:** `aws.ec2.EipAssociation` is useful in scenarios where EIPs are either
 * pre-existing or distributed to customers or users and therefore cannot be changed.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const web = new aws.ec2.Instance("web", {
 *     ami: "ami-21f78e11",
 *     availabilityZone: "us-west-2a",
 *     instanceType: aws.ec2.InstanceType.T2_Micro,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * const example = new aws.ec2.Eip("example", {domain: "vpc"});
 * const eipAssoc = new aws.ec2.EipAssociation("eip_assoc", {
 *     instanceId: web.id,
 *     allocationId: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * web = aws.ec2.Instance("web",
 *     ami="ami-21f78e11",
 *     availability_zone="us-west-2a",
 *     instance_type=aws.ec2.InstanceType.T2_MICRO,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * example = aws.ec2.Eip("example", domain="vpc")
 * eip_assoc = aws.ec2.EipAssociation("eip_assoc",
 *     instance_id=web.id,
 *     allocation_id=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var web = new Aws.Ec2.Instance("web", new()
 *     {
 *         Ami = "ami-21f78e11",
 *         AvailabilityZone = "us-west-2a",
 *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 *     var example = new Aws.Ec2.Eip("example", new()
 *     {
 *         Domain = "vpc",
 *     });
 *     var eipAssoc = new Aws.Ec2.EipAssociation("eip_assoc", new()
 *     {
 *         InstanceId = web.Id,
 *         AllocationId = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		web, err := ec2.NewInstance(ctx, "web", &ec2.InstanceArgs{
 * 			Ami:              pulumi.String("ami-21f78e11"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			InstanceType:     pulumi.String(ec2.InstanceType_T2_Micro),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ec2.NewEip(ctx, "example", &ec2.EipArgs{
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewEipAssociation(ctx, "eip_assoc", &ec2.EipAssociationArgs{
 * 			InstanceId:   web.ID(),
 * 			AllocationId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.ec2.EipAssociation;
 * import com.pulumi.aws.ec2.EipAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami("ami-21f78e11")
 *             .availabilityZone("us-west-2a")
 *             .instanceType("t2.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var eipAssoc = new EipAssociation("eipAssoc", EipAssociationArgs.builder()
 *             .instanceId(web.id())
 *             .allocationId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   eipAssoc:
 *     type: aws:ec2:EipAssociation
 *     name: eip_assoc
 *     properties:
 *       instanceId: ${web.id}
 *       allocationId: ${example.id}
 *   web:
 *     type: aws:ec2:Instance
 *     properties:
 *       ami: ami-21f78e11
 *       availabilityZone: us-west-2a
 *       instanceType: t2.micro
 *       tags:
 *         Name: HelloWorld
 *   example:
 *     type: aws:ec2:Eip
 *     properties:
 *       domain: vpc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EIP Assocations using their association IDs. For example:
 * ```sh
 * $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
 * ```
 * @property allocationId The allocation ID. This is required for EC2-VPC.
 * @property allowReassociation Whether to allow an Elastic IP to
 * be re-associated. Defaults to `true` in VPC.
 * @property instanceId The ID of the instance. This is required for
 * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
 * network interface ID, but not both. The operation fails if you specify an
 * instance ID unless exactly one network interface is attached.
 * @property networkInterfaceId The ID of the network interface. If the
 * instance has more than one network interface, you must specify a network
 * interface ID.
 * @property privateIpAddress The primary or secondary private IP address
 * to associate with the Elastic IP address. If no private IP address is
 * specified, the Elastic IP address is associated with the primary private IP
 * address.
 * @property publicIp The Elastic IP address. This is required for EC2-Classic.
 */
public data class EipAssociationArgs(
    public val allocationId: Output<String>? = null,
    public val allowReassociation: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val publicIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.EipAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.EipAssociationArgs =
        com.pulumi.aws.ec2.EipAssociationArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .allowReassociation(allowReassociation?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .publicIp(publicIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipAssociationArgs].
 */
@PulumiTagMarker
public class EipAssociationArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var allowReassociation: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var publicIp: Output<String>? = null

    /**
     * @param value The allocation ID. This is required for EC2-VPC.
     */
    @JvmName("eqfhussjbherbwli")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    @JvmName("cnyvbparcxvhuasb")
    public suspend fun allowReassociation(`value`: Output<Boolean>) {
        this.allowReassociation = value
    }

    /**
     * @param value The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    @JvmName("wrfwsllfotdsfsdj")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    @JvmName("mdbmciwyvuflslml")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    @JvmName("oipcqdxfwoenrmca")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The Elastic IP address. This is required for EC2-Classic.
     */
    @JvmName("uyywdqybqfibnxux")
    public suspend fun publicIp(`value`: Output<String>) {
        this.publicIp = value
    }

    /**
     * @param value The allocation ID. This is required for EC2-VPC.
     */
    @JvmName("rlmqhpetyipaufhj")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    @JvmName("inulttqtkygkmpsm")
    public suspend fun allowReassociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowReassociation = mapped
    }

    /**
     * @param value The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    @JvmName("fqnqnkspiuxsyhyx")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    @JvmName("jyppsxdsdiasufbj")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    @JvmName("sawmnlokgiggdgnd")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The Elastic IP address. This is required for EC2-Classic.
     */
    @JvmName("umnvymvlodnvubjr")
    public suspend fun publicIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIp = mapped
    }

    internal fun build(): EipAssociationArgs = EipAssociationArgs(
        allocationId = allocationId,
        allowReassociation = allowReassociation,
        instanceId = instanceId,
        networkInterfaceId = networkInterfaceId,
        privateIpAddress = privateIpAddress,
        publicIp = publicIp,
    )
}
