@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.EipDomainNameTimeouts
import com.pulumi.aws.ec2.kotlin.outputs.EipDomainNameTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EipDomainName].
 */
@PulumiTagMarker
public class EipDomainNameResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipDomainNameArgs = EipDomainNameArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipDomainNameArgsBuilder.() -> Unit) {
        val builder = EipDomainNameArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EipDomainName {
        val builtJavaResource = com.pulumi.aws.ec2.EipDomainName(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EipDomainName(builtJavaResource)
    }
}

/**
 * Assigns a static reverse DNS record to an Elastic IP addresses. See [Using reverse DNS for email applications](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Eip("example", {domain: "vpc"});
 * const exampleRecord = new aws.route53.Record("example", {
 *     zoneId: main.zoneId,
 *     name: "reverse",
 *     type: aws.route53.RecordType.A,
 *     records: [example&#46;publicIp],
 * });
 * const exampleEipDomainName = new aws.ec2.EipDomainName("example", {
 *     allocationId: example.allocationId,
 *     domainName: exampleRecord.fqdn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Eip("example", domain="vpc")
 * example_record = aws.route53.Record("example",
 *     zone_id=main["zoneId"],
 *     name="reverse",
 *     type=aws.route53.RecordType.A,
 *     records=[example&#46;public_ip])
 * example_eip_domain_name = aws.ec2.EipDomainName("example",
 *     allocation_id=example.allocation_id,
 *     domain_name=example_record.fqdn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Eip("example", new()
 *     {
 *         Domain = "vpc",
 *     });
 *     var exampleRecord = new Aws.Route53.Record("example", new()
 *     {
 *         ZoneId = main.ZoneId,
 *         Name = "reverse",
 *         Type = Aws.Route53.RecordType.A,
 *         Records = new[]
 *         {
 *             example.PublicIp,
 *         },
 *     });
 *     var exampleEipDomainName = new Aws.Ec2.EipDomainName("example", new()
 *     {
 *         AllocationId = example.AllocationId,
 *         DomainName = exampleRecord.Fqdn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewEip(ctx, "example", &ec2.EipArgs{
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRecord, err := route53.NewRecord(ctx, "example", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(main.ZoneId),
 * 			Name:   pulumi.String("reverse"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Records: pulumi.StringArray{
 * 				example.PublicIp,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewEipDomainName(ctx, "example", &ec2.EipDomainNameArgs{
 * 			AllocationId: example.AllocationId,
 * 			DomainName:   exampleRecord.Fqdn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.ec2.EipDomainName;
 * import com.pulumi.aws.ec2.EipDomainNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .zoneId(main.zoneId())
 *             .name("reverse")
 *             .type("A")
 *             .records(example.publicIp())
 *             .build());
 *         var exampleEipDomainName = new EipDomainName("exampleEipDomainName", EipDomainNameArgs.builder()
 *             .allocationId(example.allocationId())
 *             .domainName(exampleRecord.fqdn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Eip
 *     properties:
 *       domain: vpc
 *   exampleRecord:
 *     type: aws:route53:Record
 *     name: example
 *     properties:
 *       zoneId: ${main.zoneId}
 *       name: reverse
 *       type: A
 *       records:
 *         - ${example.publicIp}
 *   exampleEipDomainName:
 *     type: aws:ec2:EipDomainName
 *     name: example
 *     properties:
 *       allocationId: ${example.allocationId}
 *       domainName: ${exampleRecord.fqdn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class EipDomainName internal constructor(
    override val javaResource: com.pulumi.aws.ec2.EipDomainName,
) : KotlinCustomResource(javaResource, EipDomainNameMapper) {
    /**
     * The allocation ID.
     */
    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    /**
     * The domain name to modify for the IP address.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The DNS pointer (PTR) record for the IP address.
     */
    public val ptrRecord: Output<String>
        get() = javaResource.ptrRecord().applyValue({ args0 -> args0 })

    public val timeouts: Output<EipDomainNameTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object EipDomainNameMapper : ResourceMapper<EipDomainName> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.EipDomainName::class == javaResource::class

    override fun map(javaResource: Resource): EipDomainName = EipDomainName(
        javaResource as
            com.pulumi.aws.ec2.EipDomainName,
    )
}

/**
 * @see [EipDomainName].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EipDomainName].
 */
public suspend fun eipDomainName(
    name: String,
    block: suspend EipDomainNameResourceBuilder.() -> Unit,
): EipDomainName {
    val builder = EipDomainNameResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EipDomainName].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eipDomainName(name: String): EipDomainName {
    val builder = EipDomainNameResourceBuilder()
    builder.name(name)
    return builder.build()
}
