@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.EipDomainNameArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.EipDomainNameTimeoutsArgs
import com.pulumi.aws.ec2.kotlin.inputs.EipDomainNameTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Assigns a static reverse DNS record to an Elastic IP addresses. See [Using reverse DNS for email applications](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Eip("example", {domain: "vpc"});
 * const exampleRecord = new aws.route53.Record("example", {
 *     zoneId: main.zoneId,
 *     name: "reverse",
 *     type: aws.route53.RecordType.A,
 *     records: [example&#46;publicIp],
 * });
 * const exampleEipDomainName = new aws.ec2.EipDomainName("example", {
 *     allocationId: example.allocationId,
 *     domainName: exampleRecord.fqdn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Eip("example", domain="vpc")
 * example_record = aws.route53.Record("example",
 *     zone_id=main["zoneId"],
 *     name="reverse",
 *     type=aws.route53.RecordType.A,
 *     records=[example&#46;public_ip])
 * example_eip_domain_name = aws.ec2.EipDomainName("example",
 *     allocation_id=example.allocation_id,
 *     domain_name=example_record.fqdn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Eip("example", new()
 *     {
 *         Domain = "vpc",
 *     });
 *     var exampleRecord = new Aws.Route53.Record("example", new()
 *     {
 *         ZoneId = main.ZoneId,
 *         Name = "reverse",
 *         Type = Aws.Route53.RecordType.A,
 *         Records = new[]
 *         {
 *             example.PublicIp,
 *         },
 *     });
 *     var exampleEipDomainName = new Aws.Ec2.EipDomainName("example", new()
 *     {
 *         AllocationId = example.AllocationId,
 *         DomainName = exampleRecord.Fqdn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/route53"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewEip(ctx, "example", &ec2.EipArgs{
 * 			Domain: pulumi.String("vpc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRecord, err := route53.NewRecord(ctx, "example", &route53.RecordArgs{
 * 			ZoneId: pulumi.Any(main.ZoneId),
 * 			Name:   pulumi.String("reverse"),
 * 			Type:   pulumi.String(route53.RecordTypeA),
 * 			Records: pulumi.StringArray{
 * 				example.PublicIp,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewEipDomainName(ctx, "example", &ec2.EipDomainNameArgs{
 * 			AllocationId: example.AllocationId,
 * 			DomainName:   exampleRecord.Fqdn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.ec2.EipDomainName;
 * import com.pulumi.aws.ec2.EipDomainNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .zoneId(main.zoneId())
 *             .name("reverse")
 *             .type("A")
 *             .records(example.publicIp())
 *             .build());
 *         var exampleEipDomainName = new EipDomainName("exampleEipDomainName", EipDomainNameArgs.builder()
 *             .allocationId(example.allocationId())
 *             .domainName(exampleRecord.fqdn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Eip
 *     properties:
 *       domain: vpc
 *   exampleRecord:
 *     type: aws:route53:Record
 *     name: example
 *     properties:
 *       zoneId: ${main.zoneId}
 *       name: reverse
 *       type: A
 *       records:
 *         - ${example.publicIp}
 *   exampleEipDomainName:
 *     type: aws:ec2:EipDomainName
 *     name: example
 *     properties:
 *       allocationId: ${example.allocationId}
 *       domainName: ${exampleRecord.fqdn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property allocationId The allocation ID.
 * @property domainName The domain name to modify for the IP address.
 * @property timeouts
 */
public data class EipDomainNameArgs(
    public val allocationId: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val timeouts: Output<EipDomainNameTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.EipDomainNameArgs> {
    override fun toJava(): com.pulumi.aws.ec2.EipDomainNameArgs =
        com.pulumi.aws.ec2.EipDomainNameArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EipDomainNameArgs].
 */
@PulumiTagMarker
public class EipDomainNameArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var domainName: Output<String>? = null

    private var timeouts: Output<EipDomainNameTimeoutsArgs>? = null

    /**
     * @param value The allocation ID.
     */
    @JvmName("vqrucfesfjohosqj")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value The domain name to modify for the IP address.
     */
    @JvmName("itfqweynymyntuql")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value
     */
    @JvmName("fdvapxerpiqbpktf")
    public suspend fun timeouts(`value`: Output<EipDomainNameTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The allocation ID.
     */
    @JvmName("fnhdwwxwhplywhdp")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value The domain name to modify for the IP address.
     */
    @JvmName("uevdpkkxvftsyido")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value
     */
    @JvmName("puwkyltdtfwwldvf")
    public suspend fun timeouts(`value`: EipDomainNameTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ykraqlmlpeqwtkvt")
    public suspend fun timeouts(argument: suspend EipDomainNameTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = EipDomainNameTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): EipDomainNameArgs = EipDomainNameArgs(
        allocationId = allocationId,
        domainName = domainName,
        timeouts = timeouts,
    )
}
