@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.FleetArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.FleetFleetInstanceSetArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetFleetInstanceSetArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetLaunchTemplateConfigArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetLaunchTemplateConfigArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetOnDemandOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetOnDemandOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetSpotOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetSpotOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetTargetCapacitySpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetTargetCapacitySpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage EC2 Fleets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Fleet("example", {
 *     launchTemplateConfigs: [{
 *         launchTemplateSpecification: {
 *             launchTemplateId: exampleAwsLaunchTemplate.id,
 *             version: exampleAwsLaunchTemplate.latestVersion,
 *         },
 *     }],
 *     targetCapacitySpecification: {
 *         defaultTargetCapacityType: "spot",
 *         totalTargetCapacity: 5,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Fleet("example",
 *     launch_template_configs=[{
 *         "launch_template_specification": {
 *             "launch_template_id": example_aws_launch_template["id"],
 *             "version": example_aws_launch_template["latestVersion"],
 *         },
 *     }],
 *     target_capacity_specification={
 *         "default_target_capacity_type": "spot",
 *         "total_target_capacity": 5,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Fleet("example", new()
 *     {
 *         LaunchTemplateConfigs = new[]
 *         {
 *             new Aws.Ec2.Inputs.FleetLaunchTemplateConfigArgs
 *             {
 *                 LaunchTemplateSpecification = new Aws.Ec2.Inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs
 *                 {
 *                     LaunchTemplateId = exampleAwsLaunchTemplate.Id,
 *                     Version = exampleAwsLaunchTemplate.LatestVersion,
 *                 },
 *             },
 *         },
 *         TargetCapacitySpecification = new Aws.Ec2.Inputs.FleetTargetCapacitySpecificationArgs
 *         {
 *             DefaultTargetCapacityType = "spot",
 *             TotalTargetCapacity = 5,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewFleet(ctx, "example", &ec2.FleetArgs{
 * 			LaunchTemplateConfigs: ec2.FleetLaunchTemplateConfigArray{
 * 				&ec2.FleetLaunchTemplateConfigArgs{
 * 					LaunchTemplateSpecification: &ec2.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs{
 * 						LaunchTemplateId: pulumi.Any(exampleAwsLaunchTemplate.Id),
 * 						Version:          pulumi.Any(exampleAwsLaunchTemplate.LatestVersion),
 * 					},
 * 				},
 * 			},
 * 			TargetCapacitySpecification: &ec2.FleetTargetCapacitySpecificationArgs{
 * 				DefaultTargetCapacityType: pulumi.String("spot"),
 * 				TotalTargetCapacity:       pulumi.Int(5),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Fleet;
 * import com.pulumi.aws.ec2.FleetArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .launchTemplateConfigs(FleetLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .launchTemplateId(exampleAwsLaunchTemplate.id())
 *                     .version(exampleAwsLaunchTemplate.latestVersion())
 *                     .build())
 *                 .build())
 *             .targetCapacitySpecification(FleetTargetCapacitySpecificationArgs.builder()
 *                 .defaultTargetCapacityType("spot")
 *                 .totalTargetCapacity(5)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Fleet
 *     properties:
 *       launchTemplateConfigs:
 *         - launchTemplateSpecification:
 *             launchTemplateId: ${exampleAwsLaunchTemplate.id}
 *             version: ${exampleAwsLaunchTemplate.latestVersion}
 *       targetCapacitySpecification:
 *         defaultTargetCapacityType: spot
 *         totalTargetCapacity: 5
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_fleet` using the Fleet identifier. For example:
 * ```sh
 * $ pulumi import aws:ec2/fleet:Fleet example fleet-b9b55d27-c5fc-41ac-a6f3-48fcc91f080c
 * ```
 * @property context Reserved.
 * @property excessCapacityTerminationPolicy Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
 * @property fleetInstanceSets Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
 * @property fleetState The state of the EC2 Fleet.
 * @property fulfilledCapacity The number of units fulfilled by this request compared to the set target capacity.
 * @property fulfilledOnDemandCapacity The number of units fulfilled by this request compared to the set target On-Demand capacity.
 * @property launchTemplateConfigs Nested argument containing EC2 Launch Template configurations. Defined below.
 * @property onDemandOptions Nested argument containing On-Demand configurations. Defined below.
 * @property replaceUnhealthyInstances Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
 * @property spotOptions Nested argument containing Spot configurations. Defined below.
 * @property tags Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetCapacitySpecification Nested argument containing target capacity configurations. Defined below.
 * @property terminateInstances Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
 * @property terminateInstancesWithExpiration Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
 * @property type The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
 * @property validFrom The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
 * @property validUntil The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
 */
public data class FleetArgs(
    public val context: Output<String>? = null,
    public val excessCapacityTerminationPolicy: Output<String>? = null,
    public val fleetInstanceSets: Output<List<FleetFleetInstanceSetArgs>>? = null,
    public val fleetState: Output<String>? = null,
    public val fulfilledCapacity: Output<Double>? = null,
    public val fulfilledOnDemandCapacity: Output<Double>? = null,
    public val launchTemplateConfigs: Output<List<FleetLaunchTemplateConfigArgs>>? = null,
    public val onDemandOptions: Output<FleetOnDemandOptionsArgs>? = null,
    public val replaceUnhealthyInstances: Output<Boolean>? = null,
    public val spotOptions: Output<FleetSpotOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCapacitySpecification: Output<FleetTargetCapacitySpecificationArgs>? = null,
    public val terminateInstances: Output<Boolean>? = null,
    public val terminateInstancesWithExpiration: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.FleetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.FleetArgs = com.pulumi.aws.ec2.FleetArgs.builder()
        .context(context?.applyValue({ args0 -> args0 }))
        .excessCapacityTerminationPolicy(excessCapacityTerminationPolicy?.applyValue({ args0 -> args0 }))
        .fleetInstanceSets(
            fleetInstanceSets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .fleetState(fleetState?.applyValue({ args0 -> args0 }))
        .fulfilledCapacity(fulfilledCapacity?.applyValue({ args0 -> args0 }))
        .fulfilledOnDemandCapacity(fulfilledOnDemandCapacity?.applyValue({ args0 -> args0 }))
        .launchTemplateConfigs(
            launchTemplateConfigs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .onDemandOptions(onDemandOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .replaceUnhealthyInstances(replaceUnhealthyInstances?.applyValue({ args0 -> args0 }))
        .spotOptions(spotOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .targetCapacitySpecification(
            targetCapacitySpecification?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .terminateInstances(terminateInstances?.applyValue({ args0 -> args0 }))
        .terminateInstancesWithExpiration(terminateInstancesWithExpiration?.applyValue({ args0 -> args0 }))
        .type(type?.applyValue({ args0 -> args0 }))
        .validFrom(validFrom?.applyValue({ args0 -> args0 }))
        .validUntil(validUntil?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var excessCapacityTerminationPolicy: Output<String>? = null

    private var fleetInstanceSets: Output<List<FleetFleetInstanceSetArgs>>? = null

    private var fleetState: Output<String>? = null

    private var fulfilledCapacity: Output<Double>? = null

    private var fulfilledOnDemandCapacity: Output<Double>? = null

    private var launchTemplateConfigs: Output<List<FleetLaunchTemplateConfigArgs>>? = null

    private var onDemandOptions: Output<FleetOnDemandOptionsArgs>? = null

    private var replaceUnhealthyInstances: Output<Boolean>? = null

    private var spotOptions: Output<FleetSpotOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCapacitySpecification: Output<FleetTargetCapacitySpecificationArgs>? = null

    private var terminateInstances: Output<Boolean>? = null

    private var terminateInstancesWithExpiration: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    /**
     * @param value Reserved.
     */
    @JvmName("hbgfhgymskopribf")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
     */
    @JvmName("ooretjrjhljkvxlk")
    public suspend fun excessCapacityTerminationPolicy(`value`: Output<String>) {
        this.excessCapacityTerminationPolicy = value
    }

    /**
     * @param value Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("simvuojydyiiqgpv")
    public suspend fun fleetInstanceSets(`value`: Output<List<FleetFleetInstanceSetArgs>>) {
        this.fleetInstanceSets = value
    }

    @JvmName("eyvxkqybfixkwmxt")
    public suspend fun fleetInstanceSets(vararg values: Output<FleetFleetInstanceSetArgs>) {
        this.fleetInstanceSets = Output.all(values.asList())
    }

    /**
     * @param values Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("kayfnpparvuymmpq")
    public suspend fun fleetInstanceSets(values: List<Output<FleetFleetInstanceSetArgs>>) {
        this.fleetInstanceSets = Output.all(values)
    }

    /**
     * @param value The state of the EC2 Fleet.
     */
    @JvmName("uxjouccytxufyuut")
    public suspend fun fleetState(`value`: Output<String>) {
        this.fleetState = value
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target capacity.
     */
    @JvmName("gguofnvrfwguxhkr")
    public suspend fun fulfilledCapacity(`value`: Output<Double>) {
        this.fulfilledCapacity = value
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    @JvmName("yxmdufnnwsllwved")
    public suspend fun fulfilledOnDemandCapacity(`value`: Output<Double>) {
        this.fulfilledOnDemandCapacity = value
    }

    /**
     * @param value Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("vdmqycrcsaxxpegi")
    public suspend fun launchTemplateConfigs(`value`: Output<List<FleetLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = value
    }

    @JvmName("veuowyetbhlyrlak")
    public suspend fun launchTemplateConfigs(vararg values: Output<FleetLaunchTemplateConfigArgs>) {
        this.launchTemplateConfigs = Output.all(values.asList())
    }

    /**
     * @param values Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("thslstityakqpfgx")
    public suspend fun launchTemplateConfigs(values: List<Output<FleetLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = Output.all(values)
    }

    /**
     * @param value Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("svivvitvouoewird")
    public suspend fun onDemandOptions(`value`: Output<FleetOnDemandOptionsArgs>) {
        this.onDemandOptions = value
    }

    /**
     * @param value Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
     */
    @JvmName("qiebyqhngqwhbgro")
    public suspend fun replaceUnhealthyInstances(`value`: Output<Boolean>) {
        this.replaceUnhealthyInstances = value
    }

    /**
     * @param value Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("oihaxpnfbuldgvss")
    public suspend fun spotOptions(`value`: Output<FleetSpotOptionsArgs>) {
        this.spotOptions = value
    }

    /**
     * @param value Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uuikwnkoxpspuqdq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("erqcaeiogsrkgmwt")
    public suspend fun targetCapacitySpecification(`value`: Output<FleetTargetCapacitySpecificationArgs>) {
        this.targetCapacitySpecification = value
    }

    /**
     * @param value Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
     */
    @JvmName("tmnpkevwictihjav")
    public suspend fun terminateInstances(`value`: Output<Boolean>) {
        this.terminateInstances = value
    }

    /**
     * @param value Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
     */
    @JvmName("degsmlltuavaiuji")
    public suspend fun terminateInstancesWithExpiration(`value`: Output<Boolean>) {
        this.terminateInstancesWithExpiration = value
    }

    /**
     * @param value The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
     */
    @JvmName("dibyvmwmbykkaawg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("pvnqmfwjdtepaocj")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @JvmName("tganvvsdrixefoed")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value Reserved.
     */
    @JvmName("lnqbunmbtovfsqqk")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
     */
    @JvmName("ikcvbcpvlsjpqxrm")
    public suspend fun excessCapacityTerminationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excessCapacityTerminationPolicy = mapped
    }

    /**
     * @param value Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("ofsxtnjoneaxhpni")
    public suspend fun fleetInstanceSets(`value`: List<FleetFleetInstanceSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("ernxrlaarwubjbbp")
    public suspend fun fleetInstanceSets(argument: List<suspend FleetFleetInstanceSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetFleetInstanceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("lywypwbqtyvuhfoc")
    public suspend fun fleetInstanceSets(vararg argument: suspend FleetFleetInstanceSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FleetFleetInstanceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("royufdbcsanmcybl")
    public suspend fun fleetInstanceSets(argument: suspend FleetFleetInstanceSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FleetFleetInstanceSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param values Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("ljgppedflsmbgors")
    public suspend fun fleetInstanceSets(vararg values: FleetFleetInstanceSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fleetInstanceSets = mapped
    }

    /**
     * @param value The state of the EC2 Fleet.
     */
    @JvmName("ktvplfrhrbdsoodx")
    public suspend fun fleetState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetState = mapped
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target capacity.
     */
    @JvmName("otaciowyinjqrjue")
    public suspend fun fulfilledCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfilledCapacity = mapped
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    @JvmName("athxobfxcdvahyet")
    public suspend fun fulfilledOnDemandCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfilledOnDemandCapacity = mapped
    }

    /**
     * @param value Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("yusngpvckjcryqmb")
    public suspend fun launchTemplateConfigs(`value`: List<FleetLaunchTemplateConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("erhckqgwnriqgukr")
    public suspend fun launchTemplateConfigs(argument: List<suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("etfvmdfbhwbxtmnp")
    public suspend fun launchTemplateConfigs(vararg argument: suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("tcadmirtuqqnmlhr")
    public suspend fun launchTemplateConfigs(argument: suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param values Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("mxumotiugbsfopoy")
    public suspend fun launchTemplateConfigs(vararg values: FleetLaunchTemplateConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param value Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("rlkbcmocqqjcavpt")
    public suspend fun onDemandOptions(`value`: FleetOnDemandOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandOptions = mapped
    }

    /**
     * @param argument Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("kmdflkgxrbswgpcu")
    public suspend fun onDemandOptions(argument: suspend FleetOnDemandOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FleetOnDemandOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onDemandOptions = mapped
    }

    /**
     * @param value Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
     */
    @JvmName("pxmcraypoxgthojd")
    public suspend fun replaceUnhealthyInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceUnhealthyInstances = mapped
    }

    /**
     * @param value Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("qmqdixrhtklvctot")
    public suspend fun spotOptions(`value`: FleetSpotOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotOptions = mapped
    }

    /**
     * @param argument Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("jyohwtjhxevlbtop")
    public suspend fun spotOptions(argument: suspend FleetSpotOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FleetSpotOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spotOptions = mapped
    }

    /**
     * @param value Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("whkiqvmpgojsdlhf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ayvvwjiplofmfvsk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("luvphhetogtjtagy")
    public suspend fun targetCapacitySpecification(`value`: FleetTargetCapacitySpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacitySpecification = mapped
    }

    /**
     * @param argument Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("cyqcflvrlqbiubwc")
    public suspend fun targetCapacitySpecification(argument: suspend FleetTargetCapacitySpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = FleetTargetCapacitySpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetCapacitySpecification = mapped
    }

    /**
     * @param value Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
     */
    @JvmName("ouixojgchnwwkfsg")
    public suspend fun terminateInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstances = mapped
    }

    /**
     * @param value Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
     */
    @JvmName("mjrthoneuiebrbrn")
    public suspend fun terminateInstancesWithExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstancesWithExpiration = mapped
    }

    /**
     * @param value The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
     */
    @JvmName("inluhluqtleutptf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("fhwuontleuwnkxiq")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @JvmName("dloalflcdmqpgpqr")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        context = context,
        excessCapacityTerminationPolicy = excessCapacityTerminationPolicy,
        fleetInstanceSets = fleetInstanceSets,
        fleetState = fleetState,
        fulfilledCapacity = fulfilledCapacity,
        fulfilledOnDemandCapacity = fulfilledOnDemandCapacity,
        launchTemplateConfigs = launchTemplateConfigs,
        onDemandOptions = onDemandOptions,
        replaceUnhealthyInstances = replaceUnhealthyInstances,
        spotOptions = spotOptions,
        tags = tags,
        targetCapacitySpecification = targetCapacitySpecification,
        terminateInstances = terminateInstances,
        terminateInstancesWithExpiration = terminateInstancesWithExpiration,
        type = type,
        validFrom = validFrom,
        validUntil = validUntil,
    )
}
