@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.ImageBlockPublicAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a regional public access block for AMIs. This prevents AMIs from being made publicly accessible.
 * If you already have public AMIs, they will remain publicly available.
 * > **NOTE:** Deleting this resource does not change the block public access value, the resource in simply removed from state instead.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 * const test = new aws.ec2.ImageBlockPublicAccess("test", {state: "block-new-sharing"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 * test = aws.ec2.ImageBlockPublicAccess("test", state="block-new-sharing")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 *     var test = new Aws.Ec2.ImageBlockPublicAccess("test", new()
 *     {
 *         State = "block-new-sharing",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 * 		_, err := ec2.NewImageBlockPublicAccess(ctx, "test", &ec2.ImageBlockPublicAccessArgs{
 * 			State: pulumi.String("block-new-sharing"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccess;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 *         var test = new ImageBlockPublicAccess("test", ImageBlockPublicAccessArgs.builder()
 *             .state("block-new-sharing")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Prevent making AMIs publicly accessible in the region and account for which the provider is configured
 *   test:
 *     type: aws:ec2:ImageBlockPublicAccess
 *     properties:
 *       state: block-new-sharing
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import this resource.
 * @property state The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
 */
public data class ImageBlockPublicAccessArgs(
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.ImageBlockPublicAccessArgs> {
    override fun toJava(): com.pulumi.aws.ec2.ImageBlockPublicAccessArgs =
        com.pulumi.aws.ec2.ImageBlockPublicAccessArgs.builder()
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageBlockPublicAccessArgs].
 */
@PulumiTagMarker
public class ImageBlockPublicAccessArgsBuilder internal constructor() {
    private var state: Output<String>? = null

    /**
     * @param value The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
     */
    @JvmName("kibcywgeigolerpq")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
     */
    @JvmName("eyvgdrlctuvhmwxp")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ImageBlockPublicAccessArgs = ImageBlockPublicAccessArgs(
        state = state,
    )
}
