@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.InstanceCapacityReservationSpecification
import com.pulumi.aws.ec2.kotlin.outputs.InstanceCpuOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceCreditSpecification
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEbsBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEnclaveOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEphemeralBlockDevice
import com.pulumi.aws.ec2.kotlin.outputs.InstanceInstanceMarketOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceLaunchTemplate
import com.pulumi.aws.ec2.kotlin.outputs.InstanceMaintenanceOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceMetadataOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceNetworkInterface
import com.pulumi.aws.ec2.kotlin.outputs.InstancePrivateDnsNameOptions
import com.pulumi.aws.ec2.kotlin.outputs.InstanceRootBlockDevice
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.InstanceCapacityReservationSpecification.Companion.toKotlin as instanceCapacityReservationSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceCpuOptions.Companion.toKotlin as instanceCpuOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceCreditSpecification.Companion.toKotlin as instanceCreditSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEbsBlockDevice.Companion.toKotlin as instanceEbsBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEnclaveOptions.Companion.toKotlin as instanceEnclaveOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceEphemeralBlockDevice.Companion.toKotlin as instanceEphemeralBlockDeviceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceInstanceMarketOptions.Companion.toKotlin as instanceInstanceMarketOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceLaunchTemplate.Companion.toKotlin as instanceLaunchTemplateToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceMaintenanceOptions.Companion.toKotlin as instanceMaintenanceOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceMetadataOptions.Companion.toKotlin as instanceMetadataOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceNetworkInterface.Companion.toKotlin as instanceNetworkInterfaceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstancePrivateDnsNameOptions.Companion.toKotlin as instancePrivateDnsNameOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.InstanceRootBlockDevice.Companion.toKotlin as instanceRootBlockDeviceToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.ec2.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.
 * ## Example Usage
 * ### Basic example using AMI lookup
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ubuntu = aws.ec2.getAmi({
 *     mostRecent: true,
 *     filters: [
 *         {
 *             name: "name",
 *             values: ["ubuntu/images/hvm-ssd/ubuntu-jammy-22&#46;04-amd64-server-*"],
 *         },
 *         {
 *             name: "virtualization-type",
 *             values: ["hvm"],
 *         },
 *     ],
 *     owners: ["099720109477"],
 * });
 * const web = new aws.ec2.Instance("web", {
 *     ami: ubuntu.then(ubuntu => ubuntu.id),
 *     instanceType: aws.ec2.InstanceType.T3_Micro,
 *     tags: {
 *         Name: "HelloWorld",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ubuntu = aws.ec2.get_ami(most_recent=True,
 *     filters=[
 *         {
 *             "name": "name",
 *             "values": ["ubuntu/images/hvm-ssd/ubuntu-jammy-22&#46;04-amd64-server-*"],
 *         },
 *         {
 *             "name": "virtualization-type",
 *             "values": ["hvm"],
 *         },
 *     ],
 *     owners=["099720109477"])
 * web = aws.ec2.Instance("web",
 *     ami=ubuntu.id,
 *     instance_type=aws.ec2.InstanceType.T3_MICRO,
 *     tags={
 *         "Name": "HelloWorld",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ubuntu = Aws.Ec2.GetAmi.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "name",
 *                 Values = new[]
 *                 {
 *                     "ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*",
 *                 },
 *             },
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "virtualization-type",
 *                 Values = new[]
 *                 {
 *                     "hvm",
 *                 },
 *             },
 *         },
 *         Owners = new[]
 *         {
 *             "099720109477",
 *         },
 *     });
 *     var web = new Aws.Ec2.Instance("web", new()
 *     {
 *         Ami = ubuntu.Apply(getAmiResult => getAmiResult.Id),
 *         InstanceType = Aws.Ec2.InstanceType.T3_Micro,
 *         Tags =
 *         {
 *             { "Name", "HelloWorld" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ubuntu, err := ec2.LookupAmi(ctx, &ec2.LookupAmiArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Filters: []ec2.GetAmiFilter{
 * 				{
 * 					Name: "name",
 * 					Values: []string{
 * 						"ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*",
 * 					},
 * 				},
 * 				{
 * 					Name: "virtualization-type",
 * 					Values: []string{
 * 						"hvm",
 * 					},
 * 				},
 * 			},
 * 			Owners: []string{
 * 				"099720109477",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInstance(ctx, "web", &ec2.InstanceArgs{
 * 			Ami:          pulumi.String(ubuntu.Id),
 * 			InstanceType: pulumi.String(ec2.InstanceType_T3_Micro),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("HelloWorld"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ubuntu = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("virtualization-type")
 *                     .values("hvm")
 *                     .build())
 *             .owners("099720109477")
 *             .build());
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami(ubuntu.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t3.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   web:
 *     type: aws:ec2:Instance
 *     properties:
 *       ami: ${ubuntu.id}
 *       instanceType: t3.micro
 *       tags:
 *         Name: HelloWorld
 * variables:
 *   ubuntu:
 *     fn::invoke:
 *       Function: aws:ec2:getAmi
 *       Arguments:
 *         mostRecent: true
 *         filters:
 *           - name: name
 *             values:
 *               - ubuntu/images/hvm-ssd/ubuntu-jammy-22.04-amd64-server-*
 *           - name: virtualization-type
 *             values:
 *               - hvm
 *         owners:
 *           - '099720109477'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Spot instance example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const this = aws.ec2.getAmi({
 *     mostRecent: true,
 *     owners: ["amazon"],
 *     filters: [
 *         {
 *             name: "architecture",
 *             values: ["arm64"],
 *         },
 *         {
 *             name: "name",
 *             values: ["al2023-ami-2023*"],
 *         },
 *     ],
 * });
 * const thisInstance = new aws.ec2.Instance("this", {
 *     ami: _this.then(_this => _this.id),
 *     instanceMarketOptions: {
 *         spotOptions: {
 *             maxPrice: "0.0031",
 *         },
 *     },
 *     instanceType: aws.ec2.InstanceType.T4g_Nano,
 *     tags: {
 *         Name: "test-spot",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * this = aws.ec2.get_ami(most_recent=True,
 *     owners=["amazon"],
 *     filters=[
 *         {
 *             "name": "architecture",
 *             "values": ["arm64"],
 *         },
 *         {
 *             "name": "name",
 *             "values": ["al2023-ami-2023*"],
 *         },
 *     ])
 * this_instance = aws.ec2.Instance("this",
 *     ami=this.id,
 *     instance_market_options={
 *         "spot_options": {
 *             "max_price": "0.0031",
 *         },
 *     },
 *     instance_type=aws.ec2.InstanceType.T4G_NANO,
 *     tags={
 *         "Name": "test-spot",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = Aws.Ec2.GetAmi.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Owners = new[]
 *         {
 *             "amazon",
 *         },
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "architecture",
 *                 Values = new[]
 *                 {
 *                     "arm64",
 *                 },
 *             },
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "name",
 *                 Values = new[]
 *                 {
 *                     "al2023-ami-2023*",
 *                 },
 *             },
 *         },
 *     });
 *     var thisInstance = new Aws.Ec2.Instance("this", new()
 *     {
 *         Ami = @this.Apply(@this => @this.Apply(getAmiResult => getAmiResult.Id)),
 *         InstanceMarketOptions = new Aws.Ec2.Inputs.InstanceInstanceMarketOptionsArgs
 *         {
 *             SpotOptions = new Aws.Ec2.Inputs.InstanceInstanceMarketOptionsSpotOptionsArgs
 *             {
 *                 MaxPrice = "0.0031",
 *             },
 *         },
 *         InstanceType = Aws.Ec2.InstanceType.T4g_Nano,
 *         Tags =
 *         {
 *             { "Name", "test-spot" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		this, err := ec2.LookupAmi(ctx, &ec2.LookupAmiArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners: []string{
 * 				"amazon",
 * 			},
 * 			Filters: []ec2.GetAmiFilter{
 * 				{
 * 					Name: "architecture",
 * 					Values: []string{
 * 						"arm64",
 * 					},
 * 				},
 * 				{
 * 					Name: "name",
 * 					Values: []string{
 * 						"al2023-ami-2023*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInstance(ctx, "this", &ec2.InstanceArgs{
 * 			Ami: pulumi.String(this.Id),
 * 			InstanceMarketOptions: &ec2.InstanceInstanceMarketOptionsArgs{
 * 				SpotOptions: &ec2.InstanceInstanceMarketOptionsSpotOptionsArgs{
 * 					MaxPrice: pulumi.String("0.0031"),
 * 				},
 * 			},
 * 			InstanceType: pulumi.String(ec2.InstanceType_T4g_Nano),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("test-spot"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var this = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("architecture")
 *                     .values("arm64")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("al2023-ami-2023*")
 *                     .build())
 *             .build());
 *         var thisInstance = new Instance("thisInstance", InstanceArgs.builder()
 *             .ami(this_.id())
 *             .instanceMarketOptions(InstanceInstanceMarketOptionsArgs.builder()
 *                 .spotOptions(InstanceInstanceMarketOptionsSpotOptionsArgs.builder()
 *                     .maxPrice(0.0031)
 *                     .build())
 *                 .build())
 *             .instanceType("t4g.nano")
 *             .tags(Map.of("Name", "test-spot"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   thisInstance:
 *     type: aws:ec2:Instance
 *     name: this
 *     properties:
 *       ami: ${this.id}
 *       instanceMarketOptions:
 *         spotOptions:
 *           maxPrice: 0.0031
 *       instanceType: t4g.nano
 *       tags:
 *         Name: test-spot
 * variables:
 *   this:
 *     fn::invoke:
 *       Function: aws:ec2:getAmi
 *       Arguments:
 *         mostRecent: true
 *         owners:
 *           - amazon
 *         filters:
 *           - name: architecture
 *             values:
 *               - arm64
 *           - name: name
 *             values:
 *               - al2023-ami-2023*
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Network and credit specification example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const myVpc = new aws.ec2.Vpc("my_vpc", {
 *     cidrBlock: "172.16.0.0/16",
 *     tags: {
 *         Name: "tf-example",
 *     },
 * });
 * const mySubnet = new aws.ec2.Subnet("my_subnet", {
 *     vpcId: myVpc.id,
 *     cidrBlock: "172.16.10.0/24",
 *     availabilityZone: "us-west-2a",
 *     tags: {
 *         Name: "tf-example",
 *     },
 * });
 * const foo = new aws.ec2.NetworkInterface("foo", {
 *     subnetId: mySubnet.id,
 *     privateIps: ["172&#46;16&#46;10&#46;100"],
 *     tags: {
 *         Name: "primary_network_interface",
 *     },
 * });
 * const fooInstance = new aws.ec2.Instance("foo", {
 *     ami: "ami-005e54dee72cc1d00",
 *     instanceType: aws.ec2.InstanceType.T2_Micro,
 *     networkInterfaces: [{
 *         networkInterfaceId: foo.id,
 *         deviceIndex: 0,
 *     }],
 *     creditSpecification: {
 *         cpuCredits: "unlimited",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * my_vpc = aws.ec2.Vpc("my_vpc",
 *     cidr_block="172.16.0.0/16",
 *     tags={
 *         "Name": "tf-example",
 *     })
 * my_subnet = aws.ec2.Subnet("my_subnet",
 *     vpc_id=my_vpc.id,
 *     cidr_block="172.16.10.0/24",
 *     availability_zone="us-west-2a",
 *     tags={
 *         "Name": "tf-example",
 *     })
 * foo = aws.ec2.NetworkInterface("foo",
 *     subnet_id=my_subnet.id,
 *     private_ips=["172&#46;16&#46;10&#46;100"],
 *     tags={
 *         "Name": "primary_network_interface",
 *     })
 * foo_instance = aws.ec2.Instance("foo",
 *     ami="ami-005e54dee72cc1d00",
 *     instance_type=aws.ec2.InstanceType.T2_MICRO,
 *     network_interfaces=[{
 *         "network_interface_id": foo.id,
 *         "device_index": 0,
 *     }],
 *     credit_specification={
 *         "cpu_credits": "unlimited",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var myVpc = new Aws.Ec2.Vpc("my_vpc", new()
 *     {
 *         CidrBlock = "172.16.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "tf-example" },
 *         },
 *     });
 *     var mySubnet = new Aws.Ec2.Subnet("my_subnet", new()
 *     {
 *         VpcId = myVpc.Id,
 *         CidrBlock = "172.16.10.0/24",
 *         AvailabilityZone = "us-west-2a",
 *         Tags =
 *         {
 *             { "Name", "tf-example" },
 *         },
 *     });
 *     var foo = new Aws.Ec2.NetworkInterface("foo", new()
 *     {
 *         SubnetId = mySubnet.Id,
 *         PrivateIps = new[]
 *         {
 *             "172.16.10.100",
 *         },
 *         Tags =
 *         {
 *             { "Name", "primary_network_interface" },
 *         },
 *     });
 *     var fooInstance = new Aws.Ec2.Instance("foo", new()
 *     {
 *         Ami = "ami-005e54dee72cc1d00",
 *         InstanceType = Aws.Ec2.InstanceType.T2_Micro,
 *         NetworkInterfaces = new[]
 *         {
 *             new Aws.Ec2.Inputs.InstanceNetworkInterfaceArgs
 *             {
 *                 NetworkInterfaceId = foo.Id,
 *                 DeviceIndex = 0,
 *             },
 *         },
 *         CreditSpecification = new Aws.Ec2.Inputs.InstanceCreditSpecificationArgs
 *         {
 *             CpuCredits = "unlimited",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		myVpc, err := ec2.NewVpc(ctx, "my_vpc", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		mySubnet, err := ec2.NewSubnet(ctx, "my_subnet", &ec2.SubnetArgs{
 * 			VpcId:            myVpc.ID(),
 * 			CidrBlock:        pulumi.String("172.16.10.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := ec2.NewNetworkInterface(ctx, "foo", &ec2.NetworkInterfaceArgs{
 * 			SubnetId: mySubnet.ID(),
 * 			PrivateIps: pulumi.StringArray{
 * 				pulumi.String("172.16.10.100"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("primary_network_interface"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInstance(ctx, "foo", &ec2.InstanceArgs{
 * 			Ami:          pulumi.String("ami-005e54dee72cc1d00"),
 * 			InstanceType: pulumi.String(ec2.InstanceType_T2_Micro),
 * 			NetworkInterfaces: ec2.InstanceNetworkInterfaceArray{
 * 				&ec2.InstanceNetworkInterfaceArgs{
 * 					NetworkInterfaceId: foo.ID(),
 * 					DeviceIndex:        pulumi.Int(0),
 * 				},
 * 			},
 * 			CreditSpecification: &ec2.InstanceCreditSpecificationArgs{
 * 				CpuCredits: pulumi.String("unlimited"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceNetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myVpc = new Vpc("myVpc", VpcArgs.builder()
 *             .cidrBlock("172.16.0.0/16")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var mySubnet = new Subnet("mySubnet", SubnetArgs.builder()
 *             .vpcId(myVpc.id())
 *             .cidrBlock("172.16.10.0/24")
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var foo = new NetworkInterface("foo", NetworkInterfaceArgs.builder()
 *             .subnetId(mySubnet.id())
 *             .privateIps("172.16.10.100")
 *             .tags(Map.of("Name", "primary_network_interface"))
 *             .build());
 *         var fooInstance = new Instance("fooInstance", InstanceArgs.builder()
 *             .ami("ami-005e54dee72cc1d00")
 *             .instanceType("t2.micro")
 *             .networkInterfaces(InstanceNetworkInterfaceArgs.builder()
 *                 .networkInterfaceId(foo.id())
 *                 .deviceIndex(0)
 *                 .build())
 *             .creditSpecification(InstanceCreditSpecificationArgs.builder()
 *                 .cpuCredits("unlimited")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   myVpc:
 *     type: aws:ec2:Vpc
 *     name: my_vpc
 *     properties:
 *       cidrBlock: 172.16.0.0/16
 *       tags:
 *         Name: tf-example
 *   mySubnet:
 *     type: aws:ec2:Subnet
 *     name: my_subnet
 *     properties:
 *       vpcId: ${myVpc.id}
 *       cidrBlock: 172.16.10.0/24
 *       availabilityZone: us-west-2a
 *       tags:
 *         Name: tf-example
 *   foo:
 *     type: aws:ec2:NetworkInterface
 *     properties:
 *       subnetId: ${mySubnet.id}
 *       privateIps:
 *         - 172.16.10.100
 *       tags:
 *         Name: primary_network_interface
 *   fooInstance:
 *     type: aws:ec2:Instance
 *     name: foo
 *     properties:
 *       ami: ami-005e54dee72cc1d00
 *       instanceType: t2.micro
 *       networkInterfaces:
 *         - networkInterfaceId: ${foo.id}
 *           deviceIndex: 0
 *       creditSpecification:
 *         cpuCredits: unlimited
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CPU options example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.Vpc("example", {
 *     cidrBlock: "172.16.0.0/16",
 *     tags: {
 *         Name: "tf-example",
 *     },
 * });
 * const exampleSubnet = new aws.ec2.Subnet("example", {
 *     vpcId: example.id,
 *     cidrBlock: "172.16.10.0/24",
 *     availabilityZone: "us-east-2a",
 *     tags: {
 *         Name: "tf-example",
 *     },
 * });
 * const amzn-linux-2023-ami = aws.ec2.getAmi({
 *     mostRecent: true,
 *     owners: ["amazon"],
 *     filters: [{
 *         name: "name",
 *         values: ["al2023-ami-2023&#46;*-x86_64"],
 *     }],
 * });
 * const exampleInstance = new aws.ec2.Instance("example", {
 *     ami: amzn_linux_2023_ami.then(amzn_linux_2023_ami => amzn_linux_2023_ami.id),
 *     instanceType: aws.ec2.InstanceType.C6a_2XLarge,
 *     subnetId: exampleSubnet.id,
 *     cpuOptions: {
 *         coreCount: 2,
 *         threadsPerCore: 2,
 *     },
 *     tags: {
 *         Name: "tf-example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.Vpc("example",
 *     cidr_block="172.16.0.0/16",
 *     tags={
 *         "Name": "tf-example",
 *     })
 * example_subnet = aws.ec2.Subnet("example",
 *     vpc_id=example.id,
 *     cidr_block="172.16.10.0/24",
 *     availability_zone="us-east-2a",
 *     tags={
 *         "Name": "tf-example",
 *     })
 * amzn_linux_2023_ami = aws.ec2.get_ami(most_recent=True,
 *     owners=["amazon"],
 *     filters=[{
 *         "name": "name",
 *         "values": ["al2023-ami-2023&#46;*-x86_64"],
 *     }])
 * example_instance = aws.ec2.Instance("example",
 *     ami=amzn_linux_2023_ami.id,
 *     instance_type=aws.ec2.InstanceType.C6A_2_X_LARGE,
 *     subnet_id=example_subnet.id,
 *     cpu_options={
 *         "core_count": 2,
 *         "threads_per_core": 2,
 *     },
 *     tags={
 *         "Name": "tf-example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "172.16.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "tf-example" },
 *         },
 *     });
 *     var exampleSubnet = new Aws.Ec2.Subnet("example", new()
 *     {
 *         VpcId = example.Id,
 *         CidrBlock = "172.16.10.0/24",
 *         AvailabilityZone = "us-east-2a",
 *         Tags =
 *         {
 *             { "Name", "tf-example" },
 *         },
 *     });
 *     var amzn_linux_2023_ami = Aws.Ec2.GetAmi.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Owners = new[]
 *         {
 *             "amazon",
 *         },
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "name",
 *                 Values = new[]
 *                 {
 *                     "al2023-ami-2023.*-x86_64",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleInstance = new Aws.Ec2.Instance("example", new()
 *     {
 *         Ami = amzn_linux_2023_ami.Apply(amzn_linux_2023_ami => amzn_linux_2023_ami.Apply(getAmiResult => getAmiResult.Id)),
 *         InstanceType = Aws.Ec2.InstanceType.C6a_2XLarge,
 *         SubnetId = exampleSubnet.Id,
 *         CpuOptions = new Aws.Ec2.Inputs.InstanceCpuOptionsArgs
 *         {
 *             CoreCount = 2,
 *             ThreadsPerCore = 2,
 *         },
 *         Tags =
 *         {
 *             { "Name", "tf-example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSubnet, err := ec2.NewSubnet(ctx, "example", &ec2.SubnetArgs{
 * 			VpcId:            example.ID(),
 * 			CidrBlock:        pulumi.String("172.16.10.0/24"),
 * 			AvailabilityZone: pulumi.String("us-east-2a"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		amzn_linux_2023_ami, err := ec2.LookupAmi(ctx, &ec2.LookupAmiArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners: []string{
 * 				"amazon",
 * 			},
 * 			Filters: []ec2.GetAmiFilter{
 * 				{
 * 					Name: "name",
 * 					Values: []string{
 * 						"al2023-ami-2023.*-x86_64",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInstance(ctx, "example", &ec2.InstanceArgs{
 * 			Ami:          pulumi.String(amzn_linux_2023_ami.Id),
 * 			InstanceType: pulumi.String(ec2.InstanceType_C6a_2XLarge),
 * 			SubnetId:     exampleSubnet.ID(),
 * 			CpuOptions: &ec2.InstanceCpuOptionsArgs{
 * 				CoreCount:      pulumi.Int(2),
 * 				ThreadsPerCore: pulumi.Int(2),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vpc("example", VpcArgs.builder()
 *             .cidrBlock("172.16.0.0/16")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
 *             .vpcId(example.id())
 *             .cidrBlock("172.16.10.0/24")
 *             .availabilityZone("us-east-2a")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         final var amzn-linux-2023-ami = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("al2023-ami-2023.*-x86_64")
 *                 .build())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .ami(amzn_linux_2023_ami.id())
 *             .instanceType("c6a.2xlarge")
 *             .subnetId(exampleSubnet.id())
 *             .cpuOptions(InstanceCpuOptionsArgs.builder()
 *                 .coreCount(2)
 *                 .threadsPerCore(2)
 *                 .build())
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 172.16.0.0/16
 *       tags:
 *         Name: tf-example
 *   exampleSubnet:
 *     type: aws:ec2:Subnet
 *     name: example
 *     properties:
 *       vpcId: ${example.id}
 *       cidrBlock: 172.16.10.0/24
 *       availabilityZone: us-east-2a
 *       tags:
 *         Name: tf-example
 *   exampleInstance:
 *     type: aws:ec2:Instance
 *     name: example
 *     properties:
 *       ami: ${["amzn-linux-2023-ami"].id}
 *       instanceType: c6a.2xlarge
 *       subnetId: ${exampleSubnet.id}
 *       cpuOptions:
 *         coreCount: 2
 *         threadsPerCore: 2
 *       tags:
 *         Name: tf-example
 * variables:
 *   amzn-linux-2023-ami:
 *     fn::invoke:
 *       Function: aws:ec2:getAmi
 *       Arguments:
 *         mostRecent: true
 *         owners:
 *           - amazon
 *         filters:
 *           - name: name
 *             values:
 *               - al2023-ami-2023.*-x86_64
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Host resource group or License Manager registered AMI example
 * A host resource group is a collection of Dedicated Hosts that you can manage as a single entity. As you launch instances, License Manager allocates the hosts and launches instances on them based on the settings that you configured. You can add existing Dedicated Hosts to a host resource group and take advantage of automated host management through License Manager.
 * > **NOTE:** A dedicated host is automatically associated with a License Manager host resource group if **Allocate hosts automatically** is enabled. Otherwise, use the `host_resource_group_arn` argument to explicitly associate the instance with the host resource group.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _this = new aws.ec2.Instance("this", {
 *     ami: "ami-0dcc1e21636832c5d",
 *     instanceType: aws.ec2.InstanceType.M5_Large,
 *     hostResourceGroupArn: "arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost",
 *     tenancy: "host",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * this = aws.ec2.Instance("this",
 *     ami="ami-0dcc1e21636832c5d",
 *     instance_type=aws.ec2.InstanceType.M5_LARGE,
 *     host_resource_group_arn="arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost",
 *     tenancy="host")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new Aws.Ec2.Instance("this", new()
 *     {
 *         Ami = "ami-0dcc1e21636832c5d",
 *         InstanceType = Aws.Ec2.InstanceType.M5_Large,
 *         HostResourceGroupArn = "arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost",
 *         Tenancy = "host",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewInstance(ctx, "this", &ec2.InstanceArgs{
 * 			Ami:                  pulumi.String("ami-0dcc1e21636832c5d"),
 * 			InstanceType:         pulumi.String(ec2.InstanceType_M5_Large),
 * 			HostResourceGroupArn: pulumi.String("arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost"),
 * 			Tenancy:              pulumi.String("host"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Instance("this", InstanceArgs.builder()
 *             .ami("ami-0dcc1e21636832c5d")
 *             .instanceType("m5.large")
 *             .hostResourceGroupArn("arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost")
 *             .tenancy("host")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: aws:ec2:Instance
 *     properties:
 *       ami: ami-0dcc1e21636832c5d
 *       instanceType: m5.large
 *       hostResourceGroupArn: arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost
 *       tenancy: host
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Tag Guide
 * These are the five types of tags you might encounter relative to an `aws.ec2.Instance`:
 * 1. **Instance tags**: Applied to instances but not to `ebs_block_device` and `root_block_device` volumes.
 * 2. **Default tags**: Applied to the instance and to `ebs_block_device` and `root_block_device` volumes.
 * 3. **Volume tags**: Applied during creation to `ebs_block_device` and `root_block_device` volumes.
 * 4. **Root block device tags**: Applied only to the `root_block_device` volume. These conflict with `volume_tags`.
 * 5. **EBS block device tags**: Applied only to the specific `ebs_block_device` volume you configure them for and cannot be updated. These conflict with `volume_tags`.
 * Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
 * ## Import
 * Using `pulumi import`, import instances using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/instance:Instance web i-12345678
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    public val ami: Output<String>
        get() = javaResource.ami().applyValue({ args0 -> args0 })

    /**
     * ARN of the instance.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to associate a public IP address with an instance in a VPC.
     */
    public val associatePublicIpAddress: Output<Boolean>
        get() = javaResource.associatePublicIpAddress().applyValue({ args0 -> args0 })

    /**
     * AZ to start the instance in.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    public val capacityReservationSpecification: Output<InstanceCapacityReservationSpecification>
        get() = javaResource.capacityReservationSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceCapacityReservationSpecificationToKotlin(args0)
            })
        })

    /**
     * Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuCoreCount: Output<Int>
        get() = javaResource.cpuCoreCount().applyValue({ args0 -> args0 })

    /**
     * The CPU options for the instance. See CPU Options below for more details.
     */
    public val cpuOptions: Output<InstanceCpuOptions>
        get() = javaResource.cpuOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceCpuOptionsToKotlin(args0)
            })
        })

    /**
     * If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuThreadsPerCore: Output<Int>
        get() = javaResource.cpuThreadsPerCore().applyValue({ args0 -> args0 })

    /**
     * Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    public val creditSpecification: Output<InstanceCreditSpecification>?
        get() = javaResource.creditSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceCreditSpecificationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    public val disableApiStop: Output<Boolean>
        get() = javaResource.disableApiStop().applyValue({ args0 -> args0 })

    /**
     * If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    public val disableApiTermination: Output<Boolean>
        get() = javaResource.disableApiTermination().applyValue({ args0 -> args0 })

    /**
     * One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    public val ebsBlockDevices: Output<List<InstanceEbsBlockDevice>>
        get() = javaResource.ebsBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceEbsBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    public val ebsOptimized: Output<Boolean>
        get() = javaResource.ebsOptimized().applyValue({ args0 -> args0 })

    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    public val enclaveOptions: Output<InstanceEnclaveOptions>
        get() = javaResource.enclaveOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceEnclaveOptionsToKotlin(args0)
            })
        })

    /**
     * One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    public val ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDevice>>
        get() = javaResource.ephemeralBlockDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceEphemeralBlockDeviceToKotlin(args0) })
            })
        })

    /**
     * If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    public val getPasswordData: Output<Boolean>?
        get() = javaResource.getPasswordData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the launched EC2 instance will support hibernation.
     */
    public val hibernation: Output<Boolean>?
        get() = javaResource.hibernation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    public val hostId: Output<String>
        get() = javaResource.hostId().applyValue({ args0 -> args0 })

    /**
     * ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    public val hostResourceGroupArn: Output<String>
        get() = javaResource.hostResourceGroupArn().applyValue({ args0 -> args0 })

    /**
     * IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    public val iamInstanceProfile: Output<String>
        get() = javaResource.iamInstanceProfile().applyValue({ args0 -> args0 })

    /**
     * Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    public val instanceInitiatedShutdownBehavior: Output<String>
        get() = javaResource.instanceInitiatedShutdownBehavior().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     */
    public val instanceLifecycle: Output<String>
        get() = javaResource.instanceLifecycle().applyValue({ args0 -> args0 })

    /**
     * Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     */
    public val instanceMarketOptions: Output<InstanceInstanceMarketOptions>
        get() = javaResource.instanceMarketOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceInstanceMarketOptionsToKotlin(args0)
            })
        })

    /**
     * State of the instance. One of: `pending`, `running`, `shutting-down`, `terminated`, `stopping`, `stopped`. See [Instance Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html) for more information.
     */
    public val instanceState: Output<String>
        get() = javaResource.instanceState().applyValue({ args0 -> args0 })

    /**
     * Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    public val ipv6AddressCount: Output<Int>
        get() = javaResource.ipv6AddressCount().applyValue({ args0 -> args0 })

    /**
     * Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    public val ipv6Addresses: Output<List<String>>
        get() = javaResource.ipv6Addresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    public val keyName: Output<String>
        get() = javaResource.keyName().applyValue({ args0 -> args0 })

    /**
     * Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    public val launchTemplate: Output<InstanceLaunchTemplate>?
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceLaunchTemplateToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    public val maintenanceOptions: Output<InstanceMaintenanceOptions>
        get() = javaResource.maintenanceOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceMaintenanceOptionsToKotlin(args0)
            })
        })

    /**
     * Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    public val metadataOptions: Output<InstanceMetadataOptions>
        get() = javaResource.metadataOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceMetadataOptionsToKotlin(args0)
            })
        })

    /**
     * If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    public val monitoring: Output<Boolean>
        get() = javaResource.monitoring().applyValue({ args0 -> args0 })

    /**
     * Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    public val networkInterfaces: Output<List<InstanceNetworkInterface>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> instanceNetworkInterfaceToKotlin(args0) })
            })
        })

    /**
     * ARN of the Outpost the instance is assigned to.
     */
    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    /**
     * Base-64 encoded encrypted password data for the instance. Useful for getting the administrator password for instances running Microsoft Windows. This attribute is only exported if `get_password_data` is true. Note that this encrypted value will be stored in the state file, as with all exported attributes. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    public val passwordData: Output<String>
        get() = javaResource.passwordData().applyValue({ args0 -> args0 })

    /**
     * Placement Group to start the instance in.
     */
    public val placementGroup: Output<String>
        get() = javaResource.placementGroup().applyValue({ args0 -> args0 })

    /**
     * Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    public val placementPartitionNumber: Output<Int>
        get() = javaResource.placementPartitionNumber().applyValue({ args0 -> args0 })

    /**
     * ID of the instance's primary network interface.
     */
    public val primaryNetworkInterfaceId: Output<String>
        get() = javaResource.primaryNetworkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * Private DNS name assigned to the instance. Can only be used inside the Amazon EC2, and only available if you've enabled DNS hostnames for your VPC.
     */
    public val privateDns: Output<String>
        get() = javaResource.privateDns().applyValue({ args0 -> args0 })

    /**
     * Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    public val privateDnsNameOptions: Output<InstancePrivateDnsNameOptions>
        get() = javaResource.privateDnsNameOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                instancePrivateDnsNameOptionsToKotlin(args0)
            })
        })

    /**
     * Private IP address to associate with the instance in a VPC.
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * Public DNS name assigned to the instance. For EC2-VPC, this is only available if you've enabled DNS hostnames for your VPC.
     */
    public val publicDns: Output<String>
        get() = javaResource.publicDns().applyValue({ args0 -> args0 })

    /**
     * Public IP address assigned to the instance, if applicable. **NOTE**: If you are using an `aws.ec2.Eip` with your instance, you should refer to the EIP's address directly and not use `public_ip` as this field will change after the EIP is attached.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    public val rootBlockDevice: Output<InstanceRootBlockDevice>
        get() = javaResource.rootBlockDevice().applyValue({ args0 ->
            args0.let({ args0 ->
                instanceRootBlockDeviceToKotlin(args0)
            })
        })

    /**
     * List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    public val secondaryPrivateIps: Output<List<String>>
        get() = javaResource.secondaryPrivateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    public val sourceDestCheck: Output<Boolean>?
        get() = javaResource.sourceDestCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the request is a Spot Instance request, the ID of the request.
     */
    public val spotInstanceRequestId: Output<String>
        get() = javaResource.spotInstanceRequestId().applyValue({ args0 -> args0 })

    /**
     * VPC Subnet ID to launch in.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    public val tenancy: Output<String>
        get() = javaResource.tenancy().applyValue({ args0 -> args0 })

    /**
     * User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    public val userData: Output<String>
        get() = javaResource.userData().applyValue({ args0 -> args0 })

    /**
     * Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    public val userDataBase64: Output<String>
        get() = javaResource.userDataBase64().applyValue({ args0 -> args0 })

    /**
     * When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    public val userDataReplaceOnChange: Output<Boolean>?
        get() = javaResource.userDataReplaceOnChange().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    public val volumeTags: Output<Map<String, String>>?
        get() = javaResource.volumeTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * List of security group IDs to associate with.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.ec2.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
