@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceMetadataDefaults].
 */
@PulumiTagMarker
public class InstanceMetadataDefaultsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceMetadataDefaultsArgs = InstanceMetadataDefaultsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceMetadataDefaultsArgsBuilder.() -> Unit) {
        val builder = InstanceMetadataDefaultsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceMetadataDefaults {
        val builtJavaResource = com.pulumi.aws.ec2.InstanceMetadataDefaults(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceMetadataDefaults(builtJavaResource)
    }
}

/**
 * Manages regional EC2 instance metadata default settings.
 * More information can be found in the [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html) user guide.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const enforce_imdsv2 = new aws.ec2.InstanceMetadataDefaults("enforce-imdsv2", {
 *     httpTokens: "required",
 *     httpPutResponseHopLimit: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * enforce_imdsv2 = aws.ec2.InstanceMetadataDefaults("enforce-imdsv2",
 *     http_tokens="required",
 *     http_put_response_hop_limit=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enforce_imdsv2 = new Aws.Ec2.InstanceMetadataDefaults("enforce-imdsv2", new()
 *     {
 *         HttpTokens = "required",
 *         HttpPutResponseHopLimit = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewInstanceMetadataDefaults(ctx, "enforce-imdsv2", &ec2.InstanceMetadataDefaultsArgs{
 * 			HttpTokens:              pulumi.String("required"),
 * 			HttpPutResponseHopLimit: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.InstanceMetadataDefaults;
 * import com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enforce_imdsv2 = new InstanceMetadataDefaults("enforce-imdsv2", InstanceMetadataDefaultsArgs.builder()
 *             .httpTokens("required")
 *             .httpPutResponseHopLimit(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   enforce-imdsv2:
 *     type: aws:ec2:InstanceMetadataDefaults
 *     properties:
 *       httpTokens: required
 *       httpPutResponseHopLimit: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import this resource.
 */
public class InstanceMetadataDefaults internal constructor(
    override val javaResource: com.pulumi.aws.ec2.InstanceMetadataDefaults,
) : KotlinCustomResource(javaResource, InstanceMetadataDefaultsMapper) {
    /**
     * Whether the metadata service is available. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    public val httpEndpoint: Output<String>
        get() = javaResource.httpEndpoint().applyValue({ args0 -> args0 })

    /**
     * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`, or `-1` to indicate no preference. Default: `-1`.
     */
    public val httpPutResponseHopLimit: Output<Int>
        get() = javaResource.httpPutResponseHopLimit().applyValue({ args0 -> args0 })

    /**
     * Whether the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"`, `"required"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    public val httpTokens: Output<String>
        get() = javaResource.httpTokens().applyValue({ args0 -> args0 })

    /**
     * Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    public val instanceMetadataTags: Output<String>
        get() = javaResource.instanceMetadataTags().applyValue({ args0 -> args0 })
}

public object InstanceMetadataDefaultsMapper : ResourceMapper<InstanceMetadataDefaults> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.InstanceMetadataDefaults::class == javaResource::class

    override fun map(javaResource: Resource): InstanceMetadataDefaults =
        InstanceMetadataDefaults(javaResource as com.pulumi.aws.ec2.InstanceMetadataDefaults)
}

/**
 * @see [InstanceMetadataDefaults].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceMetadataDefaults].
 */
public suspend fun instanceMetadataDefaults(
    name: String,
    block: suspend InstanceMetadataDefaultsResourceBuilder.() -> Unit,
): InstanceMetadataDefaults {
    val builder = InstanceMetadataDefaultsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceMetadataDefaults].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceMetadataDefaults(name: String): InstanceMetadataDefaults {
    val builder = InstanceMetadataDefaultsResourceBuilder()
    builder.name(name)
    return builder.build()
}
