@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages regional EC2 instance metadata default settings.
 * More information can be found in the [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html) user guide.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const enforce_imdsv2 = new aws.ec2.InstanceMetadataDefaults("enforce-imdsv2", {
 *     httpTokens: "required",
 *     httpPutResponseHopLimit: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * enforce_imdsv2 = aws.ec2.InstanceMetadataDefaults("enforce-imdsv2",
 *     http_tokens="required",
 *     http_put_response_hop_limit=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enforce_imdsv2 = new Aws.Ec2.InstanceMetadataDefaults("enforce-imdsv2", new()
 *     {
 *         HttpTokens = "required",
 *         HttpPutResponseHopLimit = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewInstanceMetadataDefaults(ctx, "enforce-imdsv2", &ec2.InstanceMetadataDefaultsArgs{
 * 			HttpTokens:              pulumi.String("required"),
 * 			HttpPutResponseHopLimit: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.InstanceMetadataDefaults;
 * import com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enforce_imdsv2 = new InstanceMetadataDefaults("enforce-imdsv2", InstanceMetadataDefaultsArgs.builder()
 *             .httpTokens("required")
 *             .httpPutResponseHopLimit(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   enforce-imdsv2:
 *     type: aws:ec2:InstanceMetadataDefaults
 *     properties:
 *       httpTokens: required
 *       httpPutResponseHopLimit: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You cannot import this resource.
 * @property httpEndpoint Whether the metadata service is available. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`, or `-1` to indicate no preference. Default: `-1`.
 * @property httpTokens Whether the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"`, `"required"`, or `"no-preference"`. Default: `"no-preference"`.
 * @property instanceMetadataTags Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
 */
public data class InstanceMetadataDefaultsArgs(
    public val httpEndpoint: Output<String>? = null,
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
    public val instanceMetadataTags: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs =
        com.pulumi.aws.ec2.InstanceMetadataDefaultsArgs.builder()
            .httpEndpoint(httpEndpoint?.applyValue({ args0 -> args0 }))
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 }))
            .instanceMetadataTags(instanceMetadataTags?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceMetadataDefaultsArgs].
 */
@PulumiTagMarker
public class InstanceMetadataDefaultsArgsBuilder internal constructor() {
    private var httpEndpoint: Output<String>? = null

    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    private var instanceMetadataTags: Output<String>? = null

    /**
     * @param value Whether the metadata service is available. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("iursfhixbbmfmoiv")
    public suspend fun httpEndpoint(`value`: Output<String>) {
        this.httpEndpoint = value
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`, or `-1` to indicate no preference. Default: `-1`.
     */
    @JvmName("qclvrdarsiysvctl")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value Whether the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"`, `"required"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("nvxncqetsdmcxvue")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("tyrmairvmruhkkca")
    public suspend fun instanceMetadataTags(`value`: Output<String>) {
        this.instanceMetadataTags = value
    }

    /**
     * @param value Whether the metadata service is available. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("kprsqaxivpsrstcu")
    public suspend fun httpEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpoint = mapped
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`, or `-1` to indicate no preference. Default: `-1`.
     */
    @JvmName("ebomjahblvedomgd")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value Whether the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"`, `"required"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("ptwuipfwjqntvvcv")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"`, `"disabled"`, or `"no-preference"`. Default: `"no-preference"`.
     */
    @JvmName("qpoyenlfxlcpufbo")
    public suspend fun instanceMetadataTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMetadataTags = mapped
    }

    internal fun build(): InstanceMetadataDefaultsArgs = InstanceMetadataDefaultsArgs(
        httpEndpoint = httpEndpoint,
        httpPutResponseHopLimit = httpPutResponseHopLimit,
        httpTokens = httpTokens,
        instanceMetadataTags = instanceMetadataTags,
    )
}
