@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [InternetGateway].
 */
@PulumiTagMarker
public class InternetGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InternetGatewayArgs = InternetGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InternetGatewayArgsBuilder.() -> Unit) {
        val builder = InternetGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InternetGateway {
        val builtJavaResource = com.pulumi.aws.ec2.InternetGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InternetGateway(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC Internet Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const gw = new aws.ec2.InternetGateway("gw", {
 *     vpcId: main.id,
 *     tags: {
 *         Name: "main",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * gw = aws.ec2.InternetGateway("gw",
 *     vpc_id=main["id"],
 *     tags={
 *         "Name": "main",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gw = new Aws.Ec2.InternetGateway("gw", new()
 *     {
 *         VpcId = main.Id,
 *         Tags =
 *         {
 *             { "Name", "main" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
 * 			VpcId: pulumi.Any(main.Id),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("main"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
 *             .vpcId(main.id())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   gw:
 *     type: aws:ec2:InternetGateway
 *     properties:
 *       vpcId: ${main.id}
 *       tags:
 *         Name: main
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Internet Gateways using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/internetGateway:InternetGateway gw igw-c0a643a9
 * ```
 */
public class InternetGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.InternetGateway,
) : KotlinCustomResource(javaResource, InternetGatewayMapper) {
    /**
     * The ARN of the Internet Gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the internet gateway.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **Note:** It's recommended to denote that the AWS Instance or Elastic IP depends on the Internet Gateway. For example:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const gw = new aws.ec2.InternetGateway("gw", {vpcId: main.id});
     * const foo = new aws.ec2.Instance("foo", {}, {
     *     dependsOn: [gw],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * gw = aws.ec2.InternetGateway("gw", vpc_id=main["id"])
     * foo = aws.ec2.Instance("foo", opts = pulumi.ResourceOptions(depends_on=[gw]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var gw = new Aws.Ec2.InternetGateway("gw", new()
     *     {
     *         VpcId = main.Id,
     *     });
     *     var foo = new Aws.Ec2.Instance("foo", new()
     *     {
     *     }, new CustomResourceOptions
     *     {
     *         DependsOn =
     *         {
     *             gw,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		gw, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
     * 			VpcId: pulumi.Any(main.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "foo", nil, pulumi.DependsOn([]pulumi.Resource{
     * 			gw,
     * 		}))
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.InternetGateway;
     * import com.pulumi.aws.ec2.InternetGatewayArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import com.pulumi.resources.CustomResourceOptions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
     *             .vpcId(main.id())
     *             .build());
     *         var foo = new Instance("foo", InstanceArgs.Empty, CustomResourceOptions.builder()
     *             .dependsOn(gw)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   gw:
     *     type: aws:ec2:InternetGateway
     *     properties:
     *       vpcId: ${main.id}
     *   foo:
     *     type: aws:ec2:Instance
     *     options:
     *       dependson:
     *         - ${gw}
     * ```
     * <!--End PulumiCodeChooser -->
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID to create in.  See the aws.ec2.InternetGatewayAttachment resource for an alternate way to attach an Internet Gateway to a VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object InternetGatewayMapper : ResourceMapper<InternetGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.InternetGateway::class == javaResource::class

    override fun map(javaResource: Resource): InternetGateway = InternetGateway(
        javaResource as
            com.pulumi.aws.ec2.InternetGateway,
    )
}

/**
 * @see [InternetGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InternetGateway].
 */
public suspend fun internetGateway(
    name: String,
    block: suspend InternetGatewayResourceBuilder.() -> Unit,
): InternetGateway {
    val builder = InternetGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InternetGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun internetGateway(name: String): InternetGateway {
    val builder = InternetGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
