@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InternetGatewayAttachment].
 */
@PulumiTagMarker
public class InternetGatewayAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InternetGatewayAttachmentArgs = InternetGatewayAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InternetGatewayAttachmentArgsBuilder.() -> Unit) {
        val builder = InternetGatewayAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InternetGatewayAttachment {
        val builtJavaResource = com.pulumi.aws.ec2.InternetGatewayAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InternetGatewayAttachment(builtJavaResource)
    }
}

/**
 * Provides a resource to create a VPC Internet Gateway Attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.1.0.0/16"});
 * const exampleInternetGateway = new aws.ec2.InternetGateway("example", {});
 * const example = new aws.ec2.InternetGatewayAttachment("example", {
 *     internetGatewayId: exampleInternetGateway.id,
 *     vpcId: exampleVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.1.0.0/16")
 * example_internet_gateway = aws.ec2.InternetGateway("example")
 * example = aws.ec2.InternetGatewayAttachment("example",
 *     internet_gateway_id=example_internet_gateway.id,
 *     vpc_id=example_vpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var exampleInternetGateway = new Aws.Ec2.InternetGateway("example");
 *     var example = new Aws.Ec2.InternetGatewayAttachment("example", new()
 *     {
 *         InternetGatewayId = exampleInternetGateway.Id,
 *         VpcId = exampleVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInternetGateway, err := ec2.NewInternetGateway(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInternetGatewayAttachment(ctx, "example", &ec2.InternetGatewayAttachmentArgs{
 * 			InternetGatewayId: exampleInternetGateway.ID(),
 * 			VpcId:             exampleVpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayAttachment;
 * import com.pulumi.aws.ec2.InternetGatewayAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var exampleInternetGateway = new InternetGateway("exampleInternetGateway");
 *         var example = new InternetGatewayAttachment("example", InternetGatewayAttachmentArgs.builder()
 *             .internetGatewayId(exampleInternetGateway.id())
 *             .vpcId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:InternetGatewayAttachment
 *     properties:
 *       internetGatewayId: ${exampleInternetGateway.id}
 *       vpcId: ${exampleVpc.id}
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   exampleInternetGateway:
 *     type: aws:ec2:InternetGateway
 *     name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Internet Gateway Attachments using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/internetGatewayAttachment:InternetGatewayAttachment example igw-c0a643a9:vpc-123456
 * ```
 */
public class InternetGatewayAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ec2.InternetGatewayAttachment,
) : KotlinCustomResource(javaResource, InternetGatewayAttachmentMapper) {
    /**
     * The ID of the internet gateway.
     */
    public val internetGatewayId: Output<String>
        get() = javaResource.internetGatewayId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object InternetGatewayAttachmentMapper : ResourceMapper<InternetGatewayAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.InternetGatewayAttachment::class == javaResource::class

    override fun map(javaResource: Resource): InternetGatewayAttachment =
        InternetGatewayAttachment(javaResource as com.pulumi.aws.ec2.InternetGatewayAttachment)
}

/**
 * @see [InternetGatewayAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InternetGatewayAttachment].
 */
public suspend fun internetGatewayAttachment(
    name: String,
    block: suspend InternetGatewayAttachmentResourceBuilder.() -> Unit,
): InternetGatewayAttachment {
    val builder = InternetGatewayAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InternetGatewayAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun internetGatewayAttachment(name: String): InternetGatewayAttachment {
    val builder = InternetGatewayAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
