@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.InternetGatewayAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC Internet Gateway Attachment.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.1.0.0/16"});
 * const exampleInternetGateway = new aws.ec2.InternetGateway("example", {});
 * const example = new aws.ec2.InternetGatewayAttachment("example", {
 *     internetGatewayId: exampleInternetGateway.id,
 *     vpcId: exampleVpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.1.0.0/16")
 * example_internet_gateway = aws.ec2.InternetGateway("example")
 * example = aws.ec2.InternetGatewayAttachment("example",
 *     internet_gateway_id=example_internet_gateway.id,
 *     vpc_id=example_vpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.1.0.0/16",
 *     });
 *     var exampleInternetGateway = new Aws.Ec2.InternetGateway("example");
 *     var example = new Aws.Ec2.InternetGatewayAttachment("example", new()
 *     {
 *         InternetGatewayId = exampleInternetGateway.Id,
 *         VpcId = exampleVpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.1.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInternetGateway, err := ec2.NewInternetGateway(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInternetGatewayAttachment(ctx, "example", &ec2.InternetGatewayAttachmentArgs{
 * 			InternetGatewayId: exampleInternetGateway.ID(),
 * 			VpcId:             exampleVpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayAttachment;
 * import com.pulumi.aws.ec2.InternetGatewayAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var exampleInternetGateway = new InternetGateway("exampleInternetGateway");
 *         var example = new InternetGatewayAttachment("example", InternetGatewayAttachmentArgs.builder()
 *             .internetGatewayId(exampleInternetGateway.id())
 *             .vpcId(exampleVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:InternetGatewayAttachment
 *     properties:
 *       internetGatewayId: ${exampleInternetGateway.id}
 *       vpcId: ${exampleVpc.id}
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.1.0.0/16
 *   exampleInternetGateway:
 *     type: aws:ec2:InternetGateway
 *     name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Internet Gateway Attachments using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/internetGatewayAttachment:InternetGatewayAttachment example igw-c0a643a9:vpc-123456
 * ```
 * @property internetGatewayId The ID of the internet gateway.
 * @property vpcId The ID of the VPC.
 */
public data class InternetGatewayAttachmentArgs(
    public val internetGatewayId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.InternetGatewayAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.InternetGatewayAttachmentArgs =
        com.pulumi.aws.ec2.InternetGatewayAttachmentArgs.builder()
            .internetGatewayId(internetGatewayId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetGatewayAttachmentArgs].
 */
@PulumiTagMarker
public class InternetGatewayAttachmentArgsBuilder internal constructor() {
    private var internetGatewayId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the internet gateway.
     */
    @JvmName("khukpmsvookhwmkm")
    public suspend fun internetGatewayId(`value`: Output<String>) {
        this.internetGatewayId = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("xexbferrhkymdvmh")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the internet gateway.
     */
    @JvmName("puonchbwkdxmyhhl")
    public suspend fun internetGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetGatewayId = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("siyflrkqmmibhwvi")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): InternetGatewayAttachmentArgs = InternetGatewayAttachmentArgs(
        internetGatewayId = internetGatewayId,
        vpcId = vpcId,
    )
}
