@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.LaunchConfigurationArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationEphemeralBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationMetadataOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationMetadataOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationRootBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchConfigurationRootBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a new launch configuration, used for autoscaling groups.
 * !> **WARNING:** The use of launch configurations is discouraged in favor of launch templates. Read more in the [AWS EC2 Documentation](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-configurations.html).
 * > **Note** When using `aws.ec2.LaunchConfiguration` with `aws.autoscaling.Group`, it is recommended to use the `name_prefix` (Optional) instead of the `name` (Optional) attribute.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ubuntu = aws.ec2.getAmi({
 *     mostRecent: true,
 *     filters: [
 *         {
 *             name: "name",
 *             values: ["ubuntu/images/hvm-ssd/ubuntu-trusty-14&#46;04-amd64-server-*"],
 *         },
 *         {
 *             name: "virtualization-type",
 *             values: ["hvm"],
 *         },
 *     ],
 *     owners: ["099720109477"],
 * });
 * const asConf = new aws.ec2.LaunchConfiguration("as_conf", {
 *     name: "web_config",
 *     imageId: ubuntu.then(ubuntu => ubuntu.id),
 *     instanceType: "t2.micro",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ubuntu = aws.ec2.get_ami(most_recent=True,
 *     filters=[
 *         {
 *             "name": "name",
 *             "values": ["ubuntu/images/hvm-ssd/ubuntu-trusty-14&#46;04-amd64-server-*"],
 *         },
 *         {
 *             "name": "virtualization-type",
 *             "values": ["hvm"],
 *         },
 *     ],
 *     owners=["099720109477"])
 * as_conf = aws.ec2.LaunchConfiguration("as_conf",
 *     name="web_config",
 *     image_id=ubuntu.id,
 *     instance_type="t2.micro")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ubuntu = Aws.Ec2.GetAmi.Invoke(new()
 *     {
 *         MostRecent = true,
 *         Filters = new[]
 *         {
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "name",
 *                 Values = new[]
 *                 {
 *                     "ubuntu/images/hvm-ssd/ubuntu-trusty-14.04-amd64-server-*",
 *                 },
 *             },
 *             new Aws.Ec2.Inputs.GetAmiFilterInputArgs
 *             {
 *                 Name = "virtualization-type",
 *                 Values = new[]
 *                 {
 *                     "hvm",
 *                 },
 *             },
 *         },
 *         Owners = new[]
 *         {
 *             "099720109477",
 *         },
 *     });
 *     var asConf = new Aws.Ec2.LaunchConfiguration("as_conf", new()
 *     {
 *         Name = "web_config",
 *         ImageId = ubuntu.Apply(getAmiResult => getAmiResult.Id),
 *         InstanceType = "t2.micro",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ubuntu, err := ec2.LookupAmi(ctx, &ec2.LookupAmiArgs{
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Filters: []ec2.GetAmiFilter{
 * 				{
 * 					Name: "name",
 * 					Values: []string{
 * 						"ubuntu/images/hvm-ssd/ubuntu-trusty-14.04-amd64-server-*",
 * 					},
 * 				},
 * 				{
 * 					Name: "virtualization-type",
 * 					Values: []string{
 * 						"hvm",
 * 					},
 * 				},
 * 			},
 * 			Owners: []string{
 * 				"099720109477",
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewLaunchConfiguration(ctx, "as_conf", &ec2.LaunchConfigurationArgs{
 * 			Name:         pulumi.String("web_config"),
 * 			ImageId:      pulumi.String(ubuntu.Id),
 * 			InstanceType: pulumi.String("t2.micro"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.LaunchConfiguration;
 * import com.pulumi.aws.ec2.LaunchConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ubuntu = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("ubuntu/images/hvm-ssd/ubuntu-trusty-14.04-amd64-server-*")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("virtualization-type")
 *                     .values("hvm")
 *                     .build())
 *             .owners("099720109477")
 *             .build());
 *         var asConf = new LaunchConfiguration("asConf", LaunchConfigurationArgs.builder()
 *             .name("web_config")
 *             .imageId(ubuntu.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   asConf:
 *     type: aws:ec2:LaunchConfiguration
 *     name: as_conf
 *     properties:
 *       name: web_config
 *       imageId: ${ubuntu.id}
 *       instanceType: t2.micro
 * variables:
 *   ubuntu:
 *     fn::invoke:
 *       Function: aws:ec2:getAmi
 *       Arguments:
 *         mostRecent: true
 *         filters:
 *           - name: name
 *             values:
 *               - ubuntu/images/hvm-ssd/ubuntu-trusty-14.04-amd64-server-*
 *           - name: virtualization-type
 *             values:
 *               - hvm
 *         owners:
 *           - '099720109477'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import launch configurations using the `name`. For example:
 * ```sh
 * $ pulumi import aws:ec2/launchConfiguration:LaunchConfiguration as_conf pulumi-lg-123456
 * ```
 * @property associatePublicIpAddress Associate a public ip address with an instance in a VPC.
 * @property ebsBlockDevices Additional EBS block devices to attach to the instance. See Block Devices below for details.
 * @property ebsOptimized If true, the launched EC2 instance will be EBS-optimized.
 * @property enableMonitoring Enables/disables detailed monitoring. This is enabled by default.
 * @property ephemeralBlockDevices Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
 * @property iamInstanceProfile The name attribute of the IAM instance profile to associate with launched instances.
 * @property imageId The EC2 image ID to launch.
 * @property instanceType The size of instance to launch.
 * The following arguments are optional:
 * @property keyName The key name that should be used for the instance.
 * @property metadataOptions The metadata options for the instance.
 * @property name The name of the launch configuration. If you leave this blank, this provider will auto-generate a unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property placementTenancy The tenancy of the instance. Valid values are `default` or `dedicated`, see [AWS's Create Launch Configuration](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_CreateLaunchConfiguration.html) for more details.
 * @property rootBlockDevice Customize details about the root block device of the instance. See Block Devices below for details.
 * @property securityGroups A list of associated security group IDS.
 * @property spotPrice The maximum price to use for reserving spot instances.
 * @property userData The user data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead.
 * @property userDataBase64 Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption.
 */
public data class LaunchConfigurationArgs(
    public val associatePublicIpAddress: Output<Boolean>? = null,
    public val ebsBlockDevices: Output<List<LaunchConfigurationEbsBlockDeviceArgs>>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val enableMonitoring: Output<Boolean>? = null,
    public val ephemeralBlockDevices: Output<List<LaunchConfigurationEphemeralBlockDeviceArgs>>? =
        null,
    public val iamInstanceProfile: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val keyName: Output<String>? = null,
    public val metadataOptions: Output<LaunchConfigurationMetadataOptionsArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val placementTenancy: Output<String>? = null,
    public val rootBlockDevice: Output<LaunchConfigurationRootBlockDeviceArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val spotPrice: Output<String>? = null,
    public val userData: Output<String>? = null,
    public val userDataBase64: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.LaunchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.LaunchConfigurationArgs =
        com.pulumi.aws.ec2.LaunchConfigurationArgs.builder()
            .associatePublicIpAddress(associatePublicIpAddress?.applyValue({ args0 -> args0 }))
            .ebsBlockDevices(
                ebsBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .enableMonitoring(enableMonitoring?.applyValue({ args0 -> args0 }))
            .ephemeralBlockDevices(
                ephemeralBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .iamInstanceProfile(iamInstanceProfile?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .metadataOptions(metadataOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .placementTenancy(placementTenancy?.applyValue({ args0 -> args0 }))
            .rootBlockDevice(rootBlockDevice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotPrice(spotPrice?.applyValue({ args0 -> args0 }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .userDataBase64(userDataBase64?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchConfigurationArgs].
 */
@PulumiTagMarker
public class LaunchConfigurationArgsBuilder internal constructor() {
    private var associatePublicIpAddress: Output<Boolean>? = null

    private var ebsBlockDevices: Output<List<LaunchConfigurationEbsBlockDeviceArgs>>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var enableMonitoring: Output<Boolean>? = null

    private var ephemeralBlockDevices: Output<List<LaunchConfigurationEphemeralBlockDeviceArgs>>? =
        null

    private var iamInstanceProfile: Output<String>? = null

    private var imageId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var keyName: Output<String>? = null

    private var metadataOptions: Output<LaunchConfigurationMetadataOptionsArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var placementTenancy: Output<String>? = null

    private var rootBlockDevice: Output<LaunchConfigurationRootBlockDeviceArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    private var spotPrice: Output<String>? = null

    private var userData: Output<String>? = null

    private var userDataBase64: Output<String>? = null

    /**
     * @param value Associate a public ip address with an instance in a VPC.
     */
    @JvmName("lwltgxuhlhyxwfwr")
    public suspend fun associatePublicIpAddress(`value`: Output<Boolean>) {
        this.associatePublicIpAddress = value
    }

    /**
     * @param value Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("kupkjuxtscsegbpc")
    public suspend fun ebsBlockDevices(`value`: Output<List<LaunchConfigurationEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("prtxlhmbticetkud")
    public suspend fun ebsBlockDevices(vararg values: Output<LaunchConfigurationEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("xerourngjhcwmmuh")
    public suspend fun ebsBlockDevices(values: List<Output<LaunchConfigurationEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("grmxohlpbtppitcs")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value Enables/disables detailed monitoring. This is enabled by default.
     */
    @JvmName("svhpkfmhktifknmj")
    public suspend fun enableMonitoring(`value`: Output<Boolean>) {
        this.enableMonitoring = value
    }

    /**
     * @param value Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("ypklqstkrusyrxvd")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<LaunchConfigurationEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("kyaassuehivceldj")
    public suspend fun ephemeralBlockDevices(vararg values: Output<LaunchConfigurationEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("cpvwdlldxugjisma")
    public suspend fun ephemeralBlockDevices(values: List<Output<LaunchConfigurationEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value The name attribute of the IAM instance profile to associate with launched instances.
     */
    @JvmName("dpcaxcewcijyajyu")
    public suspend fun iamInstanceProfile(`value`: Output<String>) {
        this.iamInstanceProfile = value
    }

    /**
     * @param value The EC2 image ID to launch.
     */
    @JvmName("aldraolrxbatxiuh")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value The size of instance to launch.
     * The following arguments are optional:
     */
    @JvmName("yssakwcbdcaidhfc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The key name that should be used for the instance.
     */
    @JvmName("rbxkimxioypdlpxr")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The metadata options for the instance.
     */
    @JvmName("lskmwdxkcuiecfba")
    public suspend fun metadataOptions(`value`: Output<LaunchConfigurationMetadataOptionsArgs>) {
        this.metadataOptions = value
    }

    /**
     * @param value The name of the launch configuration. If you leave this blank, this provider will auto-generate a unique name. Conflicts with `name_prefix`.
     */
    @JvmName("jcetdgoyxvyqhlxa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("jbjdkugcbwbohjbq")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The tenancy of the instance. Valid values are `default` or `dedicated`, see [AWS's Create Launch Configuration](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_CreateLaunchConfiguration.html) for more details.
     */
    @JvmName("qpcwvleltyhxfwyc")
    public suspend fun placementTenancy(`value`: Output<String>) {
        this.placementTenancy = value
    }

    /**
     * @param value Customize details about the root block device of the instance. See Block Devices below for details.
     */
    @JvmName("awgllprcwoapnygo")
    public suspend fun rootBlockDevice(`value`: Output<LaunchConfigurationRootBlockDeviceArgs>) {
        this.rootBlockDevice = value
    }

    /**
     * @param value A list of associated security group IDS.
     */
    @JvmName("euttvdtpdranaymp")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("admlscneyanqxiro")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of associated security group IDS.
     */
    @JvmName("lbndbqxclyxwkwmk")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The maximum price to use for reserving spot instances.
     */
    @JvmName("aeuvjxctrvaxlhpj")
    public suspend fun spotPrice(`value`: Output<String>) {
        this.spotPrice = value
    }

    /**
     * @param value The user data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead.
     */
    @JvmName("oplynwdxdsvckqde")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption.
     */
    @JvmName("icrenbraxqptgfro")
    public suspend fun userDataBase64(`value`: Output<String>) {
        this.userDataBase64 = value
    }

    /**
     * @param value Associate a public ip address with an instance in a VPC.
     */
    @JvmName("cdmgufrdmdlpdorg")
    public suspend fun associatePublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatePublicIpAddress = mapped
    }

    /**
     * @param value Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("unnqmduuijrougky")
    public suspend fun ebsBlockDevices(`value`: List<LaunchConfigurationEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("mthqkuvcjmnjitns")
    public suspend fun ebsBlockDevices(argument: List<suspend LaunchConfigurationEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchConfigurationEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("cutqmnhudhpdnmqw")
    public suspend fun ebsBlockDevices(vararg argument: suspend LaunchConfigurationEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchConfigurationEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("vohnfqnhbgigntvj")
    public suspend fun ebsBlockDevices(argument: suspend LaunchConfigurationEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchConfigurationEbsBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Additional EBS block devices to attach to the instance. See Block Devices below for details.
     */
    @JvmName("cjkcjxqboultpato")
    public suspend fun ebsBlockDevices(vararg values: LaunchConfigurationEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("bfbuvkrvrfemfnvn")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value Enables/disables detailed monitoring. This is enabled by default.
     */
    @JvmName("etrsagdsfihehhel")
    public suspend fun enableMonitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMonitoring = mapped
    }

    /**
     * @param value Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("sgelyeylyafpnpah")
    public suspend fun ephemeralBlockDevices(`value`: List<LaunchConfigurationEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("akxxrwoenawtmlcb")
    public suspend fun ephemeralBlockDevices(argument: List<suspend LaunchConfigurationEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchConfigurationEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("aaxnhnomffbkpehx")
    public suspend fun ephemeralBlockDevices(vararg argument: suspend LaunchConfigurationEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchConfigurationEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("gmkhdwlpyjulqekl")
    public suspend fun ephemeralBlockDevices(argument: suspend LaunchConfigurationEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchConfigurationEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details.
     */
    @JvmName("jlghtfjvfcdrxgcp")
    public suspend fun ephemeralBlockDevices(vararg values: LaunchConfigurationEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value The name attribute of the IAM instance profile to associate with launched instances.
     */
    @JvmName("ldrbcbtfoyqfhdsf")
    public suspend fun iamInstanceProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfile = mapped
    }

    /**
     * @param value The EC2 image ID to launch.
     */
    @JvmName("bffygmgidmmuqlqd")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value The size of instance to launch.
     * The following arguments are optional:
     */
    @JvmName("uqjpatjybiggbqxu")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The key name that should be used for the instance.
     */
    @JvmName("brfayggvghbbcqpc")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The metadata options for the instance.
     */
    @JvmName("mqjdlrarmcpwndxv")
    public suspend fun metadataOptions(`value`: LaunchConfigurationMetadataOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataOptions = mapped
    }

    /**
     * @param argument The metadata options for the instance.
     */
    @JvmName("cnpymkcfyxvurcaf")
    public suspend fun metadataOptions(argument: suspend LaunchConfigurationMetadataOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchConfigurationMetadataOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metadataOptions = mapped
    }

    /**
     * @param value The name of the launch configuration. If you leave this blank, this provider will auto-generate a unique name. Conflicts with `name_prefix`.
     */
    @JvmName("uhodsvxjybvdlhhh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("qpbrxjgqtyixnclq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The tenancy of the instance. Valid values are `default` or `dedicated`, see [AWS's Create Launch Configuration](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_CreateLaunchConfiguration.html) for more details.
     */
    @JvmName("ghxxtfevbnaqxtcw")
    public suspend fun placementTenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementTenancy = mapped
    }

    /**
     * @param value Customize details about the root block device of the instance. See Block Devices below for details.
     */
    @JvmName("xduqrplidovpxyhf")
    public suspend fun rootBlockDevice(`value`: LaunchConfigurationRootBlockDeviceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootBlockDevice = mapped
    }

    /**
     * @param argument Customize details about the root block device of the instance. See Block Devices below for details.
     */
    @JvmName("sdwluyrmjmowotfe")
    public suspend fun rootBlockDevice(argument: suspend LaunchConfigurationRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchConfigurationRootBlockDeviceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rootBlockDevice = mapped
    }

    /**
     * @param value A list of associated security group IDS.
     */
    @JvmName("ntnlnbhoooyccyjy")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of associated security group IDS.
     */
    @JvmName("htqonegervoyyjhm")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The maximum price to use for reserving spot instances.
     */
    @JvmName("ngghampesjhlidfx")
    public suspend fun spotPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPrice = mapped
    }

    /**
     * @param value The user data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead.
     */
    @JvmName("hwaxsksuianfbjfw")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption.
     */
    @JvmName("sgfdfcjtqxppymwv")
    public suspend fun userDataBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataBase64 = mapped
    }

    internal fun build(): LaunchConfigurationArgs = LaunchConfigurationArgs(
        associatePublicIpAddress = associatePublicIpAddress,
        ebsBlockDevices = ebsBlockDevices,
        ebsOptimized = ebsOptimized,
        enableMonitoring = enableMonitoring,
        ephemeralBlockDevices = ephemeralBlockDevices,
        iamInstanceProfile = iamInstanceProfile,
        imageId = imageId,
        instanceType = instanceType,
        keyName = keyName,
        metadataOptions = metadataOptions,
        name = name,
        namePrefix = namePrefix,
        placementTenancy = placementTenancy,
        rootBlockDevice = rootBlockDevice,
        securityGroups = securityGroups,
        spotPrice = spotPrice,
        userData = userData,
        userDataBase64 = userDataBase64,
    )
}
