@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateBlockDeviceMapping
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCapacityReservationSpecification
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCpuOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCreditSpecification
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateElasticGpuSpecification
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateElasticInferenceAccelerator
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateEnclaveOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateHibernationOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateIamInstanceProfile
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateInstanceMarketOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateInstanceRequirements
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateLicenseSpecification
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMaintenanceOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMetadataOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMonitoring
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateNetworkInterface
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplatePlacement
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplatePrivateDnsNameOptions
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateTagSpecification
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateBlockDeviceMapping.Companion.toKotlin as launchTemplateBlockDeviceMappingToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCapacityReservationSpecification.Companion.toKotlin as launchTemplateCapacityReservationSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCpuOptions.Companion.toKotlin as launchTemplateCpuOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateCreditSpecification.Companion.toKotlin as launchTemplateCreditSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateElasticGpuSpecification.Companion.toKotlin as launchTemplateElasticGpuSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateElasticInferenceAccelerator.Companion.toKotlin as launchTemplateElasticInferenceAcceleratorToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateEnclaveOptions.Companion.toKotlin as launchTemplateEnclaveOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateHibernationOptions.Companion.toKotlin as launchTemplateHibernationOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateIamInstanceProfile.Companion.toKotlin as launchTemplateIamInstanceProfileToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateInstanceMarketOptions.Companion.toKotlin as launchTemplateInstanceMarketOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateInstanceRequirements.Companion.toKotlin as launchTemplateInstanceRequirementsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateLicenseSpecification.Companion.toKotlin as launchTemplateLicenseSpecificationToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMaintenanceOptions.Companion.toKotlin as launchTemplateMaintenanceOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMetadataOptions.Companion.toKotlin as launchTemplateMetadataOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateMonitoring.Companion.toKotlin as launchTemplateMonitoringToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateNetworkInterface.Companion.toKotlin as launchTemplateNetworkInterfaceToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplatePlacement.Companion.toKotlin as launchTemplatePlacementToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplatePrivateDnsNameOptions.Companion.toKotlin as launchTemplatePrivateDnsNameOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.LaunchTemplateTagSpecification.Companion.toKotlin as launchTemplateTagSpecificationToKotlin

/**
 * Builder for [LaunchTemplate].
 */
@PulumiTagMarker
public class LaunchTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LaunchTemplateArgs = LaunchTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LaunchTemplateArgsBuilder.() -> Unit) {
        val builder = LaunchTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LaunchTemplate {
        val builtJavaResource = com.pulumi.aws.ec2.LaunchTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LaunchTemplate(builtJavaResource)
    }
}

/**
 * Provides an EC2 launch template resource. Can be used to create instances or auto scaling groups.
 * ## Import
 * Using `pulumi import`, import Launch Templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/launchTemplate:LaunchTemplate web lt-12345678
 * ```
 */
public class LaunchTemplate internal constructor(
    override val javaResource: com.pulumi.aws.ec2.LaunchTemplate,
) : KotlinCustomResource(javaResource, LaunchTemplateMapper) {
    /**
     * Amazon Resource Name (ARN) of the launch template.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    public val blockDeviceMappings: Output<List<LaunchTemplateBlockDeviceMapping>>?
        get() = javaResource.blockDeviceMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchTemplateBlockDeviceMappingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     */
    public val capacityReservationSpecification:
        Output<LaunchTemplateCapacityReservationSpecification>?
        get() = javaResource.capacityReservationSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchTemplateCapacityReservationSpecificationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The CPU options for the instance. See CPU Options below for more details.
     */
    public val cpuOptions: Output<LaunchTemplateCpuOptions>?
        get() = javaResource.cpuOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchTemplateCpuOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     */
    public val creditSpecification: Output<LaunchTemplateCreditSpecification>?
        get() = javaResource.creditSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateCreditSpecificationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Default Version of the launch template.
     */
    public val defaultVersion: Output<Int>
        get() = javaResource.defaultVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the launch template.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
     */
    public val disableApiStop: Output<Boolean>?
        get() = javaResource.disableApiStop().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If `true`, enables [EC2 Instance
   * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
     */
    public val disableApiTermination: Output<Boolean>?
        get() = javaResource.disableApiTermination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If `true`, the launched EC2 instance will be EBS-optimized.
     */
    public val ebsOptimized: Output<String>?
        get() = javaResource.ebsOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    public val elasticGpuSpecifications: Output<List<LaunchTemplateElasticGpuSpecification>>?
        get() = javaResource.elasticGpuSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchTemplateElasticGpuSpecificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     */
    public val elasticInferenceAccelerator: Output<LaunchTemplateElasticInferenceAccelerator>?
        get() = javaResource.elasticInferenceAccelerator().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchTemplateElasticInferenceAcceleratorToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    public val enclaveOptions: Output<LaunchTemplateEnclaveOptions>?
        get() = javaResource.enclaveOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateEnclaveOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hibernation options for the instance. See Hibernation Options below for more details.
     */
    public val hibernationOptions: Output<LaunchTemplateHibernationOptions>?
        get() = javaResource.hibernationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateHibernationOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     */
    public val iamInstanceProfile: Output<LaunchTemplateIamInstanceProfile>?
        get() = javaResource.iamInstanceProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateIamInstanceProfileToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
     */
    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     */
    public val instanceInitiatedShutdownBehavior: Output<String>?
        get() = javaResource.instanceInitiatedShutdownBehavior().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The market (purchasing) option for the instance. See Market Options
     * below for details.
     */
    public val instanceMarketOptions: Output<LaunchTemplateInstanceMarketOptions>?
        get() = javaResource.instanceMarketOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateInstanceMarketOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     */
    public val instanceRequirements: Output<LaunchTemplateInstanceRequirements>?
        get() = javaResource.instanceRequirements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateInstanceRequirementsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of the instance. If present then `instance_requirements` cannot be present.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The kernel ID.
     */
    public val kernelId: Output<String>?
        get() = javaResource.kernelId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The key name to use for the instance.
     */
    public val keyName: Output<String>?
        get() = javaResource.keyName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The latest version of the launch template.
     */
    public val latestVersion: Output<Int>
        get() = javaResource.latestVersion().applyValue({ args0 -> args0 })

    /**
     * A list of license specifications to associate with. See License Specification below for more details.
     */
    public val licenseSpecifications: Output<List<LaunchTemplateLicenseSpecification>>?
        get() = javaResource.licenseSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchTemplateLicenseSpecificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The maintenance options for the instance. See Maintenance Options below for more details.
     */
    public val maintenanceOptions: Output<LaunchTemplateMaintenanceOptions>?
        get() = javaResource.maintenanceOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplateMaintenanceOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Customize the metadata options for the instance. See Metadata Options below for more details.
     */
    public val metadataOptions: Output<LaunchTemplateMetadataOptions>
        get() = javaResource.metadataOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                launchTemplateMetadataOptionsToKotlin(args0)
            })
        })

    /**
     * The monitoring option for the instance. See Monitoring below for more details.
     */
    public val monitoring: Output<LaunchTemplateMonitoring>?
        get() = javaResource.monitoring().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchTemplateMonitoringToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    public val networkInterfaces: Output<List<LaunchTemplateNetworkInterface>>?
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchTemplateNetworkInterfaceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The placement of the instance. See Placement below for more details.
     */
    public val placement: Output<LaunchTemplatePlacement>?
        get() = javaResource.placement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchTemplatePlacementToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    public val privateDnsNameOptions: Output<LaunchTemplatePrivateDnsNameOptions>?
        get() = javaResource.privateDnsNameOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchTemplatePrivateDnsNameOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The ID of the RAM disk.
     */
    public val ramDiskId: Output<String>?
        get() = javaResource.ramDiskId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     */
    public val securityGroupNames: Output<List<String>>?
        get() = javaResource.securityGroupNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    public val tagSpecifications: Output<List<LaunchTemplateTagSpecification>>?
        get() = javaResource.tagSpecifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchTemplateTagSpecificationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to update Default Version each update. Conflicts with `default_version`.
     */
    public val updateDefaultVersion: Output<Boolean>?
        get() = javaResource.updateDefaultVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The base64-encoded user data to provide when launching the instance.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     */
    public val vpcSecurityGroupIds: Output<List<String>>?
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object LaunchTemplateMapper : ResourceMapper<LaunchTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.LaunchTemplate::class == javaResource::class

    override fun map(javaResource: Resource): LaunchTemplate = LaunchTemplate(
        javaResource as
            com.pulumi.aws.ec2.LaunchTemplate,
    )
}

/**
 * @see [LaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LaunchTemplate].
 */
public suspend fun launchTemplate(
    name: String,
    block: suspend LaunchTemplateResourceBuilder.() -> Unit,
): LaunchTemplate {
    val builder = LaunchTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LaunchTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun launchTemplate(name: String): LaunchTemplate {
    val builder = LaunchTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
