@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.LaunchTemplateArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateBlockDeviceMappingArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateBlockDeviceMappingArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCapacityReservationSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCapacityReservationSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCpuOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCpuOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCreditSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateCreditSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateElasticGpuSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateElasticGpuSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateElasticInferenceAcceleratorArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateElasticInferenceAcceleratorArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateEnclaveOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateEnclaveOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateHibernationOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateHibernationOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateIamInstanceProfileArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateIamInstanceProfileArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateInstanceMarketOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateInstanceMarketOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateInstanceRequirementsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateInstanceRequirementsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateLicenseSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateLicenseSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMaintenanceOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMaintenanceOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMetadataOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMetadataOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMonitoringArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateMonitoringArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateNetworkInterfaceArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateNetworkInterfaceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplatePlacementArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplatePlacementArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplatePrivateDnsNameOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplatePrivateDnsNameOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateTagSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.LaunchTemplateTagSpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 launch template resource. Can be used to create instances or auto scaling groups.
 * ## Import
 * Using `pulumi import`, import Launch Templates using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ec2/launchTemplate:LaunchTemplate web lt-12345678
 * ```
 * @property blockDeviceMappings Specify volumes to attach to the instance besides the volumes specified by the AMI.
 * See Block Devices below for details.
 * @property capacityReservationSpecification Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
 * @property cpuOptions The CPU options for the instance. See CPU Options below for more details.
 * @property creditSpecification Customize the credit specification of the instance. See Credit
 * Specification below for more details.
 * @property defaultVersion Default Version of the launch template.
 * @property description Description of the launch template.
 * @property disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
 * @property disableApiTermination If `true`, enables [EC2 Instance
 * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
 * @property ebsOptimized If `true`, the launched EC2 instance will be EBS-optimized.
 * @property elasticGpuSpecifications The elastic GPU to attach to the instance. See Elastic GPU
 * below for more details.
 * @property elasticInferenceAccelerator Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
 * @property enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
 * @property hibernationOptions The hibernation options for the instance. See Hibernation Options below for more details.
 * @property iamInstanceProfile The IAM Instance Profile to launch the instance with. See Instance Profile
 * below for more details.
 * @property imageId The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
 * @property instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Can be `stop` or `terminate`.
 * (Default: `stop`).
 * @property instanceMarketOptions The market (purchasing) option for the instance. See Market Options
 * below for details.
 * @property instanceRequirements The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
 * @property instanceType The type of the instance. If present then `instance_requirements` cannot be present.
 * @property kernelId The kernel ID.
 * @property keyName The key name to use for the instance.
 * @property licenseSpecifications A list of license specifications to associate with. See License Specification below for more details.
 * @property maintenanceOptions The maintenance options for the instance. See Maintenance Options below for more details.
 * @property metadataOptions Customize the metadata options for the instance. See Metadata Options below for more details.
 * @property monitoring The monitoring option for the instance. See Monitoring below for more details.
 * @property name The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property networkInterfaces Customize network interfaces to be attached at instance boot time. See Network
 * Interfaces below for more details.
 * @property placement The placement of the instance. See Placement below for more details.
 * @property privateDnsNameOptions The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
 * @property ramDiskId The ID of the RAM disk.
 * @property securityGroupNames A list of security group names to associate with. If you are creating Instances in a VPC, use
 * `vpc_security_group_ids` instead.
 * @property tagSpecifications The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
 * @property tags A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property updateDefaultVersion Whether to update Default Version each update. Conflicts with `default_version`.
 * @property userData The base64-encoded user data to provide when launching the instance.
 * @property vpcSecurityGroupIds A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
 */
public data class LaunchTemplateArgs(
    public val blockDeviceMappings: Output<List<LaunchTemplateBlockDeviceMappingArgs>>? = null,
    public val capacityReservationSpecification: Output<LaunchTemplateCapacityReservationSpecificationArgs>? = null,
    public val cpuOptions: Output<LaunchTemplateCpuOptionsArgs>? = null,
    public val creditSpecification: Output<LaunchTemplateCreditSpecificationArgs>? = null,
    public val defaultVersion: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val disableApiStop: Output<Boolean>? = null,
    public val disableApiTermination: Output<Boolean>? = null,
    public val ebsOptimized: Output<String>? = null,
    public val elasticGpuSpecifications: Output<List<LaunchTemplateElasticGpuSpecificationArgs>>? =
        null,
    public val elasticInferenceAccelerator: Output<LaunchTemplateElasticInferenceAcceleratorArgs>? =
        null,
    public val enclaveOptions: Output<LaunchTemplateEnclaveOptionsArgs>? = null,
    public val hibernationOptions: Output<LaunchTemplateHibernationOptionsArgs>? = null,
    public val iamInstanceProfile: Output<LaunchTemplateIamInstanceProfileArgs>? = null,
    public val imageId: Output<String>? = null,
    public val instanceInitiatedShutdownBehavior: Output<String>? = null,
    public val instanceMarketOptions: Output<LaunchTemplateInstanceMarketOptionsArgs>? = null,
    public val instanceRequirements: Output<LaunchTemplateInstanceRequirementsArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val kernelId: Output<String>? = null,
    public val keyName: Output<String>? = null,
    public val licenseSpecifications: Output<List<LaunchTemplateLicenseSpecificationArgs>>? = null,
    public val maintenanceOptions: Output<LaunchTemplateMaintenanceOptionsArgs>? = null,
    public val metadataOptions: Output<LaunchTemplateMetadataOptionsArgs>? = null,
    public val monitoring: Output<LaunchTemplateMonitoringArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val networkInterfaces: Output<List<LaunchTemplateNetworkInterfaceArgs>>? = null,
    public val placement: Output<LaunchTemplatePlacementArgs>? = null,
    public val privateDnsNameOptions: Output<LaunchTemplatePrivateDnsNameOptionsArgs>? = null,
    public val ramDiskId: Output<String>? = null,
    public val securityGroupNames: Output<List<String>>? = null,
    public val tagSpecifications: Output<List<LaunchTemplateTagSpecificationArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val updateDefaultVersion: Output<Boolean>? = null,
    public val userData: Output<String>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.LaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.ec2.LaunchTemplateArgs =
        com.pulumi.aws.ec2.LaunchTemplateArgs.builder()
            .blockDeviceMappings(
                blockDeviceMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .capacityReservationSpecification(
                capacityReservationSpecification?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .cpuOptions(cpuOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .creditSpecification(
                creditSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultVersion(defaultVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disableApiStop(disableApiStop?.applyValue({ args0 -> args0 }))
            .disableApiTermination(disableApiTermination?.applyValue({ args0 -> args0 }))
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .elasticGpuSpecifications(
                elasticGpuSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .elasticInferenceAccelerator(
                elasticInferenceAccelerator?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enclaveOptions(enclaveOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hibernationOptions(
                hibernationOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .iamInstanceProfile(
                iamInstanceProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .instanceInitiatedShutdownBehavior(
                instanceInitiatedShutdownBehavior?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceMarketOptions(
                instanceMarketOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceRequirements(
                instanceRequirements?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .kernelId(kernelId?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .licenseSpecifications(
                licenseSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maintenanceOptions(
                maintenanceOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metadataOptions(metadataOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitoring(monitoring?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .placement(placement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateDnsNameOptions(
                privateDnsNameOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ramDiskId(ramDiskId?.applyValue({ args0 -> args0 }))
            .securityGroupNames(securityGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tagSpecifications(
                tagSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .updateDefaultVersion(updateDefaultVersion?.applyValue({ args0 -> args0 }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [LaunchTemplateArgs].
 */
@PulumiTagMarker
public class LaunchTemplateArgsBuilder internal constructor() {
    private var blockDeviceMappings: Output<List<LaunchTemplateBlockDeviceMappingArgs>>? = null

    private var capacityReservationSpecification:
        Output<LaunchTemplateCapacityReservationSpecificationArgs>? = null

    private var cpuOptions: Output<LaunchTemplateCpuOptionsArgs>? = null

    private var creditSpecification: Output<LaunchTemplateCreditSpecificationArgs>? = null

    private var defaultVersion: Output<Int>? = null

    private var description: Output<String>? = null

    private var disableApiStop: Output<Boolean>? = null

    private var disableApiTermination: Output<Boolean>? = null

    private var ebsOptimized: Output<String>? = null

    private var elasticGpuSpecifications: Output<List<LaunchTemplateElasticGpuSpecificationArgs>>? =
        null

    private var elasticInferenceAccelerator: Output<LaunchTemplateElasticInferenceAcceleratorArgs>? =
        null

    private var enclaveOptions: Output<LaunchTemplateEnclaveOptionsArgs>? = null

    private var hibernationOptions: Output<LaunchTemplateHibernationOptionsArgs>? = null

    private var iamInstanceProfile: Output<LaunchTemplateIamInstanceProfileArgs>? = null

    private var imageId: Output<String>? = null

    private var instanceInitiatedShutdownBehavior: Output<String>? = null

    private var instanceMarketOptions: Output<LaunchTemplateInstanceMarketOptionsArgs>? = null

    private var instanceRequirements: Output<LaunchTemplateInstanceRequirementsArgs>? = null

    private var instanceType: Output<String>? = null

    private var kernelId: Output<String>? = null

    private var keyName: Output<String>? = null

    private var licenseSpecifications: Output<List<LaunchTemplateLicenseSpecificationArgs>>? = null

    private var maintenanceOptions: Output<LaunchTemplateMaintenanceOptionsArgs>? = null

    private var metadataOptions: Output<LaunchTemplateMetadataOptionsArgs>? = null

    private var monitoring: Output<LaunchTemplateMonitoringArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var networkInterfaces: Output<List<LaunchTemplateNetworkInterfaceArgs>>? = null

    private var placement: Output<LaunchTemplatePlacementArgs>? = null

    private var privateDnsNameOptions: Output<LaunchTemplatePrivateDnsNameOptionsArgs>? = null

    private var ramDiskId: Output<String>? = null

    private var securityGroupNames: Output<List<String>>? = null

    private var tagSpecifications: Output<List<LaunchTemplateTagSpecificationArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var updateDefaultVersion: Output<Boolean>? = null

    private var userData: Output<String>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("ycnysvffuycqcrec")
    public suspend fun blockDeviceMappings(`value`: Output<List<LaunchTemplateBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = value
    }

    @JvmName("jrbwdacqknhenmiv")
    public suspend fun blockDeviceMappings(vararg values: Output<LaunchTemplateBlockDeviceMappingArgs>) {
        this.blockDeviceMappings = Output.all(values.asList())
    }

    /**
     * @param values Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("kebybglnfhmkxxas")
    public suspend fun blockDeviceMappings(values: List<Output<LaunchTemplateBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = Output.all(values)
    }

    /**
     * @param value Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     */
    @JvmName("ljntdwxfojunujng")
    public suspend fun capacityReservationSpecification(`value`: Output<LaunchTemplateCapacityReservationSpecificationArgs>) {
        this.capacityReservationSpecification = value
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("rrokejkyjsvsfirv")
    public suspend fun cpuOptions(`value`: Output<LaunchTemplateCpuOptionsArgs>) {
        this.cpuOptions = value
    }

    /**
     * @param value Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     */
    @JvmName("xxiqcbaldaxlsrix")
    public suspend fun creditSpecification(`value`: Output<LaunchTemplateCreditSpecificationArgs>) {
        this.creditSpecification = value
    }

    /**
     * @param value Default Version of the launch template.
     */
    @JvmName("ipjirfiwsptfqbnk")
    public suspend fun defaultVersion(`value`: Output<Int>) {
        this.defaultVersion = value
    }

    /**
     * @param value Description of the launch template.
     */
    @JvmName("kghwtigqwmfebfhg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
     */
    @JvmName("iexhcgmcqvobrwre")
    public suspend fun disableApiStop(`value`: Output<Boolean>) {
        this.disableApiStop = value
    }

    /**
     * @param value If `true`, enables [EC2 Instance
   * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
     */
    @JvmName("reygihatlbcxmerv")
    public suspend fun disableApiTermination(`value`: Output<Boolean>) {
        this.disableApiTermination = value
    }

    /**
     * @param value If `true`, the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("dwuokwmvdeubadjd")
    public suspend fun ebsOptimized(`value`: Output<String>) {
        this.ebsOptimized = value
    }

    /**
     * @param value The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("wusdntrjuipdcbfc")
    public suspend fun elasticGpuSpecifications(`value`: Output<List<LaunchTemplateElasticGpuSpecificationArgs>>) {
        this.elasticGpuSpecifications = value
    }

    @JvmName("pfojdtoesgnwvooi")
    public suspend fun elasticGpuSpecifications(vararg values: Output<LaunchTemplateElasticGpuSpecificationArgs>) {
        this.elasticGpuSpecifications = Output.all(values.asList())
    }

    /**
     * @param values The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("upqtkrjrwmdqrjrt")
    public suspend fun elasticGpuSpecifications(values: List<Output<LaunchTemplateElasticGpuSpecificationArgs>>) {
        this.elasticGpuSpecifications = Output.all(values)
    }

    /**
     * @param value Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     */
    @JvmName("kklnvebbabtykhum")
    public suspend fun elasticInferenceAccelerator(`value`: Output<LaunchTemplateElasticInferenceAcceleratorArgs>) {
        this.elasticInferenceAccelerator = value
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("vxevoeebayalmpcg")
    public suspend fun enclaveOptions(`value`: Output<LaunchTemplateEnclaveOptionsArgs>) {
        this.enclaveOptions = value
    }

    /**
     * @param value The hibernation options for the instance. See Hibernation Options below for more details.
     */
    @JvmName("yqtpdbwxlnmrgwmh")
    public suspend fun hibernationOptions(`value`: Output<LaunchTemplateHibernationOptionsArgs>) {
        this.hibernationOptions = value
    }

    /**
     * @param value The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     */
    @JvmName("cwpadarxuduqvwid")
    public suspend fun iamInstanceProfile(`value`: Output<LaunchTemplateIamInstanceProfileArgs>) {
        this.iamInstanceProfile = value
    }

    /**
     * @param value The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
     */
    @JvmName("mdpdhnpgifbclghc")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     */
    @JvmName("lgiohwfrvhkkhdsh")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: Output<String>) {
        this.instanceInitiatedShutdownBehavior = value
    }

    /**
     * @param value The market (purchasing) option for the instance. See Market Options
     * below for details.
     */
    @JvmName("ntgimiwxtdswnxwi")
    public suspend fun instanceMarketOptions(`value`: Output<LaunchTemplateInstanceMarketOptionsArgs>) {
        this.instanceMarketOptions = value
    }

    /**
     * @param value The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     */
    @JvmName("gywjqytudyojscsc")
    public suspend fun instanceRequirements(`value`: Output<LaunchTemplateInstanceRequirementsArgs>) {
        this.instanceRequirements = value
    }

    /**
     * @param value The type of the instance. If present then `instance_requirements` cannot be present.
     */
    @JvmName("dfdntqdfwmvqoojv")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The kernel ID.
     */
    @JvmName("yrehodehxbhfubkn")
    public suspend fun kernelId(`value`: Output<String>) {
        this.kernelId = value
    }

    /**
     * @param value The key name to use for the instance.
     */
    @JvmName("njyuopshvutntieo")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("faokwjrnpcnbgdky")
    public suspend fun licenseSpecifications(`value`: Output<List<LaunchTemplateLicenseSpecificationArgs>>) {
        this.licenseSpecifications = value
    }

    @JvmName("eldntywemamenvnx")
    public suspend fun licenseSpecifications(vararg values: Output<LaunchTemplateLicenseSpecificationArgs>) {
        this.licenseSpecifications = Output.all(values.asList())
    }

    /**
     * @param values A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("cwvncigeyfuooqps")
    public suspend fun licenseSpecifications(values: List<Output<LaunchTemplateLicenseSpecificationArgs>>) {
        this.licenseSpecifications = Output.all(values)
    }

    /**
     * @param value The maintenance options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("kxihmtvowppepuci")
    public suspend fun maintenanceOptions(`value`: Output<LaunchTemplateMaintenanceOptionsArgs>) {
        this.maintenanceOptions = value
    }

    /**
     * @param value Customize the metadata options for the instance. See Metadata Options below for more details.
     */
    @JvmName("pxyngidykbrmrdns")
    public suspend fun metadataOptions(`value`: Output<LaunchTemplateMetadataOptionsArgs>) {
        this.metadataOptions = value
    }

    /**
     * @param value The monitoring option for the instance. See Monitoring below for more details.
     */
    @JvmName("yaoinoagptnbagct")
    public suspend fun monitoring(`value`: Output<LaunchTemplateMonitoringArgs>) {
        this.monitoring = value
    }

    /**
     * @param value The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     */
    @JvmName("lkgbncflckpmrxxn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("dkdgfjwmbyqbuibw")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("eclqtjiijyyuqeip")
    public suspend fun networkInterfaces(`value`: Output<List<LaunchTemplateNetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("rkxddbyghrtpdaoq")
    public suspend fun networkInterfaces(vararg values: Output<LaunchTemplateNetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("kbibbikkmgaepphd")
    public suspend fun networkInterfaces(values: List<Output<LaunchTemplateNetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value The placement of the instance. See Placement below for more details.
     */
    @JvmName("npjqsfodyiyttbxd")
    public suspend fun placement(`value`: Output<LaunchTemplatePlacementArgs>) {
        this.placement = value
    }

    /**
     * @param value The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("tcatdqhihrcqbfau")
    public suspend fun privateDnsNameOptions(`value`: Output<LaunchTemplatePrivateDnsNameOptionsArgs>) {
        this.privateDnsNameOptions = value
    }

    /**
     * @param value The ID of the RAM disk.
     */
    @JvmName("btalajnayifjufhq")
    public suspend fun ramDiskId(`value`: Output<String>) {
        this.ramDiskId = value
    }

    /**
     * @param value A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     */
    @JvmName("jsutproqfjolhckp")
    public suspend fun securityGroupNames(`value`: Output<List<String>>) {
        this.securityGroupNames = value
    }

    @JvmName("uhefpfvjbncwxiix")
    public suspend fun securityGroupNames(vararg values: Output<String>) {
        this.securityGroupNames = Output.all(values.asList())
    }

    /**
     * @param values A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     */
    @JvmName("qkkqaskkqgivbpwc")
    public suspend fun securityGroupNames(values: List<Output<String>>) {
        this.securityGroupNames = Output.all(values)
    }

    /**
     * @param value The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("tnkeqgnocvlaovij")
    public suspend fun tagSpecifications(`value`: Output<List<LaunchTemplateTagSpecificationArgs>>) {
        this.tagSpecifications = value
    }

    @JvmName("cpqudojsdbhvvook")
    public suspend fun tagSpecifications(vararg values: Output<LaunchTemplateTagSpecificationArgs>) {
        this.tagSpecifications = Output.all(values.asList())
    }

    /**
     * @param values The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("ouiyisdttjqtrpwc")
    public suspend fun tagSpecifications(values: List<Output<LaunchTemplateTagSpecificationArgs>>) {
        this.tagSpecifications = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxjvhivpgxhxgnrc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to update Default Version each update. Conflicts with `default_version`.
     */
    @JvmName("kxilufggwcwfrgcs")
    public suspend fun updateDefaultVersion(`value`: Output<Boolean>) {
        this.updateDefaultVersion = value
    }

    /**
     * @param value The base64-encoded user data to provide when launching the instance.
     */
    @JvmName("dlutjduiratqprut")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     */
    @JvmName("qcpbvansutwcyudw")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("mfxcqkwwwknirtsv")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     */
    @JvmName("cqartgvicuukomlu")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("trjhpyxfhswklnrd")
    public suspend fun blockDeviceMappings(`value`: List<LaunchTemplateBlockDeviceMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("ynuuklxoujkyfxkt")
    public suspend fun blockDeviceMappings(argument: List<suspend LaunchTemplateBlockDeviceMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateBlockDeviceMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("mcksklwernheyito")
    public suspend fun blockDeviceMappings(vararg argument: suspend LaunchTemplateBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateBlockDeviceMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("ufkxwbsogestfvgo")
    public suspend fun blockDeviceMappings(argument: suspend LaunchTemplateBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchTemplateBlockDeviceMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param values Specify volumes to attach to the instance besides the volumes specified by the AMI.
     * See Block Devices below for details.
     */
    @JvmName("egulogwryusikwod")
    public suspend fun blockDeviceMappings(vararg values: LaunchTemplateBlockDeviceMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param value Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     */
    @JvmName("ckiainjwegcumgqm")
    public suspend fun capacityReservationSpecification(`value`: LaunchTemplateCapacityReservationSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param argument Targeting for EC2 capacity reservations. See Capacity Reservation Specification below for more details.
     */
    @JvmName("evwwwyybmtpoffyu")
    public suspend fun capacityReservationSpecification(argument: suspend LaunchTemplateCapacityReservationSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateCapacityReservationSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("vwedhpmygxwwgdoj")
    public suspend fun cpuOptions(`value`: LaunchTemplateCpuOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOptions = mapped
    }

    /**
     * @param argument The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("uqfsqrtlddnxfmvc")
    public suspend fun cpuOptions(argument: suspend LaunchTemplateCpuOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateCpuOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cpuOptions = mapped
    }

    /**
     * @param value Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     */
    @JvmName("sfoupgvsclpscxdr")
    public suspend fun creditSpecification(`value`: LaunchTemplateCreditSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creditSpecification = mapped
    }

    /**
     * @param argument Customize the credit specification of the instance. See Credit
     * Specification below for more details.
     */
    @JvmName("aaikijceerfufgyn")
    public suspend fun creditSpecification(argument: suspend LaunchTemplateCreditSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateCreditSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.creditSpecification = mapped
    }

    /**
     * @param value Default Version of the launch template.
     */
    @JvmName("donistebnyxvajrd")
    public suspend fun defaultVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultVersion = mapped
    }

    /**
     * @param value Description of the launch template.
     */
    @JvmName("qhadtrtewgdoibsm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html).
     */
    @JvmName("assuqmkgokacoqxx")
    public suspend fun disableApiStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiStop = mapped
    }

    /**
     * @param value If `true`, enables [EC2 Instance
   * Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingDisableAPITermination.html)
     */
    @JvmName("wtopdfbnvsmuhwbn")
    public suspend fun disableApiTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiTermination = mapped
    }

    /**
     * @param value If `true`, the launched EC2 instance will be EBS-optimized.
     */
    @JvmName("nxogvnurwnqjbxuv")
    public suspend fun ebsOptimized(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("vvbjvwovrmrmxwfu")
    public suspend fun elasticGpuSpecifications(`value`: List<LaunchTemplateElasticGpuSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticGpuSpecifications = mapped
    }

    /**
     * @param argument The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("lcatyxvqhvgwglxg")
    public suspend fun elasticGpuSpecifications(argument: List<suspend LaunchTemplateElasticGpuSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateElasticGpuSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticGpuSpecifications = mapped
    }

    /**
     * @param argument The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("cnlmrhwqohvnolnx")
    public suspend fun elasticGpuSpecifications(vararg argument: suspend LaunchTemplateElasticGpuSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateElasticGpuSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.elasticGpuSpecifications = mapped
    }

    /**
     * @param argument The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("wswwfxhtcrbkpgul")
    public suspend fun elasticGpuSpecifications(argument: suspend LaunchTemplateElasticGpuSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchTemplateElasticGpuSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.elasticGpuSpecifications = mapped
    }

    /**
     * @param values The elastic GPU to attach to the instance. See Elastic GPU
     * below for more details.
     */
    @JvmName("ipytldnfrylbeglx")
    public suspend fun elasticGpuSpecifications(vararg values: LaunchTemplateElasticGpuSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticGpuSpecifications = mapped
    }

    /**
     * @param value Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     */
    @JvmName("wcivbbgerdhvycio")
    public suspend fun elasticInferenceAccelerator(`value`: LaunchTemplateElasticInferenceAcceleratorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticInferenceAccelerator = mapped
    }

    /**
     * @param argument Configuration block containing an Elastic Inference Accelerator to attach to the instance. See Elastic Inference Accelerator below for more details.
     */
    @JvmName("ihtctafoucybnfdc")
    public suspend fun elasticInferenceAccelerator(argument: suspend LaunchTemplateElasticInferenceAcceleratorArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateElasticInferenceAcceleratorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.elasticInferenceAccelerator = mapped
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("gebvppkoomdbptux")
    public suspend fun enclaveOptions(`value`: LaunchTemplateEnclaveOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enclaveOptions = mapped
    }

    /**
     * @param argument Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("hfggjuxjhokteijs")
    public suspend fun enclaveOptions(argument: suspend LaunchTemplateEnclaveOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateEnclaveOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enclaveOptions = mapped
    }

    /**
     * @param value The hibernation options for the instance. See Hibernation Options below for more details.
     */
    @JvmName("ktqpytaoypjksnua")
    public suspend fun hibernationOptions(`value`: LaunchTemplateHibernationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hibernationOptions = mapped
    }

    /**
     * @param argument The hibernation options for the instance. See Hibernation Options below for more details.
     */
    @JvmName("yapdwwcifkqxxxlv")
    public suspend fun hibernationOptions(argument: suspend LaunchTemplateHibernationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateHibernationOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hibernationOptions = mapped
    }

    /**
     * @param value The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     */
    @JvmName("qtlyodhvtgqixrci")
    public suspend fun iamInstanceProfile(`value`: LaunchTemplateIamInstanceProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfile = mapped
    }

    /**
     * @param argument The IAM Instance Profile to launch the instance with. See Instance Profile
     * below for more details.
     */
    @JvmName("brpqxsonbbyjjfjh")
    public suspend fun iamInstanceProfile(argument: suspend LaunchTemplateIamInstanceProfileArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateIamInstanceProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.iamInstanceProfile = mapped
    }

    /**
     * @param value The AMI from which to launch the instance or use a Systems Manager parameter convention e.g. `resolve:ssm:parameter-name`. See [docs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id) for more details.
     */
    @JvmName("amcameqtoanhenwf")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Shutdown behavior for the instance. Can be `stop` or `terminate`.
     * (Default: `stop`).
     */
    @JvmName("dinxqwpfirgfhdux")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInitiatedShutdownBehavior = mapped
    }

    /**
     * @param value The market (purchasing) option for the instance. See Market Options
     * below for details.
     */
    @JvmName("pxwieaowigxqqnid")
    public suspend fun instanceMarketOptions(`value`: LaunchTemplateInstanceMarketOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMarketOptions = mapped
    }

    /**
     * @param argument The market (purchasing) option for the instance. See Market Options
     * below for details.
     */
    @JvmName("vanihqmkytfjkboq")
    public suspend fun instanceMarketOptions(argument: suspend LaunchTemplateInstanceMarketOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateInstanceMarketOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceMarketOptions = mapped
    }

    /**
     * @param value The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     */
    @JvmName("mwsmbwhfdsbowkbh")
    public suspend fun instanceRequirements(`value`: LaunchTemplateInstanceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRequirements = mapped
    }

    /**
     * @param argument The attribute requirements for the type of instance. If present then `instance_type` cannot be present.
     */
    @JvmName("ddsgjuyjnwfaalfl")
    public suspend fun instanceRequirements(argument: suspend LaunchTemplateInstanceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateInstanceRequirementsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceRequirements = mapped
    }

    /**
     * @param value The type of the instance. If present then `instance_requirements` cannot be present.
     */
    @JvmName("xxfnpodilwkyxnvm")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The kernel ID.
     */
    @JvmName("rkvdvgodkuducoty")
    public suspend fun kernelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelId = mapped
    }

    /**
     * @param value The key name to use for the instance.
     */
    @JvmName("guigqukjvtpllbvo")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("tmfhgfhwgjbcomro")
    public suspend fun licenseSpecifications(`value`: List<LaunchTemplateLicenseSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseSpecifications = mapped
    }

    /**
     * @param argument A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("dmxishgupyxychdu")
    public suspend fun licenseSpecifications(argument: List<suspend LaunchTemplateLicenseSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateLicenseSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseSpecifications = mapped
    }

    /**
     * @param argument A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("kbcnaukgonuoigta")
    public suspend fun licenseSpecifications(vararg argument: suspend LaunchTemplateLicenseSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateLicenseSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseSpecifications = mapped
    }

    /**
     * @param argument A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("usjsbeagsehmemeu")
    public suspend fun licenseSpecifications(argument: suspend LaunchTemplateLicenseSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchTemplateLicenseSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.licenseSpecifications = mapped
    }

    /**
     * @param values A list of license specifications to associate with. See License Specification below for more details.
     */
    @JvmName("bchdnyncktdblxth")
    public suspend fun licenseSpecifications(vararg values: LaunchTemplateLicenseSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseSpecifications = mapped
    }

    /**
     * @param value The maintenance options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("upotmnocgvnpjscf")
    public suspend fun maintenanceOptions(`value`: LaunchTemplateMaintenanceOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceOptions = mapped
    }

    /**
     * @param argument The maintenance options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("dkpakifomybnogqc")
    public suspend fun maintenanceOptions(argument: suspend LaunchTemplateMaintenanceOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateMaintenanceOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.maintenanceOptions = mapped
    }

    /**
     * @param value Customize the metadata options for the instance. See Metadata Options below for more details.
     */
    @JvmName("lebhdwadybnlmqvy")
    public suspend fun metadataOptions(`value`: LaunchTemplateMetadataOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataOptions = mapped
    }

    /**
     * @param argument Customize the metadata options for the instance. See Metadata Options below for more details.
     */
    @JvmName("acxhmcipbnupglke")
    public suspend fun metadataOptions(argument: suspend LaunchTemplateMetadataOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateMetadataOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metadataOptions = mapped
    }

    /**
     * @param value The monitoring option for the instance. See Monitoring below for more details.
     */
    @JvmName("uwfwmyuyqltoijem")
    public suspend fun monitoring(`value`: LaunchTemplateMonitoringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoring = mapped
    }

    /**
     * @param argument The monitoring option for the instance. See Monitoring below for more details.
     */
    @JvmName("vvtkfhjacvqfxtkw")
    public suspend fun monitoring(argument: suspend LaunchTemplateMonitoringArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateMonitoringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitoring = mapped
    }

    /**
     * @param value The name of the launch template. If you leave this blank, the provider will auto-generate a unique name.
     */
    @JvmName("erwhoxllcryfultd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("arpddoblnmjskenn")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("sdspnlghogxjksmc")
    public suspend fun networkInterfaces(`value`: List<LaunchTemplateNetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("lvbjvmmgexdfxlrm")
    public suspend fun networkInterfaces(argument: List<suspend LaunchTemplateNetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("hfavxaavbvoujgux")
    public suspend fun networkInterfaces(vararg argument: suspend LaunchTemplateNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateNetworkInterfaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("dejvvltmuregolyy")
    public suspend fun networkInterfaces(argument: suspend LaunchTemplateNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchTemplateNetworkInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network
     * Interfaces below for more details.
     */
    @JvmName("vlfaxuaqngoqkmos")
    public suspend fun networkInterfaces(vararg values: LaunchTemplateNetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value The placement of the instance. See Placement below for more details.
     */
    @JvmName("lbxcvcodvhxyrtbf")
    public suspend fun placement(`value`: LaunchTemplatePlacementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placement = mapped
    }

    /**
     * @param argument The placement of the instance. See Placement below for more details.
     */
    @JvmName("fkdqbkobgeyafvks")
    public suspend fun placement(argument: suspend LaunchTemplatePlacementArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplatePlacementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.placement = mapped
    }

    /**
     * @param value The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("nhwoltsxucvvythe")
    public suspend fun privateDnsNameOptions(`value`: LaunchTemplatePrivateDnsNameOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param argument The options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("wkrhmfpkthsmxgkj")
    public suspend fun privateDnsNameOptions(argument: suspend LaunchTemplatePrivateDnsNameOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplatePrivateDnsNameOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param value The ID of the RAM disk.
     */
    @JvmName("yiidhkkqdfitwngl")
    public suspend fun ramDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramDiskId = mapped
    }

    /**
     * @param value A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     */
    @JvmName("njwnbewuxkajgcbo")
    public suspend fun securityGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupNames = mapped
    }

    /**
     * @param values A list of security group names to associate with. If you are creating Instances in a VPC, use
     * `vpc_security_group_ids` instead.
     */
    @JvmName("amvahflsbdpkvklq")
    public suspend fun securityGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupNames = mapped
    }

    /**
     * @param value The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("wnfhsgiljsirmksi")
    public suspend fun tagSpecifications(`value`: List<LaunchTemplateTagSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagSpecifications = mapped
    }

    /**
     * @param argument The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("avdojwrpyywncnea")
    public suspend fun tagSpecifications(argument: List<suspend LaunchTemplateTagSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateTagSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagSpecifications = mapped
    }

    /**
     * @param argument The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("wtaeknkusbcmhwbo")
    public suspend fun tagSpecifications(vararg argument: suspend LaunchTemplateTagSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LaunchTemplateTagSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.tagSpecifications = mapped
    }

    /**
     * @param argument The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("ydiiyegmnihwgmmi")
    public suspend fun tagSpecifications(argument: suspend LaunchTemplateTagSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchTemplateTagSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.tagSpecifications = mapped
    }

    /**
     * @param values The tags to apply to the resources during launch. See Tag Specifications below for more details. Default tags are currently not propagated to ASG created resources so you may wish to inject your default tags into this variable against the relevant child resource types created.
     */
    @JvmName("kbrisymxswrckcgj")
    public suspend fun tagSpecifications(vararg values: LaunchTemplateTagSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagSpecifications = mapped
    }

    /**
     * @param value A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fjlavciyjswgoahc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the launch template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pfngctgpvjgomiwi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether to update Default Version each update. Conflicts with `default_version`.
     */
    @JvmName("bwnlrkoxvoljsdfv")
    public suspend fun updateDefaultVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateDefaultVersion = mapped
    }

    /**
     * @param value The base64-encoded user data to provide when launching the instance.
     */
    @JvmName("ftqnpppcivpynppk")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     */
    @JvmName("libdixcofpsuseub")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values A list of security group IDs to associate with. Conflicts with `network_interfaces.security_groups`
     */
    @JvmName("mffjhsqdgpdpowra")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): LaunchTemplateArgs = LaunchTemplateArgs(
        blockDeviceMappings = blockDeviceMappings,
        capacityReservationSpecification = capacityReservationSpecification,
        cpuOptions = cpuOptions,
        creditSpecification = creditSpecification,
        defaultVersion = defaultVersion,
        description = description,
        disableApiStop = disableApiStop,
        disableApiTermination = disableApiTermination,
        ebsOptimized = ebsOptimized,
        elasticGpuSpecifications = elasticGpuSpecifications,
        elasticInferenceAccelerator = elasticInferenceAccelerator,
        enclaveOptions = enclaveOptions,
        hibernationOptions = hibernationOptions,
        iamInstanceProfile = iamInstanceProfile,
        imageId = imageId,
        instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior,
        instanceMarketOptions = instanceMarketOptions,
        instanceRequirements = instanceRequirements,
        instanceType = instanceType,
        kernelId = kernelId,
        keyName = keyName,
        licenseSpecifications = licenseSpecifications,
        maintenanceOptions = maintenanceOptions,
        metadataOptions = metadataOptions,
        monitoring = monitoring,
        name = name,
        namePrefix = namePrefix,
        networkInterfaces = networkInterfaces,
        placement = placement,
        privateDnsNameOptions = privateDnsNameOptions,
        ramDiskId = ramDiskId,
        securityGroupNames = securityGroupNames,
        tagSpecifications = tagSpecifications,
        tags = tags,
        updateDefaultVersion = updateDefaultVersion,
        userData = userData,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
