@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LocalGatewayRoute].
 */
@PulumiTagMarker
public class LocalGatewayRouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocalGatewayRouteArgs = LocalGatewayRouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocalGatewayRouteArgsBuilder.() -> Unit) {
        val builder = LocalGatewayRouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocalGatewayRoute {
        val builtJavaResource = com.pulumi.aws.ec2.LocalGatewayRoute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocalGatewayRoute(builtJavaResource)
    }
}

/**
 * Manages an EC2 Local Gateway Route. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ec2.LocalGatewayRoute("example", {
 *     destinationCidrBlock: "172.16.0.0/16",
 *     localGatewayRouteTableId: exampleAwsEc2LocalGatewayRouteTable.id,
 *     localGatewayVirtualInterfaceGroupId: exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ec2.LocalGatewayRoute("example",
 *     destination_cidr_block="172.16.0.0/16",
 *     local_gateway_route_table_id=example_aws_ec2_local_gateway_route_table["id"],
 *     local_gateway_virtual_interface_group_id=example_aws_ec2_local_gateway_virtual_interface_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ec2.LocalGatewayRoute("example", new()
 *     {
 *         DestinationCidrBlock = "172.16.0.0/16",
 *         LocalGatewayRouteTableId = exampleAwsEc2LocalGatewayRouteTable.Id,
 *         LocalGatewayVirtualInterfaceGroupId = exampleAwsEc2LocalGatewayVirtualInterfaceGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ec2.NewLocalGatewayRoute(ctx, "example", &ec2.LocalGatewayRouteArgs{
 * 			DestinationCidrBlock:                pulumi.String("172.16.0.0/16"),
 * 			LocalGatewayRouteTableId:            pulumi.Any(exampleAwsEc2LocalGatewayRouteTable.Id),
 * 			LocalGatewayVirtualInterfaceGroupId: pulumi.Any(exampleAwsEc2LocalGatewayVirtualInterfaceGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.LocalGatewayRoute;
 * import com.pulumi.aws.ec2.LocalGatewayRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LocalGatewayRoute("example", LocalGatewayRouteArgs.builder()
 *             .destinationCidrBlock("172.16.0.0/16")
 *             .localGatewayRouteTableId(exampleAwsEc2LocalGatewayRouteTable.id())
 *             .localGatewayVirtualInterfaceGroupId(exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ec2:LocalGatewayRoute
 *     properties:
 *       destinationCidrBlock: 172.16.0.0/16
 *       localGatewayRouteTableId: ${exampleAwsEc2LocalGatewayRouteTable.id}
 *       localGatewayVirtualInterfaceGroupId: ${exampleAwsEc2LocalGatewayVirtualInterfaceGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_ec2_local_gateway_route` using the EC2 Local Gateway Route Table identifier and destination CIDR block separated by underscores (`_`). For example:
 * ```sh
 * $ pulumi import aws:ec2/localGatewayRoute:LocalGatewayRoute example lgw-rtb-12345678_172.16.0.0/16
 * ```
 */
public class LocalGatewayRoute internal constructor(
    override val javaResource: com.pulumi.aws.ec2.LocalGatewayRoute,
) : KotlinCustomResource(javaResource, LocalGatewayRouteMapper) {
    /**
     * IPv4 CIDR range used for destination matches. Routing decisions are based on the most specific match.
     */
    public val destinationCidrBlock: Output<String>
        get() = javaResource.destinationCidrBlock().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Local Gateway Route Table.
     */
    public val localGatewayRouteTableId: Output<String>
        get() = javaResource.localGatewayRouteTableId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Local Gateway Virtual Interface Group.
     */
    public val localGatewayVirtualInterfaceGroupId: Output<String>
        get() = javaResource.localGatewayVirtualInterfaceGroupId().applyValue({ args0 -> args0 })
}

public object LocalGatewayRouteMapper : ResourceMapper<LocalGatewayRoute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.LocalGatewayRoute::class == javaResource::class

    override fun map(javaResource: Resource): LocalGatewayRoute = LocalGatewayRoute(
        javaResource as
            com.pulumi.aws.ec2.LocalGatewayRoute,
    )
}

/**
 * @see [LocalGatewayRoute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocalGatewayRoute].
 */
public suspend fun localGatewayRoute(
    name: String,
    block: suspend LocalGatewayRouteResourceBuilder.() -> Unit,
): LocalGatewayRoute {
    val builder = LocalGatewayRouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocalGatewayRoute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun localGatewayRoute(name: String): LocalGatewayRoute {
    val builder = LocalGatewayRouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
